/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs.ws390;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DynacachePlatformHelper {
    private static boolean initialized = false;
    private static Integer lock = new Integer(0);
    private static boolean _is_zOS = false;
    private static boolean _is_zOS_servant = false;
    private static boolean _is_zOS_controller = false;
    private static String processType = null;
    private static TraceComponent tc = Tr.register(DynacachePlatformHelper.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final String shareNone = "NOT_SHARED";
    public static final String sharePush = "PUSH";
    public static final String sharePull = "PULL";
    public static final String sharePushPull = "PUSH_PULL";
    public static final int notShared = 0;
    public static final int shared_Push = 1;
    public static final int shared_Pull = 2;
    public static final int shared_PushPull = 3;
    public static int baseZosServerReplicationType;
    private static boolean isBaseServerReplicationEnabled;
    private static boolean isBaseServer;
    private static boolean _loggedVersion;

    private DynacachePlatformHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.init: Entry.");
        }
        Integer n = lock;
        synchronized (n) {
            if (tc.isDebugEnabled() && !_loggedVersion) {
                Tr.debug(tc, "DynacachePlatformHelper.init: Version 1.4.1.1 6/29/09 15:32:55");
                _loggedVersion = true;
            }
            if (!initialized) {
                String string;
                processType = AdminServiceFactory.getAdminService().getProcessType();
                if (processType != null) {
                    isBaseServer = processType.equals("UnManagedProcess");
                }
                if ((string = System.getProperty("DynacacheEnableUnmanagedServerReplication")) != null && string.equals("true")) {
                    isBaseServerReplicationEnabled = true;
                    String string2 = System.getProperty("DynacacheUnmanagedServerReplicationType");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DynacachePlatformHelper.init:  DYNACACHE_BASE_REPLICATION_TYPE specified = " + string2);
                    }
                    if (string2 == null) {
                        string2 = shareNone;
                    }
                    baseZosServerReplicationType = string2.equalsIgnoreCase(shareNone) ? 0 : (string2.equalsIgnoreCase(sharePush) ? 1 : (string2.equalsIgnoreCase(sharePull) ? 2 : (string2.equalsIgnoreCase(sharePushPull) ? 3 : 0)));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DynacachePlatformHelper.init:  baseZosServerReplicationType= " + baseZosServerReplicationType);
                    }
                }
                if (_is_zOS = PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    _is_zOS_controller = PlatformHelperFactory.getPlatformHelper().isControlJvm();
                    _is_zOS_servant = PlatformHelperFactory.getPlatformHelper().isServantJvm();
                } else {
                    _is_zOS_controller = false;
                    _is_zOS_servant = false;
                }
                initialized = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DynacachePlatformHelper.init: _is_zOS = " + _is_zOS);
                    Tr.debug(tc, "DynacachePlatformHelper.init: _is_zOS_controller = " + _is_zOS_controller);
                    Tr.debug(tc, "DynacachePlatformHelper.init: _is_zOS_servant = " + _is_zOS_servant);
                    Tr.debug(tc, "DynacachePlatformHelper.init:  Process Type = " + processType);
                    Tr.debug(tc, "DynacachePlatformHelper.init:  enableBaseReplication = " + (string == null ? "null" : string));
                    Tr.debug(tc, "DynacachePlatformHelper.init:  isBaseServerReplicationEnabled = " + isBaseServerReplicationEnabled);
                    Tr.debug(tc, "DynacachePlatformHelper.init:  baseZosServerReplicationType = " + baseZosServerReplicationType);
                    Tr.debug(tc, "DynacachePlatformHelper.init:  isBaseServer = " + isBaseServer);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.init: Exit.");
        }
    }

    public static boolean isZOS() {
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        boolean bl = _is_zOS;
        return bl;
    }

    public static boolean isZOS_Controller() {
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        boolean bl = _is_zOS && _is_zOS_controller;
        return bl;
    }

    public static boolean isZOS_Servant() {
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        boolean bl = _is_zOS && _is_zOS_servant;
        return bl;
    }

    public static String getZOSUniqueId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.getZOSUniqueId: Entry.");
        }
        String string = null;
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        if (_is_zOS) {
            string = PlatformHelperFactory.getPlatformHelper().getUniqueId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.getZOSUniqueId: Exit - unique id " + string);
        }
        return string;
    }

    public static boolean isBaseServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.isBaseServer: Entry.");
        }
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.isBaseServer: Exit - isBaseServer = " + isBaseServer);
        }
        return isBaseServer;
    }

    public static boolean isZOSBaseServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.isZOSBaseServer: Entry.");
        }
        boolean bl = false;
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && isBaseServer;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.isZOSBaseServer: Exit - isZOSBaseServer = " + bl);
        }
        return bl;
    }

    public static boolean isBaseServerReplicationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.isBaseServerReplicationEnabled: Entry.");
        }
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.isBaseServerReplicationEnabled: Exit - isBaseServerReplicationEnabled = " + isBaseServerReplicationEnabled);
        }
        return isBaseServerReplicationEnabled;
    }

    public static boolean isZOSBaseServerReplicationEnabled() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.isZOSBaseServerReplicationEnabled: Entry.");
        }
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && isBaseServer && isBaseServerReplicationEnabled;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.isZOSBaseServerReplicationEnabled: Exit - isZOSBaseServerReplicationEnabled = " + bl);
        }
        return bl;
    }

    public static int getZOSBaseServerReplicationType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.getZOSBaseServerReplicationType: Entry.");
        }
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.getZOSBaseServerReplicationType: Exit - baseZosServerReplicationType  = " + baseZosServerReplicationType);
        }
        return baseZosServerReplicationType;
    }

    public static String getZOSServantToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.getZOSServantToken: Entry.");
        }
        String string = null;
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        if (_is_zOS) {
            string = PlatformHelperFactory.getPlatformHelper().getServantToken();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.getZOSServantToken: Exit - stoken = " + string);
        }
        return string;
    }

    public static ORB getZOSORB() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.init: Entry.");
        }
        ORB oRB = null;
        if (!initialized) {
            DynacachePlatformHelper.init();
        }
        if (_is_zOS) {
            oRB = PlatformHelperFactory.getPlatformHelper().getGlobalORB();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.init: Exit.");
        }
        return oRB;
    }

    public static byte[] getByteArray(Object object) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.init: Entry.");
        }
        byte[] byArray = new byte[]{};
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.init: Exit.");
        }
        return byArray;
    }

    public static Object getObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DynacachePlatformHelper.getObject: Entry.");
        }
        Object object = null;
        if (byArray != null && byArray.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DynacachePlatformHelper.getObject: Exit.");
        }
        return object;
    }

    public static String getProcessType() {
        return processType;
    }

    static {
        isBaseServerReplicationEnabled = false;
        isBaseServer = false;
        _loggedVersion = false;
    }
}

