/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.eca;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.eca.ECAOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class ECAConnection {
    private static TraceComponent tc = Trace.register(ECAConnection.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean usingSocket = true;
    Socket sock;

    public ECAConnection() {
        usingSocket = false;
    }

    public ECAConnection(Socket socket) {
        this.sock = socket;
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInputStream");
            }
            inputStream = null;
            try {
                if (usingSocket) {
                    inputStream = this.sock.getInputStream();
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "getInputStream exception " + iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream stream : " + inputStream);
        }
        return inputStream;
    }

    public OutputStream getOutputStream() {
        OutputStream outputStream;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOutputStream");
            }
            outputStream = null;
            try {
                outputStream = usingSocket ? this.sock.getOutputStream() : new ECAOutputStream(null);
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getOutputStream exception " + iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream stream : " + outputStream);
        }
        return outputStream;
    }

    public InetAddress getInetAddress() {
        InetAddress inetAddress;
        block4: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInetAddress");
            }
            inetAddress = null;
            try {
                inetAddress = usingSocket ? this.sock.getInetAddress() : InetAddress.getLocalHost();
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getInetAddress exception " + iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInetAddress addr : " + inetAddress);
        }
        return inetAddress;
    }

    public void close() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "close");
            }
            if (usingSocket) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "close exception " + iOException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }
}

