/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.eca;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.eca.ECAConnection;
import com.ibm.ws.management.AdminHelper;
import java.io.IOException;
import java.net.ServerSocket;

public class ECAListener {
    private static TraceComponent tc = Trace.register(ECAListener.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean isZOS = false;
    private static boolean once = false;
    private static boolean accepting = true;
    ServerSocket serverSock;

    public ECAListener(int n) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "socket : " + n);
            }
            if (!(isZOS = AdminHelper.getPlatformHelper().isZOS())) {
                try {
                    this.serverSock = new ServerSocket(n);
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "IOException " + iOException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ECAConnection accept() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "accept");
        }
        try {
            if (!isZOS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accept server socket");
                }
                ECAConnection eCAConnection = new ECAConnection(this.serverSock.accept());
                return eCAConnection;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "accept");
            }
            ECAConnection eCAConnection = new ECAConnection();
            return eCAConnection;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "accept IOException");
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "accept");
            }
        }
        return null;
    }

    public static boolean isAccepting() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAccepting");
        }
        if (isZOS) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isAccepting is zOS Servant");
            }
            if (accepting) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accepting");
                }
                if (!once) {
                    once = true;
                } else {
                    accepting = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAccepting " + accepting);
        }
        return accepting;
    }
}

