/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIInterceptInputStream;
import com.ibm.ws.esi.channel.ESIChannelLink;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ESIInterceptOutputStream
extends DataOutputStream {
    private static final TraceComponent tc = Tr.register(ESIInterceptOutputStream.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private ByteArrayOutputStream bos = null;
    private ESIChannelLink session;

    public ESIInterceptOutputStream(ESIChannelLink eSIChannelLink) {
        super(new ByteArrayOutputStream());
        this.session = eSIChannelLink;
        this.bos = (ByteArrayOutputStream)this.out;
    }

    public void sendMessageHeaders() {
        this.session.sendMessageHeaders();
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flush() ");
        }
        if (this.bos != null) {
            String string = new String(this.bos.toByteArray()).trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "flush() command : " + string);
            }
            try {
                this.session.sendIt(this.bos.toByteArray());
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "flush() caught exception " + throwable);
                }
                throwable.printStackTrace();
                throw new IOException(throwable.getMessage());
            }
            finally {
                this.bos.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flush()");
        }
    }

    public ESIInterceptInputStream flushWithResponse(boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flushWithResponse() lookForMsgEnd=" + bl);
        }
        byte[] byArray = null;
        if (this.bos != null) {
            String string = new String(this.bos.toByteArray()).trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "flushWithResponse() command :'" + string + "'");
            }
            try {
                byArray = this.session.sendItAndGetReply(this.bos.toByteArray(), bl);
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "flushWithResponse() caught exception " + throwable);
                }
                throwable.printStackTrace();
                throw new IOException(throwable.getMessage());
            }
            finally {
                this.bos.reset();
            }
        }
        if (byArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "flushWithResponse() : null response received.");
            }
            throw new IOException("flushWithResponse() : null response received.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flushWithResponse() " + byArray.length);
        }
        return new ESIInterceptInputStream(byArray);
    }
}

