/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIIntercept;
import com.ibm.ws.cache.esi.ESIInvalidatorConnection;
import com.ibm.ws.cache.esi.ESIInvalidatorDriver;
import com.ibm.ws.esi.channel.ESIChannelLink;
import java.rmi.RemoteException;
import java.util.Hashtable;

public class ESIInvalidator {
    private static TraceComponent tc = Tr.register(ESIInvalidator.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static ESIInvalidatorDriver driver = null;
    protected static boolean isUp = false;
    protected static String cmdStr = null;
    protected static int cmdVal = 0;
    protected static String response = null;
    protected static Hashtable connections = new Hashtable();

    public ESIInvalidator() {
        driver = new ESIInvalidatorDriver();
        isUp = true;
    }

    private void setCommandValues(String string) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCommandValues() : " + string);
        }
        if (isUp) {
            if (string == null) {
                throw new RemoteException("ESIInvalidator.SetCommandValues received null string");
            }
        } else {
            throw new RemoteException("down");
        }
        cmdStr = string;
        cmdVal = new Integer(cmdStr.substring(0, 1));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCommandValues() : " + cmdVal + " / " + cmdStr);
        }
    }

    public synchronized void sendCommand(String string) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendCommand() : " + string);
        }
        this.setCommandValues(string);
        driver.sendCommand();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendCommand()");
        }
    }

    public synchronized String flowCommand(String string) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flowCommand() : " + string);
        }
        this.setCommandValues(string);
        response = driver.sendCommand();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flowCommand() " + response);
        }
        return response;
    }

    public static synchronized void addConnection(ESIChannelLink eSIChannelLink) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addConnection() : " + (Object)((Object)eSIChannelLink));
        }
        String string = null;
        String string2 = eSIChannelLink.getRequestURI();
        String string3 = eSIChannelLink.getServerName();
        Integer n = new Integer(eSIChannelLink.getServerPort());
        String string4 = n.toString();
        string = string3 + ":" + string4;
        if (isUp) {
            if (connections.containsKey(string)) {
                ESIInvalidatorConnection eSIInvalidatorConnection = (ESIInvalidatorConnection)connections.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addConnection() : Found existing plugin connection " + eSIInvalidatorConnection.getPlugin() + " state : " + eSIInvalidatorConnection.isBound);
                }
            } else {
                ESIInvalidatorConnection eSIInvalidatorConnection = new ESIInvalidatorConnection(eSIChannelLink, string, string2);
                if (eSIInvalidatorConnection.isBound) {
                    connections.put(string, eSIInvalidatorConnection);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addConnection() : plugin connection " + eSIInvalidatorConnection.getPlugin() + " state : " + eSIInvalidatorConnection.isBound);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addConnection() :  proxy is not active - freeing session");
            }
            ESIIntercept.ESIFree(eSIChannelLink);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addConnection()");
        }
    }

    public static synchronized void removeConnection(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeConnection() : ");
        }
        ESIInvalidatorConnection eSIInvalidatorConnection = (ESIInvalidatorConnection)connections.get(string);
        ESIChannelLink eSIChannelLink = eSIInvalidatorConnection.getSession();
        connections.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeConnection()");
        }
    }

    public void shutdown() {
        isUp = false;
    }
}

