/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIInterceptInputStream;
import com.ibm.ws.cache.esi.ESIInterceptOutputStream;
import com.ibm.ws.cache.esi.ESIInvalidator;
import com.ibm.ws.cache.esi.ESIInvalidatorConnection;
import com.ibm.ws.cache.esi.ESIInvalidatorDriver;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import java.io.IOException;

public class ESIInvalidatorCollector
extends ThreadLocal
implements Runnable {
    private static TraceComponent tc = Tr.register(ESIInvalidatorCollector.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private ESIInvalidatorConnection eipc = null;

    public Object initialValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run() : collector thread running ... for " + this.eipc);
        }
        String string = ESIInvalidatorCollector.getThread();
        if (this.eipc == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run() : null eipc set for collector thread " + string);
            }
            return;
        }
        ESIInvalidatorConnection eSIInvalidatorConnection = this.eipc;
        synchronized (eSIInvalidatorConnection) {
            String string2 = this.getConnection().getPlugin();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "run() : collector thread " + string + " awoken for connection " + string2);
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "run() : collector thread " + string + " sending gather to plugin " + string2);
                }
                this.collect((ESIInterceptOutputStream)this.getConnection().getDos());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "run() : collector thread " + string + " received data from plugin [" + ESIInvalidatorDriver.resultsBuffer + "]");
                }
                ++ESIInvalidatorDriver.results;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "run() ex : collector thread " + string + " broken connection (" + exception.toString() + ") to " + string2);
                }
                this.getConnection().unbind();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "run() ex : collector thread " + string + " after command send failure, plugins connected : " + ESIInvalidator.connections.size());
                }
            }
            finally {
                this.notifyDriver();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run() on " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDriver() {
        String string = ESIInvalidatorCollector.getThread();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyDriver() from collector " + this + " on " + string);
        }
        Thread thread = ESIInvalidatorDriver.driver;
        synchronized (thread) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "notifyDriver() " + string + " notifies : " + ESIInvalidatorDriver.notifies + " driver waiting : " + ESIInvalidatorDriver.waiting);
            }
            if (ESIInvalidatorDriver.waiting) {
                --ESIInvalidatorDriver.notifies;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "notifyDriver() : " + string + " notifies outstanding after this sequence : " + ESIInvalidatorDriver.notifies + ". Driver waiting : " + ESIInvalidatorDriver.waiting);
                }
                if (ESIInvalidatorDriver.notifies == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "notifyDriver() : " + string + " interrupting driver : " + ESIInvalidatorDriver.driver.getName() + " / " + ESIInvalidatorDriver.driver.toString());
                    }
                    ESIInvalidatorDriver.driver.interrupt();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyDriver() on " + string + " : " + ESIInvalidatorDriver.notifies);
        }
    }

    private void collect(ESIInterceptOutputStream eSIInterceptOutputStream) throws IOException {
        this.fetchPid(eSIInterceptOutputStream);
        ESIInterceptInputStream eSIInterceptInputStream = this.sendGather(eSIInterceptOutputStream);
        this.collectStats(eSIInterceptInputStream);
    }

    private void fetchPid(ESIInterceptOutputStream eSIInterceptOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fetchPid() " + ESIInvalidatorCollector.getThread() + " ");
        }
        ESIInterceptInputStream eSIInterceptInputStream = ESIInvalidatorHelper.sendCommand(eSIInterceptOutputStream, 1, true);
        this.getConnection().setPid(eSIInterceptInputStream.readInt());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fetchPid() : " + ESIInvalidatorCollector.getThread() + " " + this.getConnection().getPid());
        }
    }

    private ESIInterceptInputStream sendGather(ESIInterceptOutputStream eSIInterceptOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendGather() " + ESIInvalidatorCollector.getThread() + " " + ESIInvalidatorDriver.selection);
        }
        eSIInterceptOutputStream.writeInt(2);
        eSIInterceptOutputStream.writeInt(ESIInvalidatorDriver.selection);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendGather() " + ESIInvalidatorCollector.getThread());
        }
        return eSIInterceptOutputStream.flushWithResponse(true);
    }

    private void collectStats(ESIInterceptInputStream eSIInterceptInputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectStats(" + this.toString() + ") " + ESIInvalidatorCollector.getThread());
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String string = ESIInvalidatorCollector.getThread();
        String string2 = this.getPlugin();
        int n2 = 0;
        stringBuffer.append(ESIInvalidatorHelper.setInt(1));
        stringBuffer.append(ESIInvalidatorHelper.setInt(this.getConnection().getPid()));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "collectStats() : " + string + "  setting remotehostname " + this.getConnection().getRemoteHostName() + " for plugin " + string2);
        }
        stringBuffer.append(ESIInvalidatorHelper.setShort((short)this.getConnection().getRemoteHostName().length()));
        stringBuffer.append(this.getConnection().getRemoteHostName());
        n = eSIInterceptInputStream.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "collectStats() : " + string + " got responseType " + n);
        }
        if (n != 2) {
            throw new IOException("collectStats() : " + string + " did not find start of response");
        }
        stringBuffer.append(ESIInvalidatorHelper.setInt(n));
        block4: while (true) {
            n = eSIInterceptInputStream.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "collectStats() : " + string + " responseType " + n);
            }
            stringBuffer.append(ESIInvalidatorHelper.setInt(n));
            switch (n) {
                case 12: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "collectStats() : " + string + " cache entry");
                    }
                    short s = eSIInterceptInputStream.readShort();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "collectStats() : " + string + " strlen: " + s);
                    }
                    stringBuffer.append(ESIInvalidatorHelper.setShort(s));
                    byte[] byArray = new byte[s];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "collectStats() readFully: " + string + " available: " + eSIInterceptInputStream.available());
                    }
                    eSIInterceptInputStream.readFully(byArray, 0, byArray.length);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "collectStats() : " + string + " keyEBCDIC: " + byArray);
                    }
                    String string3 = new String(byArray, "ASCII");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "collectStats() : " + string + " cache entry received " + new String(string3));
                    }
                    stringBuffer.append(string3);
                    int n3 = eSIInterceptInputStream.readInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "collectStats() : " + string + " messageEnds: " + n3);
                    }
                    if (n3 != 6) {
                        throw new IOException("collectStats() : " + string + " expecting end of cache entry, instead got " + n3);
                    }
                    stringBuffer.append(ESIInvalidatorHelper.setInt(n3));
                    if (!tc.isDebugEnabled()) continue block4;
                    Tr.debug(tc, "collectStats() : " + string + " done cache entry");
                    continue block4;
                }
                case 6: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "collectStats() : " + string + " end of gather");
                    }
                    stringBuffer.append(ESIInvalidatorHelper.setInt(n));
                    break;
                }
                default: {
                    if (n > 0) {
                        n2 = eSIInterceptInputStream.readInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "collectStats() : " + string + " default received value : " + n2);
                        }
                        stringBuffer.append(ESIInvalidatorHelper.setInt(n2));
                        break;
                    }
                    throw new IOException("collectStats() : " + string + " default received something unrecognisable : " + n2);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "collectStats() : " + string + " done with response type : " + n);
            }
            if (n == 6) break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "collectStats() : " + string + " ESIInvalidatorDriver.resultsBuffer: " + stringBuffer);
        }
        ESIInvalidatorDriver.resultsBuffer.append(stringBuffer);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, stringBuffer.toString());
            Tr.exit(tc, "collectStats(" + this.toString() + ") " + string + " response length : " + stringBuffer.length());
        }
    }

    protected void setConnection(ESIInvalidatorConnection eSIInvalidatorConnection) {
        this.eipc = eSIInvalidatorConnection;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setConnection(" + this.toString() + ") collector");
        }
    }

    protected ESIInvalidatorConnection getConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnection(" + this.toString() + ") collector");
        }
        return (ESIInvalidatorConnection)this.eipc.get();
    }

    private String getPlugin() {
        return this.getConnection().getPlugin();
    }

    private static String getThread() {
        return "(# " + Thread.currentThread().getName() + ")";
    }

    public String toString() {
        return Integer.toHexString(this.hashCode());
    }
}

