/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cache.esi.ESIInvalidatorControllerProxy;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ComponentImpl;

public class ESIInvalidatorComponentImpl
extends ComponentImpl {
    private static TraceComponent tc = Tr.register(ESIInvalidatorComponentImpl.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static ESIInvalidatorControllerProxy proxy = null;

    public void start() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start() : getting CR/SR");
        }
        if (this.shouldRunInThisJVM() && ESIInvalidatorHelper.isZOSController) {
            this.setStartupState("STARTING");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start() : in z CR - init ESI Proxy");
            }
            try {
                String string = System.getProperty("com.ibm.vm.bitmode");
                int n = Integer.parseInt(string);
                if (n == 64) {
                    System.loadLibrary("bbgcomm");
                } else {
                    System.loadLibrary("bbocomm");
                }
            }
            catch (Throwable throwable) {
                this.setStartupState("FAILED");
                throw new RuntimeWarning(throwable);
            }
            try {
                proxy = (ESIInvalidatorControllerProxy)this.getProxyInstance();
                AdminHelper.getPlatformHelper().register_initial_reference(proxy.getName(), proxy);
                proxy.init();
                this.setStartupState("STARTED");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "start() : created ESIControllerProxy");
                }
            }
            catch (Throwable throwable) {
                this.setStartupState("FAILED");
                Tr.event(tc, "start() : Error creating ESIControllerProxy : " + throwable);
                throw new RuntimeWarning(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start()");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop()");
        }
        if (this.shouldRunInThisJVM()) {
            block6: {
                this.setDownState("STOPPING");
                if (ESIInvalidatorHelper.isZOSController) {
                    try {
                        proxy.shutdown();
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug(tc, "stop() : exception occurred " + exception);
                    }
                }
            }
            this.setDownState("STOPPED");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop()");
        }
    }

    public void initialize() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize()");
        }
        if (this.shouldRunInThisJVM()) {
            try {
                this.setInitializationState("INITIALIZED");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initialize() : exception occurred " + exception);
                }
                throw new RuntimeWarning(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy()");
        }
        if (this.shouldRunInThisJVM()) {
            this.setDownState("DESTROYED");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy()");
        }
    }

    protected void setStartupState(String string) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStartupState() " + string);
        }
        try {
            this.setStartState(string);
        }
        catch (Exception exception) {
            throw new RuntimeWarning(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStartupState()");
        }
    }

    protected void setDownState(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDownState() " + string);
        }
        try {
            this.setStartState(string);
        }
        catch (Throwable throwable) {
            Tr.event(tc, "Exception occurred setting down state : " + throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDownState()");
        }
    }

    private Object getProxyInstance() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProxyInstance() : com.ibm.ws.cache.esi.ESIInvalidatorControllerProxyImpl");
        }
        Class<?> clazz = null;
        Object var2_2 = null;
        try {
            clazz = Class.forName("com.ibm.ws.cache.esi.ESIInvalidatorControllerProxyImpl");
            var2_2 = clazz.newInstance();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getProxyInstance() : exception occurred " + exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProxyInstance()");
        }
        return var2_2;
    }

    private boolean shouldRunInThisJVM() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ESIInvalidatorComponentImpl.shouldRunInThisJVM: Entry.");
        }
        boolean bl = false;
        bl = ESIInvalidatorHelper.isZOS;
        if (bl) {
            bl = ESIInvalidatorHelper.isZOSController;
        }
        if (bl) {
            String string = AdminServiceFactory.getAdminService().getProcessType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ESIInvalidatorComponentImpl.shouldRunInThisJVM:  Process Type = " + string);
            }
            if (string.equals("NodeAgent") || string.equals("DeploymentManager")) {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ESIInvalidatorComponentImpl.shouldRunInThisJVM: Exit rc = " + bl);
        }
        return bl;
    }
}

