/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIInterceptInputStream;
import com.ibm.ws.cache.esi.ESIInterceptOutputStream;
import com.ibm.ws.cache.esi.ESIInvalidator;
import com.ibm.ws.esi.channel.ESIChannelLink;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ESIInvalidatorConnection
extends ThreadLocal {
    private static TraceComponent tc = Tr.register(ESIInvalidatorConnection.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    protected boolean isBound = false;
    private ESIChannelLink link = null;
    private String plugin = null;
    private String remoteHostName = null;
    private int pid = 0;
    private ESIInterceptInputStream dis = null;
    private ESIInterceptOutputStream dos = null;
    private byte[] uriBytes = null;

    public Object initialValue() {
        return this;
    }

    protected ESIInvalidatorConnection(ESIChannelLink eSIChannelLink, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor for session " + string);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "address " + new String(string.getBytes("Cp-037")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.link = eSIChannelLink;
        this.plugin = string;
        this.uriBytes = string2.getBytes();
        int n = this.plugin.indexOf(":");
        this.remoteHostName = this.plugin.substring(0, n);
        if (this.bind()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, ESIInvalidatorConnection.getThread() + " eipc connection established for plugin " + this.plugin);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "eipc connection not established for plugin " + this.plugin);
            }
            this.unbind();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor for session");
        }
    }

    private boolean bind() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind() : " + this.plugin);
        }
        boolean bl = false;
        try {
            this.dis = new ESIInterceptInputStream(this.uriBytes);
            this.dos = new ESIInterceptOutputStream(this.link);
            String string = new String(this.link.getRequestURIAsByteArray());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bind() : " + ESIInvalidatorConnection.getThread() + " request received : " + string);
            }
            if (string.indexOf("/_DynaCacheEsi/esiInvalidator") > -1) {
                this.dos.sendMessageHeaders();
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bind() : connection bound for plugin : " + this.plugin);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bind() : connection received invalid request : " + string);
                }
                this.unbind();
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bind() : plugin connection failed : " + exception.toString() + " - attempting cleanup");
            }
            this.unbind();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bind() : " + ESIInvalidatorConnection.getThread() + " connection established : " + bl);
        }
        this.isBound = bl;
        return bl;
    }

    protected void unbind() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "unbind() : " + this.plugin);
            }
            this.isBound = false;
            try {
                ESIInvalidator.connections.remove(this.plugin);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unbind() : caught exception " + exception + " while removing plugin " + this.plugin);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unbind()");
        }
    }

    protected int getPid() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPid() " + this.pid);
        }
        return this.pid;
    }

    protected void setPid(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setPid() " + n);
        }
        this.pid = n;
    }

    protected DataInputStream getDis() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDis()");
        }
        return this.dis;
    }

    protected DataOutputStream getDos() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDos()");
        }
        return this.dos;
    }

    protected String getPlugin() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPlugin() " + this.plugin);
        }
        return this.plugin;
    }

    protected ESIChannelLink getSession() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSession()");
        }
        return this.link;
    }

    protected String getRemoteHostName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRemoteHostName() " + this.remoteHostName);
        }
        return this.remoteHostName;
    }

    private static String getThread() {
        return "(" + Thread.currentThread().getName() + ")";
    }

    public String toString() {
        String string = "";
        string = "ESIInvalidatorConnection ( " + super.toString() + "    " + "isBound = " + this.isBound + "    " + "link = " + (Object)((Object)this.link) + "    " + "plugin = " + this.plugin + "    " + "remoteHostName = " + this.remoteHostName + "    " + "pid = " + this.pid + "    " + "dis = " + this.dis + "    " + "dos = " + this.dos + "    " + "uriBytes = " + this.uriBytes + "    " + " )";
        return string;
    }
}

