/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.persistent.filemgr;

import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.PrimitiveArrayPool;
import com.ibm.ws.cache.persistent.filemgr.Constants;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerException;
import com.ibm.ws.cache.persistent.filemgr.Instrumentation;
import com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper;
import com.ibm.ws.cache.persistent.filemgr.PhysicalFileInterface;
import com.ibm.ws.cache.persistent.util.ByteArrayPlusOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FileManagerImpl
implements FileManager,
Constants,
Instrumentation {
    private long allocs = 0L;
    private long deallocs = 0L;
    private long coalesces = 0L;
    private long allocated_blocks = 0L;
    private long free_blocks = 0L;
    private long allocated_words = 0L;
    private long free_words = 0L;
    private long seeks = 0L;
    private long small_requests = 0L;
    private long large_requests = 0L;
    private long ql_hits = 0L;
    private long ml_hits = 0L;
    private long ml_splits = 0L;
    private long ml_blocks_searched = 0L;
    private int fast_startups = 0;
    private int nonempty_lists = 0;
    private long write_time = 0L;
    private long read_time = 0L;
    private int read_count = 0;
    private int write_count = 0;
    private long bytes_read = 0L;
    private long bytes_written = 0L;
    private int first_quick_size = 1;
    private int last_quick_size = 75;
    private int grain_size = 512;
    private int acceptable_waste = 2000;
    private int first_quick_size_block;
    private int last_quick_size_block;
    private int last_ql_index;
    private boolean readOnly;
    private long tail_ptr;
    private String filename;
    private int type;
    private int truetype;
    private Listhead[] ql_heads;
    private long[][] userData = new long[128][2];
    private PhysicalFileInterface physical = null;
    private HTODDynacache htoddc = null;

    public FileManagerImpl(String string, boolean bl, String string2, int n, HTODDynacache hTODDynacache) throws FileManagerException, IOException {
        this.type = n;
        this.htoddc = hTODDynacache;
        if (n != 2) {
            throw new FileManagerException("Unknown type: " + n);
        }
        this.physical = new MultivolumeRAFWrapper(string, string2, this, hTODDynacache.getDiskCacheSizeInfo());
        this.filename = string;
        this.readOnly = string2.equals("r");
        if (this.length() == 0L) {
            if (this.readOnly) {
                throw new FileManagerException("Attempt to open an empty file in read only mode");
            }
            this.tail_ptr = 16384L;
            this.seek(0L);
            this.writeLong(44534132L);
            this.writeLong(16384L);
            this.writeLong(0L);
            this.writeInt(this.first_quick_size);
            this.writeInt(this.last_quick_size);
            this.writeInt(this.grain_size);
            this.writeInt(this.acceptable_waste);
            byte[] byArray = new byte[128];
            this.write(byArray);
            byArray = new byte[2048];
            this.write(byArray);
            this.init_freelists(true);
        } else {
            this.seek(0L);
            long l = this.readLong();
            if (l != 44534132L) {
                throw new FileManagerException("File not valid (invalid magic string). Expected 44534132 received " + l);
            }
            this.tail_ptr = this.readLong();
            if (this.tail_ptr < 16384L) {
                throw new FileManagerException("File not valid (illegal tail pointer)");
            }
            long l2 = this.readLong();
            if (l2 < 0L) {
                throw new FileManagerException("File not valid (illegal end of cache pointer)");
            }
            this.first_quick_size = this.readInt();
            if (this.first_quick_size < 1) {
                throw new FileManagerException("File not valid (illegal first quick size)");
            }
            this.last_quick_size = this.readInt();
            if (this.last_quick_size < this.first_quick_size) {
                throw new FileManagerException("File not valid (illegal last quick size)");
            }
            this.grain_size = this.readInt();
            if (this.grain_size < 1) {
                throw new FileManagerException("File not valid (illegal grain size)");
            }
            this.acceptable_waste = this.readInt();
            this.read_user_data();
            this.init_freelists(true);
            if (this.acceptable_waste < 1) {
                throw new FileManagerException("File not valid (illegal acceptable waste)");
            }
            if (bl && !this.readOnly) {
                this.read_block_sizes_from_disk(true);
                this.seek(16L);
                this.writeLong(0L);
            } else if (l2 == 0L) {
                this.read_block_sizes_from_disk(false);
            } else {
                this.read_block_sizes_from_cache(l2);
            }
        }
    }

    private void read_user_data() throws IOException {
        this.seek(168L);
        for (int i = 0; i < 128; ++i) {
            this.userData[i][0] = this.readLong();
            this.userData[i][1] = this.readLong();
        }
    }

    private void writeUserData(int n) throws IOException {
        long l = 168L + (long)(n * 2 * 8);
        this.seek(l);
        this.writeLong(this.userData[n][0]);
        this.writeLong(this.userData[n][1]);
    }

    public long fetchUserData(long l) throws IOException {
        for (int i = 0; i < 128; ++i) {
            if (this.userData[i][0] != l) continue;
            return this.userData[i][1];
        }
        return 0L;
    }

    public boolean storeUserData(long l, long l2) throws IOException, FileManagerException {
        int n;
        if (l == 0L) {
            return false;
        }
        for (n = 0; n < 128; ++n) {
            if (this.userData[n][0] != l) continue;
            this.userData[n][1] = l2;
            this.writeUserData(n);
            return true;
        }
        for (n = 0; n < 128; ++n) {
            if (this.userData[n][0] != 0L) continue;
            this.userData[n][0] = l;
            this.userData[n][1] = l2;
            this.writeUserData(n);
            return true;
        }
        throw new FileManagerException("storeUserdata: No remaining slots");
    }

    public String filename() {
        return this.physical.filename();
    }

    public long length() throws IOException {
        return this.physical.length();
    }

    public void close() throws IOException {
        this.cache_free_storage_info();
        this.physical.close();
    }

    public void flush() throws IOException {
        this.physical.flush();
    }

    public int read() throws IOException {
        ++this.bytes_read;
        return this.physical.read();
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.physical.read(byArray);
        this.bytes_read += (long)n;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.physical.read(byArray, n, n2);
        this.bytes_read += (long)n3;
        return n3;
    }

    public int readInt() throws IOException {
        this.bytes_read += 4L;
        return this.physical.readInt();
    }

    public long readLong() throws IOException {
        this.bytes_read += 8L;
        return this.physical.readLong();
    }

    public short readShort() throws IOException {
        this.bytes_read += 2L;
        return this.physical.readShort();
    }

    public void seek(long l) throws IOException {
        this.physical.seek(l);
    }

    public void write(byte[] byArray) throws IOException {
        this.physical.write(byArray);
        this.bytes_written += (long)byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.physical.write(byArray, n, n2);
        this.bytes_written += (long)n2;
    }

    public void write(int n) throws IOException {
        this.physical.write(n);
        ++this.bytes_written;
    }

    public void writeInt(int n) throws IOException {
        this.physical.writeInt(n);
        this.bytes_written += 4L;
    }

    public void writeLong(long l) throws IOException {
        this.physical.writeLong(l);
        this.bytes_written += 8L;
    }

    public void writeShort(short s) throws IOException {
        this.physical.writeShort(s);
        this.bytes_written += 2L;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void init_storage_parameters() {
        this.first_quick_size_block = this.first_quick_size * this.grain_size;
        this.last_quick_size_block = this.last_quick_size * this.grain_size;
        this.last_ql_index = this.last_quick_size + 1 - this.first_quick_size;
        this.ql_heads = new Listhead[this.last_ql_index + 1];
    }

    private void init_freelists(boolean bl) {
        if (bl) {
            this.init_storage_parameters();
        }
        for (int i = 0; i <= this.last_ql_index; ++i) {
            if (bl) {
                this.ql_heads[i] = new Listhead();
            }
            this.ql_heads[i].length = 0;
            this.ql_heads[i].first_block = null;
        }
        this.nonempty_lists = 0;
    }

    private void read_tail_from_disk() throws IOException {
        this.seek(8L);
        this.tail_ptr = this.readLong();
    }

    private int combine_blocks(long l) throws IOException {
        long l2 = l;
        int n = this.readInt();
        if (n > 0) {
            long l3;
            while (n > 0 && l2 + (long)n < this.tail_ptr) {
                this.seek(l2 += (long)n);
                n = this.readInt();
            }
            if (n < 0) {
                l3 = l2 - l;
                this.seek(l);
                this.writeInt((int)l3);
            } else {
                l3 = this.tail_ptr - l;
            }
            return (int)l3;
        }
        return n;
    }

    private void read_block_sizes_from_disk(boolean bl) throws IOException {
        int n;
        long l = this.tail_ptr;
        for (long i = 16384L; i < this.tail_ptr; i += (long)n) {
            this.seek(i);
            n = bl ? this.combine_blocks(i) : this.readInt();
            if (n > 0) {
                if ((long)n + i >= this.tail_ptr && !this.readOnly) {
                    l = i;
                    continue;
                }
                this.add_to_freelist(i, n);
                continue;
            }
            n = -n;
            ++this.allocated_blocks;
            this.allocated_words += (long)n;
        }
        if (l != this.tail_ptr && !this.readOnly) {
            this.tail_ptr = l;
            this.seek(8L);
            this.writeLong(this.tail_ptr);
        }
    }

    private void read_block_sizes_from_cache(long l) throws IOException {
        byte[] byArray = new byte[(int)(l - this.tail_ptr)];
        this.seek(this.tail_ptr);
        this.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.allocated_blocks = dataInputStream.readLong();
        this.allocated_words = dataInputStream.readLong();
        this.free_blocks = 0L;
        this.free_words = 0L;
        long l2 = this.tail_ptr + 16L;
        while (l2 < l) {
            int n = dataInputStream.readInt();
            long l3 = dataInputStream.readLong();
            l2 += 12L;
            while (l3 != 0L) {
                int n2 = dataInputStream.readInt();
                this.add_new_block_to_freelist(l3, n2, n);
                l3 = dataInputStream.readLong();
                l2 += 12L;
            }
        }
        dataInputStream.close();
        byteArrayInputStream.close();
        if (!this.readOnly) {
            this.seek(16L);
            this.writeLong(0L);
        }
        ++this.fast_startups;
    }

    public void cache_free_storage_info() throws IOException {
        if (this.readOnly) {
            throw new FileManagerException("Attempt to cache free storage information in read only mode");
        }
        long l = 16L + (this.free_blocks + (long)this.nonempty_lists) * 12L;
        ByteArrayPlusOutputStream byteArrayPlusOutputStream = new ByteArrayPlusOutputStream((int)l);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayPlusOutputStream);
        dataOutputStream.writeLong(this.allocated_blocks);
        dataOutputStream.writeLong(this.allocated_words);
        for (int i = 0; i <= this.last_ql_index; ++i) {
            if (this.ql_heads[i].first_block == null) continue;
            dataOutputStream.writeInt(i);
            Block block = this.ql_heads[i].first_block;
            while (block != null) {
                dataOutputStream.writeLong(block.address);
                dataOutputStream.writeInt(block.size);
                block = block.next;
            }
            dataOutputStream.writeLong(0L);
        }
        dataOutputStream.close();
        byteArrayPlusOutputStream.close();
        byte[] byArray = byteArrayPlusOutputStream.getTheBuffer();
        this.seek(this.tail_ptr);
        this.write(byArray);
        this.seek(16L);
        this.writeLong(this.tail_ptr + l);
    }

    public void dump_disk_memory(Writer writer) throws IOException {
        writer.write("Information stored on disk\n");
        this.seek(0L);
        long l = this.readLong();
        writer.write("File magic number: " + l + "\n");
        this.seek(8L);
        long l2 = this.readLong();
        writer.write("Tail on disk: " + l2 + "\n");
        long l3 = this.readLong();
        writer.write("End of cached free list info: " + l3 + "\n");
        int n = this.readInt();
        writer.write("First quick size: " + n + "\n");
        n = this.readInt();
        writer.write("Last quick size: " + n + "\n");
        n = this.readInt();
        writer.write("Grain size: " + n + "\n");
        n = this.readInt();
        writer.write("Acceptable waste: " + n + "\n");
        for (long i = 16384L; i < l2; i += (long)this.abs(n)) {
            this.seek(i);
            n = this.readInt();
            writer.write(i + ", " + n + "\n");
        }
        writer.write("\n\n");
    }

    private void seek_and_count(long l) throws IOException {
        this.seek(l);
        ++this.seeks;
    }

    private void print_memory_freelist(Writer writer, Block block) throws IOException {
        while (block != null) {
            writer.write(block.address + " " + block.size + ", ");
            block = block.next;
        }
        writer.write("\n");
    }

    public void reset_stats() {
        this.seeks = 0L;
        this.small_requests = 0L;
        this.large_requests = 0L;
        this.ql_hits = 0L;
        this.ml_hits = 0L;
        this.ml_splits = 0L;
        this.ml_blocks_searched = 0L;
        this.fast_startups = 0;
        this.deallocs = 0L;
        this.allocs = 0L;
        this.read_count = 0;
        this.write_count = 0;
        this.read_time = 0L;
        this.write_time = 0L;
        this.bytes_read = 0L;
        this.bytes_written = 0L;
    }

    public void dump_stats_header(Writer writer) throws IOException {
        writer.write("Filename\t");
        writer.write("Allocations\t");
        writer.write("Deallocations\t");
        writer.write("Coalesces\t");
        writer.write("Alloc-Blocks\t");
        writer.write("Allocated-Words\t");
        writer.write("Free-Blocks\t");
        writer.write("Free-Words\t");
        writer.write("Seeks\t");
        writer.write("Reads\t");
        writer.write("Writes\t");
        writer.write("Read-Time\t");
        writer.write("Write-Time\t");
        writer.write("Bytes-Read\t");
        writer.write("Bytes-Written\t");
        writer.write("Small-Requests\t");
        writer.write("Large-Requests\t");
        writer.write("QL-Hits\t");
        writer.write("ML-Hits\t");
        writer.write("ML-Splits\t");
        writer.write("ML-Blocks_searched\t");
        writer.write("Fast-Startups\t");
    }

    public void dump_stats(Writer writer, boolean bl) throws IOException {
        if (bl) {
            writer.write("--------------------------------------------------\n");
            writer.write("FileManager Header:\n");
            writer.write("--------------------------------------------------\n");
            writer.write("Filename = " + this.filename + "\n");
            writer.write("Allocations: " + this.allocs + "\n");
            writer.write("Deallocations: " + this.deallocs + "\n");
            writer.write("Coalesces: " + this.coalesces + "\n");
            writer.write("Allocated blocks: " + this.allocated_blocks + "\n");
            writer.write("Allocated bytes: " + this.allocated_words + "\n");
            writer.write("Free blocks: " + this.free_blocks + "\n");
            writer.write("Free bytes: " + this.free_words + "\n");
            writer.write("Seeks: " + this.seeks + "\n");
            writer.write("Requests for small blocks: " + this.small_requests + "\n");
            writer.write("Requests for large blocks: " + this.large_requests + "\n");
            writer.write("Quick list hits: " + this.ql_hits + "\n");
            writer.write("Misc list hits: " + this.ml_hits + "\n");
            writer.write("Block splits (from misc list): " + this.ml_splits + "\n");
            writer.write("Misc list blocks searched: " + this.ml_blocks_searched + "\n");
            writer.write("Fast startups: " + this.fast_startups + "\n");
            writer.write("Read requests: " + this.read_count + "\n");
            writer.write("Write requests: " + this.write_count + "\n");
            writer.write("Accumulated physical read time:" + this.read_time + "\n");
            writer.write("Accumulated physical write time:" + this.write_time + "\n");
            writer.write("Bytes read: " + this.bytes_read + "\n");
            writer.write("Bytes written: " + this.bytes_written + "\n");
        } else {
            writer.write(this.filename + "\t");
            writer.write(this.allocs + "\t");
            writer.write(this.deallocs + "\t");
            writer.write(this.coalesces + "\t");
            writer.write(this.allocated_blocks + "\t");
            writer.write(this.allocated_words + "\t");
            writer.write(this.free_blocks + "\t");
            writer.write(this.free_words + "\t");
            writer.write(this.seeks + "\t");
            writer.write(this.read_count + "\t");
            writer.write(this.write_count + "\t");
            writer.write(this.read_time + "\t");
            writer.write(this.write_time + "\t");
            writer.write(this.bytes_read + "\t");
            writer.write(this.bytes_written + "\t");
            writer.write(this.small_requests + "\t");
            writer.write(this.large_requests + "\t");
            writer.write(this.ql_hits + "\t");
            writer.write(this.ml_hits + "\t");
            writer.write(this.ml_splits + "\t");
            writer.write(this.ml_blocks_searched + "\t");
            writer.write(this.fast_startups + "\t");
        }
    }

    public void dump_memory(Writer writer) throws IOException {
        writer.write("First quick size: " + this.first_quick_size + "\n");
        writer.write("Last quick size: " + this.last_quick_size + "\n");
        writer.write("Grain size: " + this.grain_size + "\n");
        writer.write("Acceptable waste: " + this.acceptable_waste + "\n");
        writer.write("Tail pointer in memory: " + this.tail_ptr + "\n");
        writer.write("First allocatable byte: " + this.start() + "\n\n");
        writer.write("Free lists from memory structures\n");
        for (int i = 0; i <= this.last_ql_index; ++i) {
            writer.write(i + ": ");
            writer.write("Length = " + this.ql_heads[i].length + "; ");
            this.print_memory_freelist(writer, this.ql_heads[i].first_block);
        }
        writer.write("Nonempty free lists: " + this.nonempty_lists + "\n");
        writer.write("Tail pointer in memory: " + this.tail_ptr + "\n");
        writer.write("First allocatable byte: " + this.start() + "\n\n");
    }

    private int calculate_list_index_for_alloc(int n) {
        int n2 = 0;
        if ((n - this.first_quick_size_block) % this.grain_size > 0) {
            n2 = 1;
        }
        return n2 + (n - this.first_quick_size_block) / this.grain_size;
    }

    private int calculate_list_index_for_dealloc(int n) {
        return (n - this.first_quick_size_block) / this.grain_size;
    }

    private int abs(int n) {
        if (n > 0) {
            return n;
        }
        return -n;
    }

    private int calculate_block_size(int n) {
        return this.first_quick_size_block + n * this.grain_size;
    }

    private long allocate_from_tail(int n) throws IOException {
        long l = this.tail_ptr;
        this.tail_ptr += (long)n;
        ++this.allocated_blocks;
        this.allocated_words += (long)n;
        this.seek_and_count(l);
        this.writeInt(-n);
        this.seek_and_count(8L);
        this.writeLong(this.tail_ptr);
        return l + 4L;
    }

    private long allocate_from_ql(int n) throws IOException {
        ++this.small_requests;
        int n2 = this.calculate_list_index_for_alloc(n);
        if (this.ql_heads[n2].length > 0) {
            Block block = this.ql_heads[n2].first_block;
            --this.ql_heads[n2].length;
            if (this.ql_heads[n2].length == 0) {
                --this.nonempty_lists;
            }
            this.ql_heads[n2].first_block = block.next;
            ++this.allocated_blocks;
            --this.free_blocks;
            ++this.ql_hits;
            this.allocated_words += (long)block.size;
            this.free_words -= (long)block.size;
            this.seek_and_count(block.address);
            this.writeInt(-block.size);
            return block.address + 4L;
        }
        int n3 = this.calculate_block_size(n2);
        return this.allocate_from_tail(n3);
    }

    private long split_block(long l, int n, int n2) throws IOException {
        this.allocated_words += (long)n;
        ++this.allocated_blocks;
        this.free_words -= (long)n;
        ++this.ml_hits;
        ++this.ml_splits;
        this.seek_and_count(l + (long)n);
        this.writeInt(n2);
        this.seek_and_count(l);
        this.writeInt(-n);
        return l + 4L;
    }

    private long search_ml(int n) throws IOException {
        int n2;
        Block block = null;
        Block block2 = null;
        Block block3 = this.ql_heads[this.last_ql_index].first_block;
        boolean bl = false;
        Block block4 = null;
        ++this.large_requests;
        while (block3 != null) {
            ++this.ml_blocks_searched;
            if (block3.size >= n) {
                n2 = block3.size - n;
                if (n2 <= this.acceptable_waste) {
                    if (block4 != null) {
                        block4.next = block3.next;
                    } else {
                        this.ql_heads[this.last_ql_index].first_block = block3.next;
                    }
                    --this.ql_heads[this.last_ql_index].length;
                    if (this.ql_heads[this.last_ql_index].length == 0) {
                        --this.nonempty_lists;
                    }
                    ++this.allocated_blocks;
                    --this.free_blocks;
                    ++this.ml_hits;
                    this.allocated_words += (long)block3.size;
                    this.free_words -= (long)block3.size;
                    this.seek_and_count(block3.address);
                    this.writeInt(-block3.size);
                    return block3.address + 4L;
                }
                if (block == null) {
                    block = block3;
                    block2 = block4;
                } else if (block.size >= block3.size) {
                    block = block3;
                    block2 = block4;
                }
            }
            block4 = block3;
            block3 = block3.next;
        }
        if (block == null) {
            return this.allocate_from_tail(n);
        }
        n2 = block.size - n;
        long l = block.address;
        if (n2 <= this.last_quick_size_block) {
            int n3 = n2 % this.grain_size;
            int n4 = this.calculate_list_index_for_dealloc(n2 -= n3);
            n += n3;
            if (block2 != null) {
                block2.next = block.next;
            } else {
                this.ql_heads[this.last_ql_index].first_block = block.next;
            }
            this.add_block_to_freelist(block, n4);
        }
        block.size = n2;
        block.address += (long)n;
        return this.split_block(l, n, n2);
    }

    public long start() {
        return 16388L;
    }

    public int grain_size() {
        return this.grain_size;
    }

    public long allocateAndClear(int n) throws FileManagerException, IOException, EOFException {
        long l = this.allocate(n);
        PrimitiveArrayPool.PoolEntry poolEntry = this.htoddc.byteArrayPool.allocate(n);
        byte[] byArray = (byte[])poolEntry.getArray();
        this.seek(l);
        this.write(byArray);
        this.htoddc.byteArrayPool.returnToPool(poolEntry);
        return l;
    }

    public long allocate(int n) throws IOException {
        if (this.readOnly) {
            throw new FileManagerException("Attempt to allocate in read only mode");
        }
        ++this.allocs;
        if ((n += 4) <= this.last_quick_size_block) {
            return this.allocate_from_ql(n);
        }
        n = (n + this.grain_size - 1) / this.grain_size * this.grain_size;
        return this.search_ml(n);
    }

    private int get_block_size(long l) throws IOException {
        this.seek_and_count(l);
        return this.readInt();
    }

    private void add_block_to_freelist(Block block, int n) {
        block.next = this.ql_heads[n].first_block;
        this.ql_heads[n].first_block = block;
        ++this.ql_heads[n].length;
        if (this.ql_heads[n].length == 1) {
            ++this.nonempty_lists;
        }
    }

    private void add_new_block_to_freelist(long l, int n, int n2) {
        Block block = new Block();
        block.address = l;
        block.size = n;
        this.add_block_to_freelist(block, n2);
        ++this.free_blocks;
        this.free_words += (long)n;
    }

    private void add_to_freelist(long l, int n) {
        int n2 = n <= this.last_quick_size_block ? this.calculate_list_index_for_dealloc(n) : this.last_ql_index;
        this.add_new_block_to_freelist(l, n, n2);
    }

    public void deallocate(long l) throws IOException {
        if (this.readOnly) {
            throw new FileManagerException("Attempt to deallocate in read only mode");
        }
        if ((l -= 4L) < 16384L) {
            throw new FileManagerException("Illegal block address passed to deallocate");
        }
        int n = this.get_block_size(l);
        if (n >= 0) {
            throw new FileManagerException("Attempt to deallocate block with illegal size");
        }
        n = this.abs(n);
        ++this.deallocs;
        this.seek_and_count(l);
        this.writeInt(n);
        this.add_to_freelist(l, n);
        --this.allocated_blocks;
        this.allocated_words -= (long)n;
    }

    public void coalesce() throws IOException {
        if (this.readOnly) {
            throw new FileManagerException("Attempt to coalesce in read only mode");
        }
        this.free_blocks = 0L;
        this.free_words = 0L;
        this.allocated_blocks = 0L;
        this.allocated_words = 0L;
        this.init_freelists(false);
        this.read_block_sizes_from_disk(true);
        ++this.coalesces;
    }

    public void update_read_time(long l) {
        this.read_time += l;
    }

    public void update_write_time(long l) {
        this.write_time += l;
    }

    public void increment_read_count() {
        ++this.read_count;
    }

    public void increment_write_count() {
        ++this.write_count;
    }

    private void run_tests() throws IOException {
        long l = this.allocate(900);
        long l2 = this.allocate(900);
        long l3 = this.allocate(900);
        long l4 = this.allocate(1900);
        long l5 = this.allocate(2900);
        long l6 = this.allocate(900);
        long l7 = this.allocate(7900);
        this.deallocate(l);
        this.deallocate(l2);
        this.deallocate(l3);
        this.deallocate(l4);
        this.deallocate(l5);
        this.deallocate(l6);
        this.deallocate(l7);
        this.cache_free_storage_info();
    }

    public static void main(String[] stringArray) throws FileManagerException, IOException {
        HTODDynacache hTODDynacache = new HTODDynacache();
        FileManagerImpl fileManagerImpl = new FileManagerImpl("foo1", false, "rw", 2, hTODDynacache);
        fileManagerImpl.run_tests();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        fileManagerImpl.dump_disk_memory(outputStreamWriter);
        fileManagerImpl.dump_memory(outputStreamWriter);
        fileManagerImpl.dump_stats(outputStreamWriter, false);
        fileManagerImpl.cache_free_storage_info();
        fileManagerImpl.dump_disk_memory(outputStreamWriter);
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    class Listhead {
        public int length;
        public Block first_block;

        Listhead() {
        }
    }

    class Block {
        public long address;
        public int size;
        public Block next;

        Block() {
        }
    }
}

