/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

class CacheProxyInputStream
extends ServletInputStream {
    BufferedInputStream bis = null;
    protected int buffer = -1;
    boolean canMark = false;

    public CacheProxyInputStream(InputStream inputStream, int n) {
        this.bis = new BufferedInputStream(inputStream, n);
        this.bis.mark(n);
        this.buffer = n;
    }

    protected void setCanMark(boolean bl) {
        this.canMark = bl;
    }

    public boolean markSupported() {
        return this.canMark;
    }

    public int available() throws IOException {
        return this.bis.available();
    }

    public void close() throws IOException {
    }

    public void mark(int n) {
        if (!this.canMark) {
            throw new IllegalStateException("ServletInputStream/CacheProxyInputStream does not support mark");
        }
        this.bis.mark(n);
    }

    public int read() throws IOException {
        return this.bis.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.bis.read(byArray, n, n2);
    }

    public void reset() throws IOException {
        if (!this.canMark) {
            throw new IllegalStateException("ServletInputStream/CacheProxyInputStream does not support mark/reset");
        }
        this.bis.reset();
    }

    public long skip(long l) throws IOException {
        return this.bis.skip(l);
    }
}

