/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import com.ibm.ws.cache.servlet.ESIInputStream;
import com.ibm.ws.cache.servlet.ESIOutputStream;
import com.ibm.ws.cache.servlet.ESIProcessorKeepAliveDaemon;
import com.ibm.ws.cache.servlet.ESIProcessorRequest;
import com.ibm.ws.cache.servlet.ESIProcessorStats;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ESIProcessor {
    private static final List _running = Collections.synchronizedList(new LinkedList());
    private static final TraceComponent _tc = Tr.register(ESIProcessor.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.servlet.ESIProcessor");
    private static final boolean isZOS = ESIInvalidatorHelper.isZOS;
    private String _hostName;
    private int _pid;
    private ESIInputStream _in;
    private ESIOutputStream _out;
    private int _localPort;
    private int _serverPort;
    private int _remotePort;
    private String _localAddr;
    private String _localName;
    private boolean _isAlive;
    private ESIProcessorRequest _curRequest = null;
    private static ESIProcessor protoprocessor = null;
    private ESIProcessorKeepAliveDaemon _keepAliveDaemon = null;
    private static final int KEEP_ALIVE_INTERVAL_IN_MS = 45000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String string, InputStream inputStream, OutputStream outputStream) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "run: " + string);
        }
        ESIProcessor eSIProcessor = null;
        try {
            eSIProcessor = new ESIProcessor(string, inputStream, outputStream);
            ESIProcessor.runCommon(eSIProcessor);
        }
        catch (IOException iOException) {
            if (_tc.isDebugEnabled()) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        finally {
            if (eSIProcessor != null) {
                _running.remove(eSIProcessor);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "run: " + eSIProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "run: " + httpServletRequest.getRemoteHost());
        }
        ESIProcessor eSIProcessor = null;
        try {
            eSIProcessor = new ESIProcessor(httpServletRequest, httpServletResponse);
            ESIProcessor.runCommon(eSIProcessor);
        }
        catch (IOException iOException) {
            if (_tc.isDebugEnabled()) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        finally {
            if (eSIProcessor != null) {
                _running.remove(eSIProcessor);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "run: " + eSIProcessor);
            }
        }
    }

    private static void runCommon(ESIProcessor eSIProcessor) throws IOException {
        if (isZOS) {
            protoprocessor = eSIProcessor;
        }
        _running.add(eSIProcessor);
        if (!isZOS) {
            eSIProcessor.listen();
        }
    }

    public static ESIProcessor[] getRunning() {
        if (isZOS) {
            _running.clear();
            _running.add(protoprocessor);
        }
        return _running.toArray(new ESIProcessor[0]);
    }

    public static synchronized int collectEdgeStats(int n) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "collectEdgeStats " + n);
        }
        String string = null;
        int n2 = 0;
        if (protoprocessor == null) {
            throw new IOException("collectEdgeStats() : Edge inactive.");
        }
        protoprocessor.writeInt(2);
        protoprocessor.writeInt(n);
        protoprocessor.flushWithResponse();
        string = ESIProcessor.protoprocessor._in.readUTF();
        n2 = new Integer(string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "collectEdgeStats() : plugins responded : " + n2);
        }
        return n2;
    }

    public static void invalidateIds(Iterator iterator) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invalidateIds");
        }
        ESIProcessor[] eSIProcessorArray = ESIProcessor.getRunning();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof String)) continue;
            for (int i = 0; i < eSIProcessorArray.length; ++i) {
                try {
                    eSIProcessorArray[i].invalidateId((String)e2);
                    continue;
                }
                catch (Exception exception) {
                    Tr.warning(_tc, "failure invalidating " + e2 + " in " + eSIProcessorArray[i] + ": " + exception.getMessage());
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invalidateIds");
        }
    }

    public static void clearCaches() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "clearCaches");
        }
        ESIProcessor[] eSIProcessorArray = ESIProcessor.getRunning();
        for (int i = 0; i < eSIProcessorArray.length; ++i) {
            try {
                eSIProcessorArray[i].clearCache();
                continue;
            }
            catch (Exception exception) {
                Tr.warning(_tc, "failure clearing cache in " + eSIProcessorArray[i] + ": " + exception.getMessage());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "clearCaches");
        }
    }

    public static void resetCounters() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resetCounters");
        }
        ESIProcessor[] eSIProcessorArray = ESIProcessor.getRunning();
        for (int i = 0; i < eSIProcessorArray.length; ++i) {
            try {
                eSIProcessorArray[i].resetCounter();
                continue;
            }
            catch (Exception exception) {
                Tr.warning(_tc, "failure resetting counters in " + eSIProcessorArray[i] + ": " + exception.getMessage());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resetCounters");
        }
    }

    public static synchronized ESIProcessorStats[] gather(int n) throws IOException {
        ESIProcessorStats[] eSIProcessorStatsArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "gather");
        }
        if (!isZOS) {
            int n2;
            ESIProcessor[] eSIProcessorArray = ESIProcessor.getRunning();
            eSIProcessorStatsArray = new ESIProcessorStats[eSIProcessorArray.length];
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "submitting requests to " + eSIProcessorStatsArray.length + " ESI processors");
            }
            for (n2 = 0; n2 < eSIProcessorStatsArray.length; ++n2) {
                eSIProcessorStatsArray[n2] = new ESIProcessorStats(eSIProcessorArray[n2], n);
                eSIProcessorArray[n2].submit(eSIProcessorStatsArray[n2]);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "waiting for responses");
            }
            n2 = 0;
            for (int i = 0; i < eSIProcessorStatsArray.length; ++i) {
                try {
                    if (eSIProcessorArray[i].isAlive()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "waiting for response from " + eSIProcessorArray[i].toString());
                        }
                        eSIProcessorStatsArray[i].awaitCompletion();
                        ++n2;
                        continue;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "processor is dead; not waiting for response from " + eSIProcessorArray[i].toString());
                    }
                    eSIProcessorStatsArray[i] = null;
                    continue;
                }
                catch (Throwable throwable) {
                    eSIProcessorStatsArray[i] = null;
                }
            }
            if (eSIProcessorStatsArray.length > n2) {
                ESIProcessorStats[] eSIProcessorStatsArray2 = new ESIProcessorStats[n2];
                n2 = 0;
                for (int i = 0; i < eSIProcessorStatsArray.length; ++i) {
                    if (eSIProcessorStatsArray[i] == null) continue;
                    eSIProcessorStatsArray2[n2++] = eSIProcessorStatsArray[i];
                }
                eSIProcessorStatsArray = eSIProcessorStatsArray2;
            }
        } else {
            int n3 = ESIProcessor.collectEdgeStats(8064);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "processors : " + n3);
            }
            eSIProcessorStatsArray = new ESIProcessorStats[n3];
            for (int i = 0; i < n3; ++i) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processing stats block " + i);
                }
                eSIProcessorStatsArray[i] = new ESIProcessorStats(protoprocessor, 8064);
                eSIProcessorStatsArray[i].handle();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "gather");
        }
        return eSIProcessorStatsArray;
    }

    protected ESIProcessor(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this._serverPort = httpServletRequest.getServerPort();
        this._remotePort = httpServletRequest.getRemotePort();
        this._localPort = httpServletRequest.getLocalPort();
        this._localAddr = httpServletRequest.getLocalAddr();
        this._localName = httpServletRequest.getLocalName();
        this.initalizeProcessor(httpServletRequest.getRemoteHost(), new ESIInputStream((InputStream)httpServletRequest.getInputStream()), new ESIOutputStream((OutputStream)httpServletResponse.getOutputStream()));
    }

    protected ESIProcessor(String string, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.initalizeProcessor(string, inputStream, outputStream);
    }

    private void initalizeProcessor(String string, InputStream inputStream, OutputStream outputStream) throws IOException {
        this._hostName = string;
        this._in = new ESIInputStream(inputStream);
        this._out = new ESIOutputStream(outputStream);
        if (isZOS && this._out == null) {
            Tr.event(_tc, "ESIProcessor constructor : no ESI OutputStream available.");
            throw new IOException("ESIProcessor constructor : no ESI OutputStream available.");
        }
        this._isAlive = true;
        this.initPID();
        this._keepAliveDaemon = new ESIProcessorKeepAliveDaemon(45000L);
        this._keepAliveDaemon.setESIProcessor(this);
        this._keepAliveDaemon.start();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "constructed " + this);
        }
    }

    public boolean isAlive() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "is alive: " + this);
        }
        return this._isAlive;
    }

    protected synchronized void markDead() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "mark dead: " + this);
        }
        this._isAlive = false;
        this._keepAliveDaemon.stop();
        this.notify();
    }

    public String getHostName() {
        return this._hostName;
    }

    public int getPID() {
        return this._pid;
    }

    public synchronized void invalidateId(String string) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invalidateId '" + string + "' in " + this);
        }
        this.writeInt(5);
        this.writeString(string);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invalidateId '" + string + "' in " + this);
        }
    }

    public synchronized void clearCache() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "clearCache in " + this);
        }
        this.writeInt(4);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "clearCache in " + this);
        }
    }

    public synchronized void resetCounter() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resetCounter in " + this);
        }
        this.writeInt(3);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resetCounter in " + this);
        }
    }

    public synchronized void submit(ESIProcessorRequest eSIProcessorRequest) throws IOException {
        this._curRequest = eSIProcessorRequest;
        this.notify();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "submit gather in " + this);
        }
    }

    private synchronized void listen() throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "begin listening to " + this);
        }
        while (this._isAlive) {
            if (this._curRequest != null) {
                try {
                    this._curRequest.handle();
                    this._curRequest.markCompleted(null);
                }
                catch (Throwable throwable) {
                    this._curRequest.markCompleted(throwable);
                }
                this._curRequest = null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "end listening to " + this);
        }
    }

    synchronized void initPID() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initPID from " + this);
        }
        if (!isZOS) {
            this.writeInt(1);
            this.flush();
            this._pid = this.readInt();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initPID from " + this);
        }
    }

    public int available() throws IOException {
        return this._in.available();
    }

    public int readInt() throws IOException {
        try {
            int n = this._in.readInt();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "readInt " + n);
            }
            return n;
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public String readString() throws IOException {
        try {
            String string = this._in.readUTF();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "readString " + string);
            }
            return string;
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public void writeInt(int n) throws IOException {
        try {
            if (!isZOS) {
                this._out.writeInt(n);
            } else {
                String string = new Integer(n).toString();
                this._out.writeUTF(string);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "writeInt " + n);
            }
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public void writeString(String string) throws IOException {
        try {
            this._out.writeUTF(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "writeString " + string);
            }
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public void flush() throws IOException {
        try {
            this._out.flush();
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public void flushWithResponse() throws IOException {
        try {
            this._in = this._out.flushWithResponse();
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ESIProcessor[");
        stringBuffer.append("_hostName = ").append(this._hostName);
        stringBuffer.append(" _isAlive = ").append(this._isAlive);
        stringBuffer.append(" _localAddr = ").append(this._localAddr);
        stringBuffer.append(" _localName = ").append(this._localName);
        stringBuffer.append(" _localPort = ").append(this._localPort);
        stringBuffer.append(" _pid = ").append(this._pid);
        stringBuffer.append(" _remotePort = ").append(this._remotePort);
        stringBuffer.append(" _serverPort = ").append(this._serverPort);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

