/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentComposer;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ESISupport {
    private static TraceComponent tc = Trace.register(ESISupport.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static int NO_ESI = 0;
    public static int ESI_10 = 100;
    public static int ESI_10PLUS = 101;
    public static int ESI_09 = 90;
    public static int ESI_08 = 80;
    static int maxTimeLimitInSeconds = 86400;

    public static final void handleESIPreProcessing(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse, FragmentInfo fragmentInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleESIPreProcessing");
        }
        FragmentComposer fragmentComposer = cacheProxyResponse.getFragmentComposer();
        FragmentComposer fragmentComposer2 = fragmentComposer.parent;
        int n = NO_ESI;
        if (fragmentComposer2 == null) {
            String string = ESISupport.getHeaderDirect(cacheProxyRequest, "Surrogate-Capability");
            if (string != null) {
                int n2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got Surrogate-Capability header: " + string);
                }
                if ((n2 = string.indexOf("ESI/1.0")) != -1) {
                    n = ESI_10;
                    if (string.charAt(n2 + "ESI/1.0".length()) == '+') {
                        n = ESI_10PLUS;
                    }
                } else if (string.indexOf("ESI/0.9+") != -1) {
                    n = ESI_09;
                } else if (string.indexOf("ESI/0.8") != -1) {
                    n = ESI_08;
                }
            }
        } else {
            n = fragmentComposer2.getESIVersion();
        }
        fragmentComposer.setESIVersion(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "esiVersion: " + n);
        }
        if (n == ESI_08) {
            if (cacheProxyRequest.getAttribute("IBM-DYNACACHE-RRD-BUFFERING") != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rrd request, set buffering for next include");
                }
                cacheProxyResponse.setBufferingOutput(true);
                cacheProxyRequest.removeAttribute("IBM-DYNACACHE-RRD-BUFFERING");
            }
        } else if (n != NO_ESI) {
            if (!fragmentComposer.getInclude() && fragmentComposer2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "forward occuring on esi request, moving output buffering");
                }
                fragmentComposer2.getResponse().setBufferingOutput(false);
                cacheProxyResponse.setBufferingOutput(true);
            } else if (fragmentComposer2 == null) {
                cacheProxyResponse.setBufferingOutput(true);
            }
        }
    }

    public static final void handleESIPostProcessing(CacheProxyResponse cacheProxyResponse, FragmentInfo fragmentInfo, boolean bl) throws IOException {
        boolean bl2;
        int n = cacheProxyResponse.getFragmentComposer().getESIVersion();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleESIPostProcessing, esiVersion=" + n);
        }
        FragmentComposer fragmentComposer = cacheProxyResponse.getFragmentComposer();
        for (bl2 = false; !bl2 && fragmentComposer != null; bl2 |= fragmentComposer.isSendRedirect) {
            fragmentComposer = fragmentComposer.parent;
        }
        if (n != NO_ESI && cacheProxyResponse.isBufferingOutput() && !bl2) {
            JSPCache jSPCache = ServerCache.getJspCache(fragmentInfo.getInstanceName());
            if (!cacheProxyResponse.containsHeader("Surrogate-Control") || jSPCache.alwaysSetSurrogateControlHdr()) {
                StringBuffer stringBuffer = null;
                FragmentComposer fragmentComposer2 = cacheProxyResponse.getFragmentComposer().parent;
                while (fragmentComposer2 != null) {
                    if (fragmentComposer2.fragmentInfo != null && fragmentComposer2.fragmentInfo.isEdgeable() && !fragmentComposer2.fragmentInfo.isUncacheable()) {
                        fragmentInfo = fragmentComposer2.fragmentInfo;
                    }
                    fragmentComposer2 = fragmentComposer2.parent;
                }
                CacheProxyResponse cacheProxyResponse2 = cacheProxyResponse;
                while (cacheProxyResponse2 instanceof HttpServletResponseWrapper) {
                    cacheProxyResponse2 = (HttpServletResponse)((HttpServletResponseWrapper)cacheProxyResponse2).getResponse();
                }
                if (fragmentInfo == null || !fragmentInfo.isEdgeable() || fragmentInfo.isUncacheable() || bl || fragmentInfo.getDoNotCache() && fragmentInfo.isEdgeable()) {
                    stringBuffer = new StringBuffer(128).append("no-store");
                    if (cacheProxyResponse.getContainsESIContent()) {
                        stringBuffer.append(", content=\"ESI/1.0");
                        if (n == ESI_10PLUS) {
                            stringBuffer.append("+\"");
                        } else {
                            stringBuffer.append("\"");
                        }
                    }
                } else {
                    stringBuffer = fragmentInfo.getExpirationTime() > 0L ? new StringBuffer(128).append("max-age=").append((fragmentInfo.getExpirationTime() - System.currentTimeMillis()) / 1000L) : new StringBuffer(128).append("max-age=").append(maxTimeLimitInSeconds);
                    if (cacheProxyResponse.getContainsESIContent()) {
                        if (n == ESI_10PLUS) {
                            stringBuffer.append(",content=\"ESI/1.0+\"");
                        } else {
                            stringBuffer.append(",content=\"ESI/1.0\"");
                        }
                    }
                    stringBuffer.append(", depid=\"").append(fragmentInfo.getId());
                    Enumeration enumeration = fragmentInfo.getTemplates();
                    while (enumeration.hasMoreElements()) {
                        stringBuffer.append("\", depid=\"").append((String)enumeration.nextElement());
                    }
                    enumeration = fragmentInfo.getDataIds();
                    while (enumeration.hasMoreElements()) {
                        stringBuffer.append("\", depid=\"").append((String)enumeration.nextElement());
                    }
                    stringBuffer.append("\"");
                    if (n == ESI_10PLUS || n == ESI_09 || n == ESI_08) {
                        stringBuffer.append(",").append(fragmentInfo.getESICacheId());
                    }
                }
                if (cacheProxyResponse2 instanceof IExtendedResponse) {
                    ((IExtendedResponse)cacheProxyResponse2).setInternalHeader("Surrogate-Control", stringBuffer.toString());
                } else {
                    cacheProxyResponse2.setHeader("Surrogate-Control", stringBuffer.toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set surrogate-control to:" + stringBuffer.toString());
                }
            } else if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleESIPostProcessing, Surrogate-Control already set");
            }
            cacheProxyResponse.flushOutput();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleESIPostProcessing");
        }
    }

    private static final void buildESIInclude(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse, FragmentInfo fragmentInfo, int n) throws IOException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildESIInclude, esiVersion=" + n);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = cacheProxyResponse.getWriter();
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException(illegalStateException, "com.ibm.ws.cache.servlet.CacheHook.buildESIInclude", "719");
            string = cacheProxyResponse.getCharacterEncoding();
            printWriter = string != null ? new PrintWriter(new OutputStreamWriter((OutputStream)cacheProxyResponse.getOutputStream(), string)) : new PrintWriter(new OutputStreamWriter((OutputStream)cacheProxyResponse.getOutputStream()));
        }
        StringBuffer stringBuffer = new StringBuffer(128).append("<esi:include src=\"");
        if (fragmentInfo.getAlternateUrl() != null) {
            int n2;
            string = fragmentInfo.getAlternateUrl();
            if (string.startsWith("/")) {
                string = cacheProxyRequest._getContextPath() + string;
            } else {
                int n3 = cacheProxyRequest.getAbsoluteUri().indexOf(cacheProxyRequest.getRelativeUri());
                String string2 = cacheProxyRequest.getAbsoluteUri().substring(0, n3);
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                string = string2 + string;
            }
            String string3 = fragmentInfo.getURI();
            if (n == ESI_10) {
                int n4 = string3.indexOf(63);
                if (n4 > -1) {
                    string3 = string3.substring(0, n4);
                }
                string3 = string3 + fragmentInfo.getESIQueryString();
            }
            if ((n2 = string3.indexOf(63)) > -1) {
                string3 = string3.replace('?', '&');
            }
            string = string.indexOf("?") == -1 ? string + "?dynacache_alturl=" + string3 : string + "&dynacache_alturl=" + string3;
            stringBuffer.append(string);
        } else if (n == ESI_10) {
            int n5 = fragmentInfo.getURI().indexOf(63);
            if (n5 > -1) {
                stringBuffer.append(fragmentInfo.getURI().substring(0, n5));
            } else {
                stringBuffer.append(fragmentInfo.getURI());
            }
            stringBuffer.append(fragmentInfo.getESIQueryString());
        } else {
            stringBuffer.append(fragmentInfo.getURI());
        }
        printWriter.print(stringBuffer.append("\" />").toString());
        printWriter.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildESIInclude: " + stringBuffer.toString());
        }
    }

    public static boolean shouldBuildESIInclude(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse, FragmentInfo fragmentInfo) throws IOException {
        int n = cacheProxyResponse.getFragmentComposer().getESIVersion();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shouldBuildESIInclude esiVersion=" + n + " isEdgeable=" + fragmentInfo.isEdgeable());
        }
        if (n != NO_ESI && n != ESI_09 && n != ESI_08) {
            String string = cacheProxyRequest.getParameter("dynacache_alturl");
            int n2 = fragmentInfo.getURI().indexOf(63);
            String string2 = n2 > -1 ? fragmentInfo.getURI().substring(0, n2) : fragmentInfo.getURI();
            boolean bl = false;
            if (string != null && string.equals(string2)) {
                bl = true;
            }
            if (fragmentInfo.isEdgeable() && !cacheProxyResponse.getFragmentComposer().isExternalPage() && !bl) {
                ESISupport.buildESIInclude(cacheProxyRequest, cacheProxyResponse, fragmentInfo, n);
                fragmentInfo.setBuildEsiInclude(true);
                cacheProxyResponse.setContainsESIContent(true);
                cacheProxyResponse.getFragmentComposer().setCacheType(2);
                fragmentInfo.setEdgeable(false);
                return true;
            }
        }
        return false;
    }

    static final String getHeaderDirect(HttpServletRequest httpServletRequest, String string) {
        while (httpServletRequest instanceof HttpServletRequestWrapper) {
            httpServletRequest = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest).getRequest();
        }
        if (httpServletRequest instanceof SRTServletRequest) {
            return ((SRTServletRequest)httpServletRequest).getHeaderDirect(string);
        }
        return httpServletRequest.getHeader(string);
    }
}

