/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.DynamicContentProvider;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.servlet.AddCookieSideEffect;
import com.ibm.ws.cache.servlet.CacheProxyOutputStream;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.CacheProxyWriter;
import com.ibm.ws.cache.servlet.CharacterEncodingSideEffect;
import com.ibm.ws.cache.servlet.ContentLengthSideEffect;
import com.ibm.ws.cache.servlet.DateHeaderSideEffect;
import com.ibm.ws.cache.servlet.DefaultStatusSideEffect;
import com.ibm.ws.cache.servlet.ESISupport;
import com.ibm.ws.cache.servlet.FragmentComposerMemento;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.servlet.HeaderSideEffect;
import com.ibm.ws.cache.servlet.IntHeaderSideEffect;
import com.ibm.ws.cache.servlet.LocaleSideEffect;
import com.ibm.ws.cache.servlet.MementoEntry;
import com.ibm.ws.cache.servlet.ResponseSideEffect;
import com.ibm.ws.cache.servlet.SendRedirectSideEffect;
import com.ibm.ws.cache.servlet.StatusSideEffect;
import com.ibm.ws.cache.servlet.UnexternalizablePageException;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.io.WSByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FragmentComposer {
    private static TraceComponent tc = Trace.register(FragmentComposer.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final int NOT_CACHED = 0;
    public static final int WAS_CACHED = 1;
    public static final int POPULATED_CACHE = 2;
    public static final int SERVLET_REQUEST = 1;
    public static final int PORTLET_CACHE_REQUEST = 2;
    public static final int PORTLET_INVALIDATE_REQUEST = 3;
    private int cacheType = -1;
    private boolean externalPage = false;
    protected static final int BYTE = 1;
    protected static final int CHAR = 2;
    protected static final int NONE = 3;
    protected int outputStyle = 3;
    protected String contentType = null;
    protected String characterEncoding = null;
    FragmentComposer parent = null;
    FragmentComposer currentChild = null;
    private ArrayList contentVector = new ArrayList();
    private int bufferSize = 8192;
    private CacheProxyOutputStream cacheProxyOutputStream;
    private CacheProxyWriter cacheProxyWriter;
    protected FragmentInfo fragmentInfo = null;
    protected boolean isSendRedirect = false;
    private boolean isJSTLImport = false;
    private boolean discardJSPContent = false;
    private String uri = null;
    private String servletClassName = null;
    private boolean doNotConsume = false;
    private boolean consumeSubfragments = false;
    private boolean hasCacheableConsumingParent = false;
    public CacheProxyRequest.Attribute[] saveAttributeList = null;
    private CacheProxyRequest.Attribute[] attributeTable = null;
    private byte[] attributeTableBytes = null;
    private boolean include = false;
    private boolean namedDispatch = false;
    private long expirationTime = Long.MAX_VALUE;
    private long timeStamp = -1L;
    private boolean parentExternallyCacheable = false;
    private CacheProxyResponse response = null;
    private CacheProxyRequest request = null;
    private String contextPath = null;
    private int esiVersion = ESISupport.NO_ESI;
    private ValueSet externalDataIds = new ValueSet(5);
    private ValueSet externalTemplates = new ValueSet(3);

    public FragmentComposer(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        this.response = cacheProxyResponse;
        this.request = cacheProxyRequest;
        this.contextPath = cacheProxyRequest._getContextPath();
    }

    public FragmentComposer() {
    }

    public void reset(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        this.response = cacheProxyResponse;
        this.request = cacheProxyRequest;
        this.contentVector.clear();
        this.discardJSPContent = false;
        this.cacheType = -1;
        this.fragmentInfo = null;
        this.uri = null;
        this.servletClassName = null;
        this.externalPage = false;
        this.outputStyle = 3;
        this.contentType = null;
        this.characterEncoding = null;
        this.attributeTable = null;
        this.include = false;
        this.namedDispatch = false;
        this.expirationTime = Long.MAX_VALUE;
        this.timeStamp = -1L;
        this.parentExternallyCacheable = false;
        this.parent = null;
        this.currentChild = null;
        this.attributeTableBytes = null;
        this.esiVersion = ESISupport.NO_ESI;
        if (this.cacheProxyOutputStream != null) {
            this.cacheProxyOutputStream.reset();
        }
        if (this.cacheProxyWriter != null) {
            this.cacheProxyWriter.reset();
        }
        if (cacheProxyRequest != null) {
            this.contextPath = cacheProxyRequest._getContextPath();
        }
        this.isSendRedirect = false;
        this.isJSTLImport = false;
        this.hasCacheableConsumingParent = false;
        this.saveAttributeList = null;
        this.externalDataIds.clear();
        this.externalTemplates.clear();
    }

    public void addContents(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.contentVector.add(objectArray[i]);
        }
    }

    public void setDoNotConsume(boolean bl) {
        String string;
        this.doNotConsume = bl;
        if (this.doNotConsume && (string = ESISupport.getHeaderDirect(this.request, "Surrogate-Capability")) != null) {
            if (this.getFragmentInfo().isEdgeable()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fragment is EdgeCacheable, setting doNotConsume=false");
                }
                this.doNotConsume = false;
                this.fragmentInfo.setConsumeExcludeList(null);
            } else {
                for (FragmentComposer fragmentComposer = this.getParent(); fragmentComposer != null; fragmentComposer = fragmentComposer.getParent()) {
                    if (!fragmentComposer.getFragmentInfo().isEdgeable()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EdgeCacheable parent found, setting doNotConsume=false");
                    }
                    this.doNotConsume = false;
                    this.fragmentInfo.setConsumeExcludeList(null);
                    break;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDoNotConsume: " + this.uri + " doNotConsume=" + this.doNotConsume);
        }
    }

    public boolean getDoNotConsume() {
        return this.doNotConsume;
    }

    public void setConsumeSubfragments(boolean bl) {
        String string;
        this.consumeSubfragments = bl;
        if (this.isExternalPage() && !this.consumeSubfragments && (string = ESISupport.getHeaderDirect(this.request, "Surrogate-Capability")) != null && this.getFragmentInfo().isEdgeable()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fragment is EdgeCacheable, setting consumeSubfragments=true");
            }
            this.consumeSubfragments = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setConsumeSubfragments: " + this.uri + " consumeSubfragments=" + this.consumeSubfragments);
        }
    }

    public boolean getConsumeSubfragments() {
        return this.consumeSubfragments;
    }

    public boolean getHasCacheableConsumingParent() {
        return this.hasCacheableConsumingParent;
    }

    public void setHasCacheableConsumingParent(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hasCacheableConsumingParent set to " + bl);
        }
        this.hasCacheableConsumingParent = bl;
    }

    public void setBufferSize(int n) {
        if (n > this.bufferSize) {
            if (this.cacheProxyOutputStream != null) {
                this.cacheProxyOutputStream.setBufferSize(n);
            }
            if (this.cacheProxyWriter != null) {
                this.cacheProxyWriter.setBufferSize(n);
            }
            this.bufferSize = n;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void resetBuffer() {
        if (this.cacheProxyWriter != null) {
            this.cacheProxyWriter.resetBuffer();
        }
        if (this.cacheProxyOutputStream != null) {
            this.cacheProxyOutputStream.resetBuffer();
        }
    }

    public void requestFinished() {
        if (this.cacheProxyWriter != null) {
            this.cacheProxyWriter.flush();
        }
        if (this.cacheProxyOutputStream != null) {
            try {
                this.cacheProxyOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.saveCachedData();
    }

    public boolean shouldCacheOutput() {
        if (this.cacheType == 2) {
            return true;
        }
        if (this.cacheType == 1) {
            return this.parentExternallyCacheable || this.isExternallyCached();
        }
        return false;
    }

    public boolean isExternallyCached() {
        if (this.isExternalPage() && this.fragmentInfo != null) {
            String string = this.fragmentInfo.getExternalCacheGroupId();
            return string != null && !string.equals("");
        }
        return false;
    }

    public void setParentExternallyCacheable(boolean bl) {
        this.parentExternallyCacheable = bl;
    }

    public boolean shouldExternalCacheOutput() {
        if (this.isExternallyCached()) {
            return true;
        }
        FragmentComposer fragmentComposer = this.getExternalFragmentComposer();
        if (fragmentComposer.isExternallyCached()) {
            if (fragmentComposer.consumeSubfragments) {
                return true;
            }
            if (this.cacheType == 1 || this.cacheType == 2) {
                return true;
            }
            FragmentComposer fragmentComposer2 = this.parent;
            while (fragmentComposer2 != null && !fragmentComposer2.consumeSubfragments) {
                fragmentComposer2 = fragmentComposer2.parent;
            }
            if (fragmentComposer2 != null && fragmentComposer2.consumeSubfragments) {
                return true;
            }
        }
        return false;
    }

    protected void saveExternalInvalidationIds() {
        if (this.shouldExternalCacheOutput() && this.fragmentInfo.getId() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveExternalInvalidationIds uri=" + this.uri);
            }
            FragmentComposer fragmentComposer = this.getExternalFragmentComposer();
            fragmentComposer.externalDataIds.union(this.fragmentInfo.getDataIds());
            fragmentComposer.externalDataIds.add(this.fragmentInfo.getId());
            fragmentComposer.externalTemplates.union(this.fragmentInfo.getTemplates());
        }
    }

    public void startChildFragmentComposer(FragmentComposer fragmentComposer) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "starting fragment composer for " + fragmentComposer.uri + " parent=" + this.uri);
        }
        this.saveCachedData();
        this.contentVector.add(fragmentComposer);
        if (this.cacheProxyWriter != null) {
            this.cacheProxyWriter.setCaching(false);
        }
        if (this.cacheProxyOutputStream != null) {
            this.cacheProxyOutputStream.setCaching(false);
        }
        if (fragmentComposer.getRequest().getCaching() || fragmentComposer.getHasCacheableConsumingParent()) {
            if (fragmentComposer.cacheProxyWriter != null) {
                fragmentComposer.cacheProxyWriter.setCaching(true);
            }
            if (fragmentComposer.cacheProxyOutputStream != null) {
                fragmentComposer.cacheProxyOutputStream.setCaching(true);
            }
        }
        fragmentComposer.setParentExternallyCacheable(this.isExternallyCached());
        this.currentChild = fragmentComposer;
    }

    public void endChildFragmentComposer() throws IOException {
        boolean bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ending fragment composer for child parent=" + this.uri);
        }
        this.currentChild.saveCachedData();
        this.childComposerEnded(this.currentChild);
        boolean bl2 = bl = this.request.getCaching() || this.getHasCacheableConsumingParent();
        if (this.cacheProxyWriter != null) {
            if (this.isJSTLImport) {
                this.cacheProxyWriter.setDelayWrite(true, bl);
                this.setJSTLImport(false);
            } else {
                this.cacheProxyWriter.setCaching(bl);
            }
        }
        if (this.cacheProxyOutputStream != null) {
            if (this.isJSTLImport) {
                this.cacheProxyOutputStream.setDelayWrite(true, bl);
                this.setJSTLImport(false);
            } else {
                this.cacheProxyOutputStream.setCaching(bl);
            }
        }
        this.currentChild = null;
    }

    protected void childComposerEnded(FragmentComposer fragmentComposer) {
        if (this.getConsumeSubfragments() && fragmentComposer.fragmentInfo != null && !fragmentComposer.fragmentInfo.getBuildEsiInclude() && !fragmentComposer.getDoNotConsume()) {
            Enumeration enumeration = fragmentComposer.fragmentInfo.getTemplates();
            while (enumeration.hasMoreElements()) {
                this.fragmentInfo.templates.add(enumeration.nextElement());
            }
            Enumeration enumeration2 = fragmentComposer.fragmentInfo.getDataIds();
            while (enumeration2.hasMoreElements()) {
                this.fragmentInfo.dataIds.add(enumeration2.nextElement());
            }
            String string = fragmentComposer.fragmentInfo.getId();
            if (string != null) {
                this.fragmentInfo.dataIds.add(string);
            }
        }
        if (this.parent != null && !fragmentComposer.getDoNotConsume() && !this.getDoNotConsume()) {
            this.parent.childComposerEnded(fragmentComposer);
        }
    }

    public void saveCachedData() {
        if (this.outputStyle == 2 && this.cacheProxyWriter.isCaching()) {
            char[] cArray = this.cacheProxyWriter.getCachedData();
            this.contentVector.add(cArray);
            this.cacheProxyWriter.resetBuffer();
        } else if (this.outputStyle == 1 && this.cacheProxyOutputStream.isCaching()) {
            byte[] byArray = this.cacheProxyOutputStream.getCachedData();
            this.contentVector.add(byArray);
            this.cacheProxyOutputStream.resetBuffer();
        }
    }

    private OutputStream obtainOutputStream() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getting OutputStream from " + this.response.getResponse() + ", buffering output = " + this.response.isBufferingOutput() + ", hasParent == " + (this.parent != null));
        }
        ServletOutputStream servletOutputStream = this.response.isBufferingOutput() ? this.response.getBufferedOutputStream() : ((HttpServletResponse)this.response.getResponse()).getOutputStream();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got OutputStream: " + servletOutputStream);
        }
        return servletOutputStream;
    }

    private Writer obtainWriter() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getting Writer from " + this.response.getResponse() + ", buffering output = " + this.response.isBufferingOutput() + ", hasParent == " + (this.parent != null));
        }
        PrintWriter printWriter = this.response.isBufferingOutput() ? this.response.getBufferedWriter() : ((HttpServletResponse)this.response.getResponse()).getWriter();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got Writer: " + printWriter);
        }
        return printWriter;
    }

    private FragmentComposer getExternalFragmentComposer() {
        FragmentComposer fragmentComposer = this;
        while (!fragmentComposer.isExternalPage()) {
            fragmentComposer = fragmentComposer.parent;
        }
        return fragmentComposer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream: " + this.uri);
        }
        this.outputStyle = 1;
        if (this.cacheProxyOutputStream == null) {
            this.cacheProxyOutputStream = new CacheProxyOutputStream();
        }
        this.cacheProxyOutputStream.setOutputStream(this.obtainOutputStream());
        this.cacheProxyOutputStream.setCaching(this.currentChild == null && (this.request.getCaching() || this.getHasCacheableConsumingParent()));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning " + (Object)((Object)this.cacheProxyOutputStream) + ", pointing to " + this.cacheProxyOutputStream.getOutputStream());
        }
        return this.cacheProxyOutputStream;
    }

    public PrintWriter getPrintWriter() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrintWriter: " + this.uri);
        }
        this.outputStyle = 2;
        if (this.cacheProxyWriter == null) {
            this.cacheProxyWriter = new CacheProxyWriter();
        }
        this.cacheProxyWriter.setWriter(this.obtainWriter());
        this.cacheProxyWriter.setCaching(this.currentChild == null && (this.request.getCaching() || this.getHasCacheableConsumingParent()));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning " + this.cacheProxyWriter + ", pointing to " + this.cacheProxyWriter.getWriter() + " caching=" + this.cacheProxyWriter.isCaching());
        }
        return this.cacheProxyWriter;
    }

    private Object[] excludeChildFragments(Object[] objectArray, ArrayList arrayList) {
        if (objectArray == null) {
            return objectArray;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof MementoEntry)) continue;
            MementoEntry mementoEntry = (MementoEntry)objectArray[i];
            String string = mementoEntry.getTemplate();
            int n = string.indexOf(63);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if (arrayList.contains(string) || arrayList.contains(mementoEntry.getServletClassName())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Fragment: " + string + " excluded from CacheEntry: " + this.getURI());
                }
                mementoEntry.contents = null;
                mementoEntry.setDoNotConsume(true);
                continue;
            }
            this.excludeChildFragments(mementoEntry.contents, arrayList);
        }
        return objectArray;
    }

    public FragmentComposerMemento getMemento(CacheProxyRequest cacheProxyRequest) throws IOException {
        String string;
        CacheProxyRequest.Attribute[] attributeArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemento: " + this.uri);
        }
        if (!this.shouldCacheOutput()) {
            throw new IllegalStateException("Cannot obtain cache memento since caching was not enabled for this fragment");
        }
        this.saveCachedData();
        FragmentComposerMemento fragmentComposerMemento = new FragmentComposerMemento();
        String string2 = this.fragmentInfo.getExternalCacheGroupId();
        fragmentComposerMemento.setExternalCacheGroupId(string2);
        fragmentComposerMemento.setConsumeSubfragments(this.getConsumeSubfragments());
        fragmentComposerMemento.setOutputStyle(this.outputStyle);
        fragmentComposerMemento.setContentType(this.contentType);
        fragmentComposerMemento.setCharacterEncoding(this.characterEncoding);
        Object[] objectArray = this.contentVector.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl;
            if (!(objectArray[i] instanceof FragmentComposer)) continue;
            attributeArray = (FragmentComposer)objectArray[i];
            String string3 = this.getContextPath();
            string = attributeArray.getContextPath();
            boolean bl2 = bl = string3 != null && string != null && string3.equals(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ignore context paths? cp1 = " + string3 + ", cp2 = " + string + " ," + bl);
            }
            MementoEntry mementoEntry = super.getMementoEntry(bl);
            mementoEntry.setOutputStyle(attributeArray.outputStyle);
            mementoEntry.setExternallyCacheable(attributeArray.shouldExternalCacheOutput());
            if (this.getConsumeSubfragments() && !attributeArray.getDoNotConsume() && !attributeArray.isDiscardJSPContent()) {
                mementoEntry.addContents(attributeArray.contentVector.toArray());
            } else if (attributeArray.isDiscardJSPContent()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating an empty mementoEntry for fragmentComposer -->" + attributeArray.uri);
                }
                mementoEntry.addContents(new ArrayList(0).toArray());
            }
            mementoEntry.setServletClassName(attributeArray.getServletClassName());
            mementoEntry.setDoNotConsume(attributeArray.getDoNotConsume());
            objectArray[i] = mementoEntry;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Created MementoEntry for " + attributeArray.getURI());
        }
        String[] stringArray = this.fragmentInfo.getConsumeExcludeList();
        if (stringArray != null) {
            attributeArray = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                attributeArray.add(stringArray[i]);
            }
            objectArray = this.excludeChildFragments(objectArray, (ArrayList)attributeArray);
        }
        fragmentComposerMemento.addContents(objectArray);
        attributeArray = this.getSaveAttributeList(cacheProxyRequest);
        if (attributeArray != null && attributeArray.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting changed attrs on memento " + this.uri + ": " + attributeArray);
            }
            boolean bl = false;
            if (this.fragmentInfo != null) {
                boolean bl3 = bl = !this.fragmentInfo.isNotShared();
            }
            if (bl) {
                string = null;
                byte[] byArray = null;
                try {
                    byArray = SerializationUtility.serialize((Serializable)attributeArray);
                }
                catch (Exception exception) {
                    string = exception.toString();
                }
                if (byArray != null) {
                    fragmentComposerMemento.addAttributeBytes(byArray);
                } else {
                    fragmentComposerMemento.addAttributes(attributeArray);
                    Tr.error(tc, "dynacache.error", new Object[]{"NON_SERIALIZABLE_ATTRIBUTES_FOUND. SET_SHARE_POLICY_TO_NOT_SHARED.  uri=" + this.uri + "  exception=" + string});
                }
            } else {
                fragmentComposerMemento.addAttributes(attributeArray);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemento: " + this.uri);
        }
        return fragmentComposerMemento;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MementoEntry getMementoEntry(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMementoEntry: " + bl);
        }
        try {
            Object object;
            if (this.uri == null) {
                throw new IllegalStateException("fragmentComposer.uri is null");
            }
            Object object2 = null;
            byte[] byArray = null;
            if (this.getHasCacheableConsumingParent() && !this.getDoNotConsume() && (object = this.saveAttributeList) != null && ((CacheProxyRequest.Attribute[])object).length > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting changed attrs on mementoEntry " + this.uri + ": " + object);
                }
                boolean bl2 = false;
                if (this.fragmentInfo != null) {
                    boolean bl3 = bl2 = !this.fragmentInfo.isNotShared();
                }
                if (bl2) {
                    String string = null;
                    byte[] byArray2 = null;
                    try {
                        byArray2 = SerializationUtility.serialize((Serializable)object);
                    }
                    catch (Exception exception) {
                        string = exception.toString();
                    }
                    if (byArray2 != null) {
                        byArray = byArray2;
                    } else {
                        object2 = object;
                        Tr.error(tc, "dynacache.error", new Object[]{"NON_SERIALIZABLE_ATTRIBUTES_FOUND. SET_SHARE_POLICY_TO_NOT_SHARED.  uri=" + this.uri + "  exception=" + string});
                    }
                } else {
                    this.attributeTable = object;
                }
            }
            if (this.attributeTableBytes == null) {
                if (bl) {
                    object = new MementoEntry(this.uri, this.attributeTable, (CacheProxyRequest.Attribute[])object2, this.include, this.namedDispatch, null);
                    return object;
                }
                object = new MementoEntry(this.uri, this.attributeTable, (CacheProxyRequest.Attribute[])object2, this.include, this.namedDispatch, this.getContextPath());
                return object;
            }
            if (bl) {
                object = new MementoEntry(this.uri, this.attributeTableBytes, byArray, this.include, this.namedDispatch, null);
                return object;
            }
            object = new MementoEntry(this.uri, this.attributeTableBytes, byArray, this.include, this.namedDispatch, this.getContextPath());
            return object;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMementoEntry");
            }
        }
    }

    public void copyContentForParents() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyContentForParents:" + this.uri);
        }
        Object[] objectArray = this.contentVector.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl;
            if (!(objectArray[i] instanceof FragmentComposer)) continue;
            FragmentComposer fragmentComposer = (FragmentComposer)objectArray[i];
            String string = this.getContextPath();
            String string2 = fragmentComposer.getContextPath();
            boolean bl2 = bl = string != null && string2 != null && string.equals(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ignore context paths? cp1 = " + string + ", cp2 = " + string2 + " ," + bl);
            }
            MementoEntry mementoEntry = fragmentComposer.getMementoEntry(bl);
            mementoEntry.setOutputStyle(fragmentComposer.outputStyle);
            mementoEntry.setExternallyCacheable(fragmentComposer.shouldExternalCacheOutput());
            if (!fragmentComposer.getDoNotConsume() && !fragmentComposer.isDiscardJSPContent()) {
                mementoEntry.addContents(fragmentComposer.contentVector.toArray());
            } else if (fragmentComposer.isDiscardJSPContent()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating an EMPTY MementoEntry for fragmentComposer -->" + fragmentComposer.uri + " fragmentComposer.isDiscardJSPContent()-->" + fragmentComposer.isDiscardJSPContent());
                }
                mementoEntry.addContents(new ArrayList(0).toArray());
            }
            mementoEntry.setDoNotConsume(fragmentComposer.getDoNotConsume());
            this.contentVector.set(i, mementoEntry);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Created MementoEntry for " + fragmentComposer.getURI());
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    protected CacheProxyRequest.Attribute[] getSaveAttributeList(CacheProxyRequest cacheProxyRequest) {
        FragmentInfo fragmentInfo = (FragmentInfo)cacheProxyRequest.getFragmentInfo();
        CacheProxyRequest.Attribute[] attributeArray = cacheProxyRequest.getChangedAttributes();
        String[] stringArray = fragmentInfo.getAttributeExcludeList();
        CacheProxyRequest.Attribute[] attributeArray2 = null;
        if (!fragmentInfo.getStoreAttributes() && stringArray == null) {
            return null;
        }
        if (fragmentInfo.getStoreAttributes() && stringArray == null) {
            return attributeArray;
        }
        if (!fragmentInfo.getStoreAttributes() && stringArray != null) {
            ArrayList<CacheProxyRequest.Attribute> arrayList = null;
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; attributeArray != null && j < attributeArray.length; ++j) {
                    if (!stringArray[i].equals(attributeArray[j].key)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<CacheProxyRequest.Attribute>();
                    }
                    arrayList.add(attributeArray[j]);
                }
            }
            if (arrayList != null) {
                attributeArray2 = arrayList.toArray(new CacheProxyRequest.Attribute[0]);
            }
        } else if (fragmentInfo.getStoreAttributes() && stringArray != null) {
            ArrayList<CacheProxyRequest.Attribute> arrayList = null;
            for (int i = 0; attributeArray != null && i < attributeArray.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(attributeArray[i].key)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<CacheProxyRequest.Attribute>();
                }
                arrayList.add(attributeArray[i]);
            }
            if (arrayList != null) {
                attributeArray2 = arrayList.toArray(new CacheProxyRequest.Attribute[0]);
            }
        }
        return attributeArray2;
    }

    public byte[] toByteArray(String string) throws IOException {
        if (!this.shouldExternalCacheOutput()) {
            throw new IllegalStateException("Cannot obtain byteArray since caching was not enabled for this fragment");
        }
        this.saveCachedData();
        byte[] byArray = null;
        WSByteArrayOutputStream wSByteArrayOutputStream = new WSByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        int n = this.contentVector.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object e2 = this.contentVector.get(i);
            if (e2 instanceof byte[]) {
                if (this.outputStyle != 1) {
                    throw new IllegalStateException("FragmentComposer " + this + " with outputStyle " + this.outputStyle + " cannot contain byte arrays");
                }
                wSByteArrayOutputStream.write((byte[])e2, 0, ((byte[])e2).length);
                wSByteArrayOutputStream.flush();
                continue;
            }
            if (e2 instanceof char[]) {
                if (this.outputStyle != 2) {
                    throw new IllegalStateException("FragmentComposer " + this + " with outputStyle " + this.outputStyle + " cannot contain char arrays");
                }
                if (outputStreamWriter == null) {
                    try {
                        outputStreamWriter = new OutputStreamWriter((OutputStream)wSByteArrayOutputStream, string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ws.cache.servlet.FragmentComposer.toByteArray", "671", this);
                        outputStreamWriter = new OutputStreamWriter(wSByteArrayOutputStream);
                    }
                }
                outputStreamWriter.write((char[])e2, 0, ((char[])e2).length);
                outputStreamWriter.flush();
                continue;
            }
            if (e2 instanceof ResponseSideEffect || e2 instanceof String) continue;
            if (e2 instanceof MementoEntry) {
                object = (MementoEntry)e2;
                byte[] byArray2 = ((MementoEntry)object).toByteArray(string);
                wSByteArrayOutputStream.write(byArray2, 0, byArray2.length);
                continue;
            }
            if (!(e2 instanceof FragmentComposer)) {
                throw new IllegalStateException("FragmentComposer should only contain other FragmentComposers, Byte Arrays, Char Arrays, and ResponseSideEffects");
            }
            object = (FragmentComposer)e2;
            byArray = ((FragmentComposer)object).toByteArray(string);
            wSByteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        return wSByteArrayOutputStream.toByteArray();
    }

    public CacheProxyRequest getCacheProxyRequest() {
        return this.request;
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(int n) {
        this.cacheType = n;
    }

    public FragmentComposer getParent() {
        return this.parent;
    }

    public void setParent(FragmentComposer fragmentComposer) {
        this.parent = fragmentComposer;
    }

    protected void setJSTLImport(boolean bl) {
        this.isJSTLImport = bl;
    }

    public boolean isExternalPage() {
        return this.externalPage;
    }

    public void setExternalPage(boolean bl) {
        this.externalPage = bl;
    }

    public void setAttributeTableBytes(byte[] byArray) {
        this.attributeTableBytes = byArray;
    }

    public byte[] getAttributeTableBytes() {
        return this.attributeTableBytes;
    }

    public void setAttributeTable(CacheProxyRequest.Attribute[] attributeArray) {
        this.attributeTable = attributeArray;
    }

    public CacheProxyRequest.Attribute[] getAttributeTable() {
        return this.attributeTable;
    }

    public FragmentInfo getFragmentInfo() {
        return this.fragmentInfo;
    }

    public void setFragmentInfo(FragmentInfo fragmentInfo) {
        this.fragmentInfo = fragmentInfo;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String string) {
        this.uri = string;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public void setServletClassName(String string) {
        this.servletClassName = string;
    }

    protected CacheProxyRequest getRequest() {
        return this.request;
    }

    protected CacheProxyResponse getResponse() {
        return this.response;
    }

    public boolean getInclude() {
        return this.include;
    }

    public void setInclude(boolean bl) {
        this.include = bl;
    }

    public boolean getNamedDispatch() {
        return this.namedDispatch;
    }

    public void setNamedDispatch(boolean bl) {
        this.namedDispatch = bl;
    }

    public void setExpirationTime(long l) {
        if (l >= 0L && l < this.expirationTime) {
            this.expirationTime = l;
        }
    }

    public long getExpirationTime() {
        long l = this.expirationTime;
        long l2 = this.fragmentInfo.getExpirationTime();
        if (l2 >= 0L && l2 < l) {
            l = l2;
        }
        int n = this.contentVector.size();
        for (int i = 0; i < n; ++i) {
            FragmentComposer fragmentComposer;
            Object e2 = this.contentVector.get(i);
            if (!(e2 instanceof FragmentComposer) || (l2 = (fragmentComposer = (FragmentComposer)e2).getExpirationTime()) < 0L || l2 >= l) continue;
            l = l2;
        }
        if (l == Long.MAX_VALUE) {
            return -1L;
        }
        return l;
    }

    public long getTimeStamp() {
        long l = this.timeStamp;
        int n = this.contentVector.size();
        for (int i = 0; i < n; ++i) {
            FragmentComposer fragmentComposer;
            long l2;
            Object e2 = this.contentVector.get(i);
            if (!(e2 instanceof FragmentComposer) || (l2 = (fragmentComposer = (FragmentComposer)e2).getTimeStamp()) <= l) continue;
            l = l2;
        }
        return l;
    }

    public void setTimeStamp(long l) {
        if (l <= this.timeStamp) {
            return;
        }
        this.timeStamp = l;
    }

    public ValueSet getAllInvalidationIds() throws UnexternalizablePageException {
        if (this.cacheType == 0) {
            throw new UnexternalizablePageException("FragmentComposer is NOT_CACHED, therefore, you cannot externalize a top level page which includes it.");
        }
        if (this.fragmentInfo == null) {
            throw new UnexternalizablePageException("FragmentInfo should not be null, or FragmentComposer should be marked NOT_CACHED");
        }
        ValueSet valueSet = new ValueSet(23);
        valueSet.add(this.fragmentInfo.getId());
        valueSet.union(this.fragmentInfo.dataIds);
        valueSet.union(this.externalDataIds);
        return valueSet;
    }

    public ValueSet getAllTemplates() throws UnexternalizablePageException {
        if (this.cacheType == 0) {
            throw new UnexternalizablePageException("FragmentComposer is NOT_CACHED, therefore, you cannot externalize a top level page which includes it.");
        }
        if (this.fragmentInfo == null) {
            throw new UnexternalizablePageException("FragmentInfo should not be null, or FragmentComposer should be marked NOT_CACHED");
        }
        ValueSet valueSet = new ValueSet(11);
        Iterator iterator = this.fragmentInfo.templates.iterator();
        while (iterator.hasNext()) {
            valueSet.add(iterator.next());
        }
        valueSet.union(this.externalTemplates);
        return valueSet;
    }

    public void setHeader(String string, String string2, boolean bl) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            if (string == null) {
                throw new IllegalArgumentException("setHeader key parameter must be non-null");
            }
            HeaderSideEffect headerSideEffect = new HeaderSideEffect(string, string2, bl);
            this.contentVector.add(headerSideEffect);
        }
    }

    public void sendRedirect(String string) {
        this.isSendRedirect = true;
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            SendRedirectSideEffect sendRedirectSideEffect = new SendRedirectSideEffect(string);
            this.contentVector.add(sendRedirectSideEffect);
        }
    }

    public void addDynamicContentProvider(DynamicContentProvider dynamicContentProvider) throws IOException {
        if (dynamicContentProvider == null) {
            throw new IllegalArgumentException("Dynamic Content Provider must be non-null");
        }
        this.saveCachedData();
        this.contentVector.add(dynamicContentProvider);
        if (this.outputStyle == 2) {
            this.cacheProxyWriter.setCaching(false);
            dynamicContentProvider.provideDynamicContent((HttpServletRequest)this.request, this.cacheProxyWriter.getWriter());
            this.cacheProxyWriter.setCaching(true);
        } else if (this.outputStyle == 1) {
            this.cacheProxyOutputStream.setCaching(false);
            dynamicContentProvider.provideDynamicContent((HttpServletRequest)this.request, this.cacheProxyOutputStream.getOutputStream());
            this.cacheProxyOutputStream.setCaching(true);
        }
    }

    public void addCookie(Cookie cookie) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            Object object;
            boolean bl;
            if (cookie == null) {
                throw new IllegalArgumentException("cookie must be non-null");
            }
            if (this.fragmentInfo.getStoreCookies()) {
                bl = true;
                object = this.fragmentInfo.getCookieExcludeList();
                if (object != null) {
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (!cookie.getName().equals(object[i])) continue;
                        bl = false;
                    }
                }
            } else {
                bl = false;
                object = this.fragmentInfo.getCookieExcludeList();
                if (object != null) {
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (!cookie.getName().equals(object[i])) continue;
                        bl = true;
                    }
                }
            }
            if (bl) {
                object = new AddCookieSideEffect(cookie);
                this.contentVector.add(object);
            }
        }
    }

    public void setDateHeader(String string, long l, boolean bl) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            if (string == null) {
                throw new IllegalArgumentException("name must be non-null");
            }
            DateHeaderSideEffect dateHeaderSideEffect = new DateHeaderSideEffect(string, l, bl);
            this.contentVector.add(dateHeaderSideEffect);
        }
    }

    public void setIntHeader(String string, int n, boolean bl) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            if (string == null) {
                throw new IllegalArgumentException("name must be non-null");
            }
            IntHeaderSideEffect intHeaderSideEffect = new IntHeaderSideEffect(string, n, bl);
            this.contentVector.add(intHeaderSideEffect);
        }
    }

    public void setStatus(int n) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            DefaultStatusSideEffect defaultStatusSideEffect = new DefaultStatusSideEffect(n);
            this.contentVector.add(defaultStatusSideEffect);
        }
    }

    public void setStatus(int n, String string) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            if (string == null) {
                throw new IllegalArgumentException("comment must be non-null");
            }
            StatusSideEffect statusSideEffect = new StatusSideEffect(n, string);
            this.contentVector.add(statusSideEffect);
        }
    }

    public void setContentLength(int n) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            ContentLengthSideEffect contentLengthSideEffect = new ContentLengthSideEffect(n);
            this.contentVector.add(contentLengthSideEffect);
        }
    }

    public void setContentType(String string) {
        if (!this.response._gotWriter && !this.response._gotOutputStream) {
            this.contentType = string;
        }
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            this.contentVector.add(string);
        }
    }

    public void setCharacterEncoding(String string) {
        if (!this.response._gotWriter && !this.response._gotOutputStream) {
            this.characterEncoding = string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting self CharacterEncoding " + string);
            }
        }
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            CharacterEncodingSideEffect characterEncodingSideEffect = new CharacterEncodingSideEffect(string);
            this.contentVector.add(characterEncodingSideEffect);
        }
    }

    public void setLocale(Locale locale) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            LocaleSideEffect localeSideEffect = new LocaleSideEffect(locale);
            this.contentVector.add(localeSideEffect);
        }
    }

    public void setESIVersion(int n) {
        this.esiVersion = n;
    }

    public int getESIVersion() {
        return this.esiVersion;
    }

    public boolean isDiscardJSPContent() {
        return this.discardJSPContent;
    }

    public void setDiscardJSPContent(boolean bl) {
        this.discardJSPContent = bl;
    }
}

