/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.ResponseSideEffect;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.io.WSByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

class MementoEntry
implements Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Trace.register(MementoEntry.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    String template = null;
    Object[] contents = null;
    byte[] attributeTableBytes = null;
    CacheProxyRequest.Attribute[] attributeTable = null;
    byte[] endAttributeTableBytes = null;
    CacheProxyRequest.Attribute[] endAttributeTable = null;
    boolean include = false;
    boolean namedDispatch = false;
    String contextPath = null;
    boolean doNotConsume = false;
    String servletClassName = null;
    int outputStyle = 3;
    boolean externallyCacheable = false;

    MementoEntry(String string, byte[] byArray, byte[] byArray2, boolean bl, boolean bl2, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Building new Memento Entry for " + string + ", attributeTableBytes, endAttributeTableBytes, include = " + bl + ", contextPath is " + string2);
        }
        this.template = string;
        this.contextPath = string2;
        this.attributeTableBytes = byArray;
        this.endAttributeTableBytes = byArray2;
        this.include = bl;
        this.namedDispatch = bl2;
    }

    MementoEntry(String string, CacheProxyRequest.Attribute[] attributeArray, CacheProxyRequest.Attribute[] attributeArray2, boolean bl, boolean bl2, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Building new Memento Entry for " + string + ", attributeTable = " + this.prettyPrintAttributeTable(attributeArray) + ", endAttributeTable = " + this.prettyPrintAttributeTable(attributeArray2) + ", include = " + bl + ", contextPath is " + string2);
        }
        this.contextPath = string2;
        this.template = string;
        this.attributeTable = attributeArray;
        this.endAttributeTable = attributeArray2;
        this.include = bl;
        this.namedDispatch = bl2;
    }

    void addContents(Object[] objectArray) {
        this.contents = objectArray;
    }

    Object[] getContents() {
        return this.contents;
    }

    String getTemplate() {
        return this.template;
    }

    CacheProxyRequest.Attribute[] getAttributeTable() {
        if (this.attributeTable != null) {
            return this.attributeTable;
        }
        if (this.attributeTableBytes == null) {
            return null;
        }
        try {
            return (CacheProxyRequest.Attribute[])SerializationUtility.deserialize(this.attributeTableBytes);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.servlet.MementoEntry.getAttributeTable", "134", this);
            exception.printStackTrace();
            return null;
        }
    }

    byte[] getAttributeTableBytes() {
        return this.attributeTableBytes;
    }

    CacheProxyRequest.Attribute[] getEndAttributeTable() {
        if (this.endAttributeTable != null) {
            return this.endAttributeTable;
        }
        if (this.endAttributeTableBytes == null) {
            return null;
        }
        try {
            return (CacheProxyRequest.Attribute[])SerializationUtility.deserialize(this.endAttributeTableBytes);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.servlet.MementoEntry.getEndAttributeTable", "134", this);
            exception.printStackTrace();
            return null;
        }
    }

    byte[] getEndAttributeTableBytes() {
        return this.endAttributeTableBytes;
    }

    boolean getInclude() {
        return this.include;
    }

    boolean getNamedDispatch() {
        return this.namedDispatch;
    }

    String getContextPath() {
        return this.contextPath;
    }

    public boolean getDoNotConsume() {
        return this.doNotConsume;
    }

    public void setDoNotConsume(boolean bl) {
        this.doNotConsume = bl;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public void setServletClassName(String string) {
        this.servletClassName = string;
    }

    public void setOutputStyle(int n) {
        this.outputStyle = n;
    }

    public void setExternallyCacheable(boolean bl) {
        this.externallyCacheable = bl;
    }

    public boolean isExternallyCacheable() {
        return this.externallyCacheable;
    }

    public byte[] toByteArray(String string) throws IOException {
        if (!this.isExternallyCacheable()) {
            throw new IllegalStateException("Cannot obtain byteArray since caching was not enabled for this fragment");
        }
        WSByteArrayOutputStream wSByteArrayOutputStream = new WSByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        byte[] byArray = null;
        for (int i = 0; i < this.contents.length; ++i) {
            Object object = this.contents[i];
            if (object instanceof byte[]) {
                if (this.outputStyle != 1) {
                    throw new IllegalStateException("MementoEntry " + this + " with outputStyle " + this.outputStyle + " cannot contain byte arrays");
                }
                wSByteArrayOutputStream.write((byte[])object, 0, ((byte[])object).length);
                wSByteArrayOutputStream.flush();
                continue;
            }
            if (object instanceof char[]) {
                if (this.outputStyle != 2) {
                    throw new IllegalStateException("MementoEntry " + this + " with outputStyle " + this.outputStyle + " cannot contain char arrays");
                }
                if (outputStreamWriter == null) {
                    try {
                        outputStreamWriter = new OutputStreamWriter((OutputStream)wSByteArrayOutputStream, string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ws.cache.servlet.FragmentComposer.toByteArray", "671", this);
                        outputStreamWriter = new OutputStreamWriter(wSByteArrayOutputStream);
                    }
                }
                outputStreamWriter.write((char[])object, 0, ((char[])object).length);
                outputStreamWriter.flush();
                continue;
            }
            if (object instanceof String || object instanceof ResponseSideEffect) continue;
            if (!(object instanceof MementoEntry)) {
                throw new IllegalStateException("MementoEntry should only contain other MementoEntries, Byte Arrays, Char Arrays, and ResponseSideEffects");
            }
            MementoEntry mementoEntry = (MementoEntry)object;
            byArray = mementoEntry.toByteArray(string);
            wSByteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        return wSByteArrayOutputStream.toByteArray();
    }

    private String prettyPrintAttributeTable(CacheProxyRequest.Attribute[] attributeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != attributeArray) {
            for (int i = 0; i < attributeArray.length; ++i) {
                CacheProxyRequest.Attribute attribute = attributeArray[i];
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append(attribute);
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

