/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.CacheableServlet;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.ConfigChangeListener;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigManager;
import com.ibm.ws.cache.servlet.CacheHook;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentCacheProcessor;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.portletcontainer.portlet.PortletUtils;
import com.ibm.ws.portletcontainer.util.PortletContainerAccessHelper;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;

public class ServletWrapper
implements CacheableServlet,
Servlet,
HttpJspPage,
ConfigChangeListener {
    private static final long serialVersionUID = 5502601840576150659L;
    private static TraceComponent tc = Trace.register(ServletWrapper.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    Servlet proxied = null;
    boolean wrapsCacheableServlet = false;
    private HashMap activeConfigEntries = new HashMap();

    public ServletWrapper(Servlet servlet) {
        this.proxied = servlet;
        this.wrapsCacheableServlet = servlet instanceof CacheableServlet;
        ConfigManager.getInstance().addConfigChangeListener(this);
    }

    public void configChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareMetadata(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareMetadata: " + this.proxied);
        }
        FragmentInfo fragmentInfo = null;
        int n = 0;
        if (this.wrapsCacheableServlet) {
            CacheableServlet cacheableServlet = (CacheableServlet)this.proxied;
            String string = cacheableServlet.getId(cacheProxyRequest);
            int n2 = cacheableServlet.getSharingPolicy(cacheProxyRequest);
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cacheId is null");
                }
            } else {
                fragmentInfo = (FragmentInfo)cacheProxyRequest.getFragmentInfo();
                String string2 = cacheProxyRequest.getMethod();
                StringBuffer stringBuffer = new StringBuffer();
                if (string.indexOf("requestType=" + string2) == -1 && (string2.equals("GET") || string2.equals("POST")) && !fragmentInfo.isIgnoreGetPost()) {
                    fragmentInfo.addDataId(string);
                    stringBuffer.append(string).append(':').append("requestType=" + string2);
                    string = stringBuffer.toString();
                }
                fragmentInfo.setId(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sharingPolicy: " + n2);
                }
                fragmentInfo.setSharingPolicy(n2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareMetadata");
            }
            return;
        }
        ConfigEntry configEntry = null;
        String string = cacheProxyRequest.getContextPath();
        String string3 = cacheProxyRequest._getContextPath();
        String string4 = this.buildName(cacheProxyRequest);
        n = cacheProxyRequest.getPortletMethod();
        configEntry = n == 1 || PortletContainerAccessHelper.getPortletURI((String)string3, (String)string4) == null ? ConfigManager.getInstance().getServletCacheEntry(this.proxied, string4, string) : ConfigManager.getInstance().getPortletCacheEntry(this.proxied, string4, string3);
        fragmentInfo = (FragmentInfo)cacheProxyRequest.getFragmentInfo();
        if (configEntry == null) {
            fragmentInfo.setId(null);
        } else {
            this.activeConfigEntries.put(configEntry.name, configEntry);
            FragmentCacheProcessor fragmentCacheProcessor = (FragmentCacheProcessor)ConfigManager.getInstance().getCacheProcessor(configEntry);
            try {
                JSPCache jSPCache;
                fragmentCacheProcessor.execute(cacheProxyRequest, cacheProxyResponse, this.proxied);
                fragmentInfo.setId(fragmentCacheProcessor.getId());
                if (fragmentCacheProcessor.getId() != null) {
                    fragmentCacheProcessor.populateFragmentInfo(fragmentInfo);
                }
                if ((jSPCache = ServerCache.getJspCache(configEntry.instanceName)) != null) {
                    ArrayList arrayList = fragmentCacheProcessor.getInvalidationIds();
                    if (arrayList != null) {
                        int n3 = arrayList.size();
                        for (int i = 0; i < n3; ++i) {
                            jSPCache.invalidateById((String)arrayList.get(i), i == n3 - 1);
                        }
                    }
                    if (n == 3) {
                        String string5 = PortletUtils.getPortletWindow((PortletRequest)cacheProxyRequest.getPortletRequest()).getId(IdentifierNamespace.REQUEST).toString();
                        String string6 = PortletContainerAccessHelper.getPortletURI((String)cacheProxyRequest.getContextPath(), (String)this.buildName(cacheProxyRequest));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Portlet ActionRequest ... invalidating templates: " + string6 + ", " + string6 + ":" + string5);
                        }
                        jSPCache.invalidateByTemplate(string6, true);
                        jSPCache.invalidateByTemplate(string6 + ":" + string5, true);
                    }
                }
            }
            finally {
                ConfigManager.getInstance().returnCacheProcessor(fragmentCacheProcessor);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareMetadata");
        }
    }

    String buildName(CacheProxyRequest cacheProxyRequest) {
        int n;
        String string = "";
        String string2 = cacheProxyRequest._getContextPath();
        String string3 = cacheProxyRequest.getRelativeUri();
        string = string2 + string3;
        if (string == null) {
            return null;
        }
        if (string2 != null && string2.equals("/") && string3 != null && string3.startsWith("/")) {
            string = string3;
        }
        if ((n = string.indexOf(63)) == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getId(HttpServletRequest httpServletRequest) {
        CacheProxyRequest cacheProxyRequest = (CacheProxyRequest)httpServletRequest;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getId() for " + this.proxied + " returned " + cacheProxyRequest.getFragmentInfo().getId());
        }
        return cacheProxyRequest.getFragmentInfo().getId();
    }

    public int getSharingPolicy(HttpServletRequest httpServletRequest) {
        CacheProxyRequest cacheProxyRequest = (CacheProxyRequest)httpServletRequest;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSharingPolicy() for " + this.proxied + " returned " + cacheProxyRequest.getFragmentInfo().getSharingPolicy());
        }
        return cacheProxyRequest.getFragmentInfo().getSharingPolicy();
    }

    public void destroy() {
        CacheConfig cacheConfig = ServerCache.cacheUnit.getCacheConfig();
        if (!CacheServiceImpl.state.equals("STOPPING")) {
            for (ConfigEntry configEntry : this.activeConfigEntries.values()) {
                JSPCache jSPCache = ServerCache.getJspCache(configEntry.instanceName);
                if (jSPCache == null) continue;
                if (cacheConfig.disableTemplateInvalidation) {
                    Tr.info(tc, "dynacache.error", "Error type=destroy warning. Skipping template invalidation for JSP " + configEntry.name);
                    continue;
                }
                jSPCache.invalidateByTemplate(configEntry.name, true);
            }
        }
        this.activeConfigEntries.clear();
        this.proxied.destroy();
        ConfigManager.getInstance().removeConfigChangeListener(this);
    }

    public ServletConfig getServletConfig() {
        return this.proxied.getServletConfig();
    }

    public String getServletInfo() {
        return this.proxied.getServletInfo();
    }

    public ServletContext getServletContext() {
        return this.proxied.getServletConfig().getServletContext();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init()");
        }
        this.proxied.init(servletConfig);
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        try {
            CacheHook.handleServlet(this, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        }
        catch (ClassCastException classCastException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Wanted a HttpServletRequest, got " + servletRequest + ".  servicing as normal");
            }
            this.serviceProxied(servletRequest, servletResponse);
        }
    }

    public Servlet getProxiedServlet() {
        return this.proxied;
    }

    public void serviceProxied(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.proxied.service(servletRequest, servletResponse);
    }

    public void _jspService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ((HttpJspPage)this.proxied)._jspService(httpServletRequest, httpServletResponse);
    }

    public void jspInit() {
        ((HttpJspPage)this.proxied).jspInit();
    }

    public void jspDestroy() {
        ((HttpJspPage)this.proxied).jspDestroy();
    }
}

