/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.stat;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CacheStatsModule
extends StatisticActions
implements CachePerf {
    private static TraceComponent tc = Trace.register(CacheStatsModule.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean assertRanOnce = false;
    private static final String templateCount2 = "/com/ibm/websphere/pmi/xml/cacheModule_root.xml";
    private static final String templateCount15 = "/com/ibm/websphere/pmi/xml/cacheModule_template.xml";
    private static final String templateCount13 = "/com/ibm/websphere/pmi/xml/cacheModule_disk.xml";
    public static final int TYPE_SERVLET = 1;
    public static final int TYPE_OBJECT = 2;
    private static StatsGroup _cacheRootStatsGroup;
    private StatsGroup _cacheTemplateStatsGroup;
    private StatsGroup _cacheDiskStatsGroup;
    private StatsGroup _cacheObjectStatsGroup;
    private StatsInstance _statsInstance = null;
    private CacheStatsModule _cacheStatsModule = null;
    private CacheStatsModule _csmDisk = null;
    private CacheStatsModule _csmObject = null;
    private String _sCacheName;
    private String _sName;
    private int _iCacheType;
    protected boolean _enable = false;
    protected int _enableCount = 0;
    private SPICountStatistic _maxInMemoryCacheEntryCount = null;
    private SPICountStatistic _inMemoryCacheEntryCount = null;
    private SPICountStatistic _objectsOnDisk = null;
    private SPICountStatistic _hitsOnDisk = null;
    private SPICountStatistic _explicitInvalidationsFromDisk = null;
    private SPICountStatistic _timeoutInvalidationsFromDisk = null;
    private SPICountStatistic _pendingRemovalFromDisk = null;
    private SPICountStatistic _dependencyIdsOnDisk = null;
    private SPICountStatistic _dependencyIdsBufferedForDisk = null;
    private SPICountStatistic _dependencyIdsOffloadedToDisk = null;
    private SPICountStatistic _dependencyIdBasedInvalidationsFromDisk = null;
    private SPICountStatistic _templatesOnDisk = null;
    private SPICountStatistic _templatesBufferedForDisk = null;
    private SPICountStatistic _templatesOffloadedToDisk = null;
    private SPICountStatistic _templateBasedInvalidationsFromDisk = null;
    private SPICountStatistic _garbageCollectorInvalidationsFromDisk = null;
    private SPICountStatistic _overflowInvalidationsFromDisk = null;
    private SPICountStatistic _hitsInMemoryCount = null;
    private SPICountStatistic _hitsOnDiskCount = null;
    private SPICountStatistic _explicitInvalidationCount = null;
    private SPICountStatistic _lruInvalidationCount = null;
    private SPICountStatistic _timeoutInvalidationCount = null;
    private SPICountStatistic _inMemoryAndDiskCacheEntryCount = null;
    private SPICountStatistic _remoteHitCount = null;
    private SPICountStatistic _missCount = null;
    private SPICountStatistic _clientRequestCount = null;
    private SPICountStatistic _distributedRequestCount = null;
    private SPICountStatistic _explicitMemoryInvalidationCount = null;
    private SPICountStatistic _explicitDiskInvalidationCount = null;
    private SPICountStatistic _localExplicitInvalidationCount = null;
    private SPICountStatistic _remoteExplicitInvalidationCount = null;
    private SPICountStatistic _remoteCreationCount = null;
    HashMap templatesPassed = new HashMap();
    ArrayList templatesFailed = new ArrayList();

    private CacheStatsModule() {
    }

    public CacheStatsModule(int n, String string, boolean bl) throws StatsFactoryException {
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CacheStatsModule() CTOR #1 cacheName=" + string + " cacheType=" + n);
        }
        assert (string != null);
        this._sCacheName = string;
        this._sName = string;
        this._cacheStatsModule = this;
        this._iCacheType = n;
        if (_cacheRootStatsGroup == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CacheStatsModule() CTOR #1 Creating cacheModule group for cacheName=" + this._sCacheName);
            }
            _cacheRootStatsGroup = StatsFactory.createStatsGroup("cacheModule", templateCount2, null);
            assert (_cacheRootStatsGroup != null);
        }
        if (this._iCacheType == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CacheStatsModule() CTOR #1 Creating statistic for " + this._sCacheName + " instance (servlet cache)");
            }
            this._statsInstance = StatsFactory.createStatsInstance("Servlet: " + string, _cacheRootStatsGroup, null, (StatisticActions)this);
            if (bl) {
                if (this._cacheDiskStatsGroup == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CacheStatsModule() CTOR #1 Creating disk group for cacheName=" + this._sCacheName);
                    }
                    this._cacheDiskStatsGroup = StatsFactory.createStatsGroup("cacheModule.disk", templateCount13, this._statsInstance, null);
                    assert (this._cacheDiskStatsGroup != null);
                }
                this._csmDisk = new CacheStatsModule(this._sCacheName, "cacheModule.diskOffloadEnabled", this._cacheDiskStatsGroup, this);
            }
        } else if (this._iCacheType == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CacheStatsModule() CTOR #1 Creating statistic for " + this._sCacheName + " instance (object cache)");
            }
            this._statsInstance = StatsFactory.createStatsInstance("Object: " + string, _cacheRootStatsGroup, null, (StatisticActions)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CacheStatsModule() CTOR #1 Creating object cache group for cacheName=" + this._sCacheName);
            }
            this._cacheObjectStatsGroup = StatsFactory.createStatsGroup("cacheModule.objectCache", templateCount15, this._statsInstance, null);
            assert (this._cacheObjectStatsGroup != null);
            this._csmObject = new CacheStatsModule(this._sCacheName, "cacheModule.counters", this._cacheObjectStatsGroup, this);
            if (bl) {
                if (this._cacheDiskStatsGroup == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CacheStatsModule() CTOR #1 Creating disk group for cacheName=" + this._sCacheName);
                    }
                    this._cacheDiskStatsGroup = StatsFactory.createStatsGroup("cacheModule.disk", templateCount13, this._statsInstance, null);
                    assert (this._cacheDiskStatsGroup != null);
                }
                this._csmDisk = new CacheStatsModule(this._sCacheName, "cacheModule.diskOffloadEnabled", this._cacheDiskStatsGroup, this);
            }
        } else assert (false) : "Unknown cache type=" + this._iCacheType;
        assert (this._statsInstance != null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CacheStatsModule() CTOR #1 _statsInstance=" + this._statsInstance + " for cacheName=" + this._sCacheName);
        }
    }

    public CacheStatsModule(String string, String string2, StatsGroup statsGroup, CacheStatsModule cacheStatsModule) throws StatsFactoryException {
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CacheStatsModule() CTOR #2 cacheName=" + string, " name/template=" + string2);
        }
        assert (string != null);
        assert (string2 != null);
        assert (statsGroup != null);
        this._sCacheName = string;
        this._sName = string2;
        this._cacheStatsModule = cacheStatsModule;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CacheStatsModule() CTOR #2 Creating statistic for name/template=" + string2 + " instance for cacheName=" + string);
        }
        this._statsInstance = StatsFactory.createStatsInstance(string2, statsGroup, null, (StatisticActions)this);
        assert (this._statsInstance != null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CacheStatsModule() CTOR #2 _statsInstance=" + this._statsInstance + " for cacheName=" + string);
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        switch (sPIStatistic.getId()) {
            case 1: {
                this._maxInMemoryCacheEntryCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 2: {
                this._inMemoryCacheEntryCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 21: {
                this._hitsInMemoryCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 22: {
                this._hitsOnDiskCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 23: {
                this._explicitInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 24: {
                this._lruInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 25: {
                this._timeoutInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 26: {
                this._inMemoryAndDiskCacheEntryCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 27: {
                this._remoteHitCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 28: {
                this._missCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 29: {
                this._clientRequestCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 30: {
                this._distributedRequestCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 31: {
                this._explicitMemoryInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 32: {
                this._explicitDiskInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 34: {
                this._localExplicitInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 35: {
                this._remoteExplicitInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 36: {
                this._remoteCreationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 4: {
                this._objectsOnDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 5: {
                this._hitsOnDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 6: {
                this._explicitInvalidationsFromDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 7: {
                this._timeoutInvalidationsFromDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 8: {
                this._pendingRemovalFromDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 9: {
                this._dependencyIdsOnDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 10: {
                this._dependencyIdsBufferedForDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 11: {
                this._dependencyIdsOffloadedToDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 12: {
                this._dependencyIdBasedInvalidationsFromDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 13: {
                this._templatesOnDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 14: {
                this._templatesBufferedForDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 15: {
                this._templatesOffloadedToDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 16: {
                this._templateBasedInvalidationsFromDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 17: {
                this._garbageCollectorInvalidationsFromDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 18: {
                this._overflowInvalidationsFromDisk = (SPICountStatistic)sPIStatistic;
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "statisticCreated() Error - Unknown stats Id for cacheModule cacheName=" + this._sCacheName + " dataID=" + sPIStatistic.getId());
                }
                assert (false);
                break;
            }
        }
    }

    public void enableStatusChanged(int[] nArray, int[] nArray2) {
        if (this._enable) {
            if (nArray.length == 0) {
                this._enable = false;
                --this._cacheStatsModule._enableCount;
            }
        } else if (nArray.length > 0) {
            this._enable = true;
            ++this._cacheStatsModule._enableCount;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enableStatusChanged() cacheName=" + this._sCacheName + " name=" + this._sName + " enabledSize=" + nArray.length + " disabledSize=" + nArray2.length + " enable=" + this._enable + " enableCount=" + this._cacheStatsModule._enableCount);
        }
    }

    public void updateStatisticOnRequest(int n) {
    }

    public boolean isPMIEnabled() {
        if (tc.isDebugEnabled() && this._enableCount < 0) {
            Tr.debug(tc, "isPMIEnabled() enableCount < 0");
            this._enableCount = 0;
        }
        return this._enableCount > 0;
    }

    public void resetPMICounters() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resetPMICounters() cacheName=" + this._sCacheName);
        }
        if (this._enable && this._maxInMemoryCacheEntryCount != null) {
            this._maxInMemoryCacheEntryCount.setCount(0L);
        }
        if (this._enable && this._inMemoryCacheEntryCount != null) {
            this._inMemoryCacheEntryCount.setCount(0L);
        }
        if (this._csmDisk != null && this._csmDisk._enable) {
            if (this._csmDisk._objectsOnDisk != null) {
                this._csmDisk._objectsOnDisk.setCount(0L);
            }
            if (this._csmDisk._hitsOnDisk != null) {
                this._csmDisk._hitsOnDisk.setCount(0L);
            }
            if (this._csmDisk._explicitInvalidationsFromDisk != null) {
                this._csmDisk._explicitInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._timeoutInvalidationsFromDisk != null) {
                this._csmDisk._timeoutInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._pendingRemovalFromDisk != null) {
                this._csmDisk._pendingRemovalFromDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsOnDisk != null) {
                this._csmDisk._dependencyIdsOnDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsBufferedForDisk != null) {
                this._csmDisk._dependencyIdsBufferedForDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsOffloadedToDisk != null) {
                this._csmDisk._dependencyIdsOffloadedToDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdBasedInvalidationsFromDisk != null) {
                this._csmDisk._dependencyIdBasedInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._templatesOnDisk != null) {
                this._csmDisk._templatesOnDisk.setCount(0L);
            }
            if (this._csmDisk._templatesBufferedForDisk != null) {
                this._csmDisk._templatesBufferedForDisk.setCount(0L);
            }
            if (this._csmDisk._templatesOffloadedToDisk != null) {
                this._csmDisk._templatesOffloadedToDisk.setCount(0L);
            }
            if (this._csmDisk._templateBasedInvalidationsFromDisk != null) {
                this._csmDisk._templateBasedInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._garbageCollectorInvalidationsFromDisk != null) {
                this._csmDisk._garbageCollectorInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._overflowInvalidationsFromDisk != null) {
                this._csmDisk._overflowInvalidationsFromDisk.setCount(0L);
            }
        }
        if (this._iCacheType == 1) {
            Iterator iterator = this.templatesPassed.keySet().iterator();
            while (iterator.hasNext()) {
                CacheStatsModule cacheStatsModule = null;
                String string = (String)iterator.next();
                cacheStatsModule = (CacheStatsModule)this.templatesPassed.get(string);
                if (cacheStatsModule == null || !cacheStatsModule._enable) continue;
                if (cacheStatsModule._hitsInMemoryCount != null) {
                    cacheStatsModule._hitsInMemoryCount.setCount(0L);
                }
                if (cacheStatsModule._hitsOnDiskCount != null) {
                    cacheStatsModule._hitsOnDiskCount.setCount(0L);
                }
                if (cacheStatsModule._explicitInvalidationCount != null) {
                    cacheStatsModule._explicitInvalidationCount.setCount(0L);
                }
                if (cacheStatsModule._lruInvalidationCount != null) {
                    cacheStatsModule._lruInvalidationCount.setCount(0L);
                }
                if (cacheStatsModule._timeoutInvalidationCount != null) {
                    cacheStatsModule._timeoutInvalidationCount.setCount(0L);
                }
                if (cacheStatsModule._inMemoryAndDiskCacheEntryCount != null) {
                    cacheStatsModule._inMemoryAndDiskCacheEntryCount.setCount(0L);
                }
                if (cacheStatsModule._remoteHitCount != null) {
                    cacheStatsModule._remoteHitCount.setCount(0L);
                }
                if (cacheStatsModule._missCount != null) {
                    cacheStatsModule._missCount.setCount(0L);
                }
                if (cacheStatsModule._clientRequestCount != null) {
                    cacheStatsModule._clientRequestCount.setCount(0L);
                }
                if (cacheStatsModule._distributedRequestCount != null) {
                    cacheStatsModule._distributedRequestCount.setCount(0L);
                }
                if (cacheStatsModule._explicitMemoryInvalidationCount != null) {
                    cacheStatsModule._explicitMemoryInvalidationCount.setCount(0L);
                }
                if (cacheStatsModule._explicitDiskInvalidationCount != null) {
                    cacheStatsModule._explicitDiskInvalidationCount.setCount(0L);
                }
                if (cacheStatsModule._localExplicitInvalidationCount != null) {
                    cacheStatsModule._localExplicitInvalidationCount.setCount(0L);
                }
                if (cacheStatsModule._remoteExplicitInvalidationCount != null) {
                    cacheStatsModule._remoteExplicitInvalidationCount.setCount(0L);
                }
                if (cacheStatsModule._remoteCreationCount == null) continue;
                cacheStatsModule._remoteCreationCount.setCount(0L);
            }
        } else if (this._csmObject != null && this._csmObject._enable) {
            if (this._csmObject._hitsInMemoryCount != null) {
                this._csmObject._hitsInMemoryCount.setCount(0L);
            }
            if (this._csmObject._hitsOnDiskCount != null) {
                this._csmObject._hitsOnDiskCount.setCount(0L);
            }
            if (this._csmObject._explicitInvalidationCount != null) {
                this._csmObject._explicitInvalidationCount.setCount(0L);
            }
            if (this._csmObject._lruInvalidationCount != null) {
                this._csmObject._lruInvalidationCount.setCount(0L);
            }
            if (this._csmObject._timeoutInvalidationCount != null) {
                this._csmObject._timeoutInvalidationCount.setCount(0L);
            }
            if (this._csmObject._inMemoryAndDiskCacheEntryCount != null) {
                this._csmObject._inMemoryAndDiskCacheEntryCount.setCount(0L);
            }
            if (this._csmObject._remoteHitCount != null) {
                this._csmObject._remoteHitCount.setCount(0L);
            }
            if (this._csmObject._missCount != null) {
                this._csmObject._missCount.setCount(0L);
            }
            if (this._csmObject._clientRequestCount != null) {
                this._csmObject._clientRequestCount.setCount(0L);
            }
            if (this._csmObject._distributedRequestCount != null) {
                this._csmObject._distributedRequestCount.setCount(0L);
            }
            if (this._csmObject._explicitMemoryInvalidationCount != null) {
                this._csmObject._explicitMemoryInvalidationCount.setCount(0L);
            }
            if (this._csmObject._explicitDiskInvalidationCount != null) {
                this._csmObject._explicitDiskInvalidationCount.setCount(0L);
            }
            if (this._csmObject._localExplicitInvalidationCount != null) {
                this._csmObject._localExplicitInvalidationCount.setCount(0L);
            }
            if (this._csmObject._remoteExplicitInvalidationCount != null) {
                this._csmObject._remoteExplicitInvalidationCount.setCount(0L);
            }
            if (this._csmObject._remoteCreationCount != null) {
                this._csmObject._remoteCreationCount.setCount(0L);
            }
        }
    }

    public void updateCacheSizes(long l, long l2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateCacheSizes() cacheName=" + this._sCacheName + " max=" + l + " current=" + l2 + " enable=" + this._enable);
        }
        if (this._enable) {
            if (this._maxInMemoryCacheEntryCount != null) {
                this._maxInMemoryCacheEntryCount.setCount(l);
            }
            if (this._inMemoryCacheEntryCount != null) {
                this._inMemoryCacheEntryCount.setCount(l2);
            }
        }
    }

    public void updateDiskCacheStatistics(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
        if (this._csmDisk != null && this._csmDisk._enable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateDiskCacheStatistics() cacheName=" + this._sCacheName + " updateCacheStatistics, objectsOnDisk=" + l + " pendingRemovalFromDisk=" + l2 + " dependencyIdsOnDisk=" + l3 + " dependencyIdsBufferedForDisk=" + l4 + " dependencyIdsOffloadedToDisk=" + l5 + " dependencyIdBasedInvalidations=" + l6 + " templatesOnDisk=" + l7 + " templatesBufferedForDisk=" + l8 + " templatesOffloadedToDisk=" + l9 + " templateBasedInvalidations=" + l10 + " enable=" + this._csmDisk._enable);
            }
            if (this._csmDisk._objectsOnDisk != null) {
                this._csmDisk._objectsOnDisk.setCount(l);
            }
            if (this._csmDisk._pendingRemovalFromDisk != null) {
                this._csmDisk._pendingRemovalFromDisk.setCount(l2);
            }
            if (this._csmDisk._dependencyIdsOnDisk != null) {
                this._csmDisk._dependencyIdsOnDisk.setCount(l3);
            }
            if (this._csmDisk._dependencyIdsBufferedForDisk != null) {
                this._csmDisk._dependencyIdsBufferedForDisk.setCount(l4);
            }
            if (this._csmDisk._dependencyIdsOffloadedToDisk != null) {
                this._csmDisk._dependencyIdsOffloadedToDisk.setCount(l5);
            }
            if (this._csmDisk._dependencyIdBasedInvalidationsFromDisk != null) {
                this._csmDisk._dependencyIdBasedInvalidationsFromDisk.setCount(l6);
            }
            if (this._csmDisk._templatesOnDisk != null) {
                this._csmDisk._templatesOnDisk.setCount(l7);
            }
            if (this._csmDisk._templatesBufferedForDisk != null) {
                this._csmDisk._templatesBufferedForDisk.setCount(l8);
            }
            if (this._csmDisk._templatesOffloadedToDisk != null) {
                this._csmDisk._templatesOffloadedToDisk.setCount(l9);
            }
            if (this._csmDisk._templateBasedInvalidationsFromDisk != null) {
                this._csmDisk._templateBasedInvalidationsFromDisk.setCount(l10);
            }
        }
    }

    public void onCacheHit(String string, int n) {
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onCacheHit() cacheName=" + this._sCacheName + " template=" + string + " locality=" + n + " enable=" + cacheStatsModule._enable + " parentEnable=" + this._enable);
        }
        switch (n) {
            case 2: {
                if (!cacheStatsModule._enable) break;
                if (cacheStatsModule._remoteHitCount != null) {
                    cacheStatsModule._remoteHitCount.increment();
                }
                if (cacheStatsModule._inMemoryAndDiskCacheEntryCount != null) {
                    cacheStatsModule._inMemoryAndDiskCacheEntryCount.increment();
                }
                if (cacheStatsModule._remoteCreationCount == null) break;
                cacheStatsModule._remoteCreationCount.increment();
                break;
            }
            case 1: {
                if (!cacheStatsModule._enable || cacheStatsModule._hitsInMemoryCount == null) break;
                cacheStatsModule._hitsInMemoryCount.increment();
                break;
            }
            case 3: {
                if (this._csmDisk != null && this._csmDisk._enable && this._csmDisk._hitsOnDisk != null) {
                    this._csmDisk._hitsOnDisk.increment();
                }
                if (!cacheStatsModule._enable || cacheStatsModule._hitsOnDiskCount == null) break;
                cacheStatsModule._hitsOnDiskCount.increment();
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "onCacheHit() Error - Unrecognized locality " + n + " cacheName=" + this._sCacheName);
            }
        }
    }

    public void onCacheMiss(String string, int n) {
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onCacheMiss() cacheName=" + this._sCacheName + " template=" + string + " locality=" + n + " enable=" + cacheStatsModule._enable);
        }
        if (cacheStatsModule._enable && cacheStatsModule._missCount != null) {
            cacheStatsModule._missCount.increment();
        }
    }

    public void onEntryCreation(String string, int n) {
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onEntryCreation() cacheName=" + this._sCacheName + " template=" + string + " source=" + n + " enable=" + cacheStatsModule._enable);
        }
        if (cacheStatsModule._enable) {
            if (n == 2 && cacheStatsModule._remoteCreationCount != null) {
                cacheStatsModule._remoteCreationCount.increment();
            }
            if (cacheStatsModule._inMemoryAndDiskCacheEntryCount != null) {
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.increment();
            }
        }
    }

    public void onRequest(String string, int n) {
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onRequest() cacheName=" + this._sCacheName + " template=" + string + " source=" + n + " enable=" + cacheStatsModule._enable);
        }
        if (cacheStatsModule._enable) {
            if (n == 5) {
                if (cacheStatsModule._clientRequestCount != null) {
                    cacheStatsModule._clientRequestCount.increment();
                }
            } else if (n == 2 && cacheStatsModule._distributedRequestCount != null) {
                cacheStatsModule._distributedRequestCount.increment();
            }
        }
    }

    public void batchOnInvalidate(String string, int n, int n2, int n3, int n4) {
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchOnInvalidate() cacheName=" + this._sCacheName + " template=" + string + " cause=" + n + " locality=" + n2 + " source=" + n3 + " delete=" + n4 + " enable=" + cacheStatsModule._enable + " parentEnable=" + this._enable);
        }
        switch (n) {
            case 1: {
                if (cacheStatsModule._enable && cacheStatsModule._explicitInvalidationCount != null) {
                    cacheStatsModule._explicitInvalidationCount.increment(n4);
                }
                switch (n2) {
                    case 1: {
                        if (!cacheStatsModule._enable) break;
                        if (cacheStatsModule._explicitMemoryInvalidationCount != null) {
                            cacheStatsModule._explicitMemoryInvalidationCount.increment(n4);
                        }
                        if (cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                        cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement(n4);
                        break;
                    }
                    case 3: {
                        if (this._csmDisk != null && this._csmDisk._enable && this._csmDisk._explicitInvalidationsFromDisk != null) {
                            this._csmDisk._explicitInvalidationsFromDisk.increment(n4);
                        }
                        if (!cacheStatsModule._enable) break;
                        if (cacheStatsModule._explicitDiskInvalidationCount != null) {
                            cacheStatsModule._explicitDiskInvalidationCount.increment(n4);
                        }
                        if (cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                        cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement(n4);
                    }
                }
                switch (n3) {
                    case 5: {
                        if (!cacheStatsModule._enable || cacheStatsModule._localExplicitInvalidationCount == null) break;
                        cacheStatsModule._localExplicitInvalidationCount.increment(n4);
                        break;
                    }
                    case 2: {
                        if (!cacheStatsModule._enable || cacheStatsModule._remoteExplicitInvalidationCount == null) break;
                        cacheStatsModule._remoteExplicitInvalidationCount.increment(n4);
                    }
                }
                break;
            }
            case 2: {
                if (cacheStatsModule._enable && cacheStatsModule._lruInvalidationCount != null) {
                    cacheStatsModule._lruInvalidationCount.increment(n4);
                }
                if (n2 == 3 || !cacheStatsModule._enable || cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement(n4);
                break;
            }
            case 3: {
                if (this._csmDisk != null && n2 == 3 && this._csmDisk._enable && this._csmDisk._timeoutInvalidationsFromDisk != null) {
                    this._csmDisk._timeoutInvalidationsFromDisk.increment(n4);
                }
                if (!cacheStatsModule._enable) break;
                if (cacheStatsModule._timeoutInvalidationCount != null) {
                    cacheStatsModule._timeoutInvalidationCount.increment(n4);
                }
                if (cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement(n4);
                break;
            }
            case 7: {
                if (this._csmDisk != null && this._csmDisk._enable && this._csmDisk._garbageCollectorInvalidationsFromDisk != null) {
                    this._csmDisk._garbageCollectorInvalidationsFromDisk.increment(n4);
                }
                if (!cacheStatsModule._enable || cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement(n4);
                break;
            }
            case 8: {
                if (this._csmDisk != null && this._csmDisk._enable && this._csmDisk._overflowInvalidationsFromDisk != null) {
                    this._csmDisk._overflowInvalidationsFromDisk.increment(n4);
                }
                if (!cacheStatsModule._enable || cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement(n4);
            }
        }
    }

    public void onInvalidate(String string, int n, int n2, int n3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onInvalidate() cacheName=" + this._sCacheName + " template=" + string + " cause=" + n + " locality=" + n2 + " source=" + n3);
        }
        this.batchOnInvalidate(string, n, n2, n3, 1);
    }

    public void onCacheClear(boolean bl, boolean bl2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onCacheClear() cacheName=" + this._sCacheName + " memory=" + bl + " disk=" + bl2);
        }
        if (this._enable && this._inMemoryCacheEntryCount != null && bl) {
            this._inMemoryCacheEntryCount.setCount(0L);
        }
        if (this._csmDisk != null && this._csmDisk._enable && bl2) {
            if (this._csmDisk._objectsOnDisk != null) {
                this._csmDisk._objectsOnDisk.setCount(0L);
            }
            if (this._csmDisk._pendingRemovalFromDisk != null) {
                this._csmDisk._pendingRemovalFromDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsOnDisk != null) {
                this._csmDisk._dependencyIdsOnDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsBufferedForDisk != null) {
                this._csmDisk._dependencyIdsBufferedForDisk.setCount(0L);
            }
            if (this._csmDisk._templatesOnDisk != null) {
                this._csmDisk._templatesOnDisk.setCount(0L);
            }
            if (this._csmDisk._templatesBufferedForDisk != null) {
                this._csmDisk._templatesBufferedForDisk.setCount(0L);
            }
        }
        if (this._iCacheType == 1 && (bl || bl2)) {
            Iterator iterator = this.templatesPassed.keySet().iterator();
            while (iterator.hasNext()) {
                CacheStatsModule cacheStatsModule = null;
                String string = (String)iterator.next();
                cacheStatsModule = (CacheStatsModule)this.templatesPassed.get(string);
                if (cacheStatsModule == null || !cacheStatsModule._enable || cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) continue;
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.setCount(0L);
            }
        } else if (this._csmObject != null && this._csmObject._enable && (bl || bl2) && this._csmObject._inMemoryAndDiskCacheEntryCount != null) {
            this._csmObject._inMemoryAndDiskCacheEntryCount.setCount(0L);
        }
    }

    private synchronized CacheStatsModule createTemplateModule(String string) {
        CacheStatsModule cacheStatsModule = (CacheStatsModule)this.templatesPassed.get(string);
        if (cacheStatsModule == null && !this.templatesFailed.contains(string)) {
            try {
                if (this._cacheTemplateStatsGroup == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createTemplateModule() Creating template group for cacheName=" + this._sCacheName);
                    }
                    this._cacheTemplateStatsGroup = StatsFactory.createStatsGroup("cacheModule.template", templateCount15, this._statsInstance, null);
                    assert (this._cacheTemplateStatsGroup != null);
                }
                cacheStatsModule = new CacheStatsModule(this._sCacheName, string, this._cacheTemplateStatsGroup, this);
                this.templatesPassed.put(string, cacheStatsModule);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.stat.CacheStatsModule", "572", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createTemplateModule() Exception while creating template - cacheName=" + this._sCacheName + " template=" + string + ": " + ExceptionUtility.getStackTrace(throwable));
                }
                this.templatesFailed.add(string);
                cacheStatsModule = null;
            }
        }
        return cacheStatsModule;
    }

    private CacheStatsModule getCSM(String string) {
        CacheStatsModule cacheStatsModule = null;
        if (this._iCacheType == 1) {
            if (string != null && !string.equals("") && (cacheStatsModule = (CacheStatsModule)this.templatesPassed.get(string)) == null) {
                cacheStatsModule = this.createTemplateModule(string);
            }
        } else if (this._iCacheType == 2) {
            cacheStatsModule = this._csmObject;
        }
        return cacheStatsModule;
    }
}

