/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.webservices.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigManager;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.webservices.client.JAXRPCCacheProcessor;
import com.ibm.ws.cache.webservices.client.JAXRPCEntryInfo;
import com.ibm.ws.cache.webservices.client.JAXRPCResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.webservices.engine.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class JAXRPCCache {
    private static TraceComponent tc = Tr.register(JAXRPCCache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final String WSDL_PORT_NAME = "wsdl.portName";
    private static JAXRPCEntryInfoObjectPool entryInfoPool = new JAXRPCEntryInfoObjectPool(50);
    private static MessageFactory mf = null;

    private JAXRPCCache() {
    }

    public static boolean getId(String string, SOAPMessageContext sOAPMessageContext, JAXRPCEntryInfo jAXRPCEntryInfo) {
        Object object;
        Object object2;
        SOAPMessageContext sOAPMessageContext2 = sOAPMessageContext;
        SOAPHeader sOAPHeader = null;
        SOAPBody sOAPBody = null;
        if (string == null || string.equals("")) {
            return false;
        }
        ConfigEntry configEntry = ConfigManager.getInstance().getJaxRpcConfigEntry(string);
        if (configEntry == null) {
            return false;
        }
        try {
            object2 = sOAPMessageContext2.getMessage();
            object = object2.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = object.getEnvelope();
            sOAPHeader = sOAPEnvelope.getHeader();
            sOAPBody = sOAPEnvelope.getBody();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.cache.webservices.client.JAXRPCCache.getId", "85");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while retrieving SOAP elements. " + exception.getMessage());
            }
            throw new JAXRPCException((Throwable)exception);
        }
        object2 = (JAXRPCCacheProcessor)ConfigManager.getInstance().getCacheProcessor(configEntry);
        object = (QName)sOAPMessageContext.getProperty(WSDL_PORT_NAME);
        boolean bl = ((JAXRPCCacheProcessor)object2).execute(sOAPMessageContext2, string, null, (QName)object, sOAPHeader, sOAPBody);
        jAXRPCEntryInfo.instanceName = configEntry.instanceName;
        ((JAXRPCCacheProcessor)object2).setEntryInfo(jAXRPCEntryInfo);
        DCache dCache = ServerCache.getJaxRpcCache(configEntry.instanceName);
        if (dCache != null) {
            ArrayList arrayList = ((CacheProcessor)object2).getInvalidationIds();
            if (arrayList != null) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    dCache.invalidateById((String)arrayList.get(i), i == n - 1);
                }
            }
        } else {
            return false;
        }
        ConfigManager.getInstance().returnCacheProcessor((CacheProcessor)object2);
        return bl;
    }

    public static byte[] serialize(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ((SOAPMessage)object).writeTo((OutputStream)byteArrayOutputStream);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException(sOAPException, "com.ibm.ws.cache.webservices.client.JAXRPCCache.serialize", "135");
            IOException iOException = new IOException("Exception while serializing SOAP message");
            iOException.initCause(sOAPException);
            throw iOException;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Data after serialized:  " + new String(byArray));
        }
        return byArray;
    }

    public static Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SOAPMessage sOAPMessage = null;
        try {
            if (mf == null) {
                mf = MessageFactory.newInstance();
            }
            sOAPMessage = mf.createMessage(null, (InputStream)byteArrayInputStream);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException(sOAPException, "com.ibm.ws.cache.webservices.client.JAXRPCCache.deserialize", "160");
            IOException iOException = new IOException("Exception while creating SOAP message from input stream");
            iOException.initCause(sOAPException);
            throw iOException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Data after deserialized:  " + ((Message)sOAPMessage).getSOAPPartAsString());
        }
        return sOAPMessage;
    }

    public static Object getValue(JAXRPCEntryInfo jAXRPCEntryInfo) {
        JAXRPCResponse jAXRPCResponse;
        block5: {
            DCache dCache = ServerCache.getJaxRpcCache(jAXRPCEntryInfo.instanceName);
            if (dCache == null) {
                return null;
            }
            byte[] byArray = (byte[])dCache.getValue(jAXRPCEntryInfo, false);
            if (byArray == null) {
                return null;
            }
            jAXRPCResponse = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deserializing cache value to create SOAP response.");
                }
                jAXRPCResponse = (JAXRPCResponse)SerializationUtility.deserialize(byArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.cache.webservices.client.JAXRPCCache.getValue", "187");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception while deserialize SOAP response. " + exception.getMessage());
            }
        }
        return jAXRPCResponse.getCopyValue();
    }

    public static void setValue(JAXRPCEntryInfo jAXRPCEntryInfo, Object object) {
        DCache dCache = ServerCache.getJaxRpcCache(jAXRPCEntryInfo.instanceName);
        if (dCache != null) {
            JAXRPCResponse jAXRPCResponse = new JAXRPCResponse();
            jAXRPCResponse.setCopyValue(object);
            byte[] byArray = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Serializing the value to save a copy of SOAP response.");
                }
                byArray = SerializationUtility.serialize(jAXRPCResponse);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.cache.webservices.client.JAXRPCCache.setValue", "230");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while serialize SOAP response. " + exception.getMessage());
                }
                return;
            }
            jAXRPCEntryInfo.setCacheType(1);
            dCache.setValue(jAXRPCEntryInfo, byArray);
        }
    }

    public static boolean isCachingEnabled() {
        return ServerCache.cacheEnabled;
    }

    public static void returnToEntryInfoPool(JAXRPCEntryInfo jAXRPCEntryInfo) {
        if (jAXRPCEntryInfo != null) {
            jAXRPCEntryInfo.reset();
            entryInfoPool.add(jAXRPCEntryInfo);
        }
    }

    public static JAXRPCEntryInfo getFromEntryInfoPool() {
        return (JAXRPCEntryInfo)entryInfoPool.remove();
    }

    static class JAXRPCEntryInfoObjectPool
    extends ObjectPool {
        public JAXRPCEntryInfoObjectPool(int n) {
            super("JAXRPCEntryInfoPool", n);
        }

        public Object createObject() {
            return new JAXRPCEntryInfo();
        }
    }
}

