/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.webservices.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.webservices.client.JAXRPCCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class JAXRPCResponse
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = -136093285270439588L;
    private static TraceComponent tc = Tr.register(JAXRPCResponse.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private QName[] names = null;
    private Object value = null;
    private String serializationMethod = null;
    private String copyingMethod = null;

    public Object getCopyValue() {
        return this.value;
    }

    public void setCopyValue(Object object) {
        this.value = object;
    }

    public QName[] getNames() {
        return this.names;
    }

    public void setNames(QName[] qNameArray) {
        this.names = qNameArray;
    }

    public void setSerializationMethod(String string) {
        this.serializationMethod = string;
    }

    public void setCopyingMethod(String string) {
        this.copyingMethod = string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.copyingMethod);
        objectOutput.writeObject(this.serializationMethod);
        if (this.value == null) {
            objectOutput.writeBoolean(false);
            return;
        }
        objectOutput.writeBoolean(true);
        byte[] byArray = JAXRPCCache.serialize(this.value);
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.copyingMethod = (String)objectInput.readObject();
        this.serializationMethod = (String)objectInput.readObject();
        if (!objectInput.readBoolean()) {
            return;
        }
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray);
        this.value = JAXRPCCache.deserialize(byArray);
    }

    public static Object copy(Object object) {
        if (object instanceof Cloneable) {
            try {
                Class<?> clazz = object.getClass();
                Method method2 = clazz.getMethod("clone", new Class[0]);
                Object object2 = method2.invoke(object, null);
                return object2;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "FAIL CLONE! return reference. " + exception.getMessage());
                }
                return object;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NOT CLONEABLE! return reference.");
        }
        return object;
    }

    public String toString() {
        String string = "";
        try {
            SOAPPart sOAPPart = ((SOAPMessage)this.value).getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            string = sOAPEnvelope.toString();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.webservices.client.JAXRPCResponse.toString", "146", this);
        }
        return string;
    }
}

