/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.applicationclient;

import com.ibm.ejs.csi.HandleDelegateFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CAdminObject;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.url.URLProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.client.applicationclient.ClientContainerException;
import com.ibm.websphere.client.applicationclient.NoMainClassException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.client.applicationclient.ApplicationClientMetaData;
import com.ibm.ws.client.applicationclient.ClientBindingObjectException;
import com.ibm.ws.client.applicationclient.ClientBindingObjectUnknownException;
import com.ibm.ws.client.applicationclient.ClientComponentInitImpl;
import com.ibm.ws.client.applicationclient.ClientContainerParms;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.applicationclient.ClientDataSourceResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJ2CResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJMSClientInit;
import com.ibm.ws.client.applicationclient.ClientJMSConnectionResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJMSDestinationResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJMSQueueConnectionResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJMSQueueResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJMSTopicConnectionResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJMSTopicResourceBinder;
import com.ibm.ws.client.applicationclient.ClientMailResourceBinder;
import com.ibm.ws.client.applicationclient.ClientORBFactory;
import com.ibm.ws.client.applicationclient.ClientProcessService;
import com.ibm.ws.client.applicationclient.ClientResourceBinder;
import com.ibm.ws.client.applicationclient.ClientResourceBinderImpl;
import com.ibm.ws.client.applicationclient.ClientStreamHandlerFactory;
import com.ibm.ws.client.applicationclient.ClientURLResourceBinder;
import com.ibm.ws.client.applicationclient.FactoryNotFoundException;
import com.ibm.ws.client.applicationclient.ReferenceName;
import com.ibm.ws.client.applicationclient.Utility;
import com.ibm.ws.client.applicationclient.javaNameSpaceAccessorImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.naming.java.javaNameSpace;
import com.ibm.ws.naming.java.javaURLContextFactoryBase;
import com.ibm.ws.naming.util.IndirectJndiLookup;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ComponentManagerFactory;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.security.common.auth.spi.SecurityCallbackHandlerAccessor;
import com.ibm.ws.webservices.configuration.WASWebServicesBind;
import com.ibm.ws.webservices.configuration.WASWebServicesBindException;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.Policy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.UncontainedModuleFileException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.xml.NotSupportedException;

public class ClientContainer {
    private static final TraceComponent tc = Tr.register(ClientContainer.class, null, "com.ibm.ws.client.applicationclient.ResourceBundle");
    private ClientContainerParms _ccp = null;
    private javaNameSpace _jns = null;
    private static javaNameSpaceAccessorImpl _jnsa = null;
    private Properties _props = null;
    private Context _envCtx = null;
    private Context _javaColonCtx = null;
    private Context _servicesColonCtx = null;
    private Context _compCtx = null;
    private ApplicationClientMetaData _acmd = null;
    private Hashtable _resourceBinders = new Hashtable();
    private NameParser _np = null;
    private static final String KEYPREFIX = "com.ibm.websphere.client.applicationclient";
    private boolean _verbose = false;
    private static ClientStreamHandlerFactory _urlf = null;
    private Component _CComp = null;
    private String iCorbaURL = null;
    private static final String _sourceInfo = "SERV1/ws/code/client/src/com/ibm/ws/client/applicationclient/ClientContainer.java, WAS.client, WASX.SERV1, o0509.11, ver. 1.78";
    private String _installRoot = null;

    public ClientContainer(ClientContainerParms clientContainerParms) throws NoMainClassException, EmptyResourceException, UncontainedModuleFileException, ClientContainerException, NotSupportedException, ArchiveWrappedException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientContainer Constructor", _sourceInfo);
        }
        this._ccp = clientContainerParms;
        this._acmd = new ApplicationClientMetaData(this._ccp);
        this._verbose = this._ccp.getVerbose();
        this._props = this._ccp.getProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientContainer Constructor");
        }
    }

    public void init() throws NamingException, ClientContainerException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.initNameSpace();
        this.addEnvEntries();
        this.addEJBEntries();
        this.addResourceEntries();
        this.addResourceEnvRefs();
        this.addMessageDestinationRefs();
        this.addHandleDelegate();
        this.addORB();
        this.addInstalledConnectorsToClassPath();
        this._acmd.setupClassLoader();
        this.createCallbackHandler();
        this.setupForComponents();
        this.initializeComponents();
        this.addServiceRefs();
        this.startComponents();
        this.cleanupForComponents();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    private void addInstalledConnectorsToClassPath() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addInstalledConnectorsToClassPath");
        }
        if ((string = this._ccp.getInstalledConnectors()) != null && string.length() >= 1) {
            File file = new File(string);
            if (!file.exists()) {
                Tr.info(tc, "instConn.notExist", string);
            } else if (!file.isDirectory()) {
                Utility.printWarning(Utility.getMessage("instConn.notDirectory", string));
            } else {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(file, stringArray[i]);
                    if (!file2.isDirectory()) continue;
                    this.addClasspath(file2.getPath());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addInstalledConnectorsToClassPath");
        }
    }

    private String getInstallRoot() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstallRoot");
        }
        if (this._installRoot == null) {
            this._installRoot = System.getProperty("was.install.root", "NOTFOUND");
            this._installRoot = this._installRoot.replace('\\', '/');
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstallRoot", this._installRoot);
        }
        return this._installRoot;
    }

    private String expandVariablesInPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandVariablesInPath");
        }
        String string2 = string.replaceAll("\\$\\{CONNECTOR_INSTALL_ROOT\\}", this._ccp.getInstalledConnectors());
        string2 = string2.replaceAll("\\$\\{WAS_INSTALL_ROOT\\}", this.getInstallRoot());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandVariablesInPath", string2);
        }
        return string2;
    }

    public Class getMainClass() throws IOException, ClassNotFoundException, ZipException, ClientContainerException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMainClass");
        }
        Class clazz = this._acmd.getApplicationMainClass();
        this.enableSecurityManager();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMainClass");
        }
        return clazz;
    }

    public Context getJavaColonContext() {
        return this._javaColonCtx;
    }

    private void initNameSpace() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initNameSpace");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this._jns = javaNameSpace.createJavaNameSpace();
        hashtable.put("com.ibm.ws.naming.java.javanamespace", this._jns);
        hashtable.put("java.naming.factory.initial", "com.ibm.ws.naming.java.javaURLInitialContextFactory");
        if (_jnsa == null) {
            _jnsa = new javaNameSpaceAccessorImpl(this._jns);
            javaURLContextFactoryBase.setAccessor(_jnsa);
        } else {
            _jnsa.setJavaNameSpace(this._jns);
        }
        this._javaColonCtx = new InitialContext(hashtable);
        this._envCtx = (Context)this._javaColonCtx.lookup("comp/env");
        this._compCtx = (Context)this._javaColonCtx.lookup("comp");
        this._np = this._javaColonCtx.getNameParser("java:comp");
        hashtable.clear();
        hashtable.put("java.naming.factory.initial", "com.ibm.websphere.naming.genericURLInitialContextFactory");
        hashtable.put("com.ibm.websphere.naming.generic.url.schemeid", "services");
        hashtable.put("com.ibm.websphere.naming.generic.url.package", "com.ibm.ws.client.applicationclient");
        this._servicesColonCtx = new InitialContext(hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initNameSpace");
        }
    }

    private void addEnvEntries() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEnvEntries");
        }
        EList eList = this._acmd.getEnvironmentProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            try {
                EnvEntry envEntry = (EnvEntry)iterator.next();
                ReferenceName referenceName = new ReferenceName(envEntry.getName(), this._np);
                String[] stringArray = new String[]{envEntry.getName(), envEntry.getType().getName(), envEntry.getValue(), envEntry.getDescription()};
                this.DebugVerbose("ccenv.binding", stringArray);
                this.bind(referenceName, this.createEnvObject(envEntry.getName(), envEntry.getValue(), envEntry.getType().getName()));
                this.DebugVerbose("cc.bindingsuccess", null);
            }
            catch (ClientBindingObjectException clientBindingObjectException) {
                Utility.printWarning(clientBindingObjectException);
            }
            catch (Throwable throwable) {
                Utility.printUnknownException(tc, throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEnvEntries");
        }
    }

    private void addEJBEntries() throws NamingException {
        String[] stringArray;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEJBEntries");
        }
        IndirectJndiLookup indirectJndiLookup = null;
        String string = this.getCorbaURL();
        try {
            EList eList = this._acmd.getEJBReferences();
            object2 = eList.iterator();
            while (object2.hasNext()) {
                try {
                    object = (EjbRefBinding)object2.next();
                    stringArray = object.getBindingEjbRef();
                    if (stringArray.getName() == null) {
                        throw new Exception("ejbName is null for ejbBinding: " + object.getJndiName());
                    }
                    String string2 = new String(stringArray.getName());
                    String[] stringArray2 = new String[]{string2 + " ==> " + object.getJndiName() + " @ " + string, stringArray.getDescription()};
                    this.DebugVerbose("ccejb.binding", stringArray2);
                    ReferenceName referenceName = new ReferenceName(string2, this._np);
                    indirectJndiLookup = new IndirectJndiLookup(object.getJndiName(), this._props.getProperty("applicationclient.ejb." + string2 + ".contextfactory", ""), this._props.getProperty("applicationclient.ejb." + string2 + ".providerurl", string));
                    this.bind(referenceName, indirectJndiLookup);
                    this.DebugVerbose("cc.bindingsuccess", null);
                }
                catch (Throwable throwable) {
                    Utility.printUnknownException(tc, throwable);
                }
            }
        }
        catch (Throwable throwable) {
            Utility.printUnknownException(tc, throwable);
        }
        int n = 1;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ccejb.processingprop");
        }
        if ((object2 = this._props.getProperty("user.services.ejb." + n + ".name", null)) == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "ccejb.noentries");
        }
        while (object2 != null) {
            try {
                indirectJndiLookup = new IndirectJndiLookup(this._props.getProperty("user.services.ejb." + n + ".jndiname", ""), this._props.getProperty("user.services.ejb." + n + ".contextfactory", ""), this._props.getProperty("user.services.ejb." + n + ".providerurl", string));
                object = new ReferenceName((String)object2, this._np);
                stringArray = new String[]{object2, null};
                this.DebugVerbose("ccejb.binding", stringArray);
                this.bind((ReferenceName)object, indirectJndiLookup);
                this.DebugVerbose("cc.bindingsuccess", null);
            }
            catch (Throwable throwable) {
                Utility.printUnknownException(tc, throwable);
            }
            object2 = this._props.getProperty("user.services.ejb." + ++n + ".name", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEJBEntries");
        }
    }

    private void addResourceEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResourceEntries");
        }
        EList eList = this._acmd.getResourceReferences();
        Iterator iterator = eList.iterator();
        ClientContainerResourceRepository clientContainerResourceRepository = null;
        try {
            Object object;
            if (iterator.hasNext()) {
                this.loadResourceBinders();
                clientContainerResourceRepository = this._acmd.getResourceConfigInfo();
                this.addURLStreamHandlers(clientContainerResourceRepository);
            }
            ResourceRef resourceRef = null;
            EList eList2 = this._acmd.getResourceReferenceBindings();
            HashMap<ResourceRef, ResourceRefBinding> hashMap = new HashMap<ResourceRef, ResourceRefBinding>();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                object = (ResourceRefBinding)iterator2.next();
                hashMap.put(object.getBindingResourceRef(), (ResourceRefBinding)object);
            }
            while (iterator.hasNext()) {
                resourceRef = (ResourceRef)iterator.next();
                object = null;
                ResourceRefBinding resourceRefBinding = (ResourceRefBinding)hashMap.get(resourceRef);
                if (resourceRefBinding != null) {
                    object = resourceRefBinding.getJndiName();
                }
                this.processResource(resourceRef.getName(), (String)object, resourceRef.getType(), resourceRef.getDescription(), "ccres.binding", resourceRef);
            }
        }
        catch (Throwable throwable) {
            Utility.printUnknownException(tc, throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResourceEntries");
        }
    }

    private boolean isJndiNameSpecified(String string) {
        return string != null && !string.equals("");
    }

    private void processResourceNotLocal(String string, String string2, String string3, String string4, String string5) {
        if (this.isJndiNameSpecified(string2)) {
            this.makeIndirectRef(string, string2, string3, string4, string5);
        } else {
            FactoryNotFoundException factoryNotFoundException = new FactoryNotFoundException("ccrct.noconfig", string, tc, "");
            String[] stringArray = new String[]{string};
            this.DebugVerbose("cc.resourcewarning", stringArray);
            Utility.printWarning(factoryNotFoundException);
        }
    }

    private void processResource(String string, String string2, String string3, String string4, String string5, ResourceRef resourceRef) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processResource");
        }
        if (!(bl = this.makeLocalObjectRef(string, string, string3, string4, string5, resourceRef))) {
            this.processResourceNotLocal(string, string2, string3, string4, string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processResource");
        }
    }

    private void processMessageDestinationRef(String string, String string2, String string3, String string4, String string5, MessageDestinationRef messageDestinationRef) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processMessageDestinationRef", messageDestinationRef);
        }
        String string6 = messageDestinationRef.getLink();
        String string7 = string;
        if (string6 != null && string6.length() > 0) {
            string7 = string6;
        }
        if (!(bl = this.makeLocalObjectRef(string7, string, string3, string4, string5, null))) {
            this.processResourceNotLocal(string, string2, string3, string4, string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processMessageDestinationRef");
        }
    }

    private void makeIndirectRef(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeIndirectRef", new Object[]{string, string2, string3, string4, string5});
        }
        try {
            ClientContainerResourceRepository clientContainerResourceRepository = this._acmd.getResourceConfigInfo();
            IndirectJndiLookup indirectJndiLookup = null;
            String string6 = this.getCorbaURL();
            String[] stringArray = new String[]{string + " ==> " + string2 + " @ " + string6, string3, string4};
            this.DebugVerbose(string5, stringArray);
            ReferenceName referenceName = new ReferenceName(string, this._np);
            try {
                J2EEResourceFactory j2EEResourceFactory = clientContainerResourceRepository.findFactory(string);
                if (j2EEResourceFactory != null) {
                    String string7 = this.getClasspath(Utility.getProviderClasspath(j2EEResourceFactory.getProvider().getClasspath()));
                    this.addClasspath(string7);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            indirectJndiLookup = new IndirectJndiLookup(string2, "", string6);
            this.bind(referenceName, indirectJndiLookup);
            this.DebugVerbose("cc.bindingsuccess", null);
        }
        catch (Throwable throwable) {
            Utility.printUnknownException(tc, throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeIndirectRef");
        }
    }

    private ClientResourceBinder getResourceBinder(String string, J2EEResourceProvider j2EEResourceProvider) {
        ClientResourceBinder clientResourceBinder = null;
        clientResourceBinder = j2EEResourceProvider instanceof J2CResourceAdapter ? new ClientJ2CResourceBinder() : (ClientResourceBinder)this._resourceBinders.get(string);
        return clientResourceBinder;
    }

    private boolean makeLocalObjectRef(String string, String string2, String string3, String string4, String string5, ResourceRef resourceRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeLocalObjectRef", new Object[]{string, string2, string3, string4, string5, resourceRef});
        }
        boolean bl = true;
        ClientResourceBinder clientResourceBinder = null;
        try {
            ClientContainerResourceRepository clientContainerResourceRepository = this._acmd.getResourceConfigInfo();
            J2EEResourceFactory j2EEResourceFactory = clientContainerResourceRepository.findFactory(string);
            J2EEResourceProvider j2EEResourceProvider = null;
            Object[] objectArray = null;
            if (j2EEResourceFactory != null) {
                j2EEResourceProvider = j2EEResourceFactory.getProvider();
            } else {
                if (resourceRef == null) {
                    objectArray = clientContainerResourceRepository.findAdminObject(string);
                }
                if (objectArray == null) {
                    bl = false;
                } else {
                    j2EEResourceProvider = (J2EEResourceProvider)objectArray[1];
                }
            }
            if (bl) {
                clientResourceBinder = this.getResourceBinder(string3, j2EEResourceProvider);
                if (clientResourceBinder == null) {
                    String[] stringArray = new String[]{string2, string3, this.supportedResourceTypes()};
                    throw new ClientBindingObjectException("cc.nobinder", stringArray, tc);
                }
                String[] stringArray = new String[]{string2, string3, string4};
                this.DebugVerbose(string5, stringArray);
                ReferenceName referenceName = new ReferenceName(string2, this._np);
                String string6 = Utility.getProviderClasspath(j2EEResourceProvider.getClasspath());
                string6 = this.expandVariablesInPath(string6);
                String string7 = this.getClasspath(string6);
                String string8 = Utility.getProviderClasspath(j2EEResourceProvider.getNativepath());
                string7 = Utility.appendClasspathStrings(string7, string8);
                clientResourceBinder.setRepository(clientContainerResourceRepository);
                Object object = null;
                object = resourceRef == null ? (j2EEResourceFactory != null ? ((ClientJMSDestinationResourceBinder)clientResourceBinder).getBindingObject(j2EEResourceFactory, string7, string3) : ((ClientJ2CResourceBinder)clientResourceBinder).getBindingObject((J2CAdminObject)objectArray[0], string7, string3)) : clientResourceBinder.getBindingObject(j2EEResourceFactory, string7, resourceRef);
                this.bind(referenceName, object);
                List list = this.addClasspath(Utility.appendClasspathStrings(string7, clientResourceBinder.getClasspath()), true);
                if (list != null && !list.isEmpty()) {
                    Utility.printWarning(Utility.getMessage("resource.badClassPath", list.toString()));
                }
                this.printVerbose(clientResourceBinder.verboseOutput());
                this.DebugVerbose("cc.bindingsuccess", null);
            }
        }
        catch (ClientBindingObjectUnknownException clientBindingObjectUnknownException) {
            if (clientResourceBinder != null) {
                this.printVerbose(clientResourceBinder.verboseOutput());
            }
            Utility.printWarning(Utility.getMessage("cc.resourcewarning", string2));
            Utility.printWarning(clientBindingObjectUnknownException);
            Utility.printUnknownException(clientBindingObjectUnknownException.getThrowable());
        }
        catch (ClientBindingObjectException clientBindingObjectException) {
            if (clientResourceBinder != null) {
                this.printVerbose(clientResourceBinder.verboseOutput());
            }
            String[] stringArray = new String[]{string2};
            this.DebugVerbose("cc.resourcewarning", stringArray);
            Utility.printWarning(clientBindingObjectException);
        }
        catch (Throwable throwable) {
            if (clientResourceBinder != null) {
                this.printVerbose(clientResourceBinder.verboseOutput());
            }
            Utility.printUnknownException(tc, throwable);
        }
        if (clientResourceBinder != null) {
            clientResourceBinder.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeLocalObjectRef", "isObjectFound = " + bl);
        }
        return bl;
    }

    private void addResourceEnvRefs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResourceEnvRefs");
        }
        try {
            ResourceEnvRefBinding resourceEnvRefBinding;
            EList eList = this._acmd.getResourceEnvReferences();
            Iterator iterator = eList.iterator();
            EList eList2 = this._acmd.getResourceEnvReferenceBindings();
            HashMap<ResourceEnvRef, ResourceEnvRefBinding> hashMap = new HashMap<ResourceEnvRef, ResourceEnvRefBinding>();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                resourceEnvRefBinding = (ResourceEnvRefBinding)iterator2.next();
                hashMap.put(resourceEnvRefBinding.getBindingResourceEnvRef(), resourceEnvRefBinding);
            }
            while (iterator.hasNext()) {
                try {
                    resourceEnvRefBinding = (ResourceEnvRef)iterator.next();
                    String string = null;
                    ResourceEnvRefBinding resourceEnvRefBinding2 = (ResourceEnvRefBinding)hashMap.get(resourceEnvRefBinding);
                    if (resourceEnvRefBinding2 != null) {
                        string = resourceEnvRefBinding2.getJndiName();
                    }
                    this.processResource(resourceEnvRefBinding.getName(), string, resourceEnvRefBinding.getTypeName(), resourceEnvRefBinding.getDescription(), "ccresenv.binding", null);
                }
                catch (Throwable throwable) {
                    Utility.printUnknownException(tc, throwable);
                }
            }
        }
        catch (Throwable throwable) {
            Utility.printUnknownException(tc, throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResourceEnvRefs");
        }
    }

    private void addMessageDestinationRefs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMessageDestinationRefs");
        }
        try {
            MessageDestinationRefBinding messageDestinationRefBinding;
            EList eList = this._acmd.getMessageDestinationReferences();
            Iterator iterator = eList.iterator();
            EList eList2 = this._acmd.getMessageDestinationReferenceBindings();
            HashMap<MessageDestinationRef, MessageDestinationRefBinding> hashMap = new HashMap<MessageDestinationRef, MessageDestinationRefBinding>();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                messageDestinationRefBinding = (MessageDestinationRefBinding)iterator2.next();
                hashMap.put(messageDestinationRefBinding.getBindingMessageDestinationRef(), messageDestinationRefBinding);
            }
            while (iterator.hasNext()) {
                try {
                    messageDestinationRefBinding = (MessageDestinationRef)iterator.next();
                    String string = null;
                    MessageDestinationRefBinding messageDestinationRefBinding2 = (MessageDestinationRefBinding)hashMap.get(messageDestinationRefBinding);
                    if (messageDestinationRefBinding2 != null) {
                        string = messageDestinationRefBinding2.getJndiName();
                    }
                    EList eList3 = messageDestinationRefBinding.getDescriptions();
                    String string2 = null;
                    if (eList3 != null && eList3.size() > 0) {
                        string2 = ((Description)eList3.get(0)).getValue();
                    }
                    this.processMessageDestinationRef(messageDestinationRefBinding.getName(), string, messageDestinationRefBinding.getType(), string2, "ccmsgdst.binding", (MessageDestinationRef)messageDestinationRefBinding);
                }
                catch (Throwable throwable) {
                    Utility.printUnknownException(tc, throwable);
                }
            }
        }
        catch (Throwable throwable) {
            Utility.printUnknownException(tc, throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMessageDestinationRefs");
        }
    }

    private void cleanupForComponents() {
        this._CComp = null;
    }

    private void setupForComponents() throws ClientContainerException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupForComponents");
        }
        try {
            ComponentManager componentManager = ComponentManagerFactory.createComponentManager("META-INF/ws-client-components.xml", Thread.currentThread().getContextClassLoader());
            try {
                WsServiceRegistry.addService((Object)componentManager, (Class)ComponentManager.class);
            }
            catch (Exception exception) {
                throw new ClientContainerException(exception);
            }
        }
        catch (ConfigurationError configurationError) {
            throw new ClientContainerException(configurationError);
        }
        ClientProcessService clientProcessService = new ClientProcessService();
        clientProcessService.setJavaColonCtx(this._javaColonCtx);
        clientProcessService.setServicesColonCtx(this._servicesColonCtx);
        clientProcessService.setClientContainerParms(this._ccp);
        clientProcessService.setEarFile(this._acmd.getEarFile());
        clientProcessService.setClientFile(this._acmd.getClientFile());
        clientProcessService.setJ2EEName(this._acmd.getJ2EEName());
        try {
            WsServiceRegistry.addService((Object)clientProcessService, (Class)ClientProcessService.class);
        }
        catch (Exception exception) {
            throw new ClientContainerException(exception);
        }
        ClientComponentInitImpl clientComponentInitImpl = new ClientComponentInitImpl(this._ccp);
        this._CComp = clientComponentInitImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupForComponents");
        }
    }

    private void initializeComponents() throws ClientContainerException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeComponents");
        }
        try {
            this.DebugVerbose("cccomp.init", null);
            this._CComp.initialize(null);
        }
        catch (ConfigurationWarning configurationWarning) {
            Utility.printWarning(Utility.getMessage("cccomp.error"));
            Utility.printUnknownException(tc, configurationWarning);
        }
        catch (ConfigurationError configurationError) {
            throw new ClientContainerException(configurationError);
        }
        catch (ComponentDisabledException componentDisabledException) {
            Utility.printWarning(Utility.getMessage("cccomp.error"));
            Utility.printUnknownException(tc, componentDisabledException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeComponents");
        }
    }

    private void startComponents() throws ClientContainerException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startComponents");
        }
        try {
            this._CComp.start();
            if (((ClientComponentInitImpl)this._CComp).isSuccess()) {
                this.DebugVerbose("cccomp.success", null);
            } else {
                this.DebugVerbose("cccomp.fail", null);
            }
        }
        catch (RuntimeWarning runtimeWarning) {
            Utility.printWarning(Utility.getMessage("cccomp.error"));
            Utility.printUnknownException(tc, runtimeWarning);
        }
        catch (RuntimeError runtimeError) {
            throw new ClientContainerException(runtimeError);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startComponents");
        }
    }

    private Object createEnvObject(String string, String string2, String string3) throws ClientBindingObjectException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEnvObject");
        }
        try {
            if (string3.endsWith("Boolean")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new Boolean(string2);
            }
            if (string3.endsWith("Byte")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new Byte(string2);
            }
            if (string3.endsWith("Double")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new Double(string2);
            }
            if (string3.endsWith("Float")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new Float(string2);
            }
            if (string3.endsWith("Integer")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new Integer(string2);
            }
            if (string3.endsWith("Long")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new Long(string2);
            }
            if (string3.endsWith("Short")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new Short(string2);
            }
            if (string3.endsWith("String")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new String(string2);
            }
            if (string3.endsWith("Character")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createEnvObject");
                }
                return new Character(string2.charAt(0));
            }
        }
        catch (Throwable throwable) {
            String[] stringArray = new String[]{string, string2, string3};
            throw new ClientBindingObjectException("ccenv.invalidval", stringArray, tc, "createEnvObject");
        }
        String[] stringArray = new String[]{string, string3};
        throw new ClientBindingObjectException("ccenv.invalidtype", stringArray, tc, "createEnvObject");
    }

    private void addServiceRefs() throws ClientContainerException {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServiceRefs");
        }
        if ((eList = this._acmd.getServiceRefs()) != null && !eList.isEmpty()) {
            try {
                WASWebServicesBind.bindServiceRef(this._acmd.getJ2EEName(), null, null, this._envCtx, (List)eList);
            }
            catch (WASWebServicesBindException wASWebServicesBindException) {
                Utility.printUnknownException(tc, wASWebServicesBindException);
                throw new ClientContainerException(wASWebServicesBindException);
            }
            catch (RuntimeError runtimeError) {
                Throwable throwable = runtimeError.getCause() == null ? runtimeError : runtimeError.getCause();
                Utility.printUnknownException(tc, throwable);
                throw new ClientContainerException(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServiceRefs");
        }
    }

    private void bind(ReferenceName referenceName, Object object) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind");
        }
        Context context = this.getContext(referenceName.getPath());
        context.bind(referenceName.getBaseName(), object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bind");
        }
    }

    private Context getContext(Enumeration enumeration) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContext");
        }
        Context context = this._envCtx;
        Context context2 = this._envCtx;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            context = context2 = this.createSubContexts(string, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContext");
        }
        return context2;
    }

    private Context createSubContexts(String string, Context context) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubContexts");
        }
        Context context2 = null;
        try {
            context2 = context.createSubcontext(string);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            context2 = (Context)context.lookup(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubContexts");
        }
        return context2;
    }

    private void loadResourceBinders() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadResourceBinders");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ccres.loadingdefaultbinders");
        }
        ClientResourceBinderImpl clientResourceBinderImpl = new ClientMailResourceBinder();
        this._resourceBinders.put(clientResourceBinderImpl.usedFor(), clientResourceBinderImpl);
        clientResourceBinderImpl = new ClientDataSourceResourceBinder();
        this._resourceBinders.put(clientResourceBinderImpl.usedFor(), clientResourceBinderImpl);
        clientResourceBinderImpl = new ClientURLResourceBinder();
        this._resourceBinders.put(clientResourceBinderImpl.usedFor(), clientResourceBinderImpl);
        clientResourceBinderImpl = new ClientJMSQueueResourceBinder();
        this._resourceBinders.put(clientResourceBinderImpl.usedFor(), clientResourceBinderImpl);
        clientResourceBinderImpl = new ClientJMSTopicResourceBinder();
        this._resourceBinders.put(clientResourceBinderImpl.usedFor(), clientResourceBinderImpl);
        clientResourceBinderImpl = new ClientJMSQueueConnectionResourceBinder(this._ccp);
        this._resourceBinders.put(clientResourceBinderImpl.usedFor(), clientResourceBinderImpl);
        clientResourceBinderImpl = new ClientJMSTopicConnectionResourceBinder(this._ccp);
        this._resourceBinders.put(clientResourceBinderImpl.usedFor(), clientResourceBinderImpl);
        clientResourceBinderImpl = new ClientJMSConnectionResourceBinder(this._ccp);
        this._resourceBinders.put(clientResourceBinderImpl.usedFor(), clientResourceBinderImpl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ccres.bindersuccess");
        }
        int n = 1;
        String string = this._props.getProperty("com.ibm.websphere.client.applicationclient.resource.binder." + n + ".class", null);
        if (string == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "ccres.nobinders");
        }
        while (string != null) {
            try {
                String[] stringArray = new String[]{string};
                this.DebugVerbose("ccres.addingbinder", stringArray);
                Class<?> clazz = Class.forName(string);
                ClientResourceBinder clientResourceBinder = (ClientResourceBinder)clazz.newInstance();
                this._resourceBinders.put(this._props.getProperty("com.ibm.websphere.client.applicationclient.resource.binder." + n + ".type", null), clientResourceBinder);
                string = this._props.getProperty("com.ibm.websphere.client.applicationclient.resource.binder." + ++n + ".class", null);
                this.DebugVerbose("ccres.bindersuccess", null);
            }
            catch (Throwable throwable) {
                string = this._props.getProperty("com.ibm.websphere.client.applicationclient.resource.binder." + ++n + ".class", null);
                Utility.printUnknownException(tc, throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadResourceBinders");
        }
    }

    private String supportedResourceTypes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportedResourceTypes");
        }
        Enumeration enumeration = this._resourceBinders.keys();
        String string = (String)enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            string = string + ", " + enumeration.nextElement();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportedResourceTypes");
        }
        return string;
    }

    private String getClasspath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClasspath");
        }
        String string2 = null;
        if (!ArchiveUtil.isNullOrEmpty((String)string)) {
            string2 = string;
        }
        if (!ArchiveUtil.isNullOrEmpty((String)this._ccp.getClassPathArg())) {
            string2 = ArchiveUtil.isNullOrEmpty((String)string2) ? this._ccp.getClassPathArg() : string2 + File.pathSeparator + this._ccp.getClassPathArg();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClasspath");
        }
        return string2;
    }

    private void addClasspath(String string) {
        this.addClasspath(string, false);
    }

    private List addClasspath(String string, boolean bl) {
        List list = null;
        String[] stringArray = new String[]{string};
        this.DebugVerbose("ccres.classpath", stringArray);
        if (!ArchiveUtil.isNullOrEmpty((String)string)) {
            list = this._acmd.addResourceReferenceToClassPath(string, bl);
        }
        return list;
    }

    private void addURLStreamHandlers(ClientContainerResourceRepository clientContainerResourceRepository) {
        List list = clientContainerResourceRepository.getProviders(8);
        Iterator iterator = list.iterator();
        try {
            RuntimeClasspathEntry[] runtimeClasspathEntryArray;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ExtClassLoader extClassLoader = null;
            if (iterator.hasNext()) {
                if (classLoader instanceof ExtClassLoader) {
                    extClassLoader = (ExtClassLoader)classLoader;
                } else {
                    extClassLoader = new ExtClassLoader(classLoader);
                    Thread.currentThread().setContextClassLoader((ClassLoader)extClassLoader);
                }
                runtimeClasspathEntryArray = this._acmd.getClientFile().getFullRuntimeClassPath();
                for (int i = 0; i < runtimeClasspathEntryArray.length; ++i) {
                    extClassLoader.addPath(runtimeClasspathEntryArray[i].getAbsolutePath());
                }
            }
            while (iterator.hasNext()) {
                runtimeClasspathEntryArray = (RuntimeClasspathEntry[])iterator.next();
                if (runtimeClasspathEntryArray.getProtocol() == null || runtimeClasspathEntryArray.getProtocol().trim().length() <= 0) continue;
                extClassLoader.addPath(Utility.getProviderClasspath(runtimeClasspathEntryArray.getClasspath()));
                if (!StreamHandlerUtils.queryHandler()) {
                    StreamHandlerUtils.createStreamHandler();
                }
                StreamHandlerUtils.addProvider((URLProvider)runtimeClasspathEntryArray, Utility.getProviderClasspath(runtimeClasspathEntryArray.getClasspath()));
            }
        }
        catch (Throwable throwable) {
            Utility.printUnknownException(tc, throwable);
        }
    }

    private void createCallbackHandler() {
        block8: {
            String string;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCallbackHandler");
            }
            if ((string = this._acmd.getCallbackHandler()) != null) {
                String[] stringArray = new String[]{string};
                this.DebugVerbose("ccsec.callbackinfo", stringArray);
                Thread thread = Thread.currentThread();
                ClassLoader classLoader = thread.getContextClassLoader();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Class<?> clazz2 = classLoader.loadClass("javax.security.auth.callback.CallbackHandler");
                    Constructor<?> constructor = clazz.getDeclaredConstructor(null);
                    constructor.setAccessible(true);
                    Object obj = constructor.newInstance(null);
                    if (clazz2.isInstance(obj)) {
                        SecurityCallbackHandlerAccessor.setCallbackHandler((CallbackHandler)obj);
                        this.DebugVerbose("ccsec.callbacksuccess", null);
                        break block8;
                    }
                    String[] stringArray2 = new String[]{obj.getClass().getName(), clazz2.getName()};
                    Utility.printWarning(tc, Utility.getMessage("ccsec.callbackconverterror", stringArray2));
                }
                catch (Throwable throwable) {
                    this.DebugVerbose("ccsec.callbackfailed", null);
                    Utility.printUnknownException(tc, throwable);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No callback handler defined.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCallbackHandler");
        }
    }

    private void enableSecurityManager() throws ClientContainerException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enableSecurityManager");
        }
        if (System.getSecurityManager() != null) {
            Tr.debug(tc, "-CCSecurityManager flag is enabled");
            Policy.getPolicy().refresh();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "-CCSecurityManager flag is disabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enableSecurityManager");
        }
    }

    private void addHandleDelegate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addHandleDelegate");
        }
        this.DebugVerbose("cchdl.binding", null);
        try {
            this._compCtx.bind("HandleDelegate", (Object)new Reference("java.lang.Object", HandleDelegateFactory.class.getName(), null));
            this.DebugVerbose("cc.bindingsuccess", null);
        }
        catch (Throwable throwable) {
            Utility.printWarning(tc, Utility.getMessage("cchdl.bindingfailed"));
            Utility.printUnknownException(tc, throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addHandleDelegate");
        }
    }

    private void addORB() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addORB");
        }
        try {
            this._compCtx.bind("ORB", (Object)ClientORBFactory.getORBReference());
        }
        catch (Throwable throwable) {
            Utility.printUnknownException(tc, throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addORB");
        }
    }

    private void DebugVerbose(String string, String[] stringArray) {
        Utility.DebugVerbose(tc, string, stringArray, this._verbose);
    }

    private void printVerbose(String string) {
        Utility.printVerbose(string, this._verbose);
    }

    private String getCorbaURL() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCorbaURL");
        }
        if (this.iCorbaURL == null) {
            this.iCorbaURL = Utility.buildCorbaURL(this._ccp.getBootstrapHost(), this._ccp.getBootstrapPort(), this._ccp.getProviderURL());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCorbaURL", this.iCorbaURL);
        }
        return this.iCorbaURL;
    }

    static {
        try {
            ClientJMSClientInit.setForceAllowClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

