/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.applicationclient;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientHelpException;
import com.ibm.ws.client.applicationclient.Utility;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ClientContainerParms {
    private static final TraceComponent tc = Tr.register(ClientContainerParms.class, null, "com.ibm.ws.client.applicationclient.ResourceBundle");
    private static final String _sourceInfo = "SERV1/ws/code/client/src/com/ibm/ws/client/applicationclient/ClientContainerParms.java, WAS.client, WAS61.SERV1, cf311012.09, ver. 1.44";
    static final String CC_ARG_PREFIX = "-CC";
    static final int CC_ARG_PREFIX_LENGTH = "-CC".length();
    static final String CC_ARG_JARFILE = "jar";
    static final String CC_ARG_VERBOSE = "verbose";
    static final String CC_ARG_PROPFILE = "propfile";
    static final String CC_ARG_MAINCLASS = "mainclass";
    static final String CC_ARG_INITONLY = "initonly";
    static final String CC_ARG_CLASSPATH = "classpath";
    static final String CC_ARG_VERSION = "version";
    static final String CC_ARG_ENABLETRACE = "trace";
    static final String CC_ARG_TRACEFILE = "tracefile";
    static final String CC_ARG_BOOTHOST = "BootstrapHost";
    static final String CC_ARG_BOOTPORT = "BootstrapPort";
    static final String CC_ARG_URLCACHE = "PreloadCacheJavaURL";
    static final String CC_ARG_TREECACHE = "PreloadCacheNameTree";
    static final String CC_ARG_PRELOADFILE = "JNDIPreloadconfigFile";
    static final String CC_ARG_SECURITYMANAGER = "securityManager";
    static final String CC_ARG_SECURITYMANAGERCLASS = "securityMgrClass";
    static final String CC_ARG_SECURITYMANAGERPOLICYFILE = "securityMgrPolicy";
    static final String CC_ARG_EXITVM = "exitVM";
    static final String CC_ARG_ALTDD = "altDD";
    static final String CC_ARG_TRACEMODE = "traceMode";
    static final String CC_ARG_D = "D";
    static final String CC_ARG_SOAPCONNECTORPORT = "soapConnectorPort";
    static final String CC_ARG_ADMINCONNECTORTYPE = "adminConnectorType";
    static final String CC_ARG_ADMINCONNECTORHOST = "adminConnectorHost";
    static final String CC_ARG_ADMINCONNECTORPORT = "adminConnectorPort";
    static final String CC_ARG_ADMINCONNECTORUSER = "adminConnectorUser";
    static final String CC_ARG_ADMINCONNECTORPASSWORD = "adminConnectorPassword";
    static final String CC_ARG_PROVIDERURL = "providerURL";
    static final String CC_ARG_DUMPJAVANAMESPACE = "dumpJavaNameSpace";
    static final String CC_ARG_DELETEFILERETRYCOUNT = "deleteFileRetryCount";
    static final String CC_ARG_CLASSLOADER_MODE = "classLoaderMode";
    static final String CC_ARG_CLASSLOADER_MODE_PARENT_LAST = "PARENT_LAST";
    static final String WS_ARG_BOOTHOST = "com.ibm.CORBA.BootstrapHost";
    static final String WS_ARG_BOOTPORT = "com.ibm.CORBA.BootstrapPort";
    static final String WS_ARG_PROVIDERURL = "java.naming.provider.url";
    static final String WS_ARG_TRACESTRING = "traceString";
    static final String WS_ARG_TRACEFILE = "traceFile";
    static final String WS_TRACE_ALL = "com.*=all=enabled";
    static final String WS_TRACE_NONE = "com.*=all=disabled";
    static final String WS_ARG_PRELOADFILE = "com.ibm.websphere.naming.JNDIPreload.configFile";
    static final String JAVA_ARG_POLICYFILE = "java.security.policy";
    static final String EXITVM_PROP = "com.ibm.websphere.client.exitVM";
    static final String DEFAULT_SECURITYMANAGER = "disable";
    static final String DEFAULT_SECURITYMANAGER_CLASS = "java.lang.SecurityManager";
    static final String DEFAULT_SECURITYMANAGER_POLICYFILE = System.getProperty("user.install.root", System.getProperty("was.install.root", null)) + "/properties/client.policy";
    public static final String CLIENT_INSTALLED_CONNECTORS = "com.ibm.ws.client.installedConnectors";
    static final String USE_LOCAL_SERVER_VALUE = "SERVER";
    private String installedConnectorsValue = null;
    private static final String[] DEPRECATED_PARAMETERS_ARRAY = new String[]{"PreloadCacheJavaURL", "PreloadCacheNameTree", "JNDIPreloadconfigFile"};
    private static final List DEPRECATED_PARAMETERS = Arrays.asList(DEPRECATED_PARAMETERS_ARRAY);
    private static final String[] VALID_PARAMETERS_ARRAY = new String[]{"jar", "verbose", "propfile", "mainclass", "initonly", "classpath", "BootstrapHost", "BootstrapPort", "trace", "tracefile", "version", "securityManager", "securityMgrClass", "securityMgrPolicy", "exitVM", "traceMode", "providerURL", "dumpJavaNameSpace", "altDD", "deleteFileRetryCount", "adminConnectorType", "adminConnectorHost", "adminConnectorPort", "adminConnectorUser", "adminConnectorPassword", "soapConnectorPort", "classLoaderMode"};
    private static final List VALID_PARAMETERS = Arrays.asList(VALID_PARAMETERS_ARRAY);
    String _fileToLaunch = null;
    Properties _CCproperties = null;
    String[] _userAppArgs = null;

    public ClientContainerParms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientContainerParms", _sourceInfo);
            Tr.exit(tc, "ClientContainerParms");
        }
    }

    public void parseCommandLineArgs(String[] stringArray) throws IllegalArgumentException, ClientHelpException, FileNotFoundException, IOException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseCommandLineArgs");
        }
        if (stringArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ccparms.invalidparm");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parseCommandLineArgs");
            }
            throw new ClientHelpException();
        }
        Vector<String> vector = new Vector<String>();
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i].trim();
            if (this._fileToLaunch == null) {
                if (string.equals("-help") || string.equals("-?")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "parseCommandLineArgs");
                    }
                    throw new ClientHelpException();
                }
                if (string.equals("-JVMOptions")) {
                    Tr.debug(tc, "-JVMOptions string: " + stringArray[++i].trim());
                    continue;
                }
                if (string.equals("-profileName")) {
                    Tr.exit(tc, "-profileName string: " + stringArray[++i].trim());
                    continue;
                }
                this._fileToLaunch = new String(string);
                continue;
            }
            if (string.startsWith(CC_ARG_PREFIX)) {
                String string2 = string.substring(CC_ARG_PREFIX_LENGTH);
                int n = string2.indexOf(61);
                if (n == -1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ccparms.invalidparm");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "parseCommandLineArgs");
                    }
                    throw new IllegalArgumentException(Utility.getMessage("ccparms.valuemissing", string));
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (ArchiveUtil.isNullOrEmpty((String)string4)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ccparms.invalidparm");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "parseCommandLineArgs");
                    }
                    throw new IllegalArgumentException(Utility.getMessage("ccparms.valuemissing", string));
                }
                if (DEPRECATED_PARAMETERS.contains(string3)) {
                    Utility.printWarning(tc, Utility.getMessage("ccparms.deprecated", string3));
                    continue;
                }
                if (VALID_PARAMETERS.contains(string3) || string3.startsWith(CC_ARG_D)) {
                    properties.setProperty(string3, string4);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ccparms.invalidparm");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "parseCommandLineArgs");
                }
                throw new IllegalArgumentException(Utility.getMessage("ccparms.invalidCCvalue", string3));
            }
            vector.addElement(string);
        }
        this._userAppArgs = new String[vector.size()];
        vector.copyInto(this._userAppArgs);
        this._CCproperties = new Properties();
        this.getInitialSystemProperties(this._CCproperties);
        Properties properties2 = new Properties();
        string = properties.getProperty(CC_ARG_PROPFILE);
        if (string != null) {
            properties2 = this.loadPropertiesFromFile(string);
            this.mergePropLists(properties2, this._CCproperties);
        }
        this.mergePropLists(properties, this._CCproperties);
        this.updateSystemProperties(this._CCproperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseCommandLineArgs");
        }
    }

    public void setArgs(String string, Properties properties, String[] stringArray) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setArgs");
        }
        this._fileToLaunch = new String(string);
        this._userAppArgs = stringArray;
        if (ArchiveUtil.isNullOrEmpty((String)this._fileToLaunch)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ccparms.missingear");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setArgs");
            }
            throw new IllegalArgumentException(Utility.getMessage("ccparms.missingear"));
        }
        this._CCproperties = new Properties();
        this.getInitialSystemProperties(this._CCproperties);
        this.mergePropLists(properties, this._CCproperties);
        this.updateSystemProperties(this._CCproperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setArgs");
        }
    }

    private void getInitialSystemProperties(Properties properties) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSystemProperties");
        }
        if ((string = System.getProperty(WS_ARG_BOOTHOST)) != null) {
            properties.setProperty(CC_ARG_BOOTHOST, string);
        }
        if ((string = System.getProperty(WS_ARG_BOOTPORT)) != null) {
            properties.setProperty(CC_ARG_BOOTPORT, string);
        }
        if ((string = System.getProperty(WS_ARG_TRACESTRING)) != null) {
            properties.setProperty(CC_ARG_ENABLETRACE, string);
        }
        if ((string = System.getProperty(WS_ARG_TRACEFILE)) != null) {
            properties.setProperty(CC_ARG_TRACEFILE, string);
        }
        if ((string = System.getProperty(WS_ARG_PRELOADFILE)) != null) {
            properties.setProperty(CC_ARG_PRELOADFILE, string);
        }
        if ((string = System.getProperty(JAVA_ARG_POLICYFILE)) != null) {
            properties.setProperty(CC_ARG_SECURITYMANAGERPOLICYFILE, string);
        }
        if ((string = System.getProperty(EXITVM_PROP)) != null) {
            properties.setProperty(CC_ARG_EXITVM, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSystemProperties");
        }
    }

    private void updateSystemProperties(Properties properties) {
        String string;
        String string2;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSystemProperties");
        }
        System.setProperty("com.ibm.ws.container", "client");
        String string4 = System.getProperty("java.naming.factory.initial");
        if (ArchiveUtil.isNullOrEmpty((String)string4)) {
            System.setProperty("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
        }
        if ((string3 = properties.getProperty(CC_ARG_BOOTHOST)) != null) {
            System.setProperty(WS_ARG_BOOTHOST, string3);
        }
        if ((string2 = properties.getProperty(CC_ARG_BOOTPORT)) != null) {
            System.setProperty(WS_ARG_BOOTPORT, string2);
        }
        if ((string = System.getProperty(WS_ARG_PROVIDERURL, null)) != null) {
            if (string3 != null || string2 != null || this.getProviderURL() != null) {
                System.setProperty(WS_ARG_PROVIDERURL, Utility.buildCorbaURL(string3, string2, this.getProviderURL()));
            }
        } else {
            System.setProperty(WS_ARG_PROVIDERURL, Utility.buildCorbaURL(string3, string2, this.getProviderURL()));
        }
        if ((string4 = properties.getProperty(CC_ARG_ENABLETRACE)) != null) {
            if (string4.equalsIgnoreCase("true")) {
                System.setProperty(WS_ARG_TRACESTRING, WS_TRACE_ALL);
            } else if (string4.equalsIgnoreCase("false")) {
                System.setProperty(WS_ARG_TRACESTRING, WS_TRACE_NONE);
            } else {
                System.setProperty(WS_ARG_TRACESTRING, string4);
                properties.setProperty(CC_ARG_ENABLETRACE, "true");
            }
            properties.setProperty(WS_ARG_TRACESTRING, System.getProperty(WS_ARG_TRACESTRING));
        }
        if ((string4 = properties.getProperty(CC_ARG_TRACEFILE)) != null) {
            System.setProperty(WS_ARG_TRACEFILE, string4);
        }
        if ((string4 = properties.getProperty(CC_ARG_PRELOADFILE)) != null) {
            System.setProperty(WS_ARG_PRELOADFILE, string4);
        }
        if ((string4 = properties.getProperty(CC_ARG_SECURITYMANAGERPOLICYFILE)) != null) {
            System.setProperty(JAVA_ARG_POLICYFILE, string4);
        } else if (this.getSecurityManagerFlag()) {
            System.setProperty(JAVA_ARG_POLICYFILE, DEFAULT_SECURITYMANAGER_POLICYFILE);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith(CC_ARG_D)) continue;
            String string6 = properties.getProperty(string5);
            String string7 = string5.substring(1);
            System.setProperty(string7, string6);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Setting system property:" + string7 + "=" + string6);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSystemProperties");
        }
    }

    private Properties loadPropertiesFromFile(String string) throws FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFromFile");
        }
        Properties properties = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        if (fileInputStream != null) {
            properties = new Properties();
            properties.load(fileInputStream);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPropertiesFromFile");
        }
        return properties;
    }

    private void mergePropLists(Properties properties, Properties properties2) {
        if (properties == null) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        Enumeration<Object> enumeration2 = properties.elements();
        while (enumeration.hasMoreElements()) {
            properties2.put((String)enumeration.nextElement(), enumeration2.nextElement());
        }
    }

    public String getFileToLaunch() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileToLaunch");
            Tr.exit(tc, "getFileToLaunch");
        }
        return this._fileToLaunch;
    }

    public boolean getVerbose() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVerbose");
            Tr.exit(tc, "getVerbose");
        }
        return this._CCproperties.getProperty(CC_ARG_VERBOSE, "false").equals("true");
    }

    public boolean getVersionInfoRequested() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersionInfoRequested");
            Tr.exit(tc, "getVersionInfoRequested");
        }
        return this._CCproperties.getProperty(CC_ARG_VERSION, "false").equals("true");
    }

    public String getImbeddedClientJarFileName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getImbeddedClientJarFileName");
            Tr.exit(tc, "getImbeddedClientJarFileName");
        }
        return this._CCproperties.getProperty(CC_ARG_JARFILE);
    }

    public String getPropFileName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropFileName");
            Tr.exit(tc, "getPropFileName");
        }
        return this._CCproperties.getProperty(CC_ARG_PROPFILE);
    }

    public String getMainClass() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMainClass");
            Tr.exit(tc, "getMainClass");
        }
        return this._CCproperties.getProperty(CC_ARG_MAINCLASS);
    }

    public boolean getInitOnlyFlag() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitOnlyFlag");
            Tr.exit(tc, "getInitOnlyFlag");
        }
        return this._CCproperties.getProperty(CC_ARG_INITONLY, "false").equals("true");
    }

    public String getClassPathArg() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassPathArg");
            Tr.exit(tc, "getClassPathArg");
        }
        return this._CCproperties.getProperty(CC_ARG_CLASSPATH);
    }

    public String getBootstrapHost() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBootstrapHost");
            Tr.exit(tc, "getBootstrapHost");
        }
        return this._CCproperties.getProperty(CC_ARG_BOOTHOST);
    }

    public String getBootstrapPort() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBootstrapPort");
            Tr.exit(tc, "getBootstrapPort");
        }
        return this._CCproperties.getProperty(CC_ARG_BOOTPORT);
    }

    public boolean getTraceEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTraceEnabled");
            Tr.exit(tc, "getTraceEnabled");
        }
        return this._CCproperties.getProperty(CC_ARG_ENABLETRACE, "false").equals("true");
    }

    public String getTraceString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTraceString");
            Tr.exit(tc, "getTraceString");
        }
        return this._CCproperties.getProperty(WS_ARG_TRACESTRING);
    }

    public String getTraceFileName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTraceFileName");
            Tr.exit(tc, "getTraceFileName");
        }
        return this._CCproperties.getProperty(CC_ARG_TRACEFILE);
    }

    public boolean getPreloadCacheJavaURLFlag() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreloadCacheJavaURLFlag");
            Tr.exit(tc, "getPreloadCacheJavaURLFlag");
        }
        return this._CCproperties.getProperty(CC_ARG_URLCACHE, "false").equals("true");
    }

    public boolean getPreloadCacheNameTreeFlag() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreloadCacheNameTreeFlag");
            Tr.exit(tc, "getPreloadCacheNameTreeFlag");
        }
        return this._CCproperties.getProperty(CC_ARG_TREECACHE, "false").equals("true");
    }

    public String getJNDIPreloadConfigFileName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJNDIPreloadConfigFileName");
            Tr.exit(tc, "getJNDIPreloadConfigFileName");
        }
        return this._CCproperties.getProperty(CC_ARG_PRELOADFILE);
    }

    public boolean getSecurityManagerFlag() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityManagerFlag");
            Tr.exit(tc, "getSecurityManagerFlag");
        }
        return this._CCproperties.getProperty(CC_ARG_SECURITYMANAGER, DEFAULT_SECURITYMANAGER).equals("enable");
    }

    public String getSecurityManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityManager");
            Tr.exit(tc, "getSecurityManager");
        }
        return this._CCproperties.getProperty(CC_ARG_SECURITYMANAGER, DEFAULT_SECURITYMANAGER);
    }

    public String getSecurityManagerClass() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityManagerClass");
            Tr.exit(tc, "getSecurityManagerClass");
        }
        return this._CCproperties.getProperty(CC_ARG_SECURITYMANAGERCLASS, DEFAULT_SECURITYMANAGER_CLASS);
    }

    public String getSecurityManagerPolicyFile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityManagerPolicyFile");
            Tr.exit(tc, "getSecurityManagerPolicyFile");
        }
        return this._CCproperties.getProperty(CC_ARG_SECURITYMANAGERPOLICYFILE, DEFAULT_SECURITYMANAGER_POLICYFILE);
    }

    public boolean getExitVM() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExitVM");
            Tr.exit(tc, "getExitVM");
        }
        if (this._CCproperties != null) {
            return this._CCproperties.getProperty(CC_ARG_EXITVM, "false").equals("true");
        }
        return false;
    }

    public String getAltDD() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAltDD");
            Tr.exit(tc, "getAltDD");
        }
        return this._CCproperties.getProperty(CC_ARG_ALTDD);
    }

    public String getTraceMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTraceMode");
            Tr.exit(tc, "getTraceMode");
        }
        return this._CCproperties.getProperty(CC_ARG_TRACEMODE);
    }

    public String[] getUserAppArgs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserAppArgs");
            Tr.exit(tc, "getUserAppArgs");
        }
        return this._userAppArgs;
    }

    public Properties getProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
            Tr.exit(tc, "getProperties");
        }
        return this._CCproperties;
    }

    public String getSoapConnectorPort() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSoapConnectorPort");
            Tr.exit(tc, "getSoapConnectorPort");
        }
        return this._CCproperties.getProperty(CC_ARG_SOAPCONNECTORPORT);
    }

    public String getProviderURL() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProviderURL");
        }
        String string = this._CCproperties.getProperty(CC_ARG_PROVIDERURL, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProviderURL", string);
        }
        return string;
    }

    public String getDumpJavaNameSpace() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDumpJavaNameSpace");
        }
        String string = this._CCproperties.getProperty(CC_ARG_DUMPJAVANAMESPACE, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDumpJavaNameSpace", string);
        }
        return string;
    }

    public String getDeleteFileRetryCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, CC_ARG_DELETEFILERETRYCOUNT);
        }
        String string = this._CCproperties.getProperty(CC_ARG_DELETEFILERETRYCOUNT, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, CC_ARG_DELETEFILERETRYCOUNT, string);
        }
        return string;
    }

    public String getAdminConnectorType() {
        return this._CCproperties.getProperty(CC_ARG_ADMINCONNECTORTYPE, null);
    }

    public String getAdminConnectorHost() {
        return this._CCproperties.getProperty(CC_ARG_ADMINCONNECTORHOST, null);
    }

    public String getAdminConnectorPort() {
        return this._CCproperties.getProperty(CC_ARG_ADMINCONNECTORPORT, null);
    }

    public String getAdminConnectorUser() {
        return this._CCproperties.getProperty(CC_ARG_ADMINCONNECTORUSER, null);
    }

    public String getAdminConnectorPassword() {
        return this._CCproperties.getProperty(CC_ARG_ADMINCONNECTORPASSWORD, null);
    }

    public String getInstalledConnectors() {
        if (this.installedConnectorsValue == null) {
            this.installedConnectorsValue = System.getProperty(CLIENT_INSTALLED_CONNECTORS);
            this.installedConnectorsValue = this.installedConnectorsValue == null ? "" : this.installedConnectorsValue.replace('\\', '/');
        }
        return this.installedConnectorsValue;
    }

    public boolean isClassLoaderModePARENT_LAST() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isClassLoaderModePARENT_LAST");
        }
        boolean bl = this._CCproperties.getProperty(CC_ARG_CLASSLOADER_MODE, "").equals(CC_ARG_CLASSLOADER_MODE_PARENT_LAST);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isClassLoaderModePARENT_LAST", new Boolean(bl));
        }
        return bl;
    }
}

