/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.applicationclient;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.client.factory.jdbc.UnsupportedPropertyException;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.ws.client.applicationclient.ClientFactory;
import com.ibm.ws.client.applicationclient.Utility;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class ClientJMSFactory
extends ClientFactory
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(ClientJMSFactory.class, null, "com.ibm.ws.client.applicationclient.ResourceBundle");
    private static final Class[] setterParamList = new Class[]{String.class};
    public static final String JMS_CLASSNAME = "com.ibm.ws.client.classname";
    public static final String JMS_CLASSPATH = "com.ibm.ws.client.classpath";
    public static final String CHANNEL = "WAS.JMS.SVRCONN";
    public static final String BROKER_PUB_Q = "SYSTEM.BROKER.DEFAULT.STREAM";
    public static final String QUEUE_NAME_PREFIX = "WQ_";
    public static final String CELL_NAME = "%cellName%";
    public static final Integer QUEUED_PORT = new Integer(5558);
    public static final Integer DIRECT_PORT = new Integer(5559);
    public static final String DEFAULT_SOAP_PORT = new String("8880");
    public static final String DEFAULT_RMI_PORT = new String("2809");
    public static final String ADMIN_CONNECTOR_TYPE_PROP = "appclient.adminConnectorType";
    public static final String ADMIN_CONNECTOR_HOST_PROP = "appclient.adminConnectorHost";
    public static final String ADMIN_CONNECTOR_PORT_PROP = "appclient.adminConnectorPort";
    public static final String ADMIN_CONNECTOR_USER_PROP = "appclient.adminConnectorUser";
    public static final String ADMIN_CONNECTOR_PASSWORD_PROP = "appclient.adminConnectorPassword";
    private static final int WAS_QUEUED_PORT_TYPE = 0;
    private static final int WAS_DIRECT_PORT_TYPE = 1;

    public static Reference getJMSReference(Properties properties, String string) {
        return ClientJMSFactory.getReference(properties, string, ClientJMSFactory.class.getName());
    }

    public static Integer getBrokerVersion_V1() {
        return new Integer(0);
    }

    public static Integer getBrokerVersion_V2() {
        return new Integer(1);
    }

    public static Integer getWASBrokerVersion() {
        return ClientJMSFactory.getBrokerVersion_V2();
    }

    public static Integer getTransportClient() {
        return new Integer(1);
    }

    public static Integer getTransportDirect() {
        return new Integer(2);
    }

    public static int getNormalIntegerEncoding() {
        return 1;
    }

    public static int getReversedIntegerEncoding() {
        return 2;
    }

    public static int getNormalDecimalEncoding() {
        return 16;
    }

    public static int getReversedDecimalEncoding() {
        return 32;
    }

    public static int getIEEENormalFloatEncoding() {
        return 256;
    }

    public static int getIEEEReversedFloatEncoding() {
        return 512;
    }

    public static int getS390FloatEncoding() {
        return 768;
    }

    public static int getNativeEncoding() {
        return 273;
    }

    private void setSSLCertStoresProperty(Object object, String string) throws UnsupportedPropertyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSSLCertStoresProperty");
        }
        Class[] classArray = new Class[]{String.class};
        Object[] objectArray = new Object[]{string};
        Class<?> clazz = object.getClass();
        try {
            Method method2 = clazz.getMethod("setSSLCertStores", classArray);
            method2.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            String[] stringArray = new String[]{"SSLCertStores", clazz.toString(), illegalAccessException.getMessage()};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmsfac.illegalaccessProperty", stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSSLCertStoresProperty");
            }
            throw new UnsupportedPropertyException(Utility.getMessage("jmsfac.illegalaccessProperty", stringArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String[] stringArray = new String[]{"SSLCertStores", clazz.toString()};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmsfac.missingsettermethod", stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSSLCertStoresProperty");
            }
            throw new UnsupportedPropertyException(Utility.getMessage("jmsfac.missingsettermethod", stringArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            String[] stringArray = new String[]{"SSLCertStores", clazz.toString(), invocationTargetException.getTargetException().getMessage()};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmsfac.invocationerror", stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSSLCertStoresProperty");
            }
            throw new UnsupportedPropertyException(Utility.getMessage("jmsfac.invocationerror", stringArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSSLCertStoresProperty");
        }
    }

    protected void processProperty(String string, Properties properties, Object object, PropertyDescriptor[] propertyDescriptorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processProperty");
        }
        try {
            CharSequence charSequence;
            String string2;
            String string3;
            if ((string.equalsIgnoreCase("queueManager") || string.equalsIgnoreCase("baseQueueManagerName") || string.equalsIgnoreCase("brokerQueueManager")) && properties.getProperty(string).indexOf(CELL_NAME) != -1) {
                string3 = ClientJMSFactory.getCellName();
                string2 = properties.getProperty(string);
                int n = string2.indexOf(CELL_NAME);
                charSequence = new StringBuffer(properties.getProperty(string));
                ((StringBuffer)charSequence).replace(n, n += CELL_NAME.length(), string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting {0} to {1}", new Object[]{string, charSequence});
                }
                properties.setProperty(string, ((StringBuffer)charSequence).toString());
            }
            if (string.equalsIgnoreCase("port")) {
                string3 = "0";
                string2 = properties.getProperty(string);
                if (string2.equals("DIRECT") || string2.equals("QUEUED")) {
                    try {
                        AdminClient adminClient = AdminClientFactory.createAdminClient(ClientJMSFactory.getAdminConnectionProps(properties));
                        charSequence = properties.getProperty("node");
                        string3 = ClientJMSFactory.getWASCFPort(adminClient, (String)charSequence, string2).toString();
                        String string4 = ClientJMSFactory.getWASCFHost(adminClient, (String)charSequence);
                        if (string4 != null) {
                            this.setProperty("hostName", string4, object, propertyDescriptorArray);
                        }
                    }
                    catch (Throwable throwable) {
                        Utility.printWarning(tc, throwable);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting {0} to {1}", new Object[]{string, string3});
                    }
                    properties.setProperty(string, string3);
                }
            }
            if (string.equals("SSLCertStores")) {
                this.setSSLCertStoresProperty(object, properties.getProperty(string));
            } else if (!(string.equalsIgnoreCase("node") || string.equalsIgnoreCase(ADMIN_CONNECTOR_TYPE_PROP) || string.equalsIgnoreCase(ADMIN_CONNECTOR_HOST_PROP) || string.equalsIgnoreCase(ADMIN_CONNECTOR_PORT_PROP) || string.equalsIgnoreCase(ADMIN_CONNECTOR_USER_PROP) || string.equalsIgnoreCase(ADMIN_CONNECTOR_PASSWORD_PROP) || string.equalsIgnoreCase("soapConnectorPort"))) {
                try {
                    string3 = properties.getProperty(string);
                    this.setProperty(string, string3, object, propertyDescriptorArray);
                }
                catch (Throwable throwable) {
                    Utility.printWarning(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static String getHostName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostName");
        }
        if (System.getProperty("com.ibm.CORBA.BootstrapHost", null) == null || System.getProperty("com.ibm.CORBA.BootstrapHost", null).equals("")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getHostName");
            }
            return "localhost";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName");
        }
        return System.getProperty("com.ibm.CORBA.BootstrapHost");
    }

    public static String getSoapPort(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSoapPort");
        }
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returning soap port {0}", new Object[]{DEFAULT_SOAP_PORT});
                }
                return Integer.toString(n);
            }
            catch (NumberFormatException numberFormatException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the parameter could not be read properly.  Returning default soap port {0}", new Object[]{DEFAULT_SOAP_PORT});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSoapPort");
                }
                return DEFAULT_SOAP_PORT;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Soap port is not set.  Returning default soap port {0}", new Object[]{DEFAULT_SOAP_PORT});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSoapPort");
        }
        return DEFAULT_SOAP_PORT;
    }

    public static Integer getWASCFPort(AdminClient adminClient, String string, String string2) {
        Integer n;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWASCFPort", string);
            }
            try {
                ObjectName objectName = new ObjectName("WebSphere:name=" + string + "JMSServer,*");
                Set set = adminClient.queryNames(objectName, null);
                if (set.size() != 1 && tc.isDebugEnabled()) {
                    Tr.debug(tc, "There are {0} repositories", new Object[]{new Integer(set.size())});
                }
                Object[] objectArray = set.toArray();
                ObjectName objectName2 = (ObjectName)objectArray[0];
                n = string2.equals("DIRECT") ? (Integer)adminClient.invoke(objectName2, "getDirectPort", null, null) : (Integer)adminClient.invoke(objectName2, "getQueuedPort", null, null);
            }
            catch (Exception exception) {
                n = string2.equals("DIRECT") ? DIRECT_PORT : QUEUED_PORT;
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, exception.getMessage());
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Returning default " + string2 + " port {0}", new Object[]{n});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASCFPort", string);
        }
        return n;
    }

    public static String getCellName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName");
        }
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", System.getProperty("java.naming.factory.initial"));
            InitialContext initialContext = new InitialContext(hashtable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellName");
            }
            return (String)initialContext.lookup("cell/cellname");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, exception.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellName");
            }
            return null;
        }
    }

    private static String getWASCFHost(AdminClient adminClient, String string) {
        String string2 = null;
        try {
            ObjectName objectName = new ObjectName("WebSphere:type=JVM,node=" + string + ",*");
            Set set = adminClient.queryNames(objectName, null);
            if (set.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using default hostname.");
                }
                string2 = ClientJMSFactory.getHostName();
            } else {
                Object[] objectArray = set.toArray();
                string2 = (String)adminClient.getAttribute((ObjectName)objectArray[0], "node");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hostname retrieved from mbean.");
                }
            }
        }
        catch (Throwable throwable) {
            Utility.printWarning(tc, throwable);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred - using default hostname");
            }
            string2 = ClientJMSFactory.getHostName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jmsHostName=" + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASCFHost", string);
        }
        return string2;
    }

    private static Properties getAdminConnectionProps(Properties properties) {
        String string;
        Properties properties2 = new Properties();
        properties2.setProperty("type", ClientJMSFactory.getAdminConnectorType(properties));
        properties2.setProperty("host", ClientJMSFactory.getAdminHostName(properties));
        properties2.setProperty("port", ClientJMSFactory.getAdminPort(properties));
        properties2.setProperty("securityEnabled", "true");
        String string2 = properties.getProperty(ADMIN_CONNECTOR_USER_PROP, null);
        if (!Utility.isStringEmpty(string2)) {
            properties2.setProperty("username", string2);
        }
        if (!Utility.isStringEmpty(string = properties.getProperty(ADMIN_CONNECTOR_PASSWORD_PROP, null))) {
            properties2.setProperty("password", string);
        }
        if (tc.isDebugEnabled()) {
            Properties properties3 = new Properties();
            properties3.setProperty("password", "");
            Tr.debug(tc, "Admin Connection Properties: \n" + Utility.propertiesToStringFormattedHidePW("resource.prop", properties2, properties3));
        }
        return properties2;
    }

    private static String getAdminConnectorType(Properties properties) {
        String string = properties.getProperty(ADMIN_CONNECTOR_TYPE_PROP, null);
        if (string != null && string.equalsIgnoreCase("RMI")) {
            return "RMI";
        }
        return "SOAP";
    }

    private static String getAdminHostName(Properties properties) {
        String string = properties.getProperty(ADMIN_CONNECTOR_HOST_PROP, null);
        if (string != null) {
            return string;
        }
        return ClientJMSFactory.getHostName();
    }

    private static String getAdminPort(Properties properties) {
        block5: {
            String string = properties.getProperty(ADMIN_CONNECTOR_PORT_PROP, null);
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    return string;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "the port parameter [" + string + "] is not numeric.");
                }
            }
        }
        if (ClientJMSFactory.getAdminConnectorType(properties).equalsIgnoreCase("SOAP")) {
            return ClientJMSFactory.getSoapPort(properties.getProperty("soapConnectorPort"));
        }
        if (ClientJMSFactory.getAdminConnectorType(properties).equalsIgnoreCase("RMI")) {
            return DEFAULT_RMI_PORT;
        }
        return "0";
    }
}

