/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.applicationclient;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.jms.GenericJMSDestination;
import com.ibm.ejs.models.base.resources.jms.JMSProvider;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueue;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueue;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientBindingObjectException;
import com.ibm.ws.client.applicationclient.ClientJMSDestinationResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJMSFactory;
import com.ibm.ws.client.applicationclient.ClientResourceBinder;
import com.ibm.ws.client.applicationclient.Utility;
import java.util.Properties;

class ClientJMSQueueResourceBinder
extends ClientJMSDestinationResourceBinder
implements ClientResourceBinder {
    private static final TraceComponent tc = Tr.register(ClientJMSQueueResourceBinder.class, null, "com.ibm.ws.client.applicationclient.ResourceBundle");
    private static final String MQQUEUE_CLASS = "com.ibm.mq.jms.MQQueue";
    private static final String WASQUEUE_CLASS = "com.ibm.mq.jms.MQQueue";
    private static final String _sourceInfo = "SERV1/ws/code/client/src/com/ibm/ws/client/applicationclient/ClientJMSQueueResourceBinder.java, WAS.client, WAS61.SERV1, cf311012.09, ver. 1.10";

    public ClientJMSQueueResourceBinder() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientJMSQueueConnectionResourceBinder", _sourceInfo);
            Tr.exit(tc, "ClientJMSQueueConnectionResourceBinder");
        }
    }

    public String usedFor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "usedFor");
            Tr.exit(tc, "usedFor");
        }
        return "javax.jms.Queue";
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory, String string, String string2) throws ClientBindingObjectException {
        Object object;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getBindingObject");
            }
            object = null;
            JMSProvider jMSProvider = null;
            try {
                jMSProvider = (JMSProvider)j2EEResourceFactory.getProvider();
                if (j2EEResourceFactory instanceof GenericJMSDestination) {
                    GenericJMSDestination genericJMSDestination = (GenericJMSDestination)j2EEResourceFactory;
                    String[] stringArray = new String[]{"GenericJMSDestination"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getGenericJMSBindingObject(j2EEResourceFactory, jMSProvider, genericJMSDestination.getExternalJNDIName(), string);
                    break block6;
                }
                if (j2EEResourceFactory instanceof MQQueue) {
                    String[] stringArray = new String[]{"MQQueue"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getMQQueueBindingObject((MQQueue)j2EEResourceFactory, jMSProvider, string);
                    break block6;
                }
                if (j2EEResourceFactory instanceof WASQueue) {
                    String[] stringArray = new String[]{"WASQueue"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getWASQueueBindingObject((WASQueue)j2EEResourceFactory, jMSProvider, string);
                    break block6;
                }
                throw new ClientBindingObjectException("resource.unknownJMSresource", j2EEResourceFactory.getClass().getName(), tc, "getBindingObject");
            }
            catch (ClassCastException classCastException) {
                throw new ClientBindingObjectException("resource.wrongtype", this.usedFor(), tc, "getBindingObject");
            }
        }
        return object;
    }

    private Object getMQQueueBindingObject(MQQueue mQQueue, JMSProvider jMSProvider, String string) throws ClientBindingObjectException {
        Properties properties = new Properties();
        int n = 0;
        this.setProperty(properties, "com.ibm.ws.client.classname", "com.ibm.mq.jms.MQQueue", true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        this.setProperty(properties, "persistence", new Integer(mQQueue.getPersistence().getValue()));
        this.setPriorityProp(properties, mQQueue.getPriority().getValue(), mQQueue.getSpecifiedPriority(), -3);
        this.setExpiryProp(properties, mQQueue.getExpiry().getValue(), mQQueue.getSpecifiedExpiry(), -3);
        this.setProperty(properties, "baseQueueName", mQQueue.getBaseQueueName());
        this.setProperty(properties, "baseQueueManagerName", mQQueue.getBaseQueueManagerName());
        if (mQQueue.isUseNativeEncoding()) {
            n = ClientJMSFactory.getNativeEncoding();
        } else {
            if (mQQueue.getIntegerEncoding().getValue() == 0) {
                n |= ClientJMSFactory.getNormalIntegerEncoding();
            } else if (mQQueue.getIntegerEncoding().getValue() == 1) {
                n |= ClientJMSFactory.getReversedIntegerEncoding();
            }
            if (mQQueue.getDecimalEncoding().getValue() == 0) {
                n |= ClientJMSFactory.getNormalDecimalEncoding();
            } else if (mQQueue.getDecimalEncoding().getValue() == 1) {
                n |= ClientJMSFactory.getReversedDecimalEncoding();
            }
            if (mQQueue.getFloatingPointEncoding().getValue() == 0) {
                n |= ClientJMSFactory.getIEEENormalFloatEncoding();
            } else if (mQQueue.getFloatingPointEncoding().getValue() == 1) {
                n |= ClientJMSFactory.getIEEEReversedFloatEncoding();
            } else if (mQQueue.getFloatingPointEncoding().getValue() == 2) {
                n |= ClientJMSFactory.getS390FloatEncoding();
            }
        }
        this.setProperty(properties, "encoding", new Integer(n), true);
        this.setProperty(properties, "targetClient", new Integer(mQQueue.getTargetClient().getValue()));
        if (mQQueue.isSetCCSID()) {
            int n2 = mQQueue.getCCSID();
            this.setProperty(properties, "CCSID", new Integer(n2));
        }
        this.addPropertySet(mQQueue.getPropertySet(), properties);
        String[] stringArray = new String[]{Utility.propertiesToStringFormatted("resource.prop", properties)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }

    private Object getWASQueueBindingObject(WASQueue wASQueue, JMSProvider jMSProvider, String string) throws ClientBindingObjectException {
        Properties properties = new Properties();
        this.setProperty(properties, "com.ibm.ws.client.classname", "com.ibm.mq.jms.MQQueue", true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        this.setProperty(properties, "baseQueueName", "WQ_" + wASQueue.getName(), true);
        this.setProperty(properties, "persistence", new Integer(wASQueue.getPersistence().getValue()));
        this.setPriorityProp(properties, wASQueue.getPriority().getValue(), wASQueue.getSpecifiedPriority(), -3);
        this.setExpiryProp(properties, wASQueue.getExpiry().getValue(), wASQueue.getSpecifiedExpiry(), -3);
        this.setProperty(properties, "description", wASQueue.getDescription());
        this.addPropertySet(wASQueue.getPropertySet(), properties);
        String[] stringArray = new String[]{Utility.propertiesToStringFormatted("resource.prop", properties)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }
}

