/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.applicationclient;

import com.ibm.ejs.models.base.resources.ConnectionFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.jms.GenericJMSConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.JMSProvider;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopicConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQBrokerMsgSelection;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQBrokerType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQCFMulticastType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQCleanupType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQDirectAuthType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQSubstoreType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopicConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTransportType;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientBindingObjectException;
import com.ibm.ws.client.applicationclient.ClientContainerParms;
import com.ibm.ws.client.applicationclient.ClientJMSFactory;
import com.ibm.ws.client.applicationclient.ClientResourceBinderImpl;
import com.ibm.ws.client.applicationclient.Utility;
import com.ibm.ws.messaging.JMSQueueManagerName;
import com.ibm.ws.naming.util.IndirectJndiLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jst.j2ee.common.ResourceRef;

abstract class ClientJMSResourceBinder
extends ClientResourceBinderImpl {
    private static final TraceComponent tc = Tr.register(ClientJMSResourceBinder.class, null, "com.ibm.ws.client.applicationclient.ResourceBundle");
    private static final String MQCONNECTIONFACTORY_CLASS = "com.ibm.ws.client.applicationclient.ClientJMSConnectionFactory";
    private static final String MQQUEUECONNECTIONFACTORY_CLASS = "com.ibm.ws.client.applicationclient.ClientJMSQueueConnectionFactory";
    private static final String WASQUEUECONNECTIONFACTORY_CLASS = "com.ibm.ws.client.applicationclient.ClientJMSQueueConnectionFactory";
    private static final String MQTOPICCONNECTIONFACTORY_CLASS = "com.ibm.ws.client.applicationclient.ClientJMSTopicConnectionFactory";
    private static final String WASTOPICCONNECTIONFACTORY_CLASS = "com.ibm.ws.client.applicationclient.ClientJMSTopicConnectionFactory";
    private static final String PROPERTY_FAIL_IF_QUIESCE = "failIfQuiesce";
    private static final String PROPERTY_LOCAL_ADDRESS = "localAddress";
    private static final String PROPERTY_POLLING_INTERVAL = "pollingInterval";
    private static final String PROPERTY_RESCAN_INTERVAL = "rescanInterval";
    private static final String PROPERTY_SSL_CIPHER_SUITE = "SSLCipherSuite";
    public static final String PROPERTY_SSL_CERT_STORES = "SSLCertStores";
    private static final String PROPERTY_SSL_PEER_NAME = "SSLPeerName";
    private static final String PROPERTY_USE_CONNECTION_POOLING = "useConnectionPooling";
    private static final String PROPERTY_TEMP_Q_PREFIX = "tempQPrefix";
    private static final String PROPERTY_TEMP_MODEL = "temporaryModel";
    private static final String PROPERTY_CLEANUP_LEVEL = "cleanupLevel";
    private static final String PROPERTY_CLEANUP_INTERVAL = "cleanupInterval";
    private static final String PROPERTY_MSG_SELECTION = "messageSelection";
    private static final String PROPERTY_PUB_ACK_INTERVAL = "pubAckInterval";
    private static final String PROPERTY_SPARSE_SUBSCRIPTIONS = "sparseSubscriptions";
    private static final String PROPERTY_STAT_REFRESH_INTERVAL = "statusRefreshInterval";
    private static final String PROPERTY_SUB_STORE = "subscriptionStore";
    private static final String PROPERTY_MULTICAST = "multicast";
    private static final String PROPERTY_DIRECT_AUTH = "directAuth";
    private static final String PROPERTY_PROXY_HOST_NAME = "proxyHostName";
    private static final String PROPERTY_PROXY_PORT = "proxyPort";
    private static Map cleanupLevelMap = new HashMap();
    private static Map msgSelectionMap;
    private static Map subStoreMap;
    private static Map multicastMap;
    private static Map directAuthMap;

    public ClientJMSResourceBinder(ClientContainerParms clientContainerParms) {
        super(clientContainerParms);
    }

    public ClientJMSResourceBinder() {
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory, String string, ResourceRef resourceRef) throws ClientBindingObjectException {
        Object object;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getBindingObject");
            }
            object = null;
            JMSProvider jMSProvider = null;
            boolean bl = this.containerAuth(resourceRef.getAuth().getName());
            try {
                jMSProvider = (JMSProvider)j2EEResourceFactory.getProvider();
                if (j2EEResourceFactory instanceof GenericJMSConnectionFactory) {
                    GenericJMSConnectionFactory genericJMSConnectionFactory = (GenericJMSConnectionFactory)j2EEResourceFactory;
                    String[] stringArray = new String[]{"GenericJMSConnectionFactory"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getGenericJMSBindingObject(j2EEResourceFactory, jMSProvider, genericJMSConnectionFactory.getExternalJNDIName(), string);
                    break block9;
                }
                if (j2EEResourceFactory instanceof MQConnectionFactory) {
                    String[] stringArray = new String[]{"MQConnectionFactory"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getMQConnectionFactoryBindingObject((MQConnectionFactory)j2EEResourceFactory, jMSProvider, string, bl);
                    break block9;
                }
                if (j2EEResourceFactory instanceof MQQueueConnectionFactory) {
                    String[] stringArray = new String[]{"MQQueueConnectionFactory"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getMQQueueConnectionFactoryBindingObject((MQQueueConnectionFactory)j2EEResourceFactory, jMSProvider, string, bl);
                    break block9;
                }
                if (j2EEResourceFactory instanceof WASQueueConnectionFactory) {
                    String[] stringArray = new String[]{"WASQueueConnectionFactory"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getWASQueueConnectionFactoryBindingObject((WASQueueConnectionFactory)j2EEResourceFactory, jMSProvider, string, bl);
                    break block9;
                }
                if (j2EEResourceFactory instanceof MQTopicConnectionFactory) {
                    String[] stringArray = new String[]{"MQTopicConnectionFactory"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getMQTopicConnectionFactoryBindingObject((MQTopicConnectionFactory)j2EEResourceFactory, jMSProvider, string, bl);
                    break block9;
                }
                if (j2EEResourceFactory instanceof WASTopicConnectionFactory) {
                    String[] stringArray = new String[]{"WASTopicConnectionFactory"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getWASTopicConnectionFactoryBindingObject((WASTopicConnectionFactory)j2EEResourceFactory, jMSProvider, string, bl);
                    break block9;
                }
                throw new ClientBindingObjectException("resource.unknownJMSresource", j2EEResourceFactory.getClass().getName(), tc, "getBindingObject");
            }
            catch (ClassCastException classCastException) {
                throw new ClientBindingObjectException("resource.wrongtype", this.usedFor(), tc, "getBindingObject");
            }
        }
        return object;
    }

    protected Object getGenericJMSBindingObject(J2EEResourceFactory j2EEResourceFactory, JMSProvider jMSProvider, String string, String string2) throws ClientBindingObjectException {
        IndirectJndiLookup indirectJndiLookup = null;
        String string3 = jMSProvider.getExternalInitialContextFactory();
        String string4 = jMSProvider.getExternalProviderURL();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resource.JMSBindingIndirect", new Object[]{string});
        }
        indirectJndiLookup = new IndirectJndiLookup(string, string3, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericJMSBindingObject");
        }
        return indirectJndiLookup;
    }

    private void setMQCommonCFProperties(Properties properties, String string, int n, String string2, String string3, MQTransportType mQTransportType, String string4, String string5, boolean bl, boolean bl2, String string6, boolean bl3, int n2, String string7, String string8, String string9, boolean bl4, boolean bl5, boolean bl6, int n3) {
        this.setProperty(properties, "queueManager", string);
        this.setProperty(properties, "port", new Integer(n));
        this.setProperty(properties, "hostName", string2);
        this.setProperty(properties, "channel", string3);
        this.setProperty(properties, "transportType", mQTransportType);
        this.setProperty(properties, "clientId", string4);
        this.setProperty(properties, "CCSID", string5);
        if (bl) {
            this.setProperty(properties, PROPERTY_FAIL_IF_QUIESCE, new Integer(bl2 ? 1 : 0));
        }
        this.setProperty(properties, PROPERTY_LOCAL_ADDRESS, string6);
        if (bl3) {
            this.setProperty(properties, PROPERTY_POLLING_INTERVAL, new Integer(n2));
        }
        if (bl6) {
            this.setProperty(properties, PROPERTY_RESCAN_INTERVAL, new Integer(n3));
        }
        this.setProperty(properties, PROPERTY_SSL_CIPHER_SUITE, string7);
        this.setProperty(properties, PROPERTY_SSL_CERT_STORES, string8);
        this.setProperty(properties, PROPERTY_SSL_PEER_NAME, string9);
        if (bl4) {
            this.setProperty(properties, PROPERTY_USE_CONNECTION_POOLING, new Boolean(bl5));
        }
    }

    private void setMQQueueCFProperties(Properties properties, boolean bl, String string, String string2) {
        this.setProperty(properties, "messageRetention", bl ? new Integer(1) : new Integer(0), true);
        this.setProperty(properties, PROPERTY_TEMP_MODEL, string);
        this.setProperty(properties, PROPERTY_TEMP_Q_PREFIX, string2);
    }

    private Object map(String string, Map map) {
        Object v = map.get(string);
        return v;
    }

    private void setMQTopicCFProperties(Properties properties, String string, String string2, String string3, String string4, String string5, MQBrokerType mQBrokerType, boolean bl, MQCleanupType mQCleanupType, boolean bl2, long l, boolean bl3, MQBrokerMsgSelection mQBrokerMsgSelection, boolean bl4, int n, boolean bl5, boolean bl6, boolean bl7, int n2, boolean bl8, MQSubstoreType mQSubstoreType, boolean bl9, MQCFMulticastType mQCFMulticastType, boolean bl10, MQDirectAuthType mQDirectAuthType, String string6, boolean bl11, int n3) {
        this.setProperty(properties, "brokerControlQueue", string);
        this.setProperty(properties, "brokerQueueManager", string2);
        this.setProperty(properties, "brokerPubQueue", string3);
        this.setProperty(properties, "brokerSubQueue", string4);
        this.setProperty(properties, "brokerCCSubQueue", string5);
        this.setProperty(properties, "brokerVersion", this.determineMQBrokerVersion(mQBrokerType));
        if (bl) {
            this.setProperty(properties, PROPERTY_CLEANUP_LEVEL, this.map(mQCleanupType.getName(), cleanupLevelMap));
        }
        if (bl2) {
            this.setProperty(properties, PROPERTY_CLEANUP_INTERVAL, new Long(l));
        }
        if (bl3) {
            this.setProperty(properties, PROPERTY_MSG_SELECTION, this.map(mQBrokerMsgSelection.getName(), msgSelectionMap));
        }
        if (bl4) {
            this.setProperty(properties, PROPERTY_PUB_ACK_INTERVAL, new Integer(n));
        }
        if (bl5) {
            this.setProperty(properties, PROPERTY_SPARSE_SUBSCRIPTIONS, new Boolean(bl6));
        }
        if (bl7) {
            this.setProperty(properties, PROPERTY_STAT_REFRESH_INTERVAL, new Integer(n2));
        }
        if (bl8) {
            this.setProperty(properties, PROPERTY_SUB_STORE, this.map(mQSubstoreType.getName(), subStoreMap));
        }
        if (bl9) {
            this.setProperty(properties, PROPERTY_MULTICAST, this.map(mQCFMulticastType.getName(), multicastMap));
        }
        if (bl10) {
            this.setProperty(properties, PROPERTY_DIRECT_AUTH, this.map(mQDirectAuthType.getName(), directAuthMap));
        }
        this.setProperty(properties, PROPERTY_PROXY_HOST_NAME, string6);
        if (bl11) {
            this.setProperty(properties, PROPERTY_PROXY_PORT, new Integer(n3));
        }
    }

    private Object getMQConnectionFactoryBindingObject(MQConnectionFactory mQConnectionFactory, JMSProvider jMSProvider, String string, boolean bl) throws ClientBindingObjectException {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        this.setProperty(properties, "com.ibm.ws.client.classname", MQCONNECTIONFACTORY_CLASS, true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        this.setMQCommonCFProperties(properties, mQConnectionFactory.getQueueManager(), mQConnectionFactory.getPort(), mQConnectionFactory.getHost(), mQConnectionFactory.getChannel(), mQConnectionFactory.getTransportType(), mQConnectionFactory.getClientID(), mQConnectionFactory.getCCSID(), mQConnectionFactory.isSetFailIfQuiesce(), mQConnectionFactory.isFailIfQuiesce(), mQConnectionFactory.getLocalAddress(), mQConnectionFactory.isSetPollingInterval(), mQConnectionFactory.getPollingInterval(), mQConnectionFactory.getSslCipherSuite(), mQConnectionFactory.getSslCRL(), mQConnectionFactory.getSslPeerName(), mQConnectionFactory.isSetUseConnectionPooling(), mQConnectionFactory.isUseConnectionPooling(), mQConnectionFactory.isSetRescanInterval(), mQConnectionFactory.getRescanInterval());
        this.setMQQueueCFProperties(properties, mQConnectionFactory.isMsgRetention(), mQConnectionFactory.getTempModel(), mQConnectionFactory.getTempQueuePrefix());
        this.setMQTopicCFProperties(properties, mQConnectionFactory.getBrokerControlQueue(), mQConnectionFactory.getBrokerQueueManager(), mQConnectionFactory.getBrokerPubQueue(), mQConnectionFactory.getBrokerSubQueue(), mQConnectionFactory.getBrokerCCSubQ(), mQConnectionFactory.getBrokerVersion(), mQConnectionFactory.isSetPubSubCleanup(), mQConnectionFactory.getPubSubCleanup(), mQConnectionFactory.isSetPubSubCleanupInterval(), mQConnectionFactory.getPubSubCleanupInterval(), mQConnectionFactory.isSetMsgSelection(), mQConnectionFactory.getMsgSelection(), mQConnectionFactory.isSetPublishAckInterval(), mQConnectionFactory.getPublishAckInterval(), mQConnectionFactory.isSetSparseSubscriptions(), mQConnectionFactory.isSparseSubscriptions(), mQConnectionFactory.isSetStatRefreshInterval(), mQConnectionFactory.getStatRefreshInterval(), mQConnectionFactory.isSetSubstore(), mQConnectionFactory.getSubstore(), mQConnectionFactory.isSetMulticast(), mQConnectionFactory.getMulticast(), mQConnectionFactory.isSetDirectAuth(), mQConnectionFactory.getDirectAuth(), mQConnectionFactory.getProxyHostName(), mQConnectionFactory.isSetProxyPort(), mQConnectionFactory.getProxyPort());
        this.setUseridandPassword(properties, properties2, (ConnectionFactory)mQConnectionFactory, bl, mQConnectionFactory.getName());
        this.addPropertySet(mQConnectionFactory.getPropertySet(), properties);
        String[] stringArray = new String[]{Utility.propertiesToStringFormattedHidePW("resource.prop", properties, properties2)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }

    private Object getMQQueueConnectionFactoryBindingObject(MQQueueConnectionFactory mQQueueConnectionFactory, JMSProvider jMSProvider, String string, boolean bl) throws ClientBindingObjectException {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        this.setProperty(properties, "com.ibm.ws.client.classname", "com.ibm.ws.client.applicationclient.ClientJMSQueueConnectionFactory", true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        this.setMQCommonCFProperties(properties, mQQueueConnectionFactory.getQueueManager(), mQQueueConnectionFactory.getPort(), mQQueueConnectionFactory.getHost(), mQQueueConnectionFactory.getChannel(), mQQueueConnectionFactory.getTransportType(), mQQueueConnectionFactory.getClientID(), mQQueueConnectionFactory.getCCSID(), mQQueueConnectionFactory.isSetFailIfQuiesce(), mQQueueConnectionFactory.isFailIfQuiesce(), mQQueueConnectionFactory.getLocalAddress(), mQQueueConnectionFactory.isSetPollingInterval(), mQQueueConnectionFactory.getPollingInterval(), mQQueueConnectionFactory.getSslCipherSuite(), mQQueueConnectionFactory.getSslCRL(), mQQueueConnectionFactory.getSslPeerName(), mQQueueConnectionFactory.isSetUseConnectionPooling(), mQQueueConnectionFactory.isUseConnectionPooling(), mQQueueConnectionFactory.isSetRescanInterval(), mQQueueConnectionFactory.getRescanInterval());
        this.setMQQueueCFProperties(properties, mQQueueConnectionFactory.isMsgRetention(), mQQueueConnectionFactory.getTempModel(), mQQueueConnectionFactory.getTempQueuePrefix());
        this.setUseridandPassword(properties, properties2, (ConnectionFactory)mQQueueConnectionFactory, bl, mQQueueConnectionFactory.getName());
        this.addPropertySet(mQQueueConnectionFactory.getPropertySet(), properties);
        String[] stringArray = new String[]{Utility.propertiesToStringFormattedHidePW("resource.prop", properties, properties2)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }

    private Object getWASQueueConnectionFactoryBindingObject(WASQueueConnectionFactory wASQueueConnectionFactory, JMSProvider jMSProvider, String string, boolean bl) throws ClientBindingObjectException {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        this.setProperty(properties, "com.ibm.ws.client.classname", "com.ibm.ws.client.applicationclient.ClientJMSQueueConnectionFactory", true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        this.setProperty(properties, "queueManager", JMSQueueManagerName.getQueueManagerName("%cellName%", wASQueueConnectionFactory.getNode(), wASQueueConnectionFactory.getServerName()), true);
        this.setProperty(properties, "transportType", ClientJMSFactory.getTransportClient(), true);
        this.setProperty(properties, "channel", "WAS.JMS.SVRCONN", true);
        this.setProperty(properties, "description", wASQueueConnectionFactory.getDescription());
        this.setProperty(properties, "clientId", "WAS", true);
        this.setProperty(properties, "port", "QUEUED", true);
        this.setProperty(properties, "node", wASQueueConnectionFactory.getNode(), true);
        this.setUseridandPassword(properties, properties2, (ConnectionFactory)wASQueueConnectionFactory, bl, wASQueueConnectionFactory.getName());
        this.addPropertySet(wASQueueConnectionFactory.getPropertySet(), properties);
        this.setProperty(properties, "soapConnectorPort", this._ccp.getSoapConnectorPort());
        this.setProperty(properties, "appclient.adminConnectorType", this._ccp.getAdminConnectorType());
        this.setProperty(properties, "appclient.adminConnectorHost", this._ccp.getAdminConnectorHost());
        this.setProperty(properties, "appclient.adminConnectorPort", this._ccp.getAdminConnectorPort());
        this.setProperty(properties, "appclient.adminConnectorUser", this._ccp.getAdminConnectorUser());
        this.setPropertyPW(properties, properties2, "appclient.adminConnectorPassword", this._ccp.getAdminConnectorPassword(), !Utility.isStringEmpty(this._ccp.getAdminConnectorPassword()), "appclient.adminConnectorPassword");
        String[] stringArray = new String[]{Utility.propertiesToStringFormattedHidePW("resource.prop", properties, properties2)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }

    private Object getMQTopicConnectionFactoryBindingObject(MQTopicConnectionFactory mQTopicConnectionFactory, JMSProvider jMSProvider, String string, boolean bl) throws ClientBindingObjectException {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        this.setProperty(properties, "com.ibm.ws.client.classname", "com.ibm.ws.client.applicationclient.ClientJMSTopicConnectionFactory", true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        this.setMQCommonCFProperties(properties, mQTopicConnectionFactory.getQueueManager(), mQTopicConnectionFactory.getPort(), mQTopicConnectionFactory.getHost(), mQTopicConnectionFactory.getChannel(), mQTopicConnectionFactory.getTransportType(), mQTopicConnectionFactory.getClientID(), mQTopicConnectionFactory.getCCSID(), mQTopicConnectionFactory.isSetFailIfQuiesce(), mQTopicConnectionFactory.isFailIfQuiesce(), mQTopicConnectionFactory.getLocalAddress(), mQTopicConnectionFactory.isSetPollingInterval(), mQTopicConnectionFactory.getPollingInterval(), mQTopicConnectionFactory.getSslCipherSuite(), mQTopicConnectionFactory.getSslCRL(), mQTopicConnectionFactory.getSslPeerName(), mQTopicConnectionFactory.isSetUseConnectionPooling(), mQTopicConnectionFactory.isUseConnectionPooling(), mQTopicConnectionFactory.isSetRescanInterval(), mQTopicConnectionFactory.getRescanInterval());
        this.setMQTopicCFProperties(properties, mQTopicConnectionFactory.getBrokerControlQueue(), mQTopicConnectionFactory.getBrokerQueueManager(), mQTopicConnectionFactory.getBrokerPubQueue(), mQTopicConnectionFactory.getBrokerSubQueue(), mQTopicConnectionFactory.getBrokerCCSubQ(), mQTopicConnectionFactory.getBrokerVersion(), mQTopicConnectionFactory.isSetPubSubCleanup(), mQTopicConnectionFactory.getPubSubCleanup(), mQTopicConnectionFactory.isSetPubSubCleanupInterval(), mQTopicConnectionFactory.getPubSubCleanupInterval(), mQTopicConnectionFactory.isSetMsgSelection(), mQTopicConnectionFactory.getMsgSelection(), mQTopicConnectionFactory.isSetPublishAckInterval(), mQTopicConnectionFactory.getPublishAckInterval(), mQTopicConnectionFactory.isSetSparseSubscriptions(), mQTopicConnectionFactory.isSparseSubscriptions(), mQTopicConnectionFactory.isSetStatRefreshInterval(), mQTopicConnectionFactory.getStatRefreshInterval(), mQTopicConnectionFactory.isSetSubstore(), mQTopicConnectionFactory.getSubstore(), mQTopicConnectionFactory.isSetMulticast(), mQTopicConnectionFactory.getMulticast(), mQTopicConnectionFactory.isSetDirectAuth(), mQTopicConnectionFactory.getDirectAuth(), mQTopicConnectionFactory.getProxyHostName(), mQTopicConnectionFactory.isSetProxyPort(), mQTopicConnectionFactory.getProxyPort());
        this.setUseridandPassword(properties, properties2, (ConnectionFactory)mQTopicConnectionFactory, bl, mQTopicConnectionFactory.getName());
        this.addPropertySet(mQTopicConnectionFactory.getPropertySet(), properties);
        String[] stringArray = new String[]{Utility.propertiesToStringFormattedHidePW("resource.prop", properties, properties2)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }

    private Object getWASTopicConnectionFactoryBindingObject(WASTopicConnectionFactory wASTopicConnectionFactory, JMSProvider jMSProvider, String string, boolean bl) throws ClientBindingObjectException {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        this.setProperty(properties, "com.ibm.ws.client.classname", "com.ibm.ws.client.applicationclient.ClientJMSTopicConnectionFactory", true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        if (wASTopicConnectionFactory.getPort().getName().equals("QUEUED")) {
            this.setProperty(properties, "port", wASTopicConnectionFactory.getPort().getName(), true);
            this.setProperty(properties, "transportType", ClientJMSFactory.getTransportClient(), true);
        } else {
            this.setProperty(properties, "port", wASTopicConnectionFactory.getPort().getName(), true);
            this.setProperty(properties, "transportType", ClientJMSFactory.getTransportDirect(), true);
        }
        this.setProperty(properties, "node", wASTopicConnectionFactory.getNode(), true);
        this.setProperty(properties, "brokerVersion", ClientJMSFactory.getWASBrokerVersion(), true);
        this.setProperty(properties, "queueManager", JMSQueueManagerName.getQueueManagerName("%cellName%", wASTopicConnectionFactory.getNode(), wASTopicConnectionFactory.getServerName()), true);
        this.setProperty(properties, "brokerQueueManager", JMSQueueManagerName.getQueueManagerName("%cellName%", wASTopicConnectionFactory.getNode(), wASTopicConnectionFactory.getServerName()), true);
        this.setProperty(properties, "channel", "WAS.JMS.SVRCONN", true);
        this.setProperty(properties, "brokerPubQueue", "SYSTEM.BROKER.DEFAULT.STREAM", true);
        this.setProperty(properties, "description", wASTopicConnectionFactory.getDescription());
        this.setProperty(properties, "clientId", wASTopicConnectionFactory.getClientID());
        this.setUseridandPassword(properties, properties2, (ConnectionFactory)wASTopicConnectionFactory, bl, wASTopicConnectionFactory.getName());
        this.addPropertySet(wASTopicConnectionFactory.getPropertySet(), properties);
        this.setProperty(properties, "soapConnectorPort", this._ccp.getSoapConnectorPort());
        this.setProperty(properties, "appclient.adminConnectorType", this._ccp.getAdminConnectorType());
        this.setProperty(properties, "appclient.adminConnectorHost", this._ccp.getAdminConnectorHost());
        this.setProperty(properties, "appclient.adminConnectorPort", this._ccp.getAdminConnectorPort());
        this.setProperty(properties, "appclient.adminConnectorUser", this._ccp.getAdminConnectorUser());
        this.setPropertyPW(properties, properties2, "appclient.adminConnectorPassword", this._ccp.getAdminConnectorPassword(), !Utility.isStringEmpty(this._ccp.getAdminConnectorPassword()), "appclient.adminConnectorPassword");
        String[] stringArray = new String[]{Utility.propertiesToStringFormattedHidePW("resource.prop", properties, properties2)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }

    protected void setExpiryProp(Properties properties, int n, long l, int n2) {
        if (n == n2) {
            this.setProperty(properties, "expiry", new Long(l));
        } else {
            this.setProperty(properties, "expiry", new Integer(n));
        }
    }

    protected void setPriorityProp(Properties properties, int n, int n2, int n3) {
        if (n == n3) {
            this.setProperty(properties, "priority", new Integer(n2));
        } else {
            this.setProperty(properties, "priority", new Integer(n));
        }
    }

    private Integer determineMQBrokerVersion(MQBrokerType mQBrokerType) {
        if (mQBrokerType.getValue() == 1) {
            return ClientJMSFactory.getBrokerVersion_V1();
        }
        return ClientJMSFactory.getBrokerVersion_V2();
    }

    static {
        cleanupLevelMap.put(MQCleanupType.ASPROP_LITERAL.getName(), new Integer(-1));
        cleanupLevelMap.put(MQCleanupType.NONE_LITERAL.getName(), new Integer(0));
        cleanupLevelMap.put(MQCleanupType.SAFE_LITERAL.getName(), new Integer(1));
        cleanupLevelMap.put(MQCleanupType.STRONG_LITERAL.getName(), new Integer(2));
        msgSelectionMap = new HashMap();
        msgSelectionMap.put(MQBrokerMsgSelection.BROKER_LITERAL.getName(), new Integer(1));
        msgSelectionMap.put(MQBrokerMsgSelection.CLIENT_LITERAL.getName(), new Integer(0));
        subStoreMap = new HashMap();
        subStoreMap.put(MQSubstoreType.BROKER_LITERAL.getName(), new Integer(1));
        subStoreMap.put(MQSubstoreType.MIGRATE_LITERAL.getName(), new Integer(2));
        subStoreMap.put(MQSubstoreType.QUEUE_LITERAL.getName(), new Integer(0));
        multicastMap = new HashMap();
        multicastMap.put(MQCFMulticastType.ENABLED_LITERAL.getName(), new Integer(7));
        multicastMap.put(MQCFMulticastType.RELIABLE_LITERAL.getName(), new Integer(5));
        multicastMap.put(MQCFMulticastType.NOT_RELIABLE_LITERAL.getName(), new Integer(3));
        multicastMap.put(MQCFMulticastType.DISABLED_LITERAL.getName(), new Integer(0));
        directAuthMap = new HashMap();
        directAuthMap.put(MQDirectAuthType.CERTIFICATE_LITERAL, new Integer(1));
        directAuthMap.put(MQDirectAuthType.BASIC_LITERAL, new Integer(0));
    }
}

