/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.applicationclient;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.jms.GenericJMSDestination;
import com.ibm.ejs.models.base.resources.jms.JMSProvider;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopic;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQMulticastType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopic;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientBindingObjectException;
import com.ibm.ws.client.applicationclient.ClientJMSDestinationResourceBinder;
import com.ibm.ws.client.applicationclient.ClientJMSFactory;
import com.ibm.ws.client.applicationclient.ClientResourceBinder;
import com.ibm.ws.client.applicationclient.Utility;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class ClientJMSTopicResourceBinder
extends ClientJMSDestinationResourceBinder
implements ClientResourceBinder {
    private static final TraceComponent tc = Tr.register(ClientJMSTopicResourceBinder.class, null, "com.ibm.ws.client.applicationclient.ResourceBundle");
    private static final String MQTOPIC_CLASS = "com.ibm.mq.jms.MQTopic";
    private static final String WASTOPIC_CLASS = "com.ibm.mq.jms.MQTopic";
    private static Map multicastMap = new HashMap();

    ClientJMSTopicResourceBinder() {
    }

    public String usedFor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "usedFor");
            Tr.exit(tc, "usedFor");
        }
        return "javax.jms.Topic";
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory, String string, String string2) throws ClientBindingObjectException {
        Object object;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getBindingObject");
            }
            object = null;
            JMSProvider jMSProvider = null;
            try {
                jMSProvider = (JMSProvider)j2EEResourceFactory.getProvider();
                if (j2EEResourceFactory instanceof GenericJMSDestination) {
                    GenericJMSDestination genericJMSDestination = (GenericJMSDestination)j2EEResourceFactory;
                    String[] stringArray = new String[]{"GenericJMSDestination"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getGenericJMSBindingObject(j2EEResourceFactory, jMSProvider, genericJMSDestination.getExternalJNDIName(), string);
                    break block6;
                }
                if (j2EEResourceFactory instanceof MQTopic) {
                    String[] stringArray = new String[]{"MQTopic"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getMQTopicBindingObject((MQTopic)j2EEResourceFactory, jMSProvider, string);
                    break block6;
                }
                if (j2EEResourceFactory instanceof WASTopic) {
                    String[] stringArray = new String[]{"WASTopic"};
                    this.debugVerbose("resource.jmstype", stringArray, tc);
                    object = this.getWASTopicBindingObject((WASTopic)j2EEResourceFactory, jMSProvider, string);
                    break block6;
                }
                throw new ClientBindingObjectException("resource.unknownJMSresource", j2EEResourceFactory.getClass().getName(), tc, "getBindingObject");
            }
            catch (ClassCastException classCastException) {
                throw new ClientBindingObjectException("resource.wrongtype", this.usedFor(), tc, "getBindingObject");
            }
        }
        return object;
    }

    private Object map(String string, Map map) {
        Object v = map.get(string);
        return v;
    }

    private Object getMQTopicBindingObject(MQTopic mQTopic, JMSProvider jMSProvider, String string) throws ClientBindingObjectException {
        Properties properties = new Properties();
        int n = 0;
        this.setProperty(properties, "com.ibm.ws.client.classname", "com.ibm.mq.jms.MQTopic", true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        this.setProperty(properties, "persistence", new Integer(mQTopic.getPersistence().getValue()));
        this.setPriorityProp(properties, mQTopic.getPriority().getValue(), mQTopic.getSpecifiedPriority(), -3);
        this.setExpiryProp(properties, mQTopic.getExpiry().getValue(), mQTopic.getSpecifiedExpiry(), -3);
        this.setProperty(properties, "baseTopicName", mQTopic.getBaseTopicName());
        if (mQTopic.isUseNativeEncoding()) {
            n = ClientJMSFactory.getNativeEncoding();
        } else {
            if (mQTopic.getIntegerEncoding().getValue() == 0) {
                n |= ClientJMSFactory.getNormalIntegerEncoding();
            } else if (mQTopic.getIntegerEncoding().getValue() == 1) {
                n |= ClientJMSFactory.getReversedIntegerEncoding();
            }
            if (mQTopic.getDecimalEncoding().getValue() == 0) {
                n |= ClientJMSFactory.getNormalDecimalEncoding();
            } else if (mQTopic.getDecimalEncoding().getValue() == 1) {
                n |= ClientJMSFactory.getReversedDecimalEncoding();
            }
            if (mQTopic.getFloatingPointEncoding().getValue() == 0) {
                n |= ClientJMSFactory.getIEEENormalFloatEncoding();
            } else if (mQTopic.getFloatingPointEncoding().getValue() == 1) {
                n |= ClientJMSFactory.getIEEEReversedFloatEncoding();
            } else if (mQTopic.getFloatingPointEncoding().getValue() == 2) {
                n |= ClientJMSFactory.getS390FloatEncoding();
            }
        }
        this.setProperty(properties, "encoding", new Integer(n), true);
        this.setProperty(properties, "targetClient", new Integer(mQTopic.getTargetClient().getValue()));
        if (mQTopic.isSetCCSID()) {
            int n2 = mQTopic.getCCSID();
            this.setProperty(properties, "CCSID", new Integer(n2));
        }
        this.setProperty(properties, "brokerDurSubQueue", mQTopic.getBrokerDurSubQueue());
        this.setProperty(properties, "brokerCCDurSubQueue", mQTopic.getBrokerCCDurSubQueue());
        this.setProperty(properties, "multicast", this.map(mQTopic.getMulticast().getName(), multicastMap));
        this.addPropertySet(mQTopic.getPropertySet(), properties);
        String[] stringArray = new String[]{Utility.propertiesToStringFormatted("resource.prop", properties)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }

    private Object getWASTopicBindingObject(WASTopic wASTopic, JMSProvider jMSProvider, String string) throws ClientBindingObjectException {
        Properties properties = new Properties();
        this.setProperty(properties, "com.ibm.ws.client.classname", "com.ibm.mq.jms.MQTopic", true);
        this.setProperty(properties, "com.ibm.ws.client.classpath", string, !Utility.isStringEmpty(string));
        this.setProperty(properties, "baseTopicName", wASTopic.getTopic());
        this.setProperty(properties, "persistence", new Integer(wASTopic.getPersistence().getValue()));
        this.setPriorityProp(properties, wASTopic.getPriority().getValue(), wASTopic.getSpecifiedPriority(), -3);
        this.setExpiryProp(properties, wASTopic.getExpiry().getValue(), wASTopic.getSpecifiedExpiry(), -3);
        this.setProperty(properties, "brokerVersion", ClientJMSFactory.getWASBrokerVersion(), true);
        this.addPropertySet(wASTopic.getPropertySet(), properties);
        String[] stringArray = new String[]{Utility.propertiesToStringFormatted("resource.prop", properties)};
        this.debugVerbose("resource.properties", stringArray, tc);
        return ClientJMSFactory.getJMSReference(properties, this.usedFor());
    }

    static {
        multicastMap.put(MQMulticastType.ENABLED_LITERAL.getName(), new Integer(7));
        multicastMap.put(MQMulticastType.RELIABLE_LITERAL.getName(), new Integer(5));
        multicastMap.put(MQMulticastType.NOT_RELIABLE_LITERAL.getName(), new Integer(3));
        multicastMap.put(MQMulticastType.DISABLED_LITERAL.getName(), new Integer(0));
        multicastMap.put(MQMulticastType.AS_CF_LITERAL.getName(), new Integer(-1));
    }
}

