/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.applicationclient;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.bootstrap.ExtClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class Utility {
    protected static String kPkgID = "WSCL";
    public static final String msgBundleName = "com.ibm.ws.client.applicationclient.ResourceBundle";
    private static NLS nls = null;

    public static String getMessage(String string) {
        return nls.getString(string);
    }

    public static String getMessage(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return nls.getFormattedMessage(string, objectArray, "Internal Error: cannot find messsage key " + string);
    }

    public static String getMessage(String string, String[] stringArray) {
        return nls.getFormattedMessage(string, stringArray, "Internal Error: cannot find messsage key " + string);
    }

    public static void printWarning(TraceComponent traceComponent, Throwable throwable) {
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, throwable.getMessage());
        }
        Utility.printWarning(throwable.getMessage());
    }

    public static void printWarning(TraceComponent traceComponent, String string) {
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, string);
        }
        Utility.printWarning(string);
    }

    public static void printWarning(Throwable throwable) {
        System.err.println(throwable.getMessage());
    }

    public static void printWarning(String string) {
        System.err.println(string);
    }

    public static void printMessage(String string) {
        System.out.println(string);
    }

    public static void printMessage(TraceComponent traceComponent, String string) {
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, string);
        }
        System.out.println(string);
    }

    private static void traceMessage(TraceComponent traceComponent, String string) {
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, string);
        }
    }

    public static void printUnknownException(TraceComponent traceComponent, Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = Utility.writeStackTrace(throwable);
        String string = byteArrayOutputStream.toString();
        int n = string.indexOf(kPkgID, kPkgID.length());
        if (n > 0) {
            string = string.substring(0, n - 1) + "\n" + string.substring(n);
        }
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, "client.exception", new Object[]{string});
        }
        Utility.printWarning(Utility.getMessage("client.exception", string));
    }

    public static void printUnknownException(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = Utility.writeStackTrace(throwable);
        Utility.printWarning(Utility.getMessage("client.exception", byteArrayOutputStream.toString()));
    }

    public static String propertiesToString(Properties properties) {
        String string = "";
        Enumeration<Object> enumeration = properties.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2 + "\n";
        }
        return string;
    }

    public static String propertiesToStringFormatted(String string, Properties properties) {
        String string2 = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String[] stringArray = new String[]{string3, properties.getProperty(string3)};
            string2 = string2 + Utility.getMessage(string, stringArray);
        }
        return string2;
    }

    public static String propertiesToStringFormattedHidePW(String string, Properties properties, Properties properties2) {
        String string2 = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = null;
            string4 = properties2.containsKey(string3) ? "*********" : properties.getProperty(string3);
            String[] stringArray = new String[]{string3, string4};
            string2 = string2 + Utility.getMessage(string, stringArray);
        }
        return string2;
    }

    public static void setClassPath(ExtClassLoader extClassLoader, List list) {
        for (int i = 0; i < list.size(); ++i) {
            extClassLoader.addPath((String)list.get(i));
        }
    }

    public static ClassLoader getResourceClassLoader(TraceComponent traceComponent, String string, ClassLoader classLoader) throws MalformedURLException {
        ClassLoader classLoader2 = null;
        if (string == null || string.equalsIgnoreCase("")) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 == null) {
                classLoader2 = ClassLoader.getSystemClassLoader();
            }
        } else {
            Utility.traceMessage(traceComponent, Utility.getMessage("metadata.parsingurls", string));
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), File.pathSeparator);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals("")) continue;
                arrayList.add(string2);
            }
            Utility.traceMessage(traceComponent, Utility.getMessage("metadata.loadingurls", arrayList.toString()));
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            classLoader2 = new ExtClassLoader(classLoader);
            Utility.setClassPath((ExtClassLoader)classLoader2, arrayList);
        }
        return classLoader2;
    }

    public static boolean isStringEmpty(String string) {
        return string == null || string.length() <= 0;
    }

    public static boolean isStringSet(String string) {
        return !Utility.isStringEmpty(string);
    }

    public static String appendClasspathStrings(String string, String string2) {
        if (!Utility.isStringEmpty(string)) {
            string = string.trim();
        }
        if (!Utility.isStringEmpty(string2)) {
            string2 = string2.trim();
        }
        if (!Utility.isStringEmpty(string2)) {
            if (Utility.isStringEmpty(string)) {
                return string2;
            }
            if (string.endsWith(File.pathSeparator)) {
                return string + string2;
            }
            return string + File.pathSeparator + string2;
        }
        return string;
    }

    public static Vector classpathAsVector(String string) {
        Vector<String> vector = new Vector<String>();
        if (!Utility.isStringEmpty(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (Utility.isStringEmpty(string2)) continue;
                vector.add(string2);
            }
        }
        return vector;
    }

    public static void setProviderClasspath(EList eList, String string) {
        eList.clear();
        if (string != null || !string.equals("")) {
            eList.addAll((Collection)Utility.classpathAsVector(string));
        }
    }

    public static String getProviderClasspath(EList eList) {
        ListIterator listIterator = eList.listIterator();
        String string = new String();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            string = Utility.appendClasspathStrings(string, string2);
        }
        return string;
    }

    public static ByteArrayOutputStream writeStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream;
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        StringBuffer stringBuffer = stringWriter.getBuffer();
        return stringBuffer.toString();
    }

    public static void DebugVerbose(TraceComponent traceComponent, String string, String[] stringArray, boolean bl) {
        String string2 = null;
        string2 = stringArray == null ? Utility.getMessage(string) : (stringArray.length == 1 ? Utility.getMessage(string, stringArray[0]) : Utility.getMessage(string, stringArray));
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, string2);
        }
        Utility.printVerbose(string2, bl);
    }

    public static void printVerbose(String string, boolean bl) {
        if (bl && string != null) {
            Utility.printMessage(string);
        }
    }

    public static String buildCorbaURL(String string, String string2, String string3) {
        String string4 = "corbaloc:iiop:";
        if (Utility.isStringEmpty(string3)) {
            string4 = Utility.isStringEmpty(string) ? string4 + "localhost" : string4 + string;
            if (!Utility.isStringEmpty(string2)) {
                string4 = string4 + ":" + string2;
            }
        } else {
            string4 = string3;
        }
        return string4;
    }

    static {
        nls = new NLS(msgBundleName);
    }
}

