/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.jms.JMSConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public abstract class ConnectionFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(ConnectionFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    protected ServiceDialog _serviceDialog;
    protected ClientContainerResourceRepository _ccr;
    protected ImageIcon _icon;

    public ConnectionFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/JMSConnectionFactory.gif"));
    }

    public abstract String toString();

    public abstract String getToolTipText();

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    public class ConnectionFactoryPanel
    extends FactoryPanel {
        private static final long serialVersionUID = -2516258596496126848L;
        JTextField userIDField = this.addNextPropertyWithRemainder("helper.userLabel", "user", false);
        JPasswordField passwordField = this.addNextPasswordProperty("helper.passwordLabel", "password", false);
        JPasswordField retypePasswordField = this.addNextPasswordProperty("helper.retypePasswordLabel", "retypepassword", false);

        public ConnectionFactoryPanel() {
        }

        public ConnectionFactoryPanel(JMSConnectionFactory jMSConnectionFactory) {
            this();
            this.nameField.setText(jMSConnectionFactory.getName() != null ? jMSConnectionFactory.getName() : "");
            this.descField.setText(jMSConnectionFactory.getDescription() != null ? jMSConnectionFactory.getDescription() : "");
            this.jndiNameField.setText(jMSConnectionFactory.getJndiName() != null ? jMSConnectionFactory.getJndiName() : "");
            this.setUseridandPassword(jMSConnectionFactory.getAuthDataAlias(), jMSConnectionFactory.getAuthDataAlias() != null);
            this.nameField.setEnabled(false);
        }

        public String getUserID() {
            return this.userIDField.getText().trim();
        }

        public String getPassword() {
            return ConnectionFactoryNode.this.encryptPassword(new String(this.passwordField.getPassword()));
        }

        public String getRetypePassword() {
            return ConnectionFactoryNode.this.encryptPassword(new String(this.retypePasswordField.getPassword()));
        }

        public boolean isSetUserID() {
            return !this.userIDField.getText().trim().equals("");
        }

        public boolean isSetPassword() {
            return !new String(this.passwordField.getPassword()).trim().equals("");
        }

        public boolean isSetRetypePassword() {
            return !this.retypePasswordField.getPassword().equals("");
        }

        public void setUseridandPassword(String string, boolean bl) {
            JAASAuthData jAASAuthData = null;
            if (bl && (jAASAuthData = ConnectionFactoryNode.this._ccr.findJAASAuthData(string)) != null) {
                this.userIDField.setText(jAASAuthData.getUserId() != null ? jAASAuthData.getUserId() : "");
                this.passwordField.setText(jAASAuthData.getPassword() != null ? ConnectionFactoryNode.this.decryptPassword(jAASAuthData.getPassword()) : "");
                this.retypePasswordField.setText(jAASAuthData.getPassword() != null ? ConnectionFactoryNode.this.decryptPassword(jAASAuthData.getPassword()) : "");
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionFactoryNode.this._serviceDialog.dispose();
        }
    }
}

