/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.ccrct.Utility;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class HelpDisplayer {
    private static TraceComponent tc = Tr.register(HelpDisplayer.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private static final String defaultWin = "rundll32 url.dll,FileProtocolHandler {0}";
    private static final String defaultUnix = "netscape -remote openURL({0});false;netscape {0}";
    private static Boolean winFlag = null;
    private static Process browser;
    private static String helpPropertyString;
    private static boolean URLdll;
    private static ImageIcon informationImage;
    private static ImageIcon criticalImage;
    private static ImageIcon warningImage;

    public HelpDisplayer() {
        warningImage = new ImageIcon(this.getClass().getResource("images/warning.gif"));
        informationImage = new ImageIcon(this.getClass().getResource("images/information.gif"));
        criticalImage = new ImageIcon(this.getClass().getResource("images/critical.gif"));
    }

    public static void displayHelp(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "displayHelp", string);
        }
        if (helpPropertyString == null) {
            HelpDisplayer.initProperties();
        }
        if (helpPropertyString != null) {
            HelpDisplayer.displayURL(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "displayHelp");
        }
    }

    static void initProperties() {
        helpPropertyString = System.getProperty("AssemblyToolProperty.helpCommand", HelpDisplayer.isWindows() ? defaultWin : defaultUnix);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Help command string is:", helpPropertyString);
        }
        if (helpPropertyString.toLowerCase().indexOf("url.dll") >= 0) {
            URLdll = true;
        }
    }

    static void displayURL(String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "displayURL(" + string + ")");
        }
        String string2 = null;
        int n = string.indexOf("#");
        String string3 = n < 0 ? string : string.substring(0, n);
        boolean bl2 = new File(string3).exists();
        boolean bl3 = bl = n >= 0 && string.indexOf(" ", n + 1) >= 0;
        if (URLdll || bl) {
            string = string3;
        }
        if (HelpDisplayer.isWindows()) {
            string = string.replace('/', '\\');
        }
        StringTokenizer stringTokenizer = new StringTokenizer(helpPropertyString, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            boolean bl4 = Boolean.valueOf(stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "true");
            if (bl4 && !bl2) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("help.helpFileNotFound", string3), Utility.getMessage("helper.errorTitle"), 0, criticalImage);
                return;
            }
            string2 = MessageFormat.format(string4, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Displaying help with cmd: ", string2);
            }
            try {
                browser = Runtime.getRuntime().exec(string2);
                try {
                    if (stringTokenizer.hasMoreTokens() && browser.waitFor() != 0) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                Tr.warning(tc, "help.noBrowser", new Object[]{string2});
                JOptionPane.showMessageDialog(null, Utility.getMessage("help.cantStartBrowser"), Utility.getMessage("helper.errorTitle"), 0, criticalImage);
            }
            catch (Exception exception) {
                Tr.warning(tc, "help.noBrowser", new Object[]{string2});
                JOptionPane.showMessageDialog(null, Utility.getMessage("help.cantStartBrowser"), Utility.getMessage("helper.errorTitle"), 0, criticalImage);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "displayURL");
        }
    }

    static boolean isWindows() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWindows");
        }
        if (winFlag != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isWindows", winFlag);
            }
            return winFlag;
        }
        String string = System.getProperty("os.name");
        winFlag = string != null && string.startsWith("Windows") ? new Boolean(true) : new Boolean(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWindows", winFlag);
        }
        return winFlag;
    }

    static {
        URLdll = false;
        informationImage = null;
        criticalImage = null;
        warningImage = null;
    }
}

