/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepositoryImpl;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ProviderListener;
import com.ibm.ws.client.ccrct.ProviderPanel;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.TreeNodes;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.eclipse.emf.common.util.EList;

public class J2CProviderNode
extends Node {
    private LocalServiceDialog _serviceDialog;
    private ClientContainerResourceRepositoryImpl _ccr;
    private J2CProviderPanel _j2cPanel;
    private ImageIcon _icon;
    private static final String _providerType = "Resource Adapters";
    public static final String RAR_ARCHIVEPATH = "rar.archivePath";
    public static final String RAR_NAME = "rar.name";
    public static final String RAR_DESCRIPTION = "rar.desc";
    public static final String RAR_CLASSPATH = "rar.classpath";
    public static final String RAR_NATIVEPATH = "rar.nativePath";
    private static ExceptionHandler localHandler = new LocalExceptionHandler();

    public J2CProviderNode(ClientContainerResourceRepositoryImpl clientContainerResourceRepositoryImpl) {
        this._ccr = clientContainerResourceRepositoryImpl;
        this._icon = new ImageIcon(this.getClass().getResource("images/J2CResourceAdapter.gif"));
    }

    public String toString() {
        return _providerType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddJ2CProvider");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private static String expandVar(String string, String string2) {
        string2 = string2.replace('\\', '/');
        return string.replaceAll("\\$\\{CONNECTOR_INSTALL_ROOT\\}", string2);
    }

    public static String appendSlashIfNeeded(String string) {
        String string2 = string;
        if (!string.endsWith("/") && !string.endsWith(File.separator)) {
            string2 = string2 + "/";
        }
        return string2;
    }

    public static J2CResourceAdapter getJ2CResourceAdapter(Hashtable hashtable, String string, String string2, ExceptionHandler exceptionHandler) {
        J2CResourceAdapter j2CResourceAdapter = null;
        String string3 = null;
        if (string2 == null) {
            String string4 = (String)hashtable.get(RAR_ARCHIVEPATH);
            if (string4 == null) {
                string4 = "";
            }
            if (string4.length() < 1) {
                string4 = "${CONNECTOR_INSTALL_ROOT}/";
            }
            string4 = J2CProviderNode.appendSlashIfNeeded(string4);
            String string5 = System.getProperty("com.ibm.ws.client.installedConnectors");
            string3 = string4;
            if (string5 != null) {
                string3 = J2CProviderNode.expandVar(string4, string5);
            }
        } else {
            string3 = J2CProviderNode.appendSlashIfNeeded(string2);
        }
        string3 = string3 + string;
        try {
            j2CResourceAdapter = ClientContainerResourceRepositoryImpl.createJ2CResourceAdapter(string3, hashtable);
        }
        catch (Exception exception) {
            exceptionHandler.handleException(exception);
        }
        return j2CResourceAdapter;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = 3337148004197089805L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame, false);
            if (bl) {
                J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)J2CProviderNode.this._ccr.findProvider(string, 8224);
                J2CProviderNode.this._j2cPanel = new J2CProviderPanel(j2CResourceAdapter);
                this.createButton.setActionCommand("Update");
            } else {
                J2CProviderNode.this._j2cPanel = new J2CProviderPanel();
            }
            this.setTitle(Utility.getMessage("helper.j2cProviderTitle"));
            this.createButton.addActionListener(new J2CProviderListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(J2CProviderNode.this._j2cPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("J2CPROVIDER");
            this.finishUp(n);
        }
    }

    public class J2CProviderPanel
    extends ProviderPanel {
        private static final long serialVersionUID = 2336293268028049101L;
        private JTextField nativePathField = this.addNextPropertyWithRemainder("helper.nativePath", "nativepathname", false);
        private JTextField archiveNameField;
        private JTextField archivePathField;

        public J2CProviderPanel() {
            this(false);
        }

        public J2CProviderPanel(boolean bl) {
            if (!bl) {
                this.archiveNameField = this.addNextPropertyWithRemainder("helper.archiveName", "archivename", true);
            }
            this.archivePathField = this.addNextPropertyWithRemainder("helper.archivePath", "archivepath", false);
        }

        public J2CProviderPanel(J2CResourceAdapter j2CResourceAdapter) {
            this(true);
            this.nameField.setText(j2CResourceAdapter.getName() != null ? j2CResourceAdapter.getName() : "");
            this.descField.setText(j2CResourceAdapter.getDescription() != null ? j2CResourceAdapter.getDescription() : "");
            this.classpathField.setText(j2CResourceAdapter.getClasspath().size() > 0 ? com.ibm.ws.client.applicationclient.Utility.getProviderClasspath(j2CResourceAdapter.getClasspath()) : "");
            EList eList = j2CResourceAdapter.getNativepath();
            this.nativePathField.setText(eList.size() > 0 ? com.ibm.ws.client.applicationclient.Utility.getProviderClasspath(eList) : "");
            String string = j2CResourceAdapter.getArchivePath();
            this.archivePathField.setText(string != null ? string : "");
            this.nameField.setEnabled(false);
            this.archivePathField.setEnabled(false);
        }

        public String getNativePath() {
            return this.nativePathField.getText().trim();
        }

        public String getArchivePath() {
            return this.archivePathField.getText().trim();
        }

        public String getArchiveName() {
            return this.archiveNameField.getText().trim();
        }
    }

    public class J2CProviderListener
    extends ProviderListener
    implements ActionListener {
        private J2CResourceAdapter getJ2CResourceAdapter() {
            String string;
            String string2;
            String string3;
            J2CResourceAdapter j2CResourceAdapter = null;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(J2CProviderNode.RAR_NAME, J2CProviderNode.this._j2cPanel.getName());
            String string4 = J2CProviderNode.this._j2cPanel.getDescription().trim();
            if (string4.length() > 0) {
                hashtable.put(J2CProviderNode.RAR_DESCRIPTION, string4);
            }
            if ((string3 = J2CProviderNode.this._j2cPanel.getArchivePath()) == null) {
                string3 = "";
            }
            if ((string3 = string3.trim()).length() > 0) {
                hashtable.put(J2CProviderNode.RAR_ARCHIVEPATH, string3);
            }
            if ((string2 = J2CProviderNode.this._j2cPanel.getClasspath().trim()).length() > 0) {
                hashtable.put(J2CProviderNode.RAR_CLASSPATH, string2);
            }
            if ((string = J2CProviderNode.this._j2cPanel.getNativePath().trim()).length() > 0) {
                hashtable.put(J2CProviderNode.RAR_NATIVEPATH, string);
            }
            j2CResourceAdapter = J2CProviderNode.getJ2CResourceAdapter(hashtable, J2CProviderNode.this._j2cPanel.getArchiveName(), null, localHandler);
            return j2CResourceAdapter;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((J2CProviderNode)J2CProviderNode.this)._serviceDialog.tabbedPane, actionEvent);
            if (this.reqd) {
                J2CResourceAdapter j2CResourceAdapter;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create") && (j2CResourceAdapter = this.getJ2CResourceAdapter()) != null) {
                    if (!J2CProviderNode.this._ccr.providerExists(j2CResourceAdapter.getName(), 32)) {
                        TreeNodes.createJ2CSubNodes(j2CResourceAdapter, J2CProviderNode.this._ccr);
                        J2CProviderNode.this._ccr.addProvider((J2EEResourceProvider)j2CResourceAdapter);
                        J2CProviderNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(J2CProviderNode.this._serviceDialog);
                        if (n == 2) {
                            J2CProviderNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    j2CResourceAdapter = (J2CResourceAdapter)J2CProviderNode.this._ccr.findProvider(J2CProviderNode.this._j2cPanel.getName(), 8224);
                    j2CResourceAdapter.setDescription(J2CProviderNode.this._j2cPanel.getDescription());
                    com.ibm.ws.client.applicationclient.Utility.setProviderClasspath(j2CResourceAdapter.getClasspath(), J2CProviderNode.this._j2cPanel.getClasspath());
                    com.ibm.ws.client.applicationclient.Utility.setProviderClasspath(j2CResourceAdapter.getNativepath(), J2CProviderNode.this._j2cPanel.getNativePath());
                    J2CProviderNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    private static class LocalExceptionHandler
    implements ExceptionHandler {
        private LocalExceptionHandler() {
        }

        public void handleException(Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getLocalizedMessage(), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
        }
    }

    public static interface ExceptionHandler {
        public void handleException(Exception var1);
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            J2CProviderNode.this._serviceDialog.dispose();
        }
    }
}

