/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class JDBCFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(JDBCFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private LocalServiceDialog _serviceDialog;
    private ClientContainerResourceRepository _ccr;
    private JDBCFactoryPanel _jdbcFactoryPanel;
    private ImageIcon _icon;
    private static final String _factoryType = "Data Sources";

    public JDBCFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/DataSource.gif"));
    }

    public String toString() {
        return _factoryType;
    }

    public static String getType() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddDSFactory");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = -1189903499022018176L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                WAS40DataSource wAS40DataSource = (WAS40DataSource)JDBCFactoryNode.this._ccr.findFactory(string, 1);
                JDBCFactoryNode.this._jdbcFactoryPanel = new JDBCFactoryPanel(wAS40DataSource);
                this.customPanel = new CustomPanel((J2EEResourceFactory)wAS40DataSource);
                this.createButton.setActionCommand("Update");
            } else {
                JDBCFactoryNode.this._jdbcFactoryPanel = new JDBCFactoryPanel();
            }
            this.setTitle(Utility.getMessage("helper.dataSourcePropertiesTitle"));
            this.createButton.addActionListener(new JDBCFactoryListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(JDBCFactoryNode.this._jdbcFactoryPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("JDBCFACTORY");
            this.finishUp(n);
        }
    }

    public class JDBCFactoryPanel
    extends FactoryPanel {
        private static final long serialVersionUID = -2742421322185681566L;
        JTextField databaseNameField = this.addNextPropertyWithRemainder("helper.databaseNameLabel", "databasename", false);
        JTextField userField = this.addNextPropertyWithRemainder("helper.userLabel", "user", false);
        JPasswordField passwordField = this.addNextPasswordProperty("helper.passwordLabel", "password", false);
        JPasswordField retypePasswordField = this.addNextPasswordProperty("helper.retypePasswordLabel", "retypepassword", false);

        public JDBCFactoryPanel() {
        }

        public JDBCFactoryPanel(WAS40DataSource wAS40DataSource) {
            this();
            String string = null;
            String string2 = null;
            J2EEResourcePropertySet j2EEResourcePropertySet = wAS40DataSource.getPropertySet();
            if (j2EEResourcePropertySet != null) {
                Iterator iterator = j2EEResourcePropertySet.getResourceProperties().iterator();
                while (iterator.hasNext()) {
                    J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)iterator.next();
                    if (j2EEResourceProperty.getName().equals("user")) {
                        string = j2EEResourceProperty.getValue();
                    }
                    if (!j2EEResourceProperty.getName().equals("password")) continue;
                    string2 = j2EEResourceProperty.getValue();
                }
            }
            this.nameField.setText(wAS40DataSource.getName() != null ? wAS40DataSource.getName() : "");
            this.descField.setText(wAS40DataSource.getDescription() != null ? wAS40DataSource.getDescription() : "");
            this.jndiNameField.setText(wAS40DataSource.getJndiName() != null ? wAS40DataSource.getJndiName() : "");
            this.databaseNameField.setText(wAS40DataSource.getDatabaseName());
            this.userField.setText(string != null ? string : "");
            this.passwordField.setText(string2 != null ? jDBCFactoryNode.decryptPassword(string2) : "");
            this.retypePasswordField.setText(string2 != null ? jDBCFactoryNode.decryptPassword(string2) : "");
            this.nameField.setEnabled(false);
        }

        public String getDatabaseName() {
            return this.databaseNameField.getText().trim();
        }

        public String getUser() {
            return this.userField.getText().trim();
        }

        public String getPassword() {
            return JDBCFactoryNode.this.encryptPassword(new String(this.passwordField.getPassword()));
        }

        public String getRetypePassword() {
            return JDBCFactoryNode.this.encryptPassword(new String(this.retypePasswordField.getPassword()));
        }

        public boolean isSetUserID() {
            return !this.userField.getText().trim().equals("");
        }

        public boolean isSetPassword() {
            return !new String(this.passwordField.getPassword()).trim().equals("");
        }

        public boolean isSetRetypePassword() {
            return !new String(this.retypePasswordField.getPassword()).trim().equals("");
        }
    }

    public class JDBCFactoryListener
    extends FactoryListener
    implements ActionListener {
        boolean passwordsMatch() {
            return JDBCFactoryNode.this.decryptPassword(JDBCFactoryNode.this._jdbcFactoryPanel.getPassword()).equals(JDBCFactoryNode.this.decryptPassword(JDBCFactoryNode.this._jdbcFactoryPanel.getRetypePassword()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((JDBCFactoryNode)JDBCFactoryNode.this)._serviceDialog.tabbedPane, actionEvent);
            boolean bl = this.passwordsMatch();
            if (!bl) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.passwordsMatch"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            }
            if (this.reqd && bl) {
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(JDBCFactoryNode.this._ccr, ((JDBCFactoryNode)JDBCFactoryNode.this)._serviceDialog.customPanel);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(JDBCFactoryNode.this._jdbcFactoryPanel.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                WAS40DataSource wAS40DataSource = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!JDBCFactoryNode.this._ccr.factoryExists(JDBCFactoryNode.this._jdbcFactoryPanel.getName(), 1)) {
                        J2EEResourceProperty j2EEResourceProperty;
                        wAS40DataSource = JDBCFactoryNode.this._ccr.createDataSource();
                        wAS40DataSource.setName(JDBCFactoryNode.this._jdbcFactoryPanel.getName());
                        if (JDBCFactoryNode.this._jdbcFactoryPanel.isSetUserID()) {
                            j2EEResourceProperty = JDBCFactoryNode.this._ccr.createJ2EEResourceProperty();
                            j2EEResourceProperty.setName("user");
                            j2EEResourceProperty.setValue(JDBCFactoryNode.this._jdbcFactoryPanel.getUser());
                            j2EEResourcePropertySet.getResourceProperties().add((Object)j2EEResourceProperty);
                        }
                        if (JDBCFactoryNode.this._jdbcFactoryPanel.isSetPassword()) {
                            j2EEResourceProperty = JDBCFactoryNode.this._ccr.createJ2EEResourceProperty();
                            j2EEResourceProperty.setName("password");
                            j2EEResourceProperty.setValue(JDBCFactoryNode.this._jdbcFactoryPanel.getPassword());
                            j2EEResourcePropertySet.getResourceProperties().add((Object)j2EEResourceProperty);
                        }
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        wAS40DataSource.setProvider(JDBCFactoryNode.this._ccr.findProvider(defaultMutableTreeNode2.getParent().toString(), 1));
                        wAS40DataSource.setDescription(JDBCFactoryNode.this._jdbcFactoryPanel.getDesc());
                        wAS40DataSource.setJndiName(JDBCFactoryNode.this._jdbcFactoryPanel.getJndiName());
                        wAS40DataSource.setDatabaseName(JDBCFactoryNode.this._jdbcFactoryPanel.getDatabaseName());
                        wAS40DataSource.setPropertySet(j2EEResourcePropertySet);
                        JDBCFactoryNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(JDBCFactoryNode.this._serviceDialog);
                        if (n == 2) {
                            JDBCFactoryNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    wAS40DataSource = (WAS40DataSource)JDBCFactoryNode.this._ccr.findFactory(defaultMutableTreeNode2.toString(), 1);
                    if (JDBCFactoryNode.this._jdbcFactoryPanel.isSetUserID()) {
                        J2EEResourceProperty j2EEResourceProperty = JDBCFactoryNode.this._ccr.createJ2EEResourceProperty();
                        j2EEResourceProperty.setName("user");
                        j2EEResourceProperty.setValue(JDBCFactoryNode.this._jdbcFactoryPanel.getUser());
                        j2EEResourcePropertySet.getResourceProperties().add((Object)j2EEResourceProperty);
                    }
                    if (JDBCFactoryNode.this._jdbcFactoryPanel.isSetPassword()) {
                        J2EEResourceProperty j2EEResourceProperty = JDBCFactoryNode.this._ccr.createJ2EEResourceProperty();
                        j2EEResourceProperty.setName("password");
                        j2EEResourceProperty.setValue(JDBCFactoryNode.this._jdbcFactoryPanel.getPassword());
                        j2EEResourcePropertySet.getResourceProperties().add((Object)j2EEResourceProperty);
                    }
                    wAS40DataSource.setDescription(JDBCFactoryNode.this._jdbcFactoryPanel.getDesc());
                    wAS40DataSource.setJndiName(JDBCFactoryNode.this._jdbcFactoryPanel.getJndiName());
                    wAS40DataSource.setDatabaseName(JDBCFactoryNode.this._jdbcFactoryPanel.getDatabaseName());
                    wAS40DataSource.setPropertySet(j2EEResourcePropertySet);
                    JDBCFactoryNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JDBCFactoryNode.this._serviceDialog.dispose();
        }
    }
}

