/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.JDBCFactoryNode;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ProviderListener;
import com.ibm.ws.client.ccrct.ProviderPanel;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class JDBCProviderNode
extends Node {
    private LocalServiceDialog _serviceDialog;
    private ClientContainerResourceRepository _ccr;
    private JDBCProviderPanel _jdbcPanel;
    private ImageIcon _icon;
    private static final String _providerType = "Data Source Providers";

    public JDBCProviderNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/JDBCdriver.gif"));
    }

    public String toString() {
        return _providerType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddDSProvider");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = 7994197144916983670L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                JDBCProvider jDBCProvider = (JDBCProvider)JDBCProviderNode.this._ccr.findProvider(string, 1);
                JDBCProviderNode.this._jdbcPanel = new JDBCProviderPanel(jDBCProvider);
                this.customPanel = new CustomPanel((J2EEResourceProvider)jDBCProvider);
                this.createButton.setActionCommand("Update");
            } else {
                JDBCProviderNode.this._jdbcPanel = new JDBCProviderPanel();
            }
            this.setTitle(Utility.getMessage("helper.dataSourceProviderPropertiesTitle"));
            this.createButton.addActionListener(new JDBCProviderListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(JDBCProviderNode.this._jdbcPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("JDBCPROVIDER");
            this.finishUp(n);
        }
    }

    public class JDBCProviderPanel
    extends ProviderPanel {
        private static final long serialVersionUID = -3514672825455162563L;
        private JTextField implClassNameField;

        public JDBCProviderPanel() {
            this.setName("JDBCProviderPanel");
            this.implClassNameField = this.addNextPropertyWithRemainder("helper.implementationClassLabel", "implclassname", false);
            this.setSize(300, 300);
        }

        public JDBCProviderPanel(JDBCProvider jDBCProvider) {
            this();
            this.nameField.setText(jDBCProvider.getName() != null ? jDBCProvider.getName() : "");
            this.descField.setText(jDBCProvider.getDescription() != null ? jDBCProvider.getDescription() : "");
            this.implClassNameField.setText(jDBCProvider.getImplementationClassName() != null ? jDBCProvider.getImplementationClassName() : "");
            this.classpathField.setText(jDBCProvider.getClasspath().size() > 0 ? com.ibm.ws.client.applicationclient.Utility.getProviderClasspath(jDBCProvider.getClasspath()) : "");
            this.nameField.setEnabled(false);
        }

        public String getImplClassName() {
            return this.implClassNameField.getText().trim();
        }
    }

    public class JDBCProviderListener
    extends ProviderListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((JDBCProviderNode)JDBCProviderNode.this)._serviceDialog.tabbedPane, actionEvent);
            if (this.reqd) {
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(JDBCProviderNode.this._ccr, ((JDBCProviderNode)JDBCProviderNode.this)._serviceDialog.customPanel);
                JDBCProvider jDBCProvider = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!JDBCProviderNode.this._ccr.providerExists(JDBCProviderNode.this._jdbcPanel.getName(), 63)) {
                        jDBCProvider = JDBCProviderNode.this._ccr.createJDBCProvider();
                        jDBCProvider.setName(JDBCProviderNode.this._jdbcPanel.getName());
                        jDBCProvider.setDescription(JDBCProviderNode.this._jdbcPanel.getDescription());
                        jDBCProvider.setImplementationClassName(JDBCProviderNode.this._jdbcPanel.getImplClassName());
                        com.ibm.ws.client.applicationclient.Utility.setProviderClasspath(jDBCProvider.getClasspath(), JDBCProviderNode.this._jdbcPanel.getClasspath());
                        jDBCProvider.setPropertySet(j2EEResourcePropertySet);
                        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(JDBCProviderNode.this._jdbcPanel.getName());
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new JDBCFactoryNode(JDBCProviderNode.this._ccr));
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
                        JDBCProviderNode.this._ccr.addProvider((J2EEResourceProvider)jDBCProvider);
                        JDBCProviderNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(JDBCProviderNode.this._serviceDialog);
                        if (n == 2) {
                            JDBCProviderNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    jDBCProvider = (JDBCProvider)JDBCProviderNode.this._ccr.findProvider(JDBCProviderNode.this._jdbcPanel.getName(), 1);
                    jDBCProvider.setDescription(JDBCProviderNode.this._jdbcPanel.getDescription());
                    jDBCProvider.setImplementationClassName(JDBCProviderNode.this._jdbcPanel.getImplClassName());
                    com.ibm.ws.client.applicationclient.Utility.setProviderClasspath(jDBCProvider.getClasspath(), JDBCProviderNode.this._jdbcPanel.getClasspath());
                    jDBCProvider.setPropertySet(j2EEResourcePropertySet);
                    JDBCProviderNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JDBCProviderNode.this._serviceDialog.dispose();
        }
    }
}

