/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jms.JMSProvider;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepositoryImpl;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.GenericJMSConnectionFactoryNode;
import com.ibm.ws.client.ccrct.GenericJMSDestinationFactoryNode;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ProviderListener;
import com.ibm.ws.client.ccrct.ProviderPanel;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class JMSProviderNode
extends Node {
    private LocalServiceDialog _serviceDialog;
    private ClientContainerResourceRepositoryImpl _ccr;
    private JMSProviderPanel _jmsPanel;
    private ImageIcon _icon;
    private static final String _providerType = "Messaging Providers";

    public JMSProviderNode(ClientContainerResourceRepositoryImpl clientContainerResourceRepositoryImpl) {
        this._ccr = clientContainerResourceRepositoryImpl;
        this._icon = new ImageIcon(this.getClass().getResource("images/JMSProvider.gif"));
    }

    public String toString() {
        return _providerType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddJMSProvider");
    }

    public String getToolTipTextIfParent(String string) {
        String string2 = string.equals("WebSphere MQ Provider") || string.equals("Version 5 Default Provider") || string.equals("Default Provider") ? Utility.getMessage("tree.tttProps") : Utility.getMessage("tree.tttPropsAndDelete");
        return string2;
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = -3080851923337989652L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                if (string.equals("Default Provider")) {
                    J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)JMSProviderNode.this._ccr.findProvider(string, 4128);
                    JMSProviderNode.this._jmsPanel = new JMSProviderPanel(j2CResourceAdapter);
                    this.customPanel = new CustomPanel((J2EEResourceProvider)j2CResourceAdapter);
                } else {
                    JMSProvider jMSProvider = (JMSProvider)JMSProviderNode.this._ccr.findProvider(string, 2);
                    JMSProviderNode.this._jmsPanel = new JMSProviderPanel(jMSProvider);
                    this.customPanel = new CustomPanel((J2EEResourceProvider)jMSProvider);
                }
                this.createButton.setActionCommand("Update");
            } else {
                JMSProviderNode.this._jmsPanel = new JMSProviderPanel();
            }
            this.setTitle(Utility.getMessage("helper.jmsProviderTitle"));
            this.createButton.addActionListener(new JMSProviderListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(JMSProviderNode.this._jmsPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("JMSPROVIDER");
            this.finishUp(n);
        }
    }

    public class JMSProviderPanel
    extends ProviderPanel {
        private static final long serialVersionUID = -2026175726410595070L;
        private JTextField contextFactoryClassnameField;
        private JTextField providerURLField;

        public JMSProviderPanel() {
            this.contextFactoryClassnameField = this.addNextPropertyWithRemainder("helper.contextFactoryClassLabel", "contextfactoryclassname", false);
            this.providerURLField = this.addNextPropertyWithRemainder("helper.providerUrlLabel", "providerurl", false);
        }

        public JMSProviderPanel(JMSProvider jMSProvider) {
            this();
            this.nameField.setText(jMSProvider.getName() != null ? jMSProvider.getName() : "");
            this.descField.setText(jMSProvider.getDescription() != null ? jMSProvider.getDescription() : "");
            this.contextFactoryClassnameField.setText(jMSProvider.getExternalInitialContextFactory() != null ? jMSProvider.getExternalInitialContextFactory() : "");
            this.providerURLField.setText(jMSProvider.getExternalProviderURL() != null ? jMSProvider.getExternalProviderURL() : "");
            this.classpathField.setText(jMSProvider.getClasspath().size() > 0 ? com.ibm.ws.client.applicationclient.Utility.getProviderClasspath(jMSProvider.getClasspath()) : "");
            this.nameField.setEnabled(false);
            String string = jMSProvider.getName();
            if (string.equals("WebSphere MQ Provider") || string.equals("Version 5 Default Provider")) {
                this.descField.setEnabled(false);
            }
        }

        public JMSProviderPanel(J2CResourceAdapter j2CResourceAdapter) {
            super(false);
            this.nameField.setText(j2CResourceAdapter.getName() != null ? j2CResourceAdapter.getName() : "");
            this.descField.setText(j2CResourceAdapter.getDescription() != null ? j2CResourceAdapter.getDescription() : "");
            this.nameField.setEnabled(false);
            this.descField.setEnabled(false);
        }

        public String getContextFactoryClassname() {
            return this.contextFactoryClassnameField.getText().trim();
        }

        public String getProviderURL() {
            return this.providerURLField.getText().trim();
        }
    }

    public class JMSProviderListener
    extends ProviderListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((JMSProviderNode)JMSProviderNode.this)._serviceDialog.tabbedPane, actionEvent);
            if (this.reqd) {
                Object object;
                JMSProvider jMSProvider = null;
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(JMSProviderNode.this._ccr, ((JMSProviderNode)JMSProviderNode.this)._serviceDialog.customPanel);
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!JMSProviderNode.this._ccr.providerExists(JMSProviderNode.this._jmsPanel.getName(), 63)) {
                        jMSProvider = JMSProviderNode.this._ccr.createJMSProvider();
                        jMSProvider.setName(JMSProviderNode.this._jmsPanel.getName());
                        jMSProvider.setDescription(JMSProviderNode.this._jmsPanel.getDescription());
                        jMSProvider.setExternalInitialContextFactory(JMSProviderNode.this._jmsPanel.getContextFactoryClassname());
                        jMSProvider.setExternalProviderURL(JMSProviderNode.this._jmsPanel.getProviderURL());
                        com.ibm.ws.client.applicationclient.Utility.setProviderClasspath(jMSProvider.getClasspath(), JMSProviderNode.this._jmsPanel.getClasspath());
                        jMSProvider.setPropertySet(j2EEResourcePropertySet);
                        object = new DefaultMutableTreeNode(JMSProviderNode.this._jmsPanel.getName());
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GenericJMSConnectionFactoryNode(JMSProviderNode.this._ccr));
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new GenericJMSDestinationFactoryNode(JMSProviderNode.this._ccr));
                        Globals.getTreeModel().insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode2, (MutableTreeNode)object, 0);
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode3, (MutableTreeNode)object, 1);
                        JMSProviderNode.this._ccr.addProvider((J2EEResourceProvider)jMSProvider);
                        JMSProviderNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(JMSProviderNode.this._serviceDialog);
                        if (n == 2) {
                            JMSProviderNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    object = JMSProviderNode.this._jmsPanel.getName();
                    if (!((String)object).equals("Default Provider")) {
                        jMSProvider = (JMSProvider)JMSProviderNode.this._ccr.findProvider((String)object, 2);
                        jMSProvider.setDescription(JMSProviderNode.this._jmsPanel.getDescription());
                        jMSProvider.setExternalInitialContextFactory(JMSProviderNode.this._jmsPanel.getContextFactoryClassname());
                        jMSProvider.setExternalProviderURL(JMSProviderNode.this._jmsPanel.getProviderURL());
                        com.ibm.ws.client.applicationclient.Utility.setProviderClasspath(jMSProvider.getClasspath(), JMSProviderNode.this._jmsPanel.getClasspath());
                        jMSProvider.setPropertySet(j2EEResourcePropertySet);
                    }
                    JMSProviderNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JMSProviderNode.this._serviceDialog.dispose();
        }
    }
}

