/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.ConnectionFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQBrokerMsgSelection;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQBrokerType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQCFMulticastType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQCleanupType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQDirectAuthType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQSubstoreType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTransportType;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.ConnectionFactoryNode;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class MQConnectionFactoryNode
extends ConnectionFactoryNode {
    private static final TraceComponent tc = Tr.register(MQConnectionFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    protected MQConnectionFactoryPanel _mqConnectionFactoryPanel;
    private static final String _factoryType = "Connection Factories";
    protected static final int QUEUE_CF = 1;
    protected static final int TOPIC_CF = 2;
    protected static final int UNIFIED_CF = 3;
    private int _type = 3;
    private static final String DEFAULT_TRANSPORT_TYPE = "CLIENT";
    private static final String[] TOPIC_TRANSPORT_TYPES = new String[]{"CLIENT", "BINDINGS", "DIRECT"};
    private static final String[] QUEUE_TRANSPORT_TYPES = new String[]{"CLIENT", "BINDINGS"};

    public MQConnectionFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        super(clientContainerResourceRepository);
        this._type = 3;
    }

    protected MQConnectionFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository, int n) {
        super(clientContainerResourceRepository);
        this._type = n;
    }

    public String toString() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 3, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddCFactory");
    }

    private boolean isType(int n, int n2) {
        return 0 != (n & n2);
    }

    private void turnFieldOff(JComboBox jComboBox) {
        jComboBox.setSelectedIndex(-1);
        jComboBox.setEditable(false);
        jComboBox.setBackground(Color.lightGray);
        jComboBox.setEnabled(false);
    }

    private void turnFieldOn(JComboBox jComboBox) {
        jComboBox.setSelectedIndex(0);
        jComboBox.setEditable(true);
        jComboBox.setBackground(Color.white);
        jComboBox.setEnabled(true);
    }

    private void turnFieldOff(JTextField jTextField) {
        jTextField.setText("");
        jTextField.setEditable(false);
        jTextField.setBackground(Color.lightGray);
        jTextField.setEnabled(false);
    }

    private void turnFieldOn(JTextField jTextField) {
        jTextField.setEditable(true);
        jTextField.setBackground(Color.white);
        jTextField.setEnabled(true);
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = -4552203552691853027L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                MQConnectionFactory mQConnectionFactory = (MQConnectionFactory)MQConnectionFactoryNode.this._ccr.findFactory(string, 2);
                MQConnectionFactoryNode.this._mqConnectionFactoryPanel = new MQConnectionFactoryPanel(mQConnectionFactory);
                this.customPanel = new CustomPanel((J2EEResourceFactory)mQConnectionFactory);
                this.createButton.setActionCommand("Update");
            } else {
                MQConnectionFactoryNode.this._mqConnectionFactoryPanel = new MQConnectionFactoryPanel();
            }
            this.setTitle(Utility.getMessage("helper.CFpropTitle"));
            this.createButton.addActionListener(new MQConnectionFactoryListener());
            this.cancelButton.addActionListener(new ConnectionFactoryNode.CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(MQConnectionFactoryNode.this._mqConnectionFactoryPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("MQCONNECTIONFACTORY");
            this.finishUp(n);
        }
    }

    public class MQConnectionFactoryPanel
    extends ConnectionFactoryNode.ConnectionFactoryPanel {
        private static final long serialVersionUID = 5184295496767316978L;
        JTextField queueManagerField = this.addNextPropertyWithRemainder("helper.queueManagerLabel", "queuemanager", false);
        JTextField hostField = this.addNextPropertyWithRemainder("helper.hostLabel", "host", false);
        JTextField portField;
        JTextField channelField;
        JComboBox transportTypeField;
        JTextField clientIDField;
        JTextField CCSIDField;
        JCheckBox msgRetentionCheckBox;
        JTextField tempModelField;
        JTextField brokerControlQueueField;
        JTextField brokerQueueManagerField;
        JTextField brokerPubQueueField;
        JTextField brokerSubQueueField;
        JTextField brokerCCSubQField;
        JComboBox brokerVersionField;
        JCheckBox failIfQuiesceField;
        JTextField localAddressField;
        JTextField pollingIntervalField;
        JTextField rescanIntervalField;
        JTextField SSLCipherSuiteField;
        JTextField SSLCertStoreField;
        JTextField SSLPeerNameField;
        JTextField tempQPrefixField;
        JCheckBox useConnPoolingField;
        JComboBox cleanupLevelField;
        JTextField cleanupIntervalField;
        JComboBox msgSelectionField;
        JTextField pubAckIntervalField;
        JCheckBox sparseSubscriptionsField;
        JTextField statRefreshIntervalField;
        JComboBox subStoreField;
        JComboBox multicastField;
        JComboBox directAuthField;
        JTextField proxyHostNameField;
        JTextField proxyPortField;

        private void setFieldsBasedOnTransportType(String string) {
            if (string.equals("BINDINGS")) {
                this.getNonRequiredBorder(this.queueManagerField);
                MQConnectionFactoryNode.this.turnFieldOff(this.hostField);
                this.getNonRequiredBorder(this.hostField);
                MQConnectionFactoryNode.this.turnFieldOff(this.portField);
                this.getNonRequiredBorder(this.portField);
                MQConnectionFactoryNode.this.turnFieldOff(this.channelField);
                if (MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 2)) {
                    MQConnectionFactoryNode.this.turnFieldOff(this.multicastField);
                    this.brokerVersionField.setEnabled(true);
                    this.brokerVersionField.setBackground(Color.white);
                }
            } else if (string.equals("DIRECT")) {
                this.getRequiredBorder(this.queueManagerField);
                MQConnectionFactoryNode.this.turnFieldOn(this.hostField);
                this.getRequiredBorder(this.hostField);
                MQConnectionFactoryNode.this.turnFieldOn(this.portField);
                this.getRequiredBorder(this.portField);
                MQConnectionFactoryNode.this.turnFieldOff(this.channelField);
                MQConnectionFactoryNode.this.turnFieldOn(this.multicastField);
                this.brokerVersionField.setSelectedIndex(0);
                this.brokerVersionField.setEnabled(false);
                this.brokerVersionField.setBackground(Color.lightGray);
            } else {
                this.getRequiredBorder(this.queueManagerField);
                MQConnectionFactoryNode.this.turnFieldOn(this.hostField);
                this.getRequiredBorder(this.hostField);
                MQConnectionFactoryNode.this.turnFieldOn(this.portField);
                this.getRequiredBorder(this.portField);
                MQConnectionFactoryNode.this.turnFieldOn(this.channelField);
                if (MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 2)) {
                    MQConnectionFactoryNode.this.turnFieldOff(this.multicastField);
                    this.brokerVersionField.setEnabled(true);
                    this.brokerVersionField.setBackground(Color.white);
                }
            }
        }

        public MQConnectionFactoryPanel() {
            MQConnectionFactoryNode.this.turnFieldOff(this.hostField);
            this.portField = this.addNextPropertyWithRemainder("helper.portLabel", "port", false);
            MQConnectionFactoryNode.this.turnFieldOff(this.portField);
            this.channelField = this.addNextPropertyWithRemainder("helper.channelLabel", "channel", false);
            MQConnectionFactoryNode.this.turnFieldOff(this.channelField);
            String[] stringArray = MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 2) ? TOPIC_TRANSPORT_TYPES : QUEUE_TRANSPORT_TYPES;
            this.transportTypeField = new JComboBox<String>(stringArray);
            this.transportTypeField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    MQConnectionFactoryPanel.this.setFieldsBasedOnTransportType(string);
                }
            });
            this.addNextProperty(this.transportTypeField, "helper.transportTypeLabel", "transportType", true, true);
            this.clientIDField = this.addNextPropertyWithRemainder("helper.clientIdLabel", "clientID", false);
            this.CCSIDField = this.addNextPropertyWithRemainder("helper.ccsidLabel", "ccsid", false);
            if (MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 1)) {
                this.msgRetentionCheckBox = new JCheckBox();
                this.addNextPropertyNoBorder(this.msgRetentionCheckBox, "helper.msgRetentionLabel", "msgRetention", true);
                this.tempModelField = this.addNextProperty("helper.temporaryModelLabel", "tempModel", false);
                this.tempQPrefixField = this.addNextProperty("helper.tempQPrefix", "tempQPrefix", false);
            }
            if (MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 2)) {
                this.brokerControlQueueField = this.addNextProperty("helper.brokerControlQueueLabel", "brokerControlQueue", false);
                this.brokerQueueManagerField = this.addNextProperty("helper.brokerQueueManagerLabel", "brokerQueueManager", false);
                this.brokerPubQueueField = this.addNextProperty("helper.brokerPubQueueLabel", "brokerPubQueue", false);
                this.brokerSubQueueField = this.addNextProperty("helper.brokerSubQueueLabel", "brokerSubQueue", false);
                this.brokerCCSubQField = this.addNextProperty("helper.brokerCCSubQLabel", "brokerCCSubQ", false);
                String[] stringArray2 = new String[]{Utility.getMessage("helper.brokerVersionAdvanced"), Utility.getMessage("helper.brokerVersionBasic")};
                this.brokerVersionField = new JComboBox<String>(stringArray2);
                this.addNextProperty(this.brokerVersionField, "helper.brokerVersionLabel", "brokerVersion", true, true);
                String[] stringArray3 = new String[]{"SAFE", "ASPROP", "NONE", "STRONG"};
                this.cleanupLevelField = new JComboBox<String>(stringArray3);
                this.addNextProperty(this.cleanupLevelField, "helper.pubSubCleanup", "pubSubCleanup", false, true);
                this.cleanupIntervalField = this.addNextProperty("helper.pubSubCleanupInterval", "pubSubCleanupInterval", false);
                String[] stringArray4 = new String[]{MQConnectionFactoryNode.DEFAULT_TRANSPORT_TYPE, "BROKER"};
                this.msgSelectionField = new JComboBox<String>(stringArray4);
                this.addNextProperty(this.msgSelectionField, "helper.msgSelection", "msgSelection", false, true);
                this.pubAckIntervalField = this.addNextProperty("helper.pubAckInterval", "pubAckInterval", false);
                this.sparseSubscriptionsField = new JCheckBox();
                this.sparseSubscriptionsField.setSelected(false);
                this.addNextPropertyNoBorder(this.sparseSubscriptionsField, "helper.sparseSubs", "sparseSubs", false);
                this.statRefreshIntervalField = this.addNextProperty("helper.statRefreshInterval", "statRefreshInterval", false);
                String[] stringArray5 = new String[]{"MIGRATE", "QUEUE", "BROKER"};
                this.subStoreField = new JComboBox<String>(stringArray5);
                this.addNextProperty(this.subStoreField, "helper.subStore", "substore", false, true);
                String[] stringArray6 = new String[]{"DISABLED", "NOT_RELIABLE", "RELIABLE", "ENABLED"};
                this.multicastField = new JComboBox<String>(stringArray6);
                this.addNextProperty(this.multicastField, "helper.multicast", "multicast", false, true);
                String[] stringArray7 = new String[]{"BASIC", "CERTIFICATE"};
                this.directAuthField = new JComboBox<String>(stringArray7);
                this.addNextProperty(this.directAuthField, "helper.directAuth", "directAuth", false, true);
                this.proxyHostNameField = this.addNextProperty("helper.proxyHostName", "proxyHostName", false);
                this.proxyPortField = this.addNextProperty("helper.proxyPort", "proxyPort", false);
            }
            this.failIfQuiesceField = new JCheckBox();
            this.failIfQuiesceField.setSelected(true);
            this.addNextPropertyNoBorder(this.failIfQuiesceField, "helper.failIfQuiesce", "failIfQuiesce", false);
            this.localAddressField = this.addNextProperty("helper.localAddress", "localAddress", false);
            this.pollingIntervalField = this.addNextProperty("helper.pollingInterval", "pollingInterval", false);
            this.rescanIntervalField = this.addNextProperty("helper.rescanInterval", "rescanInterval", false);
            this.SSLCipherSuiteField = this.addNextProperty("helper.SSLCipherSuite", "sslCipherSuite", false);
            this.SSLCertStoreField = this.addNextProperty("helper.SSLCertStore", "sslCertStore", false);
            this.SSLPeerNameField = this.addNextProperty("helper.SSLPeerName", "sslPeerName", false);
            this.useConnPoolingField = new JCheckBox();
            this.useConnPoolingField.setSelected(true);
            this.addNextPropertyNoBorder(this.useConnPoolingField, "helper.useConnPooling", "useConnPooling", false);
            this.setFieldsBasedOnTransportType(MQConnectionFactoryNode.DEFAULT_TRANSPORT_TYPE);
        }

        protected void setCommonCFFields(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n, String string7, boolean bl2, MQTransportType mQTransportType, String string8, String string9, boolean bl3, String string10, boolean bl4, int n2, String string11, String string12, String string13, boolean bl5, boolean bl6, int n3) {
            this.nameField.setText(string != null ? string : "");
            this.nameField.setEnabled(false);
            this.descField.setText(string2 != null ? string2 : "");
            this.jndiNameField.setText(string3 != null ? string3 : "");
            this.setUseridandPassword(string4, string4 != null);
            this.queueManagerField.setText(string5 != null ? string5 : "");
            this.hostField.setText(string6 != null ? string6 : "");
            this.portField.setText(bl ? Integer.toString(n) : "");
            this.channelField.setText(string7 != null ? string7 : "");
            this.transportTypeField.setSelectedItem(bl2 ? mQTransportType.getName() : "");
            this.clientIDField.setText(string8 != null ? string8 : "");
            this.CCSIDField.setText(string9 != null ? string9 : "");
            this.failIfQuiesceField.setSelected(bl3);
            this.localAddressField.setText(string10 != null ? string10 : "");
            this.pollingIntervalField.setText(bl4 ? Integer.toString(n2) : "");
            this.rescanIntervalField.setText(bl6 ? Integer.toString(n3) : "");
            this.SSLCipherSuiteField.setText(string11 != null ? string11 : "");
            this.SSLCertStoreField.setText(string12 != null ? string12 : "");
            this.SSLPeerNameField.setText(string13 != null ? string13 : "");
            this.useConnPoolingField.setSelected(bl5);
        }

        protected void setQueueCFFields(boolean bl, String string, String string2) {
            this.msgRetentionCheckBox.setSelected(bl);
            this.tempModelField.setText(string != null ? string : "");
            this.tempQPrefixField.setText(string2 != null ? string2 : "");
        }

        protected void setTopicCFFields(String string, String string2, String string3, String string4, String string5, boolean bl, MQBrokerType mQBrokerType, boolean bl2, MQCleanupType mQCleanupType, boolean bl3, long l, boolean bl4, MQBrokerMsgSelection mQBrokerMsgSelection, boolean bl5, int n, boolean bl6, boolean bl7, int n2, boolean bl8, MQSubstoreType mQSubstoreType, boolean bl9, MQCFMulticastType mQCFMulticastType, boolean bl10, MQDirectAuthType mQDirectAuthType, String string6, boolean bl11, int n3) {
            this.brokerControlQueueField.setText(string != null ? string : "");
            this.brokerQueueManagerField.setText(string2 != null ? string2 : "");
            this.brokerPubQueueField.setText(string3 != null ? string3 : "");
            this.brokerSubQueueField.setText(string4 != null ? string4 : "");
            this.brokerCCSubQField.setText(string5 != null ? string5 : "");
            this.brokerVersionField.setSelectedIndex(bl ? this.mapBrokerVersion(mQBrokerType.getValue()) : 1);
            this.cleanupLevelField.setSelectedItem(bl2 ? mQCleanupType.getName() : "");
            this.cleanupIntervalField.setText(bl3 ? Long.toString(l) : "");
            this.msgSelectionField.setSelectedItem(bl4 ? mQBrokerMsgSelection.getName() : "");
            this.pubAckIntervalField.setText(bl5 ? Integer.toString(n) : "");
            this.sparseSubscriptionsField.setSelected(bl6);
            this.statRefreshIntervalField.setText(bl7 ? Integer.toString(n2) : "");
            this.subStoreField.setSelectedItem(bl8 ? mQSubstoreType.getName() : "");
            this.multicastField.setSelectedItem(bl9 ? mQCFMulticastType.getName() : "");
            this.directAuthField.setSelectedItem(bl10 ? mQDirectAuthType.getName() : "");
            this.proxyHostNameField.setText(string6 != null ? string6 : "");
            this.proxyPortField.setText(bl11 ? Integer.toString(n3) : "");
        }

        public MQConnectionFactoryPanel(MQConnectionFactory mQConnectionFactory) {
            this();
            this.setCommonCFFields(mQConnectionFactory.getName(), mQConnectionFactory.getDescription(), mQConnectionFactory.getJndiName(), mQConnectionFactory.getAuthDataAlias(), mQConnectionFactory.getQueueManager(), mQConnectionFactory.getHost(), mQConnectionFactory.isSetPort(), mQConnectionFactory.getPort(), mQConnectionFactory.getChannel(), mQConnectionFactory.isSetTransportType(), mQConnectionFactory.getTransportType(), mQConnectionFactory.getClientID(), mQConnectionFactory.getCCSID(), mQConnectionFactory.isFailIfQuiesce(), mQConnectionFactory.getLocalAddress(), mQConnectionFactory.isSetPollingInterval(), mQConnectionFactory.getPollingInterval(), mQConnectionFactory.getSslCipherSuite(), mQConnectionFactory.getSslCRL(), mQConnectionFactory.getSslPeerName(), mQConnectionFactory.isUseConnectionPooling(), mQConnectionFactory.isSetRescanInterval(), mQConnectionFactory.getRescanInterval());
            this.setQueueCFFields(mQConnectionFactory.isMsgRetention(), mQConnectionFactory.getTempModel(), mQConnectionFactory.getTempQueuePrefix());
            this.setTopicCFFields(mQConnectionFactory.getBrokerControlQueue(), mQConnectionFactory.getBrokerQueueManager(), mQConnectionFactory.getBrokerPubQueue(), mQConnectionFactory.getBrokerSubQueue(), mQConnectionFactory.getBrokerCCSubQ(), mQConnectionFactory.isSetBrokerVersion(), mQConnectionFactory.getBrokerVersion(), mQConnectionFactory.isSetPubSubCleanup(), mQConnectionFactory.getPubSubCleanup(), mQConnectionFactory.isSetPubSubCleanupInterval(), mQConnectionFactory.getPubSubCleanupInterval(), mQConnectionFactory.isSetMsgSelection(), mQConnectionFactory.getMsgSelection(), mQConnectionFactory.isSetPublishAckInterval(), mQConnectionFactory.getPublishAckInterval(), mQConnectionFactory.isSparseSubscriptions(), mQConnectionFactory.isSetStatRefreshInterval(), mQConnectionFactory.getStatRefreshInterval(), mQConnectionFactory.isSetSubstore(), mQConnectionFactory.getSubstore(), mQConnectionFactory.isSetMulticast(), mQConnectionFactory.getMulticast(), mQConnectionFactory.isSetDirectAuth(), mQConnectionFactory.getDirectAuth(), mQConnectionFactory.getProxyHostName(), mQConnectionFactory.isSetProxyPort(), mQConnectionFactory.getProxyPort());
        }

        public String getQueueManager() {
            return this.queueManagerField.getText().trim();
        }

        public String getHost() {
            return this.hostField.getText().trim();
        }

        public String getPort() {
            return this.portField.getText().trim();
        }

        public String getChannel() {
            return this.channelField.getText().trim();
        }

        public String getClientID() {
            return this.clientIDField.getText().trim();
        }

        public String getCCSID() {
            return this.CCSIDField.getText().trim();
        }

        public String getTransportType() {
            return this.transportTypeField.getSelectedItem().toString();
        }

        public boolean getMsgRetention() {
            return this.msgRetentionCheckBox.isSelected();
        }

        public String getBrokerControlQueue() {
            return this.brokerControlQueueField.getText().trim();
        }

        public String getBrokerQueueManager() {
            return this.brokerQueueManagerField.getText().trim();
        }

        public String getBrokerPubQueue() {
            return this.brokerPubQueueField.getText().trim();
        }

        public String getBrokerSubQueue() {
            return this.brokerSubQueueField.getText().trim();
        }

        public String getBrokerCCSubQ() {
            return this.brokerCCSubQField.getText().trim();
        }

        public String getBrokerVersion() {
            if (this.brokerVersionField.getSelectedIndex() == 1) {
                return "MA0C";
            }
            return "MQSI";
        }

        protected String getPollingInterval() {
            return this.pollingIntervalField.getText().trim();
        }

        protected String getRescanInterval() {
            return this.rescanIntervalField.getText().trim();
        }

        protected String getCleanupInterval() {
            return this.cleanupIntervalField.getText().trim();
        }

        protected String getPubAckInterval() {
            return this.pubAckIntervalField.getText().trim();
        }

        protected String getStatusRefreshInterval() {
            return this.statRefreshIntervalField.getText().trim();
        }

        protected String getProxyPort() {
            return this.proxyPortField.getText().trim();
        }

        protected String getTempModel() {
            return this.tempModelField.getText().trim();
        }

        protected String getTempQPrefix() {
            return this.tempQPrefixField.getText().trim();
        }

        protected boolean getFailIfQuiesce() {
            return this.failIfQuiesceField.isSelected();
        }

        protected String getLocalAddress() {
            return this.localAddressField.getText().trim();
        }

        protected String getSSLCipherSuite() {
            return this.SSLCipherSuiteField.getText().trim();
        }

        protected String getSSLCertStore() {
            return this.SSLCertStoreField.getText().trim();
        }

        protected String getSSLPeerName() {
            return this.SSLPeerNameField.getText().trim();
        }

        protected boolean getUseConnectionPooling() {
            return this.useConnPoolingField.isSelected();
        }

        protected String getCleanupLevel() {
            return this.cleanupLevelField.getSelectedItem().toString();
        }

        protected String getMsgSelection() {
            return this.msgSelectionField.getSelectedItem().toString();
        }

        protected boolean getSparseSubscriptions() {
            return this.sparseSubscriptionsField.isSelected();
        }

        protected String getSubStore() {
            return this.subStoreField.getSelectedItem().toString();
        }

        protected String getMulticast() {
            String string = null;
            Object object = this.multicastField.getSelectedItem();
            if (object != null) {
                string = object.toString();
            }
            return string;
        }

        protected String getDirectAuth() {
            return this.directAuthField.getSelectedItem().toString();
        }

        protected String getProxyHostName() {
            return this.proxyHostNameField.getText().trim();
        }

        public boolean isSetQueueManager() {
            return !this.queueManagerField.getText().trim().equals("");
        }

        public boolean isSetHost() {
            return !this.hostField.getText().trim().equals("");
        }

        public boolean isSetPort() {
            return !this.portField.getText().trim().equals("");
        }

        public boolean isSetChannel() {
            return !this.channelField.getText().trim().equals("");
        }

        public boolean isSetClientID() {
            return !this.clientIDField.getText().trim().equals("");
        }

        public boolean isSetCCSID() {
            return !this.CCSIDField.getText().trim().equals("");
        }

        public boolean isSetTransportType() {
            return this.transportTypeField.getSelectedItem().toString() != null;
        }

        public boolean isSetBrokerControlQueue() {
            return !this.brokerControlQueueField.getText().trim().equals("");
        }

        public boolean isSetBrokerQueueManager() {
            return !this.brokerQueueManagerField.getText().trim().equals("");
        }

        public boolean isSetBrokerPubQueue() {
            return !this.brokerPubQueueField.getText().trim().equals("");
        }

        public boolean isSetBrokerSubQueue() {
            return !this.brokerSubQueueField.getText().trim().equals("");
        }

        public boolean isSetBrokerCCSubQ() {
            return !this.brokerCCSubQField.getText().trim().equals("");
        }

        public boolean isSetBrokerVersion() {
            return this.brokerVersionField.getSelectedItem().toString() != null;
        }

        protected int mapBrokerVersion(int n) {
            if (n == 1) {
                return 1;
            }
            return 0;
        }
    }

    public class MQConnectionFactoryListener
    extends FactoryListener
    implements ActionListener {
        protected boolean passwordsMatch() {
            return MQConnectionFactoryNode.this.decryptPassword(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPassword()).equals(MQConnectionFactoryNode.this.decryptPassword(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getRetypePassword()));
        }

        private boolean isValidIntegerGESpecifiedMinimum(String string, int n) {
            boolean bl;
            block6: {
                bl = false;
                if (!string.equals("")) {
                    if (string.length() != 0) {
                        try {
                            int n2 = Integer.parseInt(string);
                            if (n2 > Integer.MAX_VALUE || n2 < n) {
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                        }
                    }
                } else {
                    bl = true;
                }
            }
            return bl;
        }

        private boolean isValidLongGESpecifiedMinimum(String string, long l) {
            boolean bl;
            block6: {
                bl = false;
                if (!string.equals("")) {
                    if (string.length() != 0) {
                        try {
                            long l2 = Long.parseLong(string);
                            if (l2 > Long.MAX_VALUE || l2 < l) {
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                        }
                    }
                } else {
                    bl = true;
                }
            }
            return bl;
        }

        private boolean isValidPositiveInteger(String string) {
            return this.isValidIntegerGESpecifiedMinimum(string, 0);
        }

        private boolean isValidPositiveLong(String string) {
            return this.isValidLongGESpecifiedMinimum(string, 0L);
        }

        private boolean isValidInteger(String string) {
            return this.isValidIntegerGESpecifiedMinimum(string, Integer.MIN_VALUE);
        }

        protected boolean checkPort() {
            return this.isValidPositiveInteger(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPort());
        }

        protected boolean checkPollingInterval() {
            return this.isValidPositiveInteger(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPollingInterval());
        }

        protected boolean checkCleanupInterval() {
            return this.isValidPositiveLong(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getCleanupInterval());
        }

        protected boolean checkPublishAckInterval() {
            return this.isValidPositiveInteger(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPubAckInterval());
        }

        protected boolean checkStatRefreshInterval() {
            return this.isValidPositiveInteger(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getStatusRefreshInterval());
        }

        protected boolean checkCCSID() {
            return this.isValidInteger(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getCCSID());
        }

        protected boolean checkProxyPort() {
            return this.isValidInteger(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getProxyPort());
        }

        protected boolean checkRescanInterval() {
            return this.isValidInteger(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getRescanInterval());
        }

        protected boolean jmsRequired() {
            return !MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getTransportType().equals(MQConnectionFactoryNode.DEFAULT_TRANSPORT_TYPE) || !MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getQueueManager().equals("") && !MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPort().equals("") && !MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getHost().equals("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(MQConnectionFactoryNode.this._serviceDialog.tabbedPane, actionEvent);
            if (this.reqd) {
                if (!this.passwordsMatch()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.passwordsMatch"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (!this.checkPort()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.portValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (!this.checkCCSID()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.ccsidValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 2) && !this.checkCleanupInterval()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.cleanupIntervalValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 2) && !this.checkPublishAckInterval()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.pubAckIntervalValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 2) && !this.checkStatRefreshInterval()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.statRefreshIntervalValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (!this.checkPollingInterval()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.pollingIntervalValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (!this.checkRescanInterval()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.rescanIntervalValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (MQConnectionFactoryNode.this.isType(MQConnectionFactoryNode.this._type, 2) && !this.checkProxyPort()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.proxyPortValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else if (!this.jmsRequired()) {
                    JOptionPane.showMessageDialog(null, Utility.getMessage("helper.requiredAttributes"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
                } else {
                    this.processPanel(actionEvent);
                }
            }
        }

        protected boolean isSet(String string) {
            return !string.equals("");
        }

        protected String valueToSet(String string) {
            String string2 = this.isSet(string) ? string : null;
            return string2;
        }

        protected void processPanel(ActionEvent actionEvent) {
            Object object;
            J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(MQConnectionFactoryNode.this._ccr, MQConnectionFactoryNode.this._serviceDialog.customPanel);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
            MQConnectionFactory mQConnectionFactory = null;
            boolean bl = true;
            if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                if (!MQConnectionFactoryNode.this._ccr.factoryExists(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getName(), 2)) {
                    mQConnectionFactory = MQConnectionFactoryNode.this._ccr.createMQConnectionFactory();
                    object = new DefaultMutableTreeNode(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getName());
                    Globals.getTreeModel().insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    mQConnectionFactory.setProvider(MQConnectionFactoryNode.this._ccr.findProvider(defaultMutableTreeNode.getParent().toString(), 2));
                } else {
                    int n = this.createExistsDialog(MQConnectionFactoryNode.this._serviceDialog);
                    if (n == 2) {
                        MQConnectionFactoryNode.this._serviceDialog.dispose();
                    }
                    bl = false;
                }
            }
            if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                mQConnectionFactory = (MQConnectionFactory)MQConnectionFactoryNode.this._ccr.findFactory(defaultMutableTreeNode.toString(), 2);
            }
            if (bl) {
                mQConnectionFactory.setName(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getName());
                mQConnectionFactory.setDescription(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getDesc());
                mQConnectionFactory.setJndiName(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getJndiName());
                Utility.handleAuthData(MQConnectionFactoryNode.this._ccr, (ConnectionFactory)mQConnectionFactory, MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getUserID(), MQConnectionFactoryNode.this._mqConnectionFactoryPanel.isSetUserID(), MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPassword(), MQConnectionFactoryNode.this._mqConnectionFactoryPanel.isSetPassword());
                mQConnectionFactory.setQueueManager(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getQueueManager());
                mQConnectionFactory.setHost(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getHost());
                if (MQConnectionFactoryNode.this._mqConnectionFactoryPanel.isSetPort()) {
                    mQConnectionFactory.setPort(Integer.parseInt(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPort()));
                } else {
                    mQConnectionFactory.unsetPort();
                }
                if (MQConnectionFactoryNode.this._mqConnectionFactoryPanel.isSetChannel()) {
                    mQConnectionFactory.setChannel(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getChannel());
                } else {
                    mQConnectionFactory.setChannel(null);
                }
                mQConnectionFactory.setClientID(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getClientID());
                if (MQConnectionFactoryNode.this._mqConnectionFactoryPanel.isSetCCSID()) {
                    mQConnectionFactory.setCCSID(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getCCSID());
                } else {
                    mQConnectionFactory.setCCSID(null);
                }
                mQConnectionFactory.setTransportType(MQTransportType.get((String)MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getTransportType()));
                mQConnectionFactory.setFailIfQuiesce(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getFailIfQuiesce());
                mQConnectionFactory.setLocalAddress(this.valueToSet(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getLocalAddress()));
                object = MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPollingInterval();
                if (this.isSet((String)object)) {
                    mQConnectionFactory.setPollingInterval(Integer.parseInt((String)object));
                } else {
                    mQConnectionFactory.unsetPollingInterval();
                }
                String string = MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getRescanInterval();
                if (this.isSet(string)) {
                    mQConnectionFactory.setRescanInterval(Integer.parseInt(string));
                } else {
                    mQConnectionFactory.unsetRescanInterval();
                }
                mQConnectionFactory.setSslCipherSuite(this.valueToSet(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getSSLCipherSuite()));
                mQConnectionFactory.setSslCRL(this.valueToSet(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getSSLCertStore()));
                mQConnectionFactory.setSslPeerName(this.valueToSet(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getSSLPeerName()));
                mQConnectionFactory.setUseConnectionPooling(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getUseConnectionPooling());
                mQConnectionFactory.setMsgRetention(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getMsgRetention());
                mQConnectionFactory.setTempModel(this.valueToSet(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getTempModel()));
                mQConnectionFactory.setTempQueuePrefix(this.valueToSet(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getTempQPrefix()));
                mQConnectionFactory.setBrokerControlQueue(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getBrokerControlQueue());
                mQConnectionFactory.setBrokerQueueManager(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getBrokerQueueManager());
                mQConnectionFactory.setBrokerPubQueue(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getBrokerPubQueue());
                mQConnectionFactory.setBrokerSubQueue(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getBrokerSubQueue());
                mQConnectionFactory.setBrokerCCSubQ(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getBrokerCCSubQ());
                mQConnectionFactory.setBrokerVersion(MQBrokerType.get((String)MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getBrokerVersion()));
                mQConnectionFactory.setPubSubCleanup(MQCleanupType.get((String)MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getCleanupLevel()));
                String string2 = MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getCleanupInterval();
                if (this.isSet(string2)) {
                    mQConnectionFactory.setPubSubCleanupInterval(Long.parseLong(string2));
                } else {
                    mQConnectionFactory.unsetPubSubCleanupInterval();
                }
                mQConnectionFactory.setMsgSelection(MQBrokerMsgSelection.get((String)MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getMsgSelection()));
                String string3 = MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getPubAckInterval();
                if (this.isSet(string3)) {
                    mQConnectionFactory.setPublishAckInterval(Integer.parseInt(string3));
                } else {
                    mQConnectionFactory.unsetPublishAckInterval();
                }
                mQConnectionFactory.setSparseSubscriptions(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getSparseSubscriptions());
                String string4 = MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getStatusRefreshInterval();
                if (this.isSet(string4)) {
                    mQConnectionFactory.setStatRefreshInterval(Integer.parseInt(string4));
                } else {
                    mQConnectionFactory.unsetStatRefreshInterval();
                }
                mQConnectionFactory.setSubstore(MQSubstoreType.get((String)MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getSubStore()));
                String string5 = MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getMulticast();
                if (string5 != null) {
                    mQConnectionFactory.setMulticast(MQCFMulticastType.get((String)string5));
                }
                mQConnectionFactory.setDirectAuth(MQDirectAuthType.get((String)MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getDirectAuth()));
                mQConnectionFactory.setProxyHostName(this.valueToSet(MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getProxyHostName()));
                String string6 = MQConnectionFactoryNode.this._mqConnectionFactoryPanel.getProxyPort();
                if (this.isSet(string6)) {
                    mQConnectionFactory.setProxyPort(Integer.parseInt(string6));
                } else {
                    mQConnectionFactory.unsetProxyPort();
                }
                mQConnectionFactory.setPropertySet(j2EEResourcePropertySet);
                MQConnectionFactoryNode.this._serviceDialog.dispose();
            }
        }
    }
}

