/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQDecimalEncoding;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQFloatingPointEncoding;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQIntegerEncoding;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQMessagingExpiryType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQMessagingPersistenceType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQMessagingPriorityType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueue;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTargetClientType;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class MQQueueFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(MQQueueFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private ServiceDialog _serviceDialog;
    private ClientContainerResourceRepository _ccr;
    private ImageIcon _icon;
    private MQQueuePanel _mqQueuePanel;
    private static final String _factoryType = "Queue Destinations";

    public MQQueueFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/JMSDestinationFactory.gif"));
    }

    public String toString() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 2, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddQDest");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = 7354909349077171281L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                MQQueue mQQueue = (MQQueue)MQQueueFactoryNode.this._ccr.findFactory(string, 2);
                MQQueueFactoryNode.this._mqQueuePanel = new MQQueuePanel(mQQueue);
                this.customPanel = new CustomPanel((J2EEResourceFactory)mQQueue);
                this.createButton.setActionCommand("Update");
            } else {
                MQQueueFactoryNode.this._mqQueuePanel = new MQQueuePanel();
            }
            this.setTitle(Utility.getMessage("helper.QpropTitle"));
            this.createButton.addActionListener(new MQQueueListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(MQQueueFactoryNode.this._mqQueuePanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("MQQUEUE");
            this.finishUp(n);
        }
    }

    public class MQQueuePanel
    extends FactoryPanel {
        private static final long serialVersionUID = -8501266642572490200L;
        JComboBox persistenceField;
        JComboBox priorityField;
        JTextField specifiedPriorityField;
        JComboBox expiryField;
        JTextField specifiedExpiryField;
        JTextField baseQueueNameField;
        JTextField baseQueueManagerNameField;
        JTextField CCSIDField;
        JComboBox integerEncodingField;
        JComboBox decimalEncodingField;
        JComboBox floatingpointEncodingField;
        JCheckBox nativeEncodingField;
        JComboBox targetClientField;

        public MQQueuePanel() {
            String[] stringArray = new String[]{"APPLICATION_DEFINED", "QUEUE_DEFINED", "PERSISTENT", "NONPERSISTENT"};
            this.persistenceField = new JComboBox<String>(stringArray);
            this.addNextProperty(this.persistenceField, "helper.persistenceLabel", "persistence", true, true);
            String[] stringArray2 = new String[]{"APPLICATION_DEFINED", "QUEUE_DEFINED", "SPECIFIED"};
            this.priorityField = new JComboBox<String>(stringArray2);
            this.priorityField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    if (string.equals("APPLICATION_DEFINED") || string.equals("QUEUE_DEFINED")) {
                        MQQueuePanel.this.specifiedPriorityField.setText("");
                        MQQueuePanel.this.specifiedPriorityField.setEditable(false);
                        MQQueuePanel.this.specifiedPriorityField.setBackground(Color.lightGray);
                        MQQueuePanel.this.specifiedPriorityField.setEnabled(false);
                        MQQueuePanel.this.getNonRequiredBorder(MQQueuePanel.this.specifiedPriorityField);
                    } else {
                        MQQueuePanel.this.specifiedPriorityField.setEditable(true);
                        MQQueuePanel.this.specifiedPriorityField.setBackground(Color.white);
                        MQQueuePanel.this.specifiedPriorityField.setEnabled(true);
                        MQQueuePanel.this.getRequiredBorder(MQQueuePanel.this.specifiedPriorityField);
                    }
                }
            });
            this.addNextProperty(this.priorityField, "helper.priorityLabel", "priority", true, true);
            this.specifiedPriorityField = this.addNextPropertyWithRemainder("helper.specifiedPriorityLabel", "specifiedPriority", false);
            this.specifiedPriorityField.setEditable(false);
            this.specifiedPriorityField.setBackground(Color.lightGray);
            String[] stringArray3 = new String[]{"APPLICATION_DEFINED", "UNLIMITED", "SPECIFIED"};
            this.expiryField = new JComboBox<String>(stringArray3);
            this.expiryField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    if (string.equals("APPLICATION_DEFINED") || string.equals("UNLIMITED")) {
                        MQQueuePanel.this.specifiedExpiryField.setText("");
                        MQQueuePanel.this.specifiedExpiryField.setEditable(false);
                        MQQueuePanel.this.specifiedExpiryField.setBackground(Color.lightGray);
                        MQQueuePanel.this.specifiedExpiryField.setEnabled(false);
                        MQQueuePanel.this.getNonRequiredBorder(MQQueuePanel.this.specifiedExpiryField);
                    } else {
                        MQQueuePanel.this.specifiedExpiryField.setEditable(true);
                        MQQueuePanel.this.specifiedExpiryField.setBackground(Color.white);
                        MQQueuePanel.this.specifiedExpiryField.setEnabled(true);
                        MQQueuePanel.this.getRequiredBorder(MQQueuePanel.this.specifiedExpiryField);
                    }
                }
            });
            this.addNextProperty(this.expiryField, "helper.expiryLabel", "expiry", true, true);
            this.specifiedExpiryField = this.addNextPropertyWithRemainder("helper.specifiedExpiryLabel", "specifiedExpiry", false);
            this.specifiedExpiryField.setEditable(false);
            this.specifiedExpiryField.setBackground(Color.lightGray);
            this.baseQueueNameField = this.addNextPropertyWithRemainder("helper.baseQueueNameLabel", "baseQueueName", true);
            this.baseQueueManagerNameField = this.addNextPropertyWithRemainder("helper.baseQueueManagerNameLabel", "baseQueueManagerName", false);
            this.CCSIDField = this.addNextPropertyWithRemainder("helper.ccsidLabel", "CCSID", false);
            String[] stringArray4 = new String[]{"Normal", "Reversed"};
            this.integerEncodingField = new JComboBox<String>(stringArray4);
            this.addNextProperty(this.integerEncodingField, "helper.integerEncodingLabel", "integerencoding", true, true);
            String[] stringArray5 = new String[]{"Normal", "Reversed"};
            this.decimalEncodingField = new JComboBox<String>(stringArray5);
            this.addNextProperty(this.decimalEncodingField, "helper.decimalEncodingLabel", "decimalencoding", true, true);
            String[] stringArray6 = new String[]{"IEEENormal", "IEEEReversed", "S390"};
            this.floatingpointEncodingField = new JComboBox<String>(stringArray6);
            this.addNextProperty(this.floatingpointEncodingField, "helper.floatingpointEncodingLabel", "floatingpointencoding", true, true);
            this.nativeEncodingField = new JCheckBox();
            this.nativeEncodingField.setSelected(false);
            this.nativeEncodingField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    if (bl) {
                        MQQueuePanel.this.integerEncodingField.setBackground(Color.lightGray);
                        MQQueuePanel.this.integerEncodingField.setEnabled(false);
                        MQQueuePanel.this.decimalEncodingField.setBackground(Color.lightGray);
                        MQQueuePanel.this.decimalEncodingField.setEnabled(false);
                        MQQueuePanel.this.floatingpointEncodingField.setBackground(Color.lightGray);
                        MQQueuePanel.this.floatingpointEncodingField.setEnabled(false);
                        MQQueuePanel.this.getNonRequiredBorder(MQQueuePanel.this.integerEncodingField);
                        MQQueuePanel.this.getNonRequiredBorder(MQQueuePanel.this.decimalEncodingField);
                        MQQueuePanel.this.getNonRequiredBorder(MQQueuePanel.this.floatingpointEncodingField);
                    } else {
                        MQQueuePanel.this.integerEncodingField.setBackground(Color.white);
                        MQQueuePanel.this.integerEncodingField.setEnabled(true);
                        MQQueuePanel.this.decimalEncodingField.setBackground(Color.white);
                        MQQueuePanel.this.decimalEncodingField.setEnabled(true);
                        MQQueuePanel.this.floatingpointEncodingField.setBackground(Color.white);
                        MQQueuePanel.this.floatingpointEncodingField.setEnabled(true);
                        MQQueuePanel.this.getRequiredBorder(MQQueuePanel.this.integerEncodingField);
                        MQQueuePanel.this.getRequiredBorder(MQQueuePanel.this.decimalEncodingField);
                        MQQueuePanel.this.getRequiredBorder(MQQueuePanel.this.floatingpointEncodingField);
                    }
                }
            });
            this.addNextPropertyNoBorder(this.nativeEncodingField, "helper.nativeEncodingLabel", "nativeencoding", true);
            String[] stringArray7 = new String[]{"JMS", "MQ"};
            this.targetClientField = new JComboBox<String>(stringArray7);
            this.addNextProperty(this.targetClientField, "helper.targetClientLabel", "targetClient", true, true);
        }

        public MQQueuePanel(MQQueue mQQueue) {
            this();
            this.nameField.setText(mQQueue.getName() != null ? mQQueue.getName() : "");
            this.descField.setText(mQQueue.getDescription() != null ? mQQueue.getDescription() : "");
            this.jndiNameField.setText(mQQueue.getJndiName() != null ? mQQueue.getJndiName() : "");
            this.persistenceField.setSelectedItem(mQQueue.isSetPersistence() ? mQQueue.getPersistence().getName() : "");
            this.priorityField.setSelectedItem(mQQueue.isSetPriority() ? mQQueue.getPriority().getName() : "");
            this.specifiedPriorityField.setText(mQQueue.isSetSpecifiedPriority() ? Integer.toString(mQQueue.getSpecifiedPriority()) : "");
            this.expiryField.setSelectedItem(mQQueue.isSetExpiry() ? mQQueue.getExpiry().getName() : "");
            this.specifiedExpiryField.setText(mQQueue.isSetSpecifiedExpiry() ? Long.toString(mQQueue.getSpecifiedExpiry()) : "");
            this.baseQueueNameField.setText(mQQueue.getBaseQueueName() != null ? mQQueue.getBaseQueueName() : "");
            this.baseQueueManagerNameField.setText(mQQueue.getBaseQueueManagerName() != null ? mQQueue.getBaseQueueManagerName() : "");
            this.CCSIDField.setText(mQQueue.isSetCCSID() ? Integer.toString(mQQueue.getCCSID()) : "");
            this.integerEncodingField.setSelectedItem(mQQueue.isSetIntegerEncoding() ? mQQueue.getIntegerEncoding().getName() : "");
            this.decimalEncodingField.setSelectedItem(mQQueue.isSetDecimalEncoding() ? mQQueue.getDecimalEncoding().getName() : "");
            this.floatingpointEncodingField.setSelectedItem(mQQueue.isSetFloatingPointEncoding() ? mQQueue.getFloatingPointEncoding().getName() : "");
            this.nativeEncodingField.setSelected(mQQueue.isSetUseNativeEncoding());
            if (mQQueue.isSetUseNativeEncoding()) {
                this.integerEncodingField.setBackground(Color.lightGray);
                this.integerEncodingField.setEnabled(false);
                this.decimalEncodingField.setBackground(Color.lightGray);
                this.decimalEncodingField.setEnabled(false);
                this.floatingpointEncodingField.setBackground(Color.lightGray);
                this.floatingpointEncodingField.setEnabled(false);
            }
            this.targetClientField.setSelectedItem(mQQueue.isSetTargetClient() ? mQQueue.getTargetClient().getName() : "");
            this.nameField.setEnabled(false);
        }

        public String getPersistence() {
            return (String)this.persistenceField.getSelectedItem();
        }

        public String getPriority() {
            return (String)this.priorityField.getSelectedItem();
        }

        public String getSpecifiedPriority() {
            return this.specifiedPriorityField.getText();
        }

        public String getExpiry() {
            return (String)this.expiryField.getSelectedItem();
        }

        public String getSpecifiedExpiry() {
            return this.specifiedExpiryField.getText();
        }

        public String getBaseQueueName() {
            return this.baseQueueNameField.getText().trim();
        }

        public String getBaseQueueManagerName() {
            return this.baseQueueManagerNameField.getText().trim();
        }

        public String getCCSID() {
            return this.CCSIDField.getText().trim();
        }

        public String getIntegerEncoding() {
            return (String)this.integerEncodingField.getSelectedItem();
        }

        public String getDecimalEncoding() {
            return (String)this.decimalEncodingField.getSelectedItem();
        }

        public String getFloatingpointEncoding() {
            return this.floatingpointEncodingField.getSelectedItem().toString();
        }

        public boolean getNativeEncoding() {
            return this.nativeEncodingField.isSelected();
        }

        public String getTargetClient() {
            return this.targetClientField.getSelectedItem().toString();
        }

        public boolean isSetPersistence() {
            return (String)this.persistenceField.getSelectedItem() != null;
        }

        public boolean isSetPriority() {
            return (String)this.priorityField.getSelectedItem() != null;
        }

        public boolean isSetSpecifiedPriority() {
            return !this.specifiedPriorityField.getText().equals("");
        }

        public boolean isSetExpiry() {
            return (String)this.expiryField.getSelectedItem() != null;
        }

        public boolean isSetSpecifiedExpiry() {
            return !this.specifiedExpiryField.getText().trim().equals("");
        }

        public boolean isSetBaseQueueName() {
            return !this.baseQueueNameField.getText().trim().equals("");
        }

        public boolean isSetBaseQueueManagerName() {
            return !this.baseQueueManagerNameField.getText().trim().equals("");
        }

        public boolean isSetCCSID() {
            return !this.CCSIDField.getText().trim().equals("");
        }

        public boolean isSetIntegerEncoding() {
            return (String)this.integerEncodingField.getSelectedItem() == null;
        }

        public boolean isSetDecimalEncoding() {
            return (String)this.decimalEncodingField.getSelectedItem() == null;
        }

        public boolean isSetFloatingpointEncoding() {
            return (String)this.floatingpointEncodingField.getSelectedItem() == null;
        }

        public boolean isSetNativeEncoding() {
            return this.nativeEncodingField.isSelected();
        }

        public boolean isSetTargetClient() {
            return (String)this.targetClientField.getSelectedItem() == null;
        }
    }

    public class MQQueueListener
    extends FactoryListener
    implements ActionListener {
        boolean mqRequiredCheck() {
            return !(MQQueueFactoryNode.this._mqQueuePanel.getPriority().equals("SPECIFIED") && MQQueueFactoryNode.this._mqQueuePanel.getSpecifiedPriority().equals("") || MQQueueFactoryNode.this._mqQueuePanel.getExpiry().equals("SPECIFIED") && MQQueueFactoryNode.this._mqQueuePanel.getSpecifiedExpiry().equals("")) && !MQQueueFactoryNode.this._mqQueuePanel.getBaseQueueName().equals("");
        }

        boolean checkSpecifiedPriority() {
            if (MQQueueFactoryNode.this._mqQueuePanel.getPriority().equals("SPECIFIED")) {
                String string = MQQueueFactoryNode.this._mqQueuePanel.getSpecifiedPriority();
                if (string.length() != 0) {
                    try {
                        Integer n = new Integer(string);
                        return n <= 9 && n >= 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        boolean checkSpecifiedExpiry() {
            if (MQQueueFactoryNode.this._mqQueuePanel.getExpiry().equals("SPECIFIED")) {
                String string = MQQueueFactoryNode.this._mqQueuePanel.getSpecifiedExpiry();
                if (string.length() != 0) {
                    try {
                        Long l = new Long(string);
                        return l <= Long.MAX_VALUE && l >= 0L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        boolean checkCCSID() {
            if (!MQQueueFactoryNode.this._mqQueuePanel.getCCSID().equals("")) {
                String string = MQQueueFactoryNode.this._mqQueuePanel.getCCSID();
                if (string.length() != 0) {
                    try {
                        int n = Integer.parseInt(string);
                        return n <= Integer.MAX_VALUE && n >= Integer.MIN_VALUE;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((MQQueueFactoryNode)MQQueueFactoryNode.this)._serviceDialog.tabbedPane, actionEvent);
            boolean bl = this.mqRequiredCheck();
            boolean bl2 = this.checkSpecifiedPriority();
            boolean bl3 = this.checkSpecifiedExpiry();
            boolean bl4 = this.checkCCSID();
            if (!bl && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.requiredAttributes"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl2 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.specifiedPriortyIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl3 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.specifiedExpiryIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl4 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.ccsidValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            }
            if (this.reqd && bl && bl2 && bl3 && bl4) {
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(MQQueueFactoryNode.this._ccr, ((MQQueueFactoryNode)MQQueueFactoryNode.this)._serviceDialog.customPanel);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(MQQueueFactoryNode.this._mqQueuePanel.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                MQQueue mQQueue = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!MQQueueFactoryNode.this._ccr.factoryExists(MQQueueFactoryNode.this._mqQueuePanel.getName(), 2)) {
                        mQQueue = MQQueueFactoryNode.this._ccr.createMQQueue();
                        mQQueue.setName(MQQueueFactoryNode.this._mqQueuePanel.getName());
                        mQQueue.setDescription(MQQueueFactoryNode.this._mqQueuePanel.getDesc());
                        mQQueue.setJndiName(MQQueueFactoryNode.this._mqQueuePanel.getJndiName());
                        mQQueue.setPersistence(MQMessagingPersistenceType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getPersistence()));
                        mQQueue.setPriority(MQMessagingPriorityType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getPriority()));
                        mQQueue.setExpiry(MQMessagingExpiryType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getExpiry()));
                        if (MQQueueFactoryNode.this._mqQueuePanel.isSetSpecifiedPriority()) {
                            mQQueue.setSpecifiedPriority(Integer.parseInt(MQQueueFactoryNode.this._mqQueuePanel.getSpecifiedPriority()));
                        } else {
                            mQQueue.unsetSpecifiedPriority();
                        }
                        mQQueue.setExpiry(MQMessagingExpiryType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getExpiry()));
                        if (MQQueueFactoryNode.this._mqQueuePanel.isSetSpecifiedExpiry()) {
                            mQQueue.setSpecifiedExpiry(Long.parseLong(MQQueueFactoryNode.this._mqQueuePanel.getSpecifiedExpiry()));
                        } else {
                            mQQueue.unsetSpecifiedExpiry();
                        }
                        mQQueue.setBaseQueueName(MQQueueFactoryNode.this._mqQueuePanel.getBaseQueueName());
                        mQQueue.setBaseQueueManagerName(MQQueueFactoryNode.this._mqQueuePanel.getBaseQueueManagerName());
                        if (MQQueueFactoryNode.this._mqQueuePanel.isSetCCSID()) {
                            mQQueue.setCCSID(Integer.parseInt(MQQueueFactoryNode.this._mqQueuePanel.getCCSID()));
                        } else {
                            mQQueue.unsetCCSID();
                        }
                        if (MQQueueFactoryNode.this._mqQueuePanel.isSetNativeEncoding()) {
                            mQQueue.setUseNativeEncoding(true);
                            mQQueue.unsetIntegerEncoding();
                            mQQueue.unsetDecimalEncoding();
                            mQQueue.unsetFloatingPointEncoding();
                        } else {
                            mQQueue.unsetUseNativeEncoding();
                            mQQueue.setIntegerEncoding(MQIntegerEncoding.get((String)MQQueueFactoryNode.this._mqQueuePanel.getIntegerEncoding()));
                            mQQueue.setDecimalEncoding(MQDecimalEncoding.get((String)MQQueueFactoryNode.this._mqQueuePanel.getDecimalEncoding()));
                            mQQueue.setFloatingPointEncoding(MQFloatingPointEncoding.get((String)MQQueueFactoryNode.this._mqQueuePanel.getFloatingpointEncoding()));
                        }
                        mQQueue.setTargetClient(MQTargetClientType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getTargetClient()));
                        mQQueue.setPropertySet(j2EEResourcePropertySet);
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        mQQueue.setProvider(MQQueueFactoryNode.this._ccr.findProvider(defaultMutableTreeNode2.getParent().toString(), 2));
                        MQQueueFactoryNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(MQQueueFactoryNode.this._serviceDialog);
                        if (n == 2) {
                            MQQueueFactoryNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    mQQueue = (MQQueue)MQQueueFactoryNode.this._ccr.findFactory(defaultMutableTreeNode2.toString(), 2);
                    mQQueue.setDescription(MQQueueFactoryNode.this._mqQueuePanel.getDesc());
                    mQQueue.setJndiName(MQQueueFactoryNode.this._mqQueuePanel.getJndiName());
                    mQQueue.setPersistence(MQMessagingPersistenceType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getPersistence()));
                    mQQueue.setPriority(MQMessagingPriorityType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getPriority()));
                    if (MQQueueFactoryNode.this._mqQueuePanel.isSetSpecifiedPriority()) {
                        mQQueue.setSpecifiedPriority(Integer.parseInt(MQQueueFactoryNode.this._mqQueuePanel.getSpecifiedPriority()));
                    } else {
                        mQQueue.unsetSpecifiedPriority();
                    }
                    mQQueue.setExpiry(MQMessagingExpiryType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getExpiry()));
                    if (MQQueueFactoryNode.this._mqQueuePanel.isSetSpecifiedExpiry()) {
                        mQQueue.setSpecifiedExpiry(Long.parseLong(MQQueueFactoryNode.this._mqQueuePanel.getSpecifiedExpiry()));
                    } else {
                        mQQueue.unsetSpecifiedExpiry();
                    }
                    mQQueue.setBaseQueueName(MQQueueFactoryNode.this._mqQueuePanel.getBaseQueueName());
                    mQQueue.setBaseQueueManagerName(MQQueueFactoryNode.this._mqQueuePanel.getBaseQueueManagerName());
                    if (MQQueueFactoryNode.this._mqQueuePanel.isSetCCSID()) {
                        mQQueue.setCCSID(Integer.parseInt(MQQueueFactoryNode.this._mqQueuePanel.getCCSID()));
                    } else {
                        mQQueue.unsetCCSID();
                    }
                    if (MQQueueFactoryNode.this._mqQueuePanel.isSetNativeEncoding()) {
                        mQQueue.setUseNativeEncoding(true);
                        mQQueue.unsetIntegerEncoding();
                        mQQueue.unsetDecimalEncoding();
                        mQQueue.unsetFloatingPointEncoding();
                    } else {
                        mQQueue.unsetUseNativeEncoding();
                        mQQueue.setIntegerEncoding(MQIntegerEncoding.get((String)MQQueueFactoryNode.this._mqQueuePanel.getIntegerEncoding()));
                        mQQueue.setDecimalEncoding(MQDecimalEncoding.get((String)MQQueueFactoryNode.this._mqQueuePanel.getDecimalEncoding()));
                        mQQueue.setFloatingPointEncoding(MQFloatingPointEncoding.get((String)MQQueueFactoryNode.this._mqQueuePanel.getFloatingpointEncoding()));
                    }
                    mQQueue.setTargetClient(MQTargetClientType.get((String)MQQueueFactoryNode.this._mqQueuePanel.getTargetClient()));
                    mQQueue.setPropertySet(j2EEResourcePropertySet);
                    MQQueueFactoryNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MQQueueFactoryNode.this._serviceDialog.dispose();
        }
    }
}

