/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQDecimalEncoding;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQFloatingPointEncoding;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQIntegerEncoding;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQMessagingExpiryType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQMessagingPersistenceType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQMessagingPriorityType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQMulticastType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTargetClientType;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopic;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class MQTopicFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(MQTopicFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private ServiceDialog _serviceDialog;
    private ClientContainerResourceRepository _ccr;
    private ImageIcon _icon;
    private MQTopicPanel _mqTopicPanel;
    private static final String _factoryType = "Topic Destinations";

    public MQTopicFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/JMSDestinationFactory.gif"));
    }

    public String toString() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 3, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddTopicDest");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = 6321349049357407641L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                MQTopic mQTopic = (MQTopic)MQTopicFactoryNode.this._ccr.findFactory(string, 2);
                MQTopicFactoryNode.this._mqTopicPanel = new MQTopicPanel(mQTopic);
                this.customPanel = new CustomPanel((J2EEResourceFactory)mQTopic);
                this.createButton.setActionCommand("Update");
            } else {
                MQTopicFactoryNode.this._mqTopicPanel = new MQTopicPanel();
            }
            this.setTitle(Utility.getMessage("helper.TpropTitle"));
            this.createButton.addActionListener(new MQTopicListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(MQTopicFactoryNode.this._mqTopicPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("MQTOPIC");
            this.finishUp(n);
        }
    }

    public class MQTopicPanel
    extends FactoryPanel {
        private static final long serialVersionUID = -2553678057412367360L;
        JComboBox persistenceField;
        JComboBox priorityField;
        JTextField specifiedPriorityField;
        JTextField specifiedExpiryField;
        JComboBox expiryField;
        JTextField baseTopicNameField;
        JTextField CCSIDField;
        JComboBox integerEncodingField;
        JComboBox decimalEncodingField;
        JComboBox floatingpointEncodingField;
        JCheckBox nativeEncodingField;
        JComboBox targetClientField;
        JTextField brokerDurSubQueueField;
        JTextField brokerCCDurSubQueueField;
        JComboBox multicastField;

        public MQTopicPanel() {
            String[] stringArray = new String[]{"APPLICATION_DEFINED", "QUEUE_DEFINED", "PERSISTENT", "NONPERSISTENT"};
            this.persistenceField = new JComboBox<String>(stringArray);
            this.addNextProperty(this.persistenceField, "helper.persistenceLabel", "persistence", true, true);
            String[] stringArray2 = new String[]{"APPLICATION_DEFINED", "QUEUE_DEFINED", "SPECIFIED"};
            this.priorityField = new JComboBox<String>(stringArray2);
            this.addNextProperty(this.priorityField, "helper.priorityLabel", "priority", true, true);
            this.priorityField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    if (string.equals("APPLICATION_DEFINED") || string.equals("QUEUE_DEFINED")) {
                        MQTopicPanel.this.specifiedPriorityField.setText("");
                        MQTopicPanel.this.specifiedPriorityField.setEditable(false);
                        MQTopicPanel.this.specifiedPriorityField.setBackground(Color.lightGray);
                        MQTopicPanel.this.specifiedPriorityField.setEnabled(false);
                        MQTopicPanel.this.getNonRequiredBorder(MQTopicPanel.this.specifiedPriorityField);
                    } else {
                        MQTopicPanel.this.specifiedPriorityField.setEditable(true);
                        MQTopicPanel.this.specifiedPriorityField.setBackground(Color.white);
                        MQTopicPanel.this.specifiedPriorityField.setEnabled(true);
                        MQTopicPanel.this.getRequiredBorder(MQTopicPanel.this.specifiedPriorityField);
                    }
                }
            });
            this.specifiedPriorityField = this.addNextPropertyWithRemainder("helper.specifiedPriorityLabel", "specifiedPriority", false);
            this.specifiedPriorityField.setEditable(false);
            this.specifiedPriorityField.setBackground(Color.lightGray);
            String[] stringArray3 = new String[]{"APPLICATION_DEFINED", "UNLIMITED", "SPECIFIED"};
            this.expiryField = new JComboBox<String>(stringArray3);
            this.addNextProperty(this.expiryField, "helper.expiryLabel", "expiry", true, true);
            this.expiryField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    if (string.equals("APPLICATION_DEFINED") || string.equals("UNLIMITED")) {
                        MQTopicPanel.this.specifiedExpiryField.setText("");
                        MQTopicPanel.this.specifiedExpiryField.setEditable(false);
                        MQTopicPanel.this.specifiedExpiryField.setBackground(Color.lightGray);
                        MQTopicPanel.this.specifiedExpiryField.setEnabled(false);
                        MQTopicPanel.this.getNonRequiredBorder(MQTopicPanel.this.specifiedExpiryField);
                    } else {
                        MQTopicPanel.this.specifiedExpiryField.setEditable(true);
                        MQTopicPanel.this.specifiedExpiryField.setBackground(Color.white);
                        MQTopicPanel.this.specifiedExpiryField.setEnabled(true);
                        MQTopicPanel.this.getRequiredBorder(MQTopicPanel.this.specifiedExpiryField);
                    }
                }
            });
            this.specifiedExpiryField = this.addNextPropertyWithRemainder("helper.specifiedExpiryLabel", "specifiedExpiry", false);
            this.specifiedExpiryField.setEditable(false);
            this.specifiedExpiryField.setBackground(Color.lightGray);
            this.baseTopicNameField = this.addNextProperty("helper.baseTopicNameLabel", "baseTopicName", true);
            this.CCSIDField = this.addNextProperty("helper.ccsidLabel", "CCSID", false);
            String[] stringArray4 = new String[]{"Normal", "Reversed"};
            this.integerEncodingField = new JComboBox<String>(stringArray4);
            this.addNextProperty(this.integerEncodingField, "helper.integerEncodingLabel", "integerencoding", true, true);
            String[] stringArray5 = new String[]{"Normal", "Reversed"};
            this.decimalEncodingField = new JComboBox<String>(stringArray5);
            this.addNextProperty(this.decimalEncodingField, "helper.decimalEncodingLabel", "decimalencoding", true, true);
            String[] stringArray6 = new String[]{"IEEENormal", "IEEEReversed", "S390"};
            this.floatingpointEncodingField = new JComboBox<String>(stringArray6);
            this.addNextProperty(this.floatingpointEncodingField, "helper.floatingpointEncodingLabel", "floatingpointencoding", true, true);
            this.nativeEncodingField = new JCheckBox();
            this.nativeEncodingField.setSelected(false);
            this.addNextPropertyNoBorder(this.nativeEncodingField, "helper.nativeEncodingLabel", "nativeencoding", true);
            this.nativeEncodingField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    if (bl) {
                        MQTopicPanel.this.integerEncodingField.setBackground(Color.lightGray);
                        MQTopicPanel.this.integerEncodingField.setEnabled(false);
                        MQTopicPanel.this.decimalEncodingField.setBackground(Color.lightGray);
                        MQTopicPanel.this.decimalEncodingField.setEnabled(false);
                        MQTopicPanel.this.floatingpointEncodingField.setBackground(Color.lightGray);
                        MQTopicPanel.this.floatingpointEncodingField.setEnabled(false);
                        MQTopicPanel.this.getNonRequiredBorder(MQTopicPanel.this.integerEncodingField);
                        MQTopicPanel.this.getNonRequiredBorder(MQTopicPanel.this.decimalEncodingField);
                        MQTopicPanel.this.getNonRequiredBorder(MQTopicPanel.this.floatingpointEncodingField);
                    } else {
                        MQTopicPanel.this.integerEncodingField.setBackground(Color.white);
                        MQTopicPanel.this.integerEncodingField.setEnabled(true);
                        MQTopicPanel.this.decimalEncodingField.setBackground(Color.white);
                        MQTopicPanel.this.decimalEncodingField.setEnabled(true);
                        MQTopicPanel.this.floatingpointEncodingField.setBackground(Color.white);
                        MQTopicPanel.this.floatingpointEncodingField.setEnabled(true);
                        MQTopicPanel.this.getRequiredBorder(MQTopicPanel.this.integerEncodingField);
                        MQTopicPanel.this.getRequiredBorder(MQTopicPanel.this.decimalEncodingField);
                        MQTopicPanel.this.getRequiredBorder(MQTopicPanel.this.floatingpointEncodingField);
                    }
                }
            });
            this.brokerDurSubQueueField = this.addNextProperty("helper.brokerDurSubQueueLabel", "brokerDurSubQueue", false);
            this.brokerCCDurSubQueueField = this.addNextProperty("helper.brokerCCDurSubQueueLabel", "brokerCCDurSubQueue", false);
            String[] stringArray7 = new String[]{"JMS", "MQ"};
            this.targetClientField = new JComboBox<String>(stringArray7);
            this.addNextProperty(this.targetClientField, "helper.targetClientLabel", "targetClient", true, true);
            String[] stringArray8 = new String[]{"AS_CF", "DISABLED", "NOT_RELIABLE", "RELIABLE", "ENABLED"};
            this.multicastField = new JComboBox<String>(stringArray8);
            this.addNextProperty(this.multicastField, "helper.multicast", "multicast", false, true);
        }

        public MQTopicPanel(MQTopic mQTopic) {
            this();
            this.nameField.setText(mQTopic.getName() != null ? mQTopic.getName() : "");
            this.descField.setText(mQTopic.getDescription() != null ? mQTopic.getDescription() : "");
            this.jndiNameField.setText(mQTopic.getJndiName() != null ? mQTopic.getJndiName() : "");
            this.persistenceField.setSelectedItem(mQTopic.isSetPersistence() ? mQTopic.getPersistence().toString() : "");
            this.priorityField.setSelectedItem(mQTopic.isSetPriority() ? mQTopic.getPriority().getName() : "");
            this.specifiedPriorityField.setText(mQTopic.isSetSpecifiedPriority() ? Integer.toString(mQTopic.getSpecifiedPriority()) : "");
            this.expiryField.setSelectedItem(mQTopic.isSetExpiry() ? mQTopic.getExpiry().getName() : "");
            this.specifiedExpiryField.setText(mQTopic.isSetSpecifiedExpiry() ? Long.toString(mQTopic.getSpecifiedExpiry()) : "");
            this.baseTopicNameField.setText(mQTopic.getBaseTopicName() != null ? mQTopic.getBaseTopicName() : "");
            this.CCSIDField.setText(mQTopic.isSetCCSID() ? Integer.toString(mQTopic.getCCSID()) : "");
            this.integerEncodingField.setSelectedItem(mQTopic.isSetIntegerEncoding() ? mQTopic.getIntegerEncoding().getName() : "");
            this.decimalEncodingField.setSelectedItem(mQTopic.isSetDecimalEncoding() ? mQTopic.getDecimalEncoding().getName() : "");
            this.floatingpointEncodingField.setSelectedItem(mQTopic.isSetFloatingPointEncoding() ? mQTopic.getFloatingPointEncoding().getName() : "");
            this.nativeEncodingField.setSelected(mQTopic.isSetUseNativeEncoding());
            if (mQTopic.isSetUseNativeEncoding()) {
                this.integerEncodingField.setBackground(Color.lightGray);
                this.integerEncodingField.setEnabled(false);
                this.decimalEncodingField.setBackground(Color.lightGray);
                this.decimalEncodingField.setEnabled(false);
                this.floatingpointEncodingField.setBackground(Color.lightGray);
                this.floatingpointEncodingField.setEnabled(false);
            }
            this.targetClientField.setSelectedItem(mQTopic.isSetTargetClient() ? mQTopic.getTargetClient().getName() : "");
            this.brokerDurSubQueueField.setText(mQTopic.getBrokerDurSubQueue() != null ? mQTopic.getBrokerDurSubQueue() : "");
            this.brokerCCDurSubQueueField.setText(mQTopic.getBrokerCCDurSubQueue() != null ? mQTopic.getBrokerCCDurSubQueue() : "");
            this.nameField.setEnabled(false);
            this.multicastField.setSelectedItem(mQTopic.getMulticast().getName());
        }

        public String getPersistence() {
            return (String)this.persistenceField.getSelectedItem();
        }

        public String getPriority() {
            return (String)this.priorityField.getSelectedItem();
        }

        public String getSpecifiedPriority() {
            return this.specifiedPriorityField.getText();
        }

        public String getExpiry() {
            return (String)this.expiryField.getSelectedItem();
        }

        public String getSpecifiedExpiry() {
            return this.specifiedExpiryField.getText();
        }

        public String getBaseTopicName() {
            return this.baseTopicNameField.getText().trim();
        }

        public String getCCSID() {
            return this.CCSIDField.getText().trim();
        }

        public String getIntegerEncoding() {
            return (String)this.integerEncodingField.getSelectedItem();
        }

        public String getDecimalEncoding() {
            return (String)this.decimalEncodingField.getSelectedItem();
        }

        public String getFloatingpointEncoding() {
            return this.floatingpointEncodingField.getSelectedItem().toString();
        }

        public boolean getNativeEncoding() {
            return this.nativeEncodingField.isSelected();
        }

        public String getBrokerDurSubQueue() {
            return this.brokerDurSubQueueField.getText().trim();
        }

        public String getBrokerCCDurSubQueue() {
            return this.brokerCCDurSubQueueField.getText().trim();
        }

        public String getTargetClient() {
            return this.targetClientField.getSelectedItem().toString();
        }

        public String getMulticast() {
            return this.multicastField.getSelectedItem().toString();
        }

        public boolean isSetPersistence() {
            return (String)this.persistenceField.getSelectedItem() != null;
        }

        public boolean isSetPriority() {
            return (String)this.priorityField.getSelectedItem() != null;
        }

        public boolean isSetSpecifiedPriority() {
            return !this.specifiedPriorityField.getText().equals("");
        }

        public boolean isSetExpiry() {
            return (String)this.expiryField.getSelectedItem() != null;
        }

        public boolean isSetSpecifiedExpiry() {
            return !this.specifiedExpiryField.getText().trim().equals("");
        }

        public boolean isSetBaseTopicName() {
            return !this.baseTopicNameField.getText().trim().equals("");
        }

        public boolean isSetCCSID() {
            return !this.CCSIDField.getText().trim().equals("");
        }

        public boolean isSetIntegerEncoding() {
            return (String)this.integerEncodingField.getSelectedItem() == null;
        }

        public boolean isSetDecimalEncoding() {
            return (String)this.decimalEncodingField.getSelectedItem() == null;
        }

        public boolean isSetFloatingpointEncoding() {
            return (String)this.floatingpointEncodingField.getSelectedItem() == null;
        }

        public boolean isSetNativeEncoding() {
            return this.nativeEncodingField.isSelected();
        }

        public boolean isSetBrokerCCDurSubQueue() {
            return !this.brokerCCDurSubQueueField.getText().trim().equals("");
        }

        public boolean isSetBrokerDurSubQueue() {
            return !this.brokerDurSubQueueField.getText().trim().equals("");
        }

        public boolean isSetTargetClient() {
            return (String)this.targetClientField.getSelectedItem() == null;
        }
    }

    public class MQTopicListener
    extends FactoryListener
    implements ActionListener {
        boolean mqRequiredCheck() {
            return !(MQTopicFactoryNode.this._mqTopicPanel.getPriority().equals("SPECIFIED") && MQTopicFactoryNode.this._mqTopicPanel.getSpecifiedPriority().equals("") || MQTopicFactoryNode.this._mqTopicPanel.getExpiry().equals("SPECIFIED") && MQTopicFactoryNode.this._mqTopicPanel.getSpecifiedExpiry().equals("")) && !MQTopicFactoryNode.this._mqTopicPanel.getBaseTopicName().equals("");
        }

        boolean checkSpecifiedPriority() {
            if (MQTopicFactoryNode.this._mqTopicPanel.getPriority().equals("SPECIFIED")) {
                String string = MQTopicFactoryNode.this._mqTopicPanel.getSpecifiedPriority();
                if (string.length() != 0) {
                    try {
                        Integer n = new Integer(string);
                        return n <= 9 && n >= 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        boolean checkSpecifiedExpiry() {
            if (MQTopicFactoryNode.this._mqTopicPanel.getExpiry().equals("SPECIFIED")) {
                String string = MQTopicFactoryNode.this._mqTopicPanel.getSpecifiedExpiry();
                if (string.length() != 0) {
                    try {
                        Long l = new Long(string);
                        return l <= Long.MAX_VALUE && l >= 0L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        boolean checkCCSID() {
            if (!MQTopicFactoryNode.this._mqTopicPanel.getCCSID().equals("")) {
                String string = MQTopicFactoryNode.this._mqTopicPanel.getCCSID();
                if (string.length() != 0) {
                    try {
                        int n = Integer.parseInt(string);
                        return n <= Integer.MAX_VALUE && n >= Integer.MIN_VALUE;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((MQTopicFactoryNode)MQTopicFactoryNode.this)._serviceDialog.tabbedPane, actionEvent);
            boolean bl = this.mqRequiredCheck();
            boolean bl2 = this.checkSpecifiedPriority();
            boolean bl3 = this.checkSpecifiedExpiry();
            boolean bl4 = this.checkCCSID();
            if (!bl && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.requiredAttributes"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl2 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.specifiedPriortyIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl3 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.specifiedExpiryIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl4 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.ccsidValueIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            }
            if (this.reqd && bl && bl2 && bl3 && bl4) {
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(MQTopicFactoryNode.this._ccr, ((MQTopicFactoryNode)MQTopicFactoryNode.this)._serviceDialog.customPanel);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(MQTopicFactoryNode.this._mqTopicPanel.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                MQTopic mQTopic = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!MQTopicFactoryNode.this._ccr.factoryExists(MQTopicFactoryNode.this._mqTopicPanel.getName(), 2)) {
                        mQTopic = MQTopicFactoryNode.this._ccr.createMQTopic();
                        mQTopic.setName(MQTopicFactoryNode.this._mqTopicPanel.getName());
                        mQTopic.setDescription(MQTopicFactoryNode.this._mqTopicPanel.getDesc());
                        mQTopic.setJndiName(MQTopicFactoryNode.this._mqTopicPanel.getJndiName());
                        mQTopic.setPersistence(MQMessagingPersistenceType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getPersistence()));
                        mQTopic.setPriority(MQMessagingPriorityType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getPriority()));
                        if (MQTopicFactoryNode.this._mqTopicPanel.isSetSpecifiedPriority()) {
                            mQTopic.setSpecifiedPriority(Integer.parseInt(MQTopicFactoryNode.this._mqTopicPanel.getSpecifiedPriority()));
                        } else {
                            mQTopic.unsetSpecifiedPriority();
                        }
                        mQTopic.setExpiry(MQMessagingExpiryType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getExpiry()));
                        if (MQTopicFactoryNode.this._mqTopicPanel.isSetSpecifiedExpiry()) {
                            mQTopic.setSpecifiedExpiry(Long.parseLong(MQTopicFactoryNode.this._mqTopicPanel.getSpecifiedExpiry()));
                        } else {
                            mQTopic.unsetSpecifiedExpiry();
                        }
                        mQTopic.setBaseTopicName(MQTopicFactoryNode.this._mqTopicPanel.getBaseTopicName());
                        if (MQTopicFactoryNode.this._mqTopicPanel.isSetCCSID()) {
                            mQTopic.setCCSID(Integer.parseInt(MQTopicFactoryNode.this._mqTopicPanel.getCCSID()));
                        } else {
                            mQTopic.unsetCCSID();
                        }
                        if (MQTopicFactoryNode.this._mqTopicPanel.isSetNativeEncoding()) {
                            mQTopic.setUseNativeEncoding(true);
                            mQTopic.unsetIntegerEncoding();
                            mQTopic.unsetDecimalEncoding();
                            mQTopic.unsetFloatingPointEncoding();
                        } else {
                            mQTopic.unsetUseNativeEncoding();
                            mQTopic.setIntegerEncoding(MQIntegerEncoding.get((String)MQTopicFactoryNode.this._mqTopicPanel.getIntegerEncoding()));
                            mQTopic.setDecimalEncoding(MQDecimalEncoding.get((String)MQTopicFactoryNode.this._mqTopicPanel.getDecimalEncoding()));
                            mQTopic.setFloatingPointEncoding(MQFloatingPointEncoding.get((String)MQTopicFactoryNode.this._mqTopicPanel.getFloatingpointEncoding()));
                        }
                        mQTopic.setTargetClient(MQTargetClientType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getTargetClient()));
                        mQTopic.setBrokerDurSubQueue(MQTopicFactoryNode.this._mqTopicPanel.getBrokerDurSubQueue());
                        mQTopic.setBrokerCCDurSubQueue(MQTopicFactoryNode.this._mqTopicPanel.getBrokerCCDurSubQueue());
                        mQTopic.setMulticast(MQMulticastType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getMulticast()));
                        mQTopic.setPropertySet(j2EEResourcePropertySet);
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        mQTopic.setProvider(MQTopicFactoryNode.this._ccr.findProvider(defaultMutableTreeNode2.getParent().toString(), 2));
                        MQTopicFactoryNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(MQTopicFactoryNode.this._serviceDialog);
                        if (n == 2) {
                            MQTopicFactoryNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    mQTopic = (MQTopic)MQTopicFactoryNode.this._ccr.findFactory(defaultMutableTreeNode2.toString(), 2);
                    mQTopic.setDescription(MQTopicFactoryNode.this._mqTopicPanel.getDesc());
                    mQTopic.setJndiName(MQTopicFactoryNode.this._mqTopicPanel.getJndiName());
                    mQTopic.setPersistence(MQMessagingPersistenceType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getPersistence()));
                    mQTopic.setPriority(MQMessagingPriorityType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getPriority()));
                    if (MQTopicFactoryNode.this._mqTopicPanel.isSetSpecifiedPriority()) {
                        mQTopic.setSpecifiedPriority(Integer.parseInt(MQTopicFactoryNode.this._mqTopicPanel.getSpecifiedPriority()));
                    }
                    mQTopic.setExpiry(MQMessagingExpiryType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getExpiry()));
                    if (MQTopicFactoryNode.this._mqTopicPanel.isSetSpecifiedExpiry()) {
                        mQTopic.setSpecifiedExpiry(Long.parseLong(MQTopicFactoryNode.this._mqTopicPanel.getSpecifiedExpiry()));
                    }
                    mQTopic.setBaseTopicName(MQTopicFactoryNode.this._mqTopicPanel.getBaseTopicName());
                    if (MQTopicFactoryNode.this._mqTopicPanel.isSetCCSID()) {
                        mQTopic.setCCSID(Integer.parseInt(MQTopicFactoryNode.this._mqTopicPanel.getCCSID()));
                    }
                    if (MQTopicFactoryNode.this._mqTopicPanel.isSetNativeEncoding()) {
                        mQTopic.setUseNativeEncoding(true);
                        mQTopic.unsetIntegerEncoding();
                        mQTopic.unsetDecimalEncoding();
                        mQTopic.unsetFloatingPointEncoding();
                    } else {
                        mQTopic.unsetUseNativeEncoding();
                        mQTopic.setIntegerEncoding(MQIntegerEncoding.get((String)MQTopicFactoryNode.this._mqTopicPanel.getIntegerEncoding()));
                        mQTopic.setDecimalEncoding(MQDecimalEncoding.get((String)MQTopicFactoryNode.this._mqTopicPanel.getDecimalEncoding()));
                        mQTopic.setFloatingPointEncoding(MQFloatingPointEncoding.get((String)MQTopicFactoryNode.this._mqTopicPanel.getFloatingpointEncoding()));
                    }
                    mQTopic.setTargetClient(MQTargetClientType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getTargetClient()));
                    mQTopic.setBrokerDurSubQueue(MQTopicFactoryNode.this._mqTopicPanel.getBrokerDurSubQueue());
                    mQTopic.setBrokerCCDurSubQueue(MQTopicFactoryNode.this._mqTopicPanel.getBrokerCCDurSubQueue());
                    mQTopic.setMulticast(MQMulticastType.get((String)MQTopicFactoryNode.this._mqTopicPanel.getMulticast()));
                    mQTopic.setPropertySet(j2EEResourcePropertySet);
                    MQTopicFactoryNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MQTopicFactoryNode.this._serviceDialog.dispose();
        }
    }
}

