/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.mail.MailProvider;
import com.ibm.ejs.models.base.resources.mail.MailSession;
import com.ibm.ejs.models.base.resources.mail.ProtocolProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class MailFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(MailFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private LocalServiceDialog _serviceDialog;
    private J2EEResourceProvider _provider;
    private ClientContainerResourceRepository _ccr;
    private JavaMailFactoryPanel _javaMailFactoryPanel;
    private ImageIcon _icon;
    private static final String _factoryType = "Mail Sessions";

    public MailFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository, J2EEResourceProvider j2EEResourceProvider) {
        this._ccr = clientContainerResourceRepository;
        this._provider = j2EEResourceProvider;
        this._icon = new ImageIcon(this.getClass().getResource("images/MailSession.gif"));
    }

    public String toString() {
        return _factoryType;
    }

    public static String getType() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 2, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddMailFactory");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = -2588712399739434175L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                MailSession mailSession = (MailSession)MailFactoryNode.this._ccr.findFactory(string, 4);
                MailFactoryNode.this._javaMailFactoryPanel = new JavaMailFactoryPanel(mailSession);
                this.customPanel = new CustomPanel((J2EEResourceFactory)mailSession);
                this.createButton.setActionCommand("Update");
            } else {
                MailProvider mailProvider = (MailProvider)MailFactoryNode.this._provider;
                MailFactoryNode.this._javaMailFactoryPanel = new JavaMailFactoryPanel((J2EEResourceProvider)mailProvider);
            }
            this.setTitle(Utility.getMessage("helper.javaMailSessionPropertiesTitle"));
            this.createButton.addActionListener(new JavaMailFactoryListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(MailFactoryNode.this._javaMailFactoryPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("JAVAMAILFACTORY");
            this.finishUp(n);
        }
    }

    public class JavaMailFactoryPanel
    extends FactoryPanel {
        private static final long serialVersionUID = 5954327094023199008L;
        JLabel mailTransportProtocolLabel;
        JTextField mailTransportHostField = this.addNextPropertyWithRemainder("helper.mailTransportHostLabel", "mailtransporthost", false);
        JComboBox mailTransportProtocolField;
        JTextField mailTransportUserField;
        JPasswordField mailTransportPasswordField;
        JPasswordField retypeTransportPasswordField;
        JTextField mailFromField;
        JTextField mailStoreHostField;
        JTextField mailStoreUserField;
        JPasswordField mailStorePasswordField;
        JPasswordField retypeStorePasswordField;
        JComboBox mailStoreProtocolField;
        JCheckBox mailDebugCheckBox;
        JLabel mailDebugLabel;

        JavaMailFactoryPanel(J2EEResourceProvider j2EEResourceProvider) {
            Iterator iterator = ((MailProvider)j2EEResourceProvider).getProtocolProviders().iterator();
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            while (iterator.hasNext()) {
                ProtocolProvider protocolProvider = (ProtocolProvider)iterator.next();
                if (protocolProvider.getType().getName() != null && protocolProvider.getType().getName().equals("TRANSPORT")) {
                    vector.add(protocolProvider.getProtocol());
                    continue;
                }
                vector2.add(protocolProvider.getProtocol());
            }
            vector.add("");
            vector2.add("");
            this.mailTransportProtocolField = new JComboBox(vector);
            this.addNextProperty(this.mailTransportProtocolField, "helper.mailTransportProtocolLabel", "mailtransportprotocol", false, true);
            this.mailTransportUserField = this.addNextPropertyWithRemainder("helper.mailTransportUserLabel", "mailtransportuser", false);
            this.mailTransportPasswordField = this.addNextPasswordProperty("helper.mailTransportPasswordLabel", "mailtransportpassword", false);
            this.retypeTransportPasswordField = this.addNextPasswordProperty("helper.retypePasswordLabel", "retypetransportpassword", false);
            this.mailFromField = this.addNextPropertyWithRemainder("helper.mailFromLabel", "mailfrom", false);
            this.mailStoreHostField = this.addNextPropertyWithRemainder("helper.mailStoreHostLabel", "mailstorehost", false);
            this.mailStoreUserField = this.addNextPropertyWithRemainder("helper.mailStoreUserLabel", "mailstoreuser", false);
            this.mailStorePasswordField = this.addNextPasswordProperty("helper.mailStorePasswordLabel", "mailstorepassword", false);
            this.retypeStorePasswordField = this.addNextPasswordProperty("helper.retypePasswordLabel", "retypestorepassword", false);
            this.mailStoreProtocolField = new JComboBox(vector2);
            this.addNextProperty(this.mailStoreProtocolField, "helper.mailStoreProtocolLabel", "mailstoreprotocol", false, true);
            this.mailDebugCheckBox = new JCheckBox();
            this.addNextPropertyNoBorder(this.mailDebugCheckBox, "helper.maildebug", "maildebug", true);
        }

        JavaMailFactoryPanel(MailSession mailSession) {
            this(mailSession.getProvider());
            this.nameField.setText(mailSession.getName() != null ? mailSession.getName() : "");
            this.descField.setText(mailSession.getDescription() != null ? mailSession.getDescription() : "");
            this.jndiNameField.setText(mailSession.getJndiName() != null ? mailSession.getJndiName() : "");
            this.mailTransportHostField.setText(mailSession.getMailTransportHost() != null ? mailSession.getMailTransportHost() : "");
            this.mailTransportProtocolField.setSelectedItem(mailSession.getMailTransportProtocol() != null ? mailSession.getMailTransportProtocol().getProtocol() : null);
            this.mailTransportUserField.setText(mailSession.getMailTransportUser() != null ? mailSession.getMailTransportUser() : "");
            this.mailTransportPasswordField.setText(mailSession.getMailTransportPassword() != null ? mailFactoryNode.decryptPassword(mailSession.getMailTransportPassword()) : "");
            this.retypeTransportPasswordField.setText(mailSession.getMailTransportPassword() != null ? mailFactoryNode.decryptPassword(mailSession.getMailTransportPassword()) : "");
            this.mailFromField.setText(mailSession.getMailFrom() != null ? mailSession.getMailFrom() : "");
            this.mailStoreHostField.setText(mailSession.getMailStoreHost() != null ? mailSession.getMailStoreHost() : "");
            this.mailStoreUserField.setText(mailSession.getMailStoreUser() != null ? mailSession.getMailStoreUser() : "");
            this.mailStorePasswordField.setText(mailSession.getMailStorePassword() != null ? mailFactoryNode.decryptPassword(mailSession.getMailStorePassword()) : "");
            this.retypeStorePasswordField.setText(mailSession.getMailStorePassword() != null ? mailFactoryNode.decryptPassword(mailSession.getMailStorePassword()) : "");
            this.mailStoreProtocolField.setSelectedItem(mailSession.getMailStoreProtocol() != null ? mailSession.getMailStoreProtocol().getProtocol() : null);
            this.mailDebugCheckBox.setSelected(mailSession.isDebug());
            this.nameField.setEnabled(false);
        }

        public String getMailTransportHost() {
            return this.mailTransportHostField.getText().trim();
        }

        public String getMailTransportProtocol() {
            return this.mailTransportProtocolField.getSelectedItem().toString();
        }

        public String getMailTransportUser() {
            return this.mailTransportUserField.getText().trim();
        }

        public String getMailTransportPassword() {
            return MailFactoryNode.this.encryptPassword(new String(this.mailTransportPasswordField.getPassword()).trim());
        }

        public String getRetypeTransportPassword() {
            return MailFactoryNode.this.encryptPassword(new String(this.retypeTransportPasswordField.getPassword()).trim());
        }

        public String getMailFrom() {
            return this.mailFromField.getText().trim();
        }

        public String getMailStoreHost() {
            return this.mailStoreHostField.getText().trim();
        }

        public String getMailStoreUser() {
            return this.mailStoreUserField.getText().trim();
        }

        public String getMailStorePassword() {
            return MailFactoryNode.this.encryptPassword(new String(this.mailStorePasswordField.getPassword()).trim());
        }

        public String getRetypeStorePassword() {
            return MailFactoryNode.this.encryptPassword(new String(this.retypeStorePasswordField.getPassword()).trim());
        }

        public String getMailStoreProtocol() {
            return this.mailStoreProtocolField.getSelectedItem().toString();
        }

        public boolean getMailDebugCheckBox() {
            return this.mailDebugCheckBox.isSelected();
        }

        public boolean isSetMailTransportHost() {
            return !this.getMailTransportHost().equals("");
        }

        public boolean isSetMailTransportProtocol() {
            return this.mailTransportProtocolField.getSelectedItem() != null;
        }

        public boolean isSetMailTransportUser() {
            return !this.getMailTransportUser().equals("");
        }

        public boolean isSetMailTransportPassword() {
            return !new String(this.mailTransportPasswordField.getPassword()).trim().equals("");
        }

        public boolean isSetRetypeTransportPassword() {
            return !new String(this.retypeTransportPasswordField.getPassword()).trim().equals("");
        }

        public boolean isSetMailFrom() {
            return !this.getMailFrom().equals("");
        }

        public boolean isSetMailStoreHost() {
            return !this.getMailStoreHost().equals("");
        }

        public boolean isSetMailStoreUser() {
            return !this.getMailStoreUser().equals("");
        }

        public boolean isSetMailStorePassword() {
            return !new String(this.mailStorePasswordField.getPassword()).trim().equals("");
        }

        public boolean isSetRetypeStorePassword() {
            return !new String(this.retypeStorePasswordField.getPassword()).trim().equals("");
        }

        public boolean isSetMailStoreProvider() {
            return this.mailStoreProtocolField.getSelectedItem() != null;
        }

        public boolean isSetMailDebugCheckBox() {
            return this.mailDebugCheckBox.isSelected();
        }
    }

    public class JavaMailFactoryListener
    extends FactoryListener
    implements ActionListener {
        boolean passwordsMatchMailStore() {
            return MailFactoryNode.this.decryptPassword(MailFactoryNode.this._javaMailFactoryPanel.getMailStorePassword()).equals(MailFactoryNode.this.decryptPassword(MailFactoryNode.this._javaMailFactoryPanel.getRetypeStorePassword()));
        }

        boolean passwordsMatchMailTransport() {
            return MailFactoryNode.this.decryptPassword(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportPassword()).equals(MailFactoryNode.this.decryptPassword(MailFactoryNode.this._javaMailFactoryPanel.getRetypeTransportPassword()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            super.actionPerformed(((MailFactoryNode)MailFactoryNode.this)._serviceDialog.tabbedPane, actionEvent);
            boolean bl = this.passwordsMatchMailStore();
            boolean bl2 = this.passwordsMatchMailTransport();
            boolean bl3 = bl & bl2;
            if (!bl3) {
                string = null;
                if (!bl) {
                    string = Utility.getMessage("helper.mailStorePasswordFieldName");
                }
                if (!bl2) {
                    string = Utility.getMessage("helper.mailTransportPasswordFieldName");
                }
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.passwordsMatchMail", string), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            }
            if (this.reqd && bl3) {
                string = this.getCustomValues(MailFactoryNode.this._ccr, ((MailFactoryNode)MailFactoryNode.this)._serviceDialog.customPanel);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(MailFactoryNode.this._javaMailFactoryPanel.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                MailSession mailSession = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!MailFactoryNode.this._ccr.factoryExists(MailFactoryNode.this._javaMailFactoryPanel.getName(), 4)) {
                        mailSession = MailFactoryNode.this._ccr.createMailSession();
                        mailSession.setName(MailFactoryNode.this._javaMailFactoryPanel.getName());
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        mailSession.setProvider(MailFactoryNode.this._ccr.findProvider(defaultMutableTreeNode2.getParent().toString(), 4));
                        mailSession.setDescription(MailFactoryNode.this._javaMailFactoryPanel.getDesc());
                        mailSession.setJndiName(MailFactoryNode.this._javaMailFactoryPanel.getJndiName());
                        mailSession.setMailFrom(MailFactoryNode.this._javaMailFactoryPanel.getMailFrom());
                        mailSession.setMailStoreHost(MailFactoryNode.this._javaMailFactoryPanel.getMailStoreHost());
                        mailSession.setMailStorePassword(MailFactoryNode.this._javaMailFactoryPanel.getMailStorePassword());
                        mailSession.setMailStoreUser(MailFactoryNode.this._javaMailFactoryPanel.getMailStoreUser());
                        if (MailFactoryNode.this._javaMailFactoryPanel.isSetMailStoreProvider() && !MailFactoryNode.this._javaMailFactoryPanel.getMailStoreProtocol().equals("")) {
                            mailSession.setMailStoreProtocol(MailFactoryNode.this._ccr.findProtocolProvider(MailFactoryNode.this._javaMailFactoryPanel.getMailStoreProtocol(), defaultMutableTreeNode2.getParent().toString()));
                        }
                        mailSession.setMailTransportHost(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportHost());
                        mailSession.setMailTransportPassword(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportPassword());
                        if (MailFactoryNode.this._javaMailFactoryPanel.isSetMailTransportProtocol() && !MailFactoryNode.this._javaMailFactoryPanel.getMailTransportProtocol().equals("")) {
                            mailSession.setMailTransportProtocol(MailFactoryNode.this._ccr.findProtocolProvider(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportProtocol(), defaultMutableTreeNode2.getParent().toString()));
                        }
                        mailSession.setMailTransportUser(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportUser());
                        mailSession.setDebug(MailFactoryNode.this._javaMailFactoryPanel.getMailDebugCheckBox());
                        mailSession.setPropertySet((J2EEResourcePropertySet)string);
                        MailFactoryNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(MailFactoryNode.this._serviceDialog);
                        if (n == 2) {
                            MailFactoryNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    mailSession = (MailSession)MailFactoryNode.this._ccr.findFactory(defaultMutableTreeNode2.toString(), 4);
                    mailSession.setDescription(MailFactoryNode.this._javaMailFactoryPanel.getDesc());
                    mailSession.setJndiName(MailFactoryNode.this._javaMailFactoryPanel.getJndiName());
                    mailSession.setMailFrom(MailFactoryNode.this._javaMailFactoryPanel.getMailFrom());
                    mailSession.setMailStoreHost(MailFactoryNode.this._javaMailFactoryPanel.getMailStoreHost());
                    mailSession.setMailStorePassword(MailFactoryNode.this._javaMailFactoryPanel.getMailStorePassword());
                    mailSession.setMailStoreUser(MailFactoryNode.this._javaMailFactoryPanel.getMailStoreUser());
                    if (MailFactoryNode.this._javaMailFactoryPanel.isSetMailStoreProvider()) {
                        mailSession.setMailStoreProtocol(MailFactoryNode.this._ccr.findProtocolProvider(MailFactoryNode.this._javaMailFactoryPanel.getMailStoreProtocol(), defaultMutableTreeNode2.getParent().getParent().toString()));
                    }
                    mailSession.setMailTransportHost(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportHost());
                    mailSession.setMailTransportPassword(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportPassword());
                    if (MailFactoryNode.this._javaMailFactoryPanel.isSetMailTransportProtocol()) {
                        mailSession.setMailTransportProtocol(MailFactoryNode.this._ccr.findProtocolProvider(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportProtocol(), defaultMutableTreeNode2.getParent().getParent().toString()));
                    }
                    mailSession.setMailTransportUser(MailFactoryNode.this._javaMailFactoryPanel.getMailTransportUser());
                    mailSession.setDebug(MailFactoryNode.this._javaMailFactoryPanel.getMailDebugCheckBox());
                    mailSession.setPropertySet((J2EEResourcePropertySet)string);
                    MailFactoryNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MailFactoryNode.this._serviceDialog.dispose();
        }
    }
}

