/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ws.client.ccrct.BorderUtilities;
import com.ibm.ws.client.ccrct.HelpFocusListener;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public abstract class Panel
extends JPanel {
    protected HelpFocusListener helpFocusListener = HelpFocusListener.INSTANCE;
    protected static final int FIELD_SIZE = 25;
    protected static final boolean REQUIRED = true;
    protected static final boolean NOT_REQUIRED = false;
    protected int nextPropertyPos = 0;
    GridBagConstraints gbc = new GridBagConstraints();
    JTextField nameField;
    JTextField descField;

    public Panel(Insets insets, boolean bl) {
        this.gbc.fill = 2;
        this.gbc.anchor = 18;
        this.gbc.insets = insets;
        this.setLayout(new GridBagLayout());
        this.nameField = this.addNextProperty("helper.nameLabel", "name", true, bl);
        this.descField = this.addNextProperty("helper.descriptionLabel", "description", false, bl);
    }

    public JTextField addNextPropertyWithRemainder(String string, String string2, boolean bl) {
        return this.addNextProperty(string, string2, bl, true);
    }

    public JTextField addNextProperty(String string, String string2, boolean bl) {
        return this.addNextProperty(string, string2, bl, false);
    }

    private JTextField addNextProperty(String string, String string2, boolean bl, boolean bl2) {
        JTextField jTextField = new JTextField(25);
        this.addNextProperty(jTextField, string, string2, bl, bl2);
        return jTextField;
    }

    public JPasswordField addNextPasswordProperty(String string, String string2, boolean bl) {
        JPasswordField jPasswordField = new JPasswordField(25);
        this.addNextProperty(jPasswordField, string, string2, bl, true);
        return jPasswordField;
    }

    public void addNextProperty(JComponent jComponent, String string, String string2, boolean bl, boolean bl2) {
        if (bl) {
            this.getRequiredBorder(jComponent);
        } else {
            this.getNonRequiredBorder(jComponent);
        }
        this.addNextPropertyNoBorder(jComponent, string, string2, bl2);
    }

    public void addNextPropertyNoBorder(JComponent jComponent, String string, String string2, boolean bl) {
        jComponent.setName(string2);
        jComponent.addFocusListener(this.helpFocusListener);
        JLabel jLabel = new JLabel(Utility.getMessage(string), 4);
        this.gbc.gridx = 0;
        this.gbc.gridy = this.nextPropertyPos;
        this.gbc.weightx = 0.0;
        this.gbc.gridwidth = 1;
        this.add((Component)jLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = this.nextPropertyPos;
        this.gbc.gridwidth = bl ? 0 : 1;
        this.gbc.weightx = 1.0;
        this.add((Component)jComponent, this.gbc);
        ++this.nextPropertyPos;
    }

    public GridBagConstraints getConstraints() {
        return this.gbc;
    }

    public String getName() {
        return this.nameField.getText().trim();
    }

    public String getDescription() {
        return this.descField.getText().trim();
    }

    public void getRequiredBorder(JComponent jComponent) {
        BorderUtilities.decorateJComponent(jComponent, true);
    }

    public void getNonRequiredBorder(JComponent jComponent) {
        BorderUtilities.decorateJComponent(jComponent, false);
    }
}

