/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.env.ResourceEnvEntry;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;

public class ResourceEnvFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(ResourceEnvFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private LocalServiceDialog _serviceDialog;
    private ClientContainerResourceRepository _ccr;
    private ResourceEnvEntryPanel resourceEnvEntryPanel;
    private ImageIcon _icon;
    private static final String _factoryType = "Resource Environment Entries";

    public ResourceEnvFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/ResourceEnvEntry.gif"));
    }

    public String toString() {
        return _factoryType;
    }

    public static String getType() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddResEnv");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = 4164926772680158801L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                ResourceEnvEntry resourceEnvEntry = (ResourceEnvEntry)ResourceEnvFactoryNode.this._ccr.findFactory(string, 16);
                ResourceEnvFactoryNode.this.resourceEnvEntryPanel = new ResourceEnvEntryPanel(resourceEnvEntry);
                this.customPanel = new CustomPanel((J2EEResourceFactory)resourceEnvEntry);
                this.createButton.setActionCommand("Update");
            } else {
                ResourceEnvFactoryNode.this.resourceEnvEntryPanel = new ResourceEnvEntryPanel();
            }
            this.setTitle(Utility.getMessage("helper.resRefEntryTitle"));
            this.createButton.addActionListener(new ResourceEnvEntryListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(ResourceEnvFactoryNode.this.resourceEnvEntryPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("RESOURCEENVENTRY");
            this.finishUp(n);
        }
    }

    public class ResourceEnvEntryPanel
    extends FactoryPanel {
        private static final long serialVersionUID = -4501238534469690088L;

        public ResourceEnvEntryPanel() {
        }

        ResourceEnvEntryPanel(ResourceEnvEntry resourceEnvEntry) {
            this();
            this.nameField.setText(resourceEnvEntry.getName() != null ? resourceEnvEntry.getName() : "");
            this.descField.setText(resourceEnvEntry.getDescription() != null ? resourceEnvEntry.getDescription() : "");
            this.jndiNameField.setText(resourceEnvEntry.getJndiName() != null ? resourceEnvEntry.getJndiName() : "");
            this.nameField.setEnabled(false);
        }
    }

    public class ResourceEnvEntryListener
    extends FactoryListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((ResourceEnvFactoryNode)ResourceEnvFactoryNode.this)._serviceDialog.tabbedPane, actionEvent);
            if (this.reqd) {
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(ResourceEnvFactoryNode.this._ccr, ((ResourceEnvFactoryNode)ResourceEnvFactoryNode.this)._serviceDialog.customPanel);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ResourceEnvFactoryNode.this.resourceEnvEntryPanel.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                ResourceEnvEntry resourceEnvEntry = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!ResourceEnvFactoryNode.this._ccr.factoryExists(ResourceEnvFactoryNode.this.resourceEnvEntryPanel.getName(), 16)) {
                        resourceEnvEntry = ResourceEnvFactoryNode.this._ccr.createResourceEnvEntry();
                        resourceEnvEntry.setName(ResourceEnvFactoryNode.this.resourceEnvEntryPanel.getName());
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        resourceEnvEntry.setProvider(ResourceEnvFactoryNode.this._ccr.findProvider(defaultMutableTreeNode2.getParent().toString(), 16));
                        resourceEnvEntry.setDescription(ResourceEnvFactoryNode.this.resourceEnvEntryPanel.getDesc());
                        resourceEnvEntry.setJndiName(ResourceEnvFactoryNode.this.resourceEnvEntryPanel.getJndiName());
                        resourceEnvEntry.setPropertySet(j2EEResourcePropertySet);
                        ResourceEnvFactoryNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(ResourceEnvFactoryNode.this._serviceDialog);
                        if (n == 2) {
                            ResourceEnvFactoryNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    resourceEnvEntry = (ResourceEnvEntry)ResourceEnvFactoryNode.this._ccr.findFactory(defaultMutableTreeNode2.toString(), 16);
                    resourceEnvEntry.setDescription(ResourceEnvFactoryNode.this.resourceEnvEntryPanel.getDesc());
                    resourceEnvEntry.setJndiName(ResourceEnvFactoryNode.this.resourceEnvEntryPanel.getJndiName());
                    resourceEnvEntry.setPropertySet(j2EEResourcePropertySet);
                    ResourceEnvFactoryNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ResourceEnvFactoryNode.this._serviceDialog.dispose();
        }
    }
}

