/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.url.URL;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class URLFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(URLFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private LocalServiceDialog _serviceDialog;
    private ClientContainerResourceRepository _ccr;
    private URLFactoryPanel _urlFactoryPanel;
    private ImageIcon _icon;
    private static final String _factoryType = "URLs";

    public URLFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/URL.gif"));
    }

    public String toString() {
        return _factoryType;
    }

    public static String getType() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddURL");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = 6022076681521617621L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                URL uRL = (URL)URLFactoryNode.this._ccr.findFactory(string, 8);
                URLFactoryNode.this._urlFactoryPanel = new URLFactoryPanel(uRL);
                this.customPanel = new CustomPanel((J2EEResourceFactory)uRL);
                this.createButton.setActionCommand("Update");
            } else {
                URLFactoryNode.this._urlFactoryPanel = new URLFactoryPanel();
            }
            this.setTitle(Utility.getMessage("helper.urlPropertiesTitle"));
            this.createButton.addActionListener(new URLFactoryListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(URLFactoryNode.this._urlFactoryPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("URLFACTORY");
            this.finishUp(n);
        }
    }

    public class URLFactoryPanel
    extends FactoryPanel {
        private static final long serialVersionUID = 3813067573892974295L;
        JTextField urlField = this.addNextPropertyWithRemainder("helper.urlLabel", "url", true);

        public URLFactoryPanel() {
        }

        URLFactoryPanel(URL uRL) {
            this();
            this.nameField.setText(uRL.getName() != null ? uRL.getName() : "");
            this.descField.setText(uRL.getDescription() != null ? uRL.getDescription() : "");
            this.jndiNameField.setText(uRL.getJndiName() != null ? uRL.getJndiName() : "");
            this.urlField.setText(uRL.getSpec() != null ? uRL.getSpec() : "");
            this.nameField.setEnabled(false);
        }

        public String getUrl() {
            return this.urlField.getText().trim();
        }
    }

    public class URLFactoryListener
    extends FactoryListener
    implements ActionListener {
        boolean urlRequiredCheck() {
            return !URLFactoryNode.this._urlFactoryPanel.getUrl().equals("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((URLFactoryNode)URLFactoryNode.this)._serviceDialog.tabbedPane, actionEvent);
            boolean bl = this.urlRequiredCheck();
            if (!bl && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.requiredAttributes"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            }
            if (this.reqd && bl) {
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(URLFactoryNode.this._ccr, ((URLFactoryNode)URLFactoryNode.this)._serviceDialog.customPanel);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(URLFactoryNode.this._urlFactoryPanel.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                URL uRL = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!URLFactoryNode.this._ccr.factoryExists(URLFactoryNode.this._urlFactoryPanel.getName(), 8)) {
                        uRL = URLFactoryNode.this._ccr.createURL();
                        uRL.setName(URLFactoryNode.this._urlFactoryPanel.getName());
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        uRL.setProvider(URLFactoryNode.this._ccr.findProvider(defaultMutableTreeNode2.getParent().toString(), 8));
                        uRL.setDescription(URLFactoryNode.this._urlFactoryPanel.getDesc());
                        uRL.setJndiName(URLFactoryNode.this._urlFactoryPanel.getJndiName());
                        uRL.setSpec(URLFactoryNode.this._urlFactoryPanel.getUrl());
                        uRL.setPropertySet(j2EEResourcePropertySet);
                        URLFactoryNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(URLFactoryNode.this._serviceDialog);
                        if (n == 2) {
                            URLFactoryNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    uRL = (URL)URLFactoryNode.this._ccr.findFactory(defaultMutableTreeNode2.toString(), 8);
                    uRL.setDescription(URLFactoryNode.this._urlFactoryPanel.getDesc());
                    uRL.setJndiName(URLFactoryNode.this._urlFactoryPanel.getJndiName());
                    uRL.setSpec(URLFactoryNode.this._urlFactoryPanel.getUrl());
                    uRL.setPropertySet(j2EEResourcePropertySet);
                    URLFactoryNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            URLFactoryNode.this._serviceDialog.dispose();
        }
    }
}

