/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.url.URLProvider;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepositoryImpl;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ProviderListener;
import com.ibm.ws.client.ccrct.ProviderPanel;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.URLFactoryNode;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class URLProviderNode
extends Node {
    private LocalServiceDialog _serviceDialog;
    private ClientContainerResourceRepositoryImpl _ccr;
    private URLProviderPanel _urlPanel;
    private ImageIcon _icon;
    private static final String _providerType = "URL Providers";

    public URLProviderNode(ClientContainerResourceRepositoryImpl clientContainerResourceRepositoryImpl) {
        this._ccr = clientContainerResourceRepositoryImpl;
        this._icon = new ImageIcon(this.getClass().getResource("images/URLprovider.gif"));
    }

    public String toString() {
        return _providerType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddURLProvider");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = -8152808555109844106L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                URLProvider uRLProvider = (URLProvider)URLProviderNode.this._ccr.findProvider(string, 8);
                URLProviderNode.this._urlPanel = new URLProviderPanel(uRLProvider);
                this.customPanel = new CustomPanel((J2EEResourceProvider)uRLProvider);
                this.createButton.setActionCommand("Update");
            } else {
                URLProviderNode.this._urlPanel = new URLProviderPanel();
            }
            this.setTitle(Utility.getMessage("helper.urlProviderTitle"));
            this.createButton.addActionListener(new URLProviderListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(URLProviderNode.this._urlPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("URLPROVIDER");
            this.finishUp(n);
        }
    }

    public class URLProviderPanel
    extends ProviderPanel {
        private static final long serialVersionUID = 8705549069389152895L;
        private JTextField protocolField = this.addNextPropertyWithRemainder("helper.protocolLabel", "protocol", false);
        private JTextField streamHandlerClassField = this.addNextPropertyWithRemainder("helper.streamHandlerClassLabel", "stream handler class", false);

        public URLProviderPanel() {
        }

        public URLProviderPanel(URLProvider uRLProvider) {
            this();
            this.nameField.setText(uRLProvider.getName() != null ? uRLProvider.getName() : "");
            this.descField.setText(uRLProvider.getDescription() != null ? uRLProvider.getDescription() : "");
            this.protocolField.setText(uRLProvider.getProtocol() != null ? uRLProvider.getProtocol() : "");
            this.streamHandlerClassField.setText(uRLProvider.getStreamHandlerClassName() != null ? uRLProvider.getStreamHandlerClassName() : "");
            this.classpathField.setText(uRLProvider.getClasspath().size() > 0 ? com.ibm.ws.client.applicationclient.Utility.getProviderClasspath(uRLProvider.getClasspath()) : "");
            this.nameField.setEnabled(false);
        }

        public String getProtocol() {
            return this.protocolField.getText().trim();
        }

        public String getStreamHandlerClass() {
            return this.streamHandlerClassField.getText().trim();
        }
    }

    public class URLProviderListener
    extends ProviderListener
    implements ActionListener {
        boolean urlRequiredCheck(URLProviderPanel uRLProviderPanel) {
            return !uRLProviderPanel.getStreamHandlerClass().equals("") && !uRLProviderPanel.getProtocol().equals("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((URLProviderNode)URLProviderNode.this)._serviceDialog.tabbedPane, actionEvent);
            if (this.reqd) {
                URLProvider uRLProvider = null;
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(URLProviderNode.this._ccr, ((URLProviderNode)URLProviderNode.this)._serviceDialog.customPanel);
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!URLProviderNode.this._ccr.providerExists(URLProviderNode.this._urlPanel.getName(), 63)) {
                        uRLProvider = URLProviderNode.this._ccr.createURLProvider();
                        uRLProvider.setName(URLProviderNode.this._urlPanel.getName());
                        uRLProvider.setDescription(URLProviderNode.this._urlPanel.getDescription());
                        uRLProvider.setProtocol(URLProviderNode.this._urlPanel.getProtocol());
                        uRLProvider.setStreamHandlerClassName(URLProviderNode.this._urlPanel.getStreamHandlerClass());
                        com.ibm.ws.client.applicationclient.Utility.setProviderClasspath(uRLProvider.getClasspath(), URLProviderNode.this._urlPanel.getClasspath());
                        uRLProvider.setPropertySet(j2EEResourcePropertySet);
                        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(URLProviderNode.this._urlPanel.getName());
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new URLFactoryNode(URLProviderNode.this._ccr));
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, 0);
                        URLProviderNode.this._ccr.addProvider((J2EEResourceProvider)uRLProvider);
                        URLProviderNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(URLProviderNode.this._serviceDialog);
                        if (n == 2) {
                            URLProviderNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    uRLProvider = (URLProvider)URLProviderNode.this._ccr.findProvider(URLProviderNode.this._urlPanel.getName(), 8);
                    uRLProvider.setDescription(URLProviderNode.this._urlPanel.getDescription());
                    uRLProvider.setProtocol(URLProviderNode.this._urlPanel.getProtocol());
                    uRLProvider.setStreamHandlerClassName(URLProviderNode.this._urlPanel.getStreamHandlerClass());
                    com.ibm.ws.client.applicationclient.Utility.setProviderClasspath(uRLProvider.getClasspath(), URLProviderNode.this._urlPanel.getClasspath());
                    uRLProvider.setPropertySet(j2EEResourcePropertySet);
                    URLProviderNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            URLProviderNode.this._serviceDialog.dispose();
        }
    }
}

