/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingExpiryType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingPersistenceType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingPriorityType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueue;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class WASQueueFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(WASQueueFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private ServiceDialog _serviceDialog;
    private ClientContainerResourceRepository _ccr;
    private ImageIcon _icon;
    private WASQueuePanel wasQueuePanel;
    private static final String _factoryType = "Queue Destinations";

    public WASQueueFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/JMSDestinationFactory.gif"));
    }

    public String toString() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddQDest");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = 3737330411088246176L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                WASQueue wASQueue = (WASQueue)WASQueueFactoryNode.this._ccr.findFactory(string, 2);
                WASQueueFactoryNode.this.wasQueuePanel = new WASQueuePanel(wASQueue);
                this.customPanel = new CustomPanel((J2EEResourceFactory)wASQueue);
                this.createButton.setActionCommand("Update");
            } else {
                WASQueueFactoryNode.this.wasQueuePanel = new WASQueuePanel();
            }
            this.setTitle(Utility.getMessage("helper.QpropTitle"));
            this.createButton.addActionListener(new WASQueueListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(WASQueueFactoryNode.this.wasQueuePanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("WASQUEUE");
            this.finishUp(n);
        }
    }

    public class WASQueuePanel
    extends FactoryPanel {
        private static final long serialVersionUID = 760816382418428466L;
        JComboBox persistenceField;
        JComboBox priorityField;
        JTextField specifiedPriorityField;
        JComboBox expiryField;
        JTextField specifiedExpiryField;

        public WASQueuePanel() {
            String[] stringArray = new String[]{"APPLICATION_DEFINED", "PERSISTENT", "NONPERSISTENT"};
            this.persistenceField = new JComboBox<String>(stringArray);
            this.addNextProperty(this.persistenceField, "helper.persistenceLabel", "persistence", true, true);
            String[] stringArray2 = new String[]{"APPLICATION_DEFINED", "SPECIFIED"};
            this.priorityField = new JComboBox<String>(stringArray2);
            this.addNextProperty(this.priorityField, "helper.priorityLabel", "priority", true, true);
            this.priorityField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    if (string.equals("APPLICATION_DEFINED")) {
                        WASQueuePanel.this.specifiedPriorityField.setText("");
                        WASQueuePanel.this.specifiedPriorityField.setEditable(false);
                        WASQueuePanel.this.specifiedPriorityField.setBackground(Color.lightGray);
                        WASQueuePanel.this.specifiedPriorityField.setEnabled(false);
                        WASQueuePanel.this.getNonRequiredBorder(WASQueuePanel.this.specifiedPriorityField);
                    } else {
                        WASQueuePanel.this.specifiedPriorityField.setEditable(true);
                        WASQueuePanel.this.specifiedPriorityField.setBackground(Color.white);
                        WASQueuePanel.this.specifiedPriorityField.setEnabled(true);
                        WASQueuePanel.this.getRequiredBorder(WASQueuePanel.this.specifiedPriorityField);
                    }
                }
            });
            this.specifiedPriorityField = this.addNextPropertyWithRemainder("helper.specifiedPriorityLabel", "specifiedPriority", false);
            this.specifiedPriorityField.setEditable(false);
            this.specifiedPriorityField.setBackground(Color.lightGray);
            String[] stringArray3 = new String[]{"APPLICATION_DEFINED", "UNLIMITED", "SPECIFIED"};
            this.expiryField = new JComboBox<String>(stringArray3);
            this.addNextProperty(this.expiryField, "helper.expiryLabel", "expiry", true, true);
            this.expiryField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    if (string.equals("APPLICATION_DEFINED") || string.equals("UNLIMITED")) {
                        WASQueuePanel.this.specifiedExpiryField.setText("");
                        WASQueuePanel.this.specifiedExpiryField.setEditable(false);
                        WASQueuePanel.this.specifiedExpiryField.setBackground(Color.lightGray);
                        WASQueuePanel.this.specifiedExpiryField.setEnabled(false);
                        WASQueuePanel.this.getNonRequiredBorder(WASQueuePanel.this.specifiedExpiryField);
                    } else {
                        WASQueuePanel.this.specifiedExpiryField.setEditable(true);
                        WASQueuePanel.this.specifiedExpiryField.setBackground(Color.white);
                        WASQueuePanel.this.specifiedExpiryField.setEnabled(true);
                        WASQueuePanel.this.getRequiredBorder(WASQueuePanel.this.specifiedExpiryField);
                    }
                }
            });
            this.specifiedExpiryField = this.addNextPropertyWithRemainder("helper.specifiedExpiryLabel", "specifiedExpiry", false);
            this.specifiedExpiryField.setEditable(false);
            this.specifiedExpiryField.setBackground(Color.lightGray);
        }

        public WASQueuePanel(WASQueue wASQueue) {
            this();
            this.nameField.setText(wASQueue.getName() != null ? wASQueue.getName() : "");
            this.descField.setText(wASQueue.getDescription() != null ? wASQueue.getDescription() : "");
            this.jndiNameField.setText(wASQueue.getJndiName() != null ? wASQueue.getJndiName() : "");
            this.persistenceField.setSelectedItem(wASQueue.isSetPersistence() ? wASQueue.getPersistence().getName() : "");
            this.priorityField.setSelectedItem(wASQueue.isSetPriority() ? wASQueue.getPriority().getName() : "");
            this.specifiedPriorityField.setText(wASQueue.isSetSpecifiedPriority() ? Integer.toString(wASQueue.getSpecifiedPriority()) : "");
            this.expiryField.setSelectedItem(wASQueue.isSetExpiry() ? wASQueue.getExpiry().getName() : "");
            this.specifiedExpiryField.setText(wASQueue.isSetSpecifiedExpiry() ? Long.toString(wASQueue.getSpecifiedExpiry()) : "");
        }

        public String getPersistence() {
            return (String)this.persistenceField.getSelectedItem();
        }

        public String getPriority() {
            return (String)this.priorityField.getSelectedItem();
        }

        public String getSpecifiedPriority() {
            return this.specifiedPriorityField.getText().trim();
        }

        public String getExpiry() {
            return (String)this.expiryField.getSelectedItem();
        }

        public String getSpecifiedExpiry() {
            return this.specifiedExpiryField.getText().trim();
        }

        public boolean isSetSpecifiedPriority() {
            return !this.specifiedPriorityField.getText().trim().equals("");
        }

        public boolean isSetSpecifiedExpiry() {
            return !this.specifiedExpiryField.getText().trim().equals("");
        }
    }

    public class WASQueueListener
    extends FactoryListener
    implements ActionListener {
        boolean wasRequiredCheck() {
            return (!WASQueueFactoryNode.this.wasQueuePanel.getPriority().equals("SPECIFIED") || !WASQueueFactoryNode.this.wasQueuePanel.getSpecifiedPriority().equals("")) && (!WASQueueFactoryNode.this.wasQueuePanel.getExpiry().equals("SPECIFIED") || !WASQueueFactoryNode.this.wasQueuePanel.getSpecifiedExpiry().equals(""));
        }

        boolean checkSpecifiedPriority() {
            if (WASQueueFactoryNode.this.wasQueuePanel.getPriority().equals("SPECIFIED")) {
                String string = WASQueueFactoryNode.this.wasQueuePanel.getSpecifiedPriority();
                if (string.length() != 0) {
                    try {
                        Integer n = new Integer(string);
                        return n <= 9 && n >= 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        boolean checkSpecifiedExpiry() {
            if (WASQueueFactoryNode.this.wasQueuePanel.getExpiry().equals("SPECIFIED")) {
                String string = WASQueueFactoryNode.this.wasQueuePanel.getSpecifiedExpiry();
                if (string.length() != 0) {
                    try {
                        Long l = new Long(string);
                        return l <= Long.MAX_VALUE && l >= 0L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((WASQueueFactoryNode)WASQueueFactoryNode.this)._serviceDialog.tabbedPane, actionEvent);
            boolean bl = this.wasRequiredCheck();
            boolean bl2 = this.checkSpecifiedPriority();
            boolean bl3 = this.checkSpecifiedExpiry();
            if (!bl && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.requiredAttributes"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl2 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.specifiedPriortyIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl3 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.specifiedExpiryIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            }
            if (this.reqd && bl && bl2 && bl3) {
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(WASQueueFactoryNode.this._ccr, ((WASQueueFactoryNode)WASQueueFactoryNode.this)._serviceDialog.customPanel);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(WASQueueFactoryNode.this.wasQueuePanel.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                WASQueue wASQueue = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!WASQueueFactoryNode.this._ccr.factoryExists(WASQueueFactoryNode.this.wasQueuePanel.getName(), 2)) {
                        wASQueue = WASQueueFactoryNode.this._ccr.createWASQueue();
                        wASQueue.setName(WASQueueFactoryNode.this.wasQueuePanel.getName());
                        wASQueue.setDescription(WASQueueFactoryNode.this.wasQueuePanel.getDesc());
                        wASQueue.setJndiName(WASQueueFactoryNode.this.wasQueuePanel.getJndiName());
                        wASQueue.setPersistence(MessagingPersistenceType.get((String)WASQueueFactoryNode.this.wasQueuePanel.getPersistence()));
                        wASQueue.setPriority(MessagingPriorityType.get((String)WASQueueFactoryNode.this.wasQueuePanel.getPriority()));
                        if (WASQueueFactoryNode.this.wasQueuePanel.isSetSpecifiedPriority()) {
                            wASQueue.setSpecifiedPriority(Integer.parseInt(WASQueueFactoryNode.this.wasQueuePanel.getSpecifiedPriority()));
                        }
                        wASQueue.setExpiry(MessagingExpiryType.get((String)WASQueueFactoryNode.this.wasQueuePanel.getExpiry()));
                        if (WASQueueFactoryNode.this.wasQueuePanel.isSetSpecifiedExpiry()) {
                            wASQueue.setSpecifiedExpiry(Long.parseLong(WASQueueFactoryNode.this.wasQueuePanel.getSpecifiedExpiry()));
                        }
                        wASQueue.setPropertySet(j2EEResourcePropertySet);
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        wASQueue.setProvider(WASQueueFactoryNode.this._ccr.findProvider(defaultMutableTreeNode2.getParent().toString(), 2));
                        WASQueueFactoryNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(WASQueueFactoryNode.this._serviceDialog);
                        if (n == 2) {
                            WASQueueFactoryNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    wASQueue = (WASQueue)WASQueueFactoryNode.this._ccr.findFactory(defaultMutableTreeNode2.toString(), 2);
                    wASQueue.setDescription(WASQueueFactoryNode.this.wasQueuePanel.getDesc());
                    wASQueue.setJndiName(WASQueueFactoryNode.this.wasQueuePanel.getJndiName());
                    wASQueue.setPersistence(MessagingPersistenceType.get((String)WASQueueFactoryNode.this.wasQueuePanel.getPersistence()));
                    wASQueue.setPriority(MessagingPriorityType.get((String)WASQueueFactoryNode.this.wasQueuePanel.getPriority()));
                    if (WASQueueFactoryNode.this.wasQueuePanel.isSetSpecifiedPriority()) {
                        wASQueue.setSpecifiedPriority(Integer.parseInt(WASQueueFactoryNode.this.wasQueuePanel.getSpecifiedPriority()));
                    }
                    wASQueue.setExpiry(MessagingExpiryType.get((String)WASQueueFactoryNode.this.wasQueuePanel.getExpiry()));
                    if (WASQueueFactoryNode.this.wasQueuePanel.isSetSpecifiedExpiry()) {
                        wASQueue.setSpecifiedExpiry(Long.parseLong(WASQueueFactoryNode.this.wasQueuePanel.getSpecifiedExpiry()));
                    }
                    wASQueue.setPropertySet(j2EEResourcePropertySet);
                    WASQueueFactoryNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            WASQueueFactoryNode.this._serviceDialog.dispose();
        }
    }
}

