/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingExpiryType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingPersistenceType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingPriorityType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopic;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.CustomPanel;
import com.ibm.ws.client.ccrct.FactoryListener;
import com.ibm.ws.client.ccrct.FactoryPanel;
import com.ibm.ws.client.ccrct.Globals;
import com.ibm.ws.client.ccrct.HelpButtonListener;
import com.ibm.ws.client.ccrct.Node;
import com.ibm.ws.client.ccrct.ServiceDialog;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class WASTopicFactoryNode
extends Node {
    private static final TraceComponent tc = Tr.register(WASTopicFactoryNode.class, null, "com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    private ServiceDialog _serviceDialog;
    private ClientContainerResourceRepository _ccr;
    private ImageIcon _icon;
    private WASTopicPanel wasTopicPanel;
    private static final String _factoryType = "Topic Destinations";

    public WASTopicFactoryNode(ClientContainerResourceRepository clientContainerResourceRepository) {
        this._ccr = clientContainerResourceRepository;
        this._icon = new ImageIcon(this.getClass().getResource("images/JMSDestinationFactory.gif"));
    }

    public String toString() {
        return _factoryType;
    }

    public void showServiceDialog(JFrame jFrame, String string, boolean bl) {
        this._serviceDialog = new LocalServiceDialog(jFrame, 1, string, bl);
        this._serviceDialog.setLocationRelativeTo(jFrame);
        this._serviceDialog.show();
    }

    public String getToolTipText() {
        return Utility.getMessage("tree.tttAddTopicDest");
    }

    public String getToolTipTextIfParent(String string) {
        return Utility.getMessage("tree.tttPropsAndDelete");
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    private class LocalServiceDialog
    extends ServiceDialog {
        private static final long serialVersionUID = -2758693208263975863L;

        public LocalServiceDialog(JFrame jFrame, int n, String string, boolean bl) {
            super(jFrame);
            if (bl) {
                WASTopic wASTopic = (WASTopic)WASTopicFactoryNode.this._ccr.findFactory(string, 2);
                WASTopicFactoryNode.this.wasTopicPanel = new WASTopicPanel(wASTopic);
                this.customPanel = new CustomPanel((J2EEResourceFactory)wASTopic);
                this.createButton.setActionCommand("Update");
            } else {
                WASTopicFactoryNode.this.wasTopicPanel = new WASTopicPanel();
            }
            this.setTitle(Utility.getMessage("helper.TpropTitle"));
            this.createButton.addActionListener(new WASTopicListener());
            this.cancelButton.addActionListener(new CancelButtonListener());
            this.helpButton.addActionListener(new HelpButtonListener());
            this.scrollPane.getViewport().setView(WASTopicFactoryNode.this.wasTopicPanel);
            this.tabbedPane.add((Component)this.scrollPane, Utility.getMessage("helper.generalTitle"));
            Globals.setHelpId("WASTOPIC");
            this.finishUp(n);
        }
    }

    public class WASTopicPanel
    extends FactoryPanel {
        private static final long serialVersionUID = -210186412887505377L;
        JTextField topicField = this.addNextPropertyWithRemainder("helper.topicnameLabel", "topic", true);
        JComboBox persistenceField;
        JComboBox priorityField;
        JComboBox expiryField;
        JTextField specifiedPriorityField;
        JTextField specifiedExpiryField;

        public WASTopicPanel() {
            String[] stringArray = new String[]{"APPLICATION_DEFINED", "PERSISTENT", "NONPERSISTENT"};
            this.persistenceField = new JComboBox<String>(stringArray);
            this.addNextProperty(this.persistenceField, "helper.persistenceLabel", "persistence", true, true);
            String[] stringArray2 = new String[]{"APPLICATION_DEFINED", "SPECIFIED"};
            this.priorityField = new JComboBox<String>(stringArray2);
            this.addNextProperty(this.priorityField, "helper.priorityLabel", "priority", true, true);
            this.priorityField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    if (string.equals("APPLICATION_DEFINED")) {
                        WASTopicPanel.this.specifiedPriorityField.setText("");
                        WASTopicPanel.this.specifiedPriorityField.setEditable(false);
                        WASTopicPanel.this.specifiedPriorityField.setBackground(Color.lightGray);
                        WASTopicPanel.this.specifiedPriorityField.setEnabled(false);
                        WASTopicPanel.this.getNonRequiredBorder(WASTopicPanel.this.specifiedPriorityField);
                    } else {
                        WASTopicPanel.this.specifiedPriorityField.setEditable(true);
                        WASTopicPanel.this.specifiedPriorityField.setBackground(Color.white);
                        WASTopicPanel.this.specifiedPriorityField.setEnabled(true);
                        WASTopicPanel.this.getRequiredBorder(WASTopicPanel.this.specifiedPriorityField);
                    }
                }
            });
            this.specifiedPriorityField = this.addNextPropertyWithRemainder("helper.specifiedPriorityLabel", "specifiedPriority", false);
            this.specifiedPriorityField.setEditable(false);
            this.specifiedPriorityField.setBackground(Color.lightGray);
            String[] stringArray3 = new String[]{"APPLICATION_DEFINED", "UNLIMITED", "SPECIFIED"};
            this.expiryField = new JComboBox<String>(stringArray3);
            this.addNextProperty(this.expiryField, "helper.expiryLabel", "expiry", true, true);
            this.expiryField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    if (string.equals("APPLICATION_DEFINED") || string.equals("UNLIMITED")) {
                        WASTopicPanel.this.specifiedExpiryField.setText("");
                        WASTopicPanel.this.specifiedExpiryField.setEditable(false);
                        WASTopicPanel.this.specifiedExpiryField.setBackground(Color.lightGray);
                        WASTopicPanel.this.specifiedExpiryField.setEnabled(false);
                        WASTopicPanel.this.getNonRequiredBorder(WASTopicPanel.this.specifiedExpiryField);
                    } else {
                        WASTopicPanel.this.specifiedExpiryField.setEditable(true);
                        WASTopicPanel.this.specifiedExpiryField.setBackground(Color.white);
                        WASTopicPanel.this.specifiedExpiryField.setEnabled(true);
                        WASTopicPanel.this.getRequiredBorder(WASTopicPanel.this.specifiedExpiryField);
                    }
                }
            });
            this.specifiedExpiryField = this.addNextPropertyWithRemainder("helper.specifiedExpiryLabel", "specifiedExpiry", false);
            this.specifiedExpiryField.setEditable(false);
            this.specifiedExpiryField.setBackground(Color.lightGray);
        }

        public WASTopicPanel(WASTopic wASTopic) {
            this();
            this.nameField.setText(wASTopic.getName() != null ? wASTopic.getName() : "");
            this.descField.setText(wASTopic.getDescription() != null ? wASTopic.getDescription() : "");
            this.jndiNameField.setText(wASTopic.getJndiName() != null ? wASTopic.getJndiName() : "");
            this.topicField.setText(wASTopic.getTopic() != null ? wASTopic.getTopic() : "");
            this.persistenceField.setSelectedItem(wASTopic.isSetPersistence() ? wASTopic.getPersistence().getName() : "");
            this.priorityField.setSelectedItem(wASTopic.isSetPriority() ? wASTopic.getPriority().getName() : "");
            this.specifiedPriorityField.setText(wASTopic.isSetSpecifiedPriority() ? Long.toString(wASTopic.getSpecifiedPriority()) : "");
            this.expiryField.setSelectedItem(wASTopic.isSetExpiry() ? wASTopic.getExpiry().getName() : "");
            this.specifiedExpiryField.setText(wASTopic.isSetSpecifiedExpiry() ? Long.toString(wASTopic.getSpecifiedExpiry()) : "");
            this.nameField.setEnabled(false);
        }

        public String getTopic() {
            return this.topicField.getText().trim();
        }

        public String getPersistence() {
            return (String)this.persistenceField.getSelectedItem();
        }

        public String getPriority() {
            return (String)this.priorityField.getSelectedItem();
        }

        public String getSpecifiedPriority() {
            return this.specifiedPriorityField.getText().trim();
        }

        public String getExpiry() {
            return (String)this.expiryField.getSelectedItem();
        }

        public String getSpecifiedExpiry() {
            return this.specifiedExpiryField.getText().trim();
        }

        public boolean isSetTopic() {
            return !this.topicField.getText().trim().equals("");
        }

        public boolean isSetSpecifiedPriority() {
            return !this.specifiedPriorityField.getText().trim().equals("");
        }

        public boolean isSetSpecifiedExpiry() {
            return !this.specifiedExpiryField.getText().trim().equals("");
        }
    }

    public class WASTopicListener
    extends FactoryListener
    implements ActionListener {
        boolean wasRequiredCheck() {
            return !WASTopicFactoryNode.this.wasTopicPanel.getTopic().equals("") && (!WASTopicFactoryNode.this.wasTopicPanel.getPriority().equals("SPECIFIED") || !WASTopicFactoryNode.this.wasTopicPanel.getSpecifiedPriority().equals("")) && (!WASTopicFactoryNode.this.wasTopicPanel.getExpiry().equals("SPECIFIED") || !WASTopicFactoryNode.this.wasTopicPanel.getSpecifiedExpiry().equals(""));
        }

        boolean checkSpecifiedPriority() {
            if (WASTopicFactoryNode.this.wasTopicPanel.getPriority().equals("SPECIFIED")) {
                String string = WASTopicFactoryNode.this.wasTopicPanel.getSpecifiedPriority();
                if (string.length() != 0) {
                    try {
                        Integer n = new Integer(string);
                        return n <= 9 && n >= 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        boolean checkSpecifiedExpiry() {
            if (WASTopicFactoryNode.this.wasTopicPanel.getExpiry().equals("SPECIFIED")) {
                String string = WASTopicFactoryNode.this.wasTopicPanel.getSpecifiedExpiry();
                if (string.length() != 0) {
                    try {
                        Long l = new Long(string);
                        return l <= Long.MAX_VALUE && l >= 0L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(((WASTopicFactoryNode)WASTopicFactoryNode.this)._serviceDialog.tabbedPane, actionEvent);
            boolean bl = this.wasRequiredCheck();
            boolean bl2 = this.checkSpecifiedPriority();
            boolean bl3 = this.checkSpecifiedExpiry();
            if (!bl && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.requiredAttributes"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl2 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.specifiedPriortyIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            } else if (!bl3 && this.reqd) {
                JOptionPane.showMessageDialog(null, Utility.getMessage("helper.specifiedExpiryIncorrect"), Utility.getMessage("helper.errorTitle"), 0, Globals.getCriticalImage());
            }
            if (this.reqd && bl && bl2 && bl3) {
                J2EEResourcePropertySet j2EEResourcePropertySet = this.getCustomValues(WASTopicFactoryNode.this._ccr, ((WASTopicFactoryNode)WASTopicFactoryNode.this)._serviceDialog.customPanel);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(WASTopicFactoryNode.this.wasTopicPanel.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Globals.getJTree1().getLastSelectedPathComponent();
                WASTopic wASTopic = null;
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Create")) {
                    if (!WASTopicFactoryNode.this._ccr.factoryExists(WASTopicFactoryNode.this.wasTopicPanel.getName(), 2)) {
                        wASTopic = WASTopicFactoryNode.this._ccr.createWASTopic();
                        wASTopic.setName(WASTopicFactoryNode.this.wasTopicPanel.getName());
                        wASTopic.setDescription(WASTopicFactoryNode.this.wasTopicPanel.getDesc());
                        wASTopic.setJndiName(WASTopicFactoryNode.this.wasTopicPanel.getJndiName());
                        wASTopic.setTopic(WASTopicFactoryNode.this.wasTopicPanel.getTopic());
                        wASTopic.setPersistence(MessagingPersistenceType.get((String)WASTopicFactoryNode.this.wasTopicPanel.getPersistence()));
                        wASTopic.setPriority(MessagingPriorityType.get((String)WASTopicFactoryNode.this.wasTopicPanel.getPriority()));
                        if (WASTopicFactoryNode.this.wasTopicPanel.isSetSpecifiedPriority()) {
                            wASTopic.setSpecifiedPriority(Integer.parseInt(WASTopicFactoryNode.this.wasTopicPanel.getSpecifiedPriority()));
                        }
                        wASTopic.setExpiry(MessagingExpiryType.get((String)WASTopicFactoryNode.this.wasTopicPanel.getExpiry()));
                        if (WASTopicFactoryNode.this.wasTopicPanel.isSetSpecifiedExpiry()) {
                            wASTopic.setSpecifiedExpiry(Long.parseLong(WASTopicFactoryNode.this.wasTopicPanel.getSpecifiedExpiry()));
                        }
                        wASTopic.setPropertySet(j2EEResourcePropertySet);
                        Globals.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        wASTopic.setProvider(WASTopicFactoryNode.this._ccr.findProvider(defaultMutableTreeNode2.getParent().toString(), 2));
                        WASTopicFactoryNode.this._serviceDialog.dispose();
                    } else {
                        int n = this.createExistsDialog(WASTopicFactoryNode.this._serviceDialog);
                        if (n == 2) {
                            WASTopicFactoryNode.this._serviceDialog.dispose();
                        }
                    }
                }
                if (((AbstractButton)actionEvent.getSource()).getActionCommand().equals("Update")) {
                    wASTopic = (WASTopic)WASTopicFactoryNode.this._ccr.findFactory(defaultMutableTreeNode2.toString(), 2);
                    wASTopic.setDescription(WASTopicFactoryNode.this.wasTopicPanel.getDesc());
                    wASTopic.setJndiName(WASTopicFactoryNode.this.wasTopicPanel.getJndiName());
                    wASTopic.setTopic(WASTopicFactoryNode.this.wasTopicPanel.getTopic());
                    wASTopic.setPersistence(MessagingPersistenceType.get((String)WASTopicFactoryNode.this.wasTopicPanel.getPersistence()));
                    wASTopic.setPriority(MessagingPriorityType.get((String)WASTopicFactoryNode.this.wasTopicPanel.getPriority()));
                    if (WASTopicFactoryNode.this.wasTopicPanel.isSetSpecifiedPriority()) {
                        wASTopic.setSpecifiedPriority(Integer.parseInt(WASTopicFactoryNode.this.wasTopicPanel.getSpecifiedPriority()));
                    }
                    wASTopic.setExpiry(MessagingExpiryType.get((String)WASTopicFactoryNode.this.wasTopicPanel.getExpiry()));
                    if (WASTopicFactoryNode.this.wasTopicPanel.isSetSpecifiedExpiry()) {
                        wASTopic.setSpecifiedExpiry(Long.parseLong(WASTopicFactoryNode.this.wasTopicPanel.getSpecifiedExpiry()));
                    }
                    wASTopic.setPropertySet(j2EEResourcePropertySet);
                    WASTopicFactoryNode.this._serviceDialog.dispose();
                }
            }
        }
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            WASTopicFactoryNode.this._serviceDialog.dispose();
        }
    }
}

