/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.ws.cluster.topography.LSDClusterMemberDescription;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class KeyConverter {
    private static final TraceComponent tc = Tr.register(KeyConverter.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String selectionDescImplString;
    private static final String clusterDescImplString;
    private static final String clusterMemberDescImplString;
    private static final String processDescriptionImplString;
    private static final String iiopClusterMemberDescImplString;
    private static final String lsdClusterMemberDescImplString;
    private static final String selectionClusterMemberDescImplString;
    private static KeyRepository svKeyRepository;
    private static DescriptionManager svDescriptionManager;
    private static ProcessProperties svProcessProperties;
    private static ClusterService svClusterService;
    private static Map svConvertedKeys;
    private static Map svTranslatedKeys;
    private static String[] WEIGHTED;
    private static String[] WEIGHTED_PREFERLOCAL;
    private static String cellName;
    private static String containingClusterKey;
    private static String memberName;

    public static DescriptionKey convertKey(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        DescriptionKey descriptionKey = (DescriptionKey)svConvertedKeys.get(list);
        if (descriptionKey != null) {
            return descriptionKey;
        }
        boolean bl = false;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        int n = stringArray.length;
        if (n >= 3 && stringArray[0].equals(SelectionClusterMemberDescription.distinction[1])) {
            bl = true;
        }
        if (bl) {
            if (n == 3) {
                descriptionKey = SelectionDescription.KEY_WEIGHTED;
            } else if (n == 4) {
                descriptionKey = SelectionDescription.KEY_WEIGHTED_PREFER_LOCAL;
            }
        } else {
            DescriptionKey descriptionKey2 = null;
            if (n == 2) {
                if (stringArray[0] != null && stringArray[0].equals(cellName) || stringArray[0] == null) {
                    if (stringArray[1] != null) {
                        descriptionKey = descriptionKey2 = (DescriptionKey)svClusterService.stringToIdentity(stringArray[1]);
                    }
                } else {
                    treeMap.put("CELLNAME", stringArray[0]);
                    treeMap.put("CLUSTERNAME", stringArray[1]);
                }
            } else if (n == 3) {
                descriptionKey2 = (DescriptionKey)svProcessProperties.get(stringArray[2]);
                if (descriptionKey2 == null) {
                    if (stringArray[0] != null && stringArray[0].equals(cellName) || stringArray[0] == null) {
                        if (stringArray[2] != null) {
                            descriptionKey = descriptionKey2 = (DescriptionKey)svClusterService.stringToIdentity(stringArray[2]);
                        }
                    } else {
                        treeMap.put("CELLNAME", stringArray[0]);
                        treeMap.put("CLUSTERNAME", stringArray[1]);
                        treeMap.put("UID", stringArray[2]);
                    }
                } else {
                    descriptionKey = descriptionKey2;
                }
            } else if (n == 4) {
                descriptionKey2 = (DescriptionKey)svProcessProperties.get(stringArray[2]);
                if (descriptionKey2 == null) {
                    if (stringArray[0] != null && stringArray[0].equals(cellName) || stringArray[0] == null) {
                        if (stringArray[2] != null && !stringArray[2].equals(memberName)) {
                            descriptionKey2 = (DescriptionKey)svClusterService.stringToIdentity(stringArray[2]);
                        }
                    } else {
                        treeMap.put("CELLNAME", stringArray[0]);
                        treeMap.put("CLUSTERNAME", stringArray[1]);
                        treeMap.put("UID", stringArray[2]);
                    }
                }
                if (stringArray[3].equals(IIOPClusterMemberDescription.distinction[1])) {
                    treeMap.put(IIOPClusterMemberDescription.distinction[0], stringArray[3]);
                } else if (stringArray[3].equals(LSDClusterMemberDescription.distinction[1])) {
                    treeMap.put(LSDClusterMemberDescription.distinction[0], stringArray[3]);
                } else if (stringArray[3].equals(SelectionClusterMemberDescription.distinction[1])) {
                    treeMap.put(SelectionClusterMemberDescription.distinction[0], stringArray[3]);
                }
                if (descriptionKey2 != null) {
                    descriptionKey = svKeyRepository.getDescriptionKey(descriptionKey2, treeMap);
                }
            }
            if (descriptionKey2 == null) {
                descriptionKey = svKeyRepository.getDescriptionKey(treeMap);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "converted");
            for (int i = 0; i < stringArray.length; ++i) {
                Tr.debug(tc, "identities[" + i + "] = " + stringArray[i]);
            }
            Tr.debug(tc, "to key", descriptionKey);
        }
        svConvertedKeys.put(list, descriptionKey);
        return descriptionKey;
    }

    public static DescriptionKey convertKey(String string, String string2) {
        DescriptionKey descriptionKey;
        List<String> list;
        block4: {
            String[] stringArray = new String[]{string, string2};
            list = Arrays.asList(stringArray);
            descriptionKey = (DescriptionKey)svConvertedKeys.get(list);
            if (descriptionKey != null) {
                return descriptionKey;
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("CELLNAME", string);
            treeMap.put("CLUSTERNAME", string2);
            try {
                descriptionKey = svKeyRepository.getDescriptionKey(treeMap);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, KeyConverter.class.getName() + ".convertKey", "245", new Object[]{stringArray});
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "converted " + string + ":" + string2 + " to key " + descriptionKey);
        }
        svConvertedKeys.put(list, descriptionKey);
        return descriptionKey;
    }

    public static String[] translateKey(DescriptionKey descriptionKey, DescriptionKey[] descriptionKeyArray, String string, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        boolean bl3 = bl2 = descriptionKeyArray != null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "entry values: ", new Object[]{descriptionKey, string, new Boolean(bl)});
            if (bl2) {
                for (int i = 0; i < descriptionKeyArray.length; ++i) {
                    Tr.debug(tc, "parentKeys[" + i + "] = " + descriptionKeyArray[i]);
                }
            } else {
                Tr.debug(tc, "null parent keys");
            }
        }
        if (svConvertedKeys.containsValue(descriptionKey)) {
            Iterator iterator = new HashMap(svConvertedKeys).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!entry.getValue().equals(descriptionKey)) continue;
                String[] stringArray = (String[])((List)entry.getKey()).toArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "svConvertedKeys.containsValue(key) translated " + descriptionKey + " to");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Tr.debug(tc, "result[" + i + "] = " + stringArray[i]);
                    }
                }
                return stringArray;
            }
        } else if (svTranslatedKeys.containsKey(descriptionKey)) {
            String[] stringArray = (String[])svTranslatedKeys.get(descriptionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "svTranslatedKeys.containsKey(key) translated " + descriptionKey + " to");
                for (int i = 0; i < stringArray.length; ++i) {
                    Tr.debug(tc, "result[" + i + "] = " + stringArray[i]);
                }
            }
            return stringArray;
        }
        String[] stringArray = null;
        boolean bl4 = string.equals(selectionDescImplString);
        boolean bl5 = string.equals(clusterDescImplString);
        boolean bl6 = string.equals(clusterMemberDescImplString);
        boolean bl7 = string.equals(processDescriptionImplString);
        boolean bl8 = string.equals(iiopClusterMemberDescImplString);
        boolean bl9 = string.equals(lsdClusterMemberDescImplString);
        boolean bl10 = string.equals(selectionClusterMemberDescImplString);
        if (bl4) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isSelectionDescription", new Boolean(bl));
            }
            stringArray = bl ? WEIGHTED_PREFERLOCAL : WEIGHTED;
        } else if (bl5) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isClusterDescription");
            }
            stringArray = new String[2];
            object3 = descriptionKey.getProperties();
            object2 = (String)object3.get("CELLNAME");
            object = (String)object3.get("CLUSTERNAME");
            stringArray[0] = object2 != null ? object2 : cellName;
            stringArray[1] = object != null ? object : svClusterService.identityToString(descriptionKey);
        } else if (bl6 || bl7) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isClusterMemberDescription");
            }
            stringArray = new String[3];
            if (bl2) {
                object3 = descriptionKeyArray[0];
                object2 = object3.getProperties();
                stringArray[0] = (String)object2.get("CELLNAME");
                stringArray[1] = (String)object2.get("CLUSTERNAME");
                if (stringArray[0] == null || stringArray[1] == null) {
                    stringArray[0] = cellName;
                    stringArray[1] = containingClusterKey;
                }
                stringArray[2] = svClusterService.identityToString(descriptionKey);
            } else {
                stringArray[0] = cellName;
                stringArray[1] = containingClusterKey;
                stringArray[2] = svClusterService.identityToString(descriptionKey);
            }
        } else if (bl8) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isIIOPClusterMemberDescription");
            }
            stringArray = new String[4];
            if (bl2) {
                object3 = descriptionKeyArray[0];
                object2 = null;
                if (descriptionKeyArray.length >= 2) {
                    object2 = descriptionKeyArray[1];
                }
                object = object3.getProperties();
                stringArray[0] = (String)object.get("CELLNAME");
                stringArray[1] = (String)object.get("CLUSTERNAME");
                if (object2 != null) {
                    if (stringArray[0] == null || stringArray[1] == null) {
                        stringArray[0] = cellName;
                        stringArray[1] = containingClusterKey;
                    }
                    stringArray[2] = svClusterService.identityToString((Identity)object2);
                } else {
                    stringArray[0] = cellName;
                    stringArray[1] = containingClusterKey;
                    stringArray[2] = memberName;
                }
                stringArray[3] = IIOPClusterMemberDescription.distinction[1];
            } else {
                stringArray[0] = cellName;
                stringArray[1] = containingClusterKey;
                object3 = (IIOPClusterMemberDescription)svDescriptionManager.getDescription(descriptionKey);
                object2 = null;
                if (object3 != null) {
                    object2 = ((IIOPClusterMemberDescription.Memento)object3.getMemento()).getClusterMemberAssociation();
                }
                stringArray[2] = object2 != null ? svClusterService.identityToString((Identity)object2) : memberName;
                stringArray[3] = IIOPClusterMemberDescription.distinction[1];
            }
        } else if (bl9) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isLSDClusterMemberDescription");
            }
            stringArray = new String[4];
            if (bl2) {
                object3 = descriptionKeyArray[0];
                object2 = null;
                if (descriptionKeyArray.length >= 2) {
                    object2 = descriptionKeyArray[1];
                }
                object = object3.getProperties();
                stringArray[0] = (String)object.get("CELLNAME");
                stringArray[1] = (String)object.get("CLUSTERNAME");
                if (object2 != null) {
                    if (stringArray[0] == null || stringArray[1] == null) {
                        stringArray[0] = cellName;
                        stringArray[1] = containingClusterKey;
                    }
                    stringArray[2] = svClusterService.identityToString((Identity)object2);
                } else {
                    stringArray[0] = cellName;
                    stringArray[1] = containingClusterKey;
                    stringArray[2] = memberName;
                }
                stringArray[3] = LSDClusterMemberDescription.distinction[1];
            } else {
                stringArray[0] = cellName;
                stringArray[1] = containingClusterKey;
                object3 = (LSDClusterMemberDescription)svDescriptionManager.getDescription(descriptionKey);
                object2 = null;
                if (object3 != null) {
                    object2 = ((LSDClusterMemberDescription.Memento)object3.getMemento()).getClusterMemberAssociation();
                }
                stringArray[2] = object2 != null ? svClusterService.identityToString((Identity)object2) : memberName;
                stringArray[3] = LSDClusterMemberDescription.distinction[1];
            }
        } else if (bl10) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isSelectionClusterMemberDescription");
            }
            stringArray = new String[4];
            if (bl2) {
                object3 = descriptionKeyArray[0];
                object2 = null;
                if (descriptionKeyArray.length >= 2) {
                    object2 = descriptionKeyArray[1];
                }
                object = object3.getProperties();
                stringArray[0] = (String)object.get("CELLNAME");
                stringArray[1] = (String)object.get("CLUSTERNAME");
                if (object2 != null) {
                    if (stringArray[0] == null || stringArray[1] == null) {
                        stringArray[0] = cellName;
                        stringArray[1] = containingClusterKey;
                    }
                    stringArray[2] = svClusterService.identityToString((Identity)object2);
                } else {
                    stringArray[0] = cellName;
                    stringArray[1] = containingClusterKey;
                    stringArray[2] = memberName;
                }
                stringArray[3] = SelectionClusterMemberDescription.distinction[1];
            } else {
                stringArray[0] = cellName;
                stringArray[1] = containingClusterKey;
                object3 = (SelectionClusterMemberDescription)svDescriptionManager.getDescription(descriptionKey);
                object2 = null;
                if (object3 != null) {
                    object2 = ((SelectionClusterMemberDescription.Memento)object3.getMemento()).getClusterMemberAssociation();
                }
                stringArray[2] = object2 != null ? svClusterService.identityToString((Identity)object2) : memberName;
                stringArray[3] = SelectionClusterMemberDescription.distinction[1];
            }
        }
        svTranslatedKeys.put(descriptionKey, stringArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "translated " + descriptionKey + " to");
            for (int i = 0; i < stringArray.length; ++i) {
                Tr.debug(tc, "result[" + i + "] = " + stringArray[i]);
            }
        }
        return stringArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.9 ");
        }
        selectionDescImplString = SelectionDescription.class.getName();
        clusterDescImplString = ClusterDescription.class.getName();
        clusterMemberDescImplString = ClusterMemberDescription.class.getName();
        processDescriptionImplString = ProcessDescription.class.getName();
        iiopClusterMemberDescImplString = IIOPClusterMemberDescription.class.getName();
        lsdClusterMemberDescImplString = LSDClusterMemberDescription.class.getName();
        selectionClusterMemberDescImplString = SelectionClusterMemberDescription.class.getName();
        svKeyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
        DescriptionManagerFactory.getInstance();
        svDescriptionManager = DescriptionManagerFactory.getDescriptionManager();
        svProcessProperties = ProcessProperties.getInstance();
        svClusterService = ClusterServiceFactory.getClusterService();
        svConvertedKeys = Collections.synchronizedMap(new HashMap());
        svTranslatedKeys = Collections.synchronizedMap(new HashMap());
        WEIGHTED = null;
        WEIGHTED_PREFERLOCAL = null;
        cellName = "CELLNAME";
        containingClusterKey = "clusterName";
        memberName = "memberName";
        DescriptionKey descriptionKey = (DescriptionKey)svProcessProperties.get("key.containing.cluster");
        if (descriptionKey != null) {
            containingClusterKey = svClusterService.identityToString(descriptionKey);
        }
        WEIGHTED = new String[]{SelectionClusterMemberDescription.distinction[1], "weighted"};
        WEIGHTED_PREFERLOCAL = new String[]{SelectionClusterMemberDescription.distinction[1], "weighted", "preferlocal"};
    }
}

