/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class ProcessProperties
extends HashMap
implements FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(ProcessProperties.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final long serialVersionUID = -7848078131132374203L;
    public static final String unusableIntervalKey = "com.ibm.websphere.wlm.unusable.interval";
    public static final Integer KEY_UNUSABLE_INTERVAL;
    public static final String KEY_CONTAINING_CLUSTER = "key.containing.cluster";
    public static final String KEY_CONTAINING_CLUSTER_WEIGHT_TABLE = "key.containing.cluster.weight.table";
    public static final String KEY_CONTAINING_CELLNAME = "key.containing.cellname";
    public static final String KEY_CONTAINING_CLUSTERNAME = "key.containing.clustername";
    public static final String KEY_ORIGINAL_IOR = "key.original.ior";
    public static final String KEY_WEIGHTED = "key.weighted";
    public static final String KEY_WEIGHTED_PREFER_LOCAL = "key.weighted.preferlocal";
    public static final String KEY_WEIGHTED_NOT_INITIALIZED = "key.weighted.not.initialized";
    public static final String KEY_VIRTUAL_HOST = "key.virtual.host";
    public static final String KEY_DMGR_BOOTSTRAP = "key.dmgr.bootstrap";
    public static final String KEY_LOCAL_MEMBER = "key.local.member";
    public static final String KEY_BOOTSTRAP_REGISTRAR = "key.bootstrap.registrar";
    public static final String KEY_BULLETINBOARD_FACTORY = "key.bulletinboard.factory";
    public static final String KEY_HA_GROUPMANAGER = "key.ha.groupmanager";
    public static final String KEY_CLUSTERMEMBER_SERVICE = "key.clustermember.service";
    public static final String KEY_ENDPOINT_SERVICE = "key.endpoint.service";
    public static final String KEY_CLUSTERMGR = "key.clustermgr";
    public static final String KEY_LOCALTEMPLATE_IOR = "key.localtemplate.ior";
    public static final String KEY_ENDPOINTMGR = "key.endpointmgr";
    public static final String KEY_BBSCOPES = "key.bbscopes";
    public static final String KEY_PUBLIC_BBSCOPE = "key.public.bbscope";
    public static final String KEY_CONFIGURED_WEIGHT = "key.configured.weight";
    public static final String KEY_CONTROLLER_CLUSTER_MANAGER = "key.controller.cluster.manager";
    public static final String KEY_CLUSTERMEMBER_SERVICEPROXY = "key.cluster.member.service.proxy";
    public static final String KEY_ORB = "key.orb";
    public static final String KEY_IGNORE_BB_UPDATES = "key.ignore.bb.updates";
    private static final ProcessProperties instance;

    private ProcessProperties() {
        String string;
        try {
            string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty(ProcessProperties.unusableIntervalKey);
                    return string;
                }
            });
            if (string != null) {
                this.put(KEY_UNUSABLE_INTERVAL, new Integer(Integer.parseInt(string) * 1000));
            } else {
                this.put(KEY_UNUSABLE_INTERVAL, new Integer(300000));
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, ProcessProperties.class.getName() + ".initialize", "209", this);
            Tr.warning(tc, "NLSKEY_UNABLE_TO_SET_PROPERTIES", numberFormatException);
        }
        string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty(ProcessProperties.KEY_VIRTUAL_HOST);
                return string;
            }
        });
        if (string == null) {
            try {
                string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        String string = InetAddress.getLocalHost().getHostName();
                        return string;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, ProcessProperties.class.getName() + ".initialize", "231", this);
                Tr.warning(tc, "There is a problem to get either virtual host or local host", privilegedActionException);
            }
        }
        if (string != null) {
            this.put(KEY_VIRTUAL_HOST, string);
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        TreeMap<String, String> treeMap3 = new TreeMap<String, String>();
        treeMap.put("ORIGINAL_IOR_MEMBER", "ORIGINAL_IOR_MEMBER");
        treeMap2.put("selection", "selection");
        treeMap2.put("weighted", "weighted");
        treeMap3.put("selection", "selection");
        treeMap3.put("weighted", "weighted");
        treeMap3.put("preferlocal", "preferlocal");
        KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
        try {
            DescriptionKey descriptionKey = keyRepository.getDescriptionKey(treeMap);
            DescriptionKey descriptionKey2 = keyRepository.getDescriptionKey(treeMap2);
            DescriptionKey descriptionKey3 = keyRepository.getDescriptionKey(treeMap3);
            this.put(KEY_ORIGINAL_IOR, descriptionKey);
            this.put(KEY_WEIGHTED, descriptionKey2);
            this.put(KEY_WEIGHTED_PREFER_LOCAL, descriptionKey3);
            this.put(KEY_IGNORE_BB_UPDATES, new Boolean(false));
            TreeMap<String, String> treeMap4 = new TreeMap<String, String>((Map<String, String>)treeMap2);
            treeMap4.put("initialized", "false");
            this.put(KEY_WEIGHTED_NOT_INITIALIZED, keyRepository.getDescriptionKey(treeMap4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, ProcessProperties.class.getName() + ".initialize", "259", this);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new IOException("Error - not allowed to serialize this class");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new IOException("Error - not allowed to serialize this class");
    }

    public static ProcessProperties getInstance() {
        return instance;
    }

    public String[] introspectSelf() {
        Set set = this.entrySet();
        int n = set.size();
        if (n <= 0) {
            return new String[]{"Map is empty"};
        }
        Iterator iterator = this.entrySet().iterator();
        String[] stringArray = new String[n + 1];
        StringBuffer stringBuffer = new StringBuffer();
        Object var6_6 = null;
        Object var7_7 = null;
        stringArray[0] = "Dump of each Map entry:";
        int n2 = 1;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            var6_6 = entry.getKey();
            if (var6_6 == null) continue;
            var7_7 = entry.getValue();
            stringBuffer.setLength(0);
            stringBuffer.append("   key = ");
            stringBuffer.append((Object)var6_6);
            stringBuffer.append(", value = ");
            stringBuffer.append((Object)var7_7);
            stringArray[n2] = new String(stringBuffer);
            ++n2;
        }
        return stringArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.15 ");
        }
        KEY_UNUSABLE_INTERVAL = new Integer(0);
        instance = new ProcessProperties();
    }
}

