/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.ProcessProperties;

public class WLMCustomPropertyUtility {
    private static final TraceComponent tc = Tr.register(WLMCustomPropertyUtility.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static ProcessProperties processProperties;
    private static Boolean acsDelayPostingEnabled;
    private static final boolean ENABLE_ACS_DELAY_POSTING_DEFAULT_VALUE = false;
    private static Integer acsDelayPostingWaitTime;
    private static final int ACS_DELAY_POSTING_WAIT_TIME_DEFAULT_VALUE = 500;
    private static final Object acsDelayPostingWaitTimeMutex;
    public static final int ACS_DELAY_POSTING_WAIT_TIME_RECOMMENDED_MIN_VALUE = 250;
    public static final int ACS_DELAY_POSTING_WAIT_TIME_RECOMMENDED_MAX_VALUE = 60000;
    private static Integer delayCacheManagementCycleTime;
    private static final int DELAY_CACHE_MANAGEMENT_CYCLE_TIME_DEFAULT_VALUE = 200;
    private static final Object delayCacheManagementCycleTimeMutex;
    private static final int DELAY_CACHE_MANAGEMENT_CYCLE_TIME_RECOMMENDED_MIN_VALUE = 100;
    private static final int DELAY_CACHE_MANAGEMENT_CYCLE_TIME_RECOMMENDED_MAX_VALUE = 30000;
    private static Boolean nonDefaultCookieNameEnabled;
    private static final boolean NON_DEFAULT_COOKIE_NAME_ENABLED_DEFAULT_VALUE = false;

    public static boolean getACSDelayPostingValue() {
        if (acsDelayPostingEnabled == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            String string = (String)processProperties.get("IBM_CLUSTER_ENABLE_ACS_DELAY_POSTING");
            boolean bl = false;
            if (string != null && string.compareToIgnoreCase("true") == 0) {
                bl = true;
            }
            acsDelayPostingEnabled = new Boolean(bl);
        }
        if (acsDelayPostingEnabled != null) {
            return acsDelayPostingEnabled;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getACSDelayPostingWaitTimeValue() {
        if (acsDelayPostingWaitTime == null) {
            Object object = acsDelayPostingWaitTimeMutex;
            synchronized (object) {
                if (processProperties == null) {
                    processProperties = ProcessProperties.getInstance();
                }
                Integer n = new Integer(500);
                try {
                    n = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_ACS_DELAY_POSTING_WAIT_TIME"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 250) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getACSDelayPostingWaitTimeValue below valid minimum ", new Object[]{"IBM_CLUSTER_ACS_DELAY_POSTING_WAIT_TIME", n, new Integer(250)});
                    }
                    n = new Integer(250);
                }
                if (n > 60000) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getACSDelayPostingWaitTimeValue above valid maximum ", new Object[]{"IBM_CLUSTER_ACS_DELAY_POSTING_WAIT_TIME", n, new Integer(60000)});
                    }
                    n = new Integer(60000);
                }
                acsDelayPostingWaitTime = n;
            }
        }
        if (acsDelayPostingWaitTime != null) {
            return acsDelayPostingWaitTime;
        }
        return 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDelayCacheManagementCycleTimeValue() {
        if (delayCacheManagementCycleTime == null) {
            Object object = delayCacheManagementCycleTimeMutex;
            synchronized (object) {
                if (processProperties == null) {
                    processProperties = ProcessProperties.getInstance();
                }
                Integer n = new Integer(200);
                try {
                    n = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_DELAY_CACHE_MANAGEMENT_CYCLE_TIME"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 100) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDelayCacheManagementCycleTimeValue below valid minimum ", new Object[]{"IBM_CLUSTER_DELAY_CACHE_MANAGEMENT_CYCLE_TIME", n, new Integer(100)});
                    }
                    n = new Integer(100);
                }
                if (n > 30000) {
                    if (tc.isDebugEnabled()) {
                        Tr.warning(tc, "getDelayCacheManagementCycleTimeValue above valid maximum ", new Object[]{"IBM_CLUSTER_DELAY_CACHE_MANAGEMENT_CYCLE_TIME", n, new Integer(30000)});
                    }
                    n = new Integer(30000);
                }
                delayCacheManagementCycleTime = n;
            }
        }
        if (delayCacheManagementCycleTime != null) {
            return delayCacheManagementCycleTime;
        }
        return 200;
    }

    public static boolean getNonDefaultCookieNameValue() {
        if (nonDefaultCookieNameEnabled == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            String string = (String)processProperties.get("IBM_CLUSTER_ENABLE_NON_DEFAULT_COOKIE_NAMES");
            boolean bl = false;
            if (string != null && string.compareToIgnoreCase("true") == 0) {
                bl = true;
            }
            nonDefaultCookieNameEnabled = new Boolean(bl);
        }
        if (nonDefaultCookieNameEnabled != null) {
            return nonDefaultCookieNameEnabled;
        }
        return false;
    }

    public static void setValue(String string, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setValue : ", new Object[]{string, object});
        }
        if (string.equals("IBM_CLUSTER_ENABLE_ACS_DELAY_POSTING")) {
            acsDelayPostingEnabled = (Boolean)object;
        } else if (string.equals("IBM_CLUSTER_ACS_DELAY_POSTING_WAIT_TIME")) {
            acsDelayPostingWaitTime = (Integer)object;
        } else if (string.equals("IBM_CLUSTER_DELAY_CACHE_MANAGEMENT_CYCLE_TIME")) {
            delayCacheManagementCycleTime = (Integer)object;
        } else if (string.equals("IBM_CLUSTER_ENABLE_NON_DEFAULT_COOKIE_NAMES")) {
            nonDefaultCookieNameEnabled = (Boolean)object;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2");
        }
        processProperties = ProcessProperties.getInstance();
        acsDelayPostingEnabled = null;
        acsDelayPostingWaitTime = null;
        acsDelayPostingWaitTimeMutex = new Object();
        delayCacheManagementCycleTime = null;
        delayCacheManagementCycleTimeMutex = new Object();
        nonDefaultCookieNameEnabled = null;
    }
}

