/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.DetailedCFEndPointCriteria;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChannelTargetRule
implements SelectionRule {
    private static final TraceComponent tc;
    private static final ClusterService clusterService;
    protected static final DescriptionManager descMgr;
    private static final ChannelFrameworkService cfService;
    private RuleArbitrator arbiter = null;
    private CFEndPointCriteria cfEndPointCriteria;
    private int hashCode = 0;
    static /* synthetic */ Class class$com$ibm$wsspi$channel$framework$ChannelFrameworkService;

    public ChannelTargetRule(CFEndPointCriteria cFEndPointCriteria) {
        if (cFEndPointCriteria == null) {
            throw new IllegalArgumentException("The criteria must not be null.");
        }
        this.cfEndPointCriteria = cFEndPointCriteria;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", this.cfEndPointCriteria);
        }
        this.hashCode = (cFEndPointCriteria.getChainName() == null ? 0 : cFEndPointCriteria.getChainName().hashCode()) + (cFEndPointCriteria.getChannelAccessor() == null ? 0 : cFEndPointCriteria.getChannelAccessor().hashCode()) + (cFEndPointCriteria.isSSLRequired() ? 0 : 1) + (cFEndPointCriteria instanceof DetailedCFEndPointCriteria ? ((Object)((DetailedCFEndPointCriteria)cFEndPointCriteria).getChainProperties()).hashCode() + Arrays.deepHashCode(((DetailedCFEndPointCriteria)cFEndPointCriteria).getOptionalChannelFactories()) : 0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", String.valueOf(this.hashCode));
        }
    }

    public void subset(List list, StringBuffer stringBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "subset", list);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClusterMemberDescription clusterMemberDescription;
            ClusterMemberDescription.Memento memento;
            Identity identity = (Identity)iterator.next();
            if (this.arbiter != null) {
                this.arbiter.registerNotificationType(this, identity, "type.add.extrinsic");
                this.arbiter.registerNotificationType(this, identity, "type.remove.extrinsic");
            }
            if (!(memento = (ClusterMemberDescription.Memento)(clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)identity)).getMemento()).isLeaf()) continue;
            EndPoint[] endPointArray = clusterService.matchEndPoints(identity, ChannelTargetImpl.distinction);
            if (endPointArray == null || endPointArray.length == 0) {
                iterator.remove();
                stringBuffer.append(identity);
                stringBuffer.append(" removed: no CFEndPoint ");
                continue;
            }
            CFEndPoint[] cFEndPointArray = new CFEndPoint[endPointArray.length];
            for (int i = 0; i < endPointArray.length; ++i) {
                EndPoint endPoint = endPointArray[i];
                if (endPoint == null) {
                    if (!tc.isEventEnabled()) break;
                    Tr.event(tc, "No Endpoint in list at position " + i);
                    break;
                }
                if (this.arbiter != null) {
                    this.arbiter.registerNotificationType(this, endPoint.getIdentity(), "type.state.change.reachability");
                    this.arbiter.registerNotificationType(this, endPoint.getIdentity(), "type.memento.updated");
                }
                if (!endPoint.isAvailable()) continue;
                cFEndPointArray[i] = IdentityMapping.getCFEndPoint(endPoint.getIdentity());
            }
            if (cfService == null || cfService.determineBestEndPoint(cFEndPointArray, this.cfEndPointCriteria) != null) continue;
            iterator.remove();
            stringBuffer.append(identity);
            stringBuffer.append(" removed: no CFEndPoint matching criteria ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "subset", list);
        }
    }

    public void registerRuleArbitrator(RuleArbitrator ruleArbitrator) {
        this.arbiter = ruleArbitrator;
    }

    public boolean equals(Object object) {
        Map map;
        boolean bl = true;
        ChannelTargetRule channelTargetRule = null;
        if (!(object instanceof ChannelTargetRule)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "equals called when not same object", object);
            }
            return false;
        }
        channelTargetRule = (ChannelTargetRule)object;
        String string = this.cfEndPointCriteria.getChainName();
        if (string != null) {
            bl = string.equals(channelTargetRule.cfEndPointCriteria.getChainName());
        }
        if (!bl) {
            return bl;
        }
        Map map2 = map = this.cfEndPointCriteria instanceof DetailedCFEndPointCriteria ? ((DetailedCFEndPointCriteria)this.cfEndPointCriteria).getChainProperties() : null;
        if (map != null) {
            bl = ((Object)map).equals(((DetailedCFEndPointCriteria)channelTargetRule.cfEndPointCriteria).getChainProperties());
        }
        if (!bl) {
            return bl;
        }
        Class clazz = this.cfEndPointCriteria.getChannelAccessor();
        if (clazz != null) {
            bl = clazz.equals(channelTargetRule.cfEndPointCriteria.getChannelAccessor());
        }
        if (!bl) {
            return bl;
        }
        boolean bl2 = this.cfEndPointCriteria.isSSLRequired();
        if (bl2 && channelTargetRule.cfEndPointCriteria.isSSLRequired()) {
            bl = true;
        } else {
            boolean bl3 = bl = !bl2 && !channelTargetRule.cfEndPointCriteria.isSSLRequired();
        }
        if (!bl) {
            return bl;
        }
        Class[] classArray = this.cfEndPointCriteria.getOptionalChannelFactories();
        Class[] classArray2 = channelTargetRule.cfEndPointCriteria.getOptionalChannelFactories();
        if (classArray != null && classArray2 != null) {
            int n = classArray.length;
            int n2 = classArray2.length;
            if (n > 0 && n == n2) {
                int n3;
                ArrayList<Class> arrayList = new ArrayList<Class>();
                for (n3 = 0; n3 < classArray.length; ++n3) {
                    arrayList.add(classArray[n3]);
                }
                for (n3 = 0; n3 < classArray2.length; ++n3) {
                    if (arrayList.contains(classArray2[n3])) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = n == 0 && n2 == 0;
            }
        } else if (classArray != null && classArray2 == null || classArray == null && classArray2 != null) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(super.toString());
        stringBuilder.append(" [cfEndPointCriteria=");
        stringBuilder.append(this.cfEndPointCriteria);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        ChannelFrameworkService channelFrameworkService;
        block3: {
            tc = Tr.register(ChannelTargetRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
            clusterService = ClusterServiceFactory.getClusterService();
            descMgr = DescriptionManagerFactory.getDescriptionManager();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "version : ", "1.7.1.1 ");
            }
            channelFrameworkService = null;
            try {
                channelFrameworkService = (ChannelFrameworkService)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Object object = WsServiceRegistry.getService((Object)(class$com$ibm$ws$cluster$channel$ChannelTargetRule == null ? (class$com$ibm$ws$cluster$channel$ChannelTargetRule = ChannelTargetRule.class$("com.ibm.ws.cluster.channel.ChannelTargetRule")) : class$com$ibm$ws$cluster$channel$ChannelTargetRule), (Class)(class$com$ibm$wsspi$channel$framework$ChannelFrameworkService == null ? (class$com$ibm$wsspi$channel$framework$ChannelFrameworkService = ChannelTargetRule.class$("com.ibm.wsspi.channel.framework.ChannelFrameworkService")) : class$com$ibm$wsspi$channel$framework$ChannelFrameworkService));
                        return object;
                    }
                });
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block3;
                Tr.event(tc, "Running without ChannelFrameworkService", exception);
            }
        }
        cfService = channelFrameworkService;
    }
}

