/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.control;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.control.WLMServletListenerThread;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class WLMServletListener
implements NotificationListener {
    private Integer handback = new Integer(1);
    private Integer handbackSD = new Integer(2);
    private static final TraceComponent tc = Tr.register(WLMServletListener.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private AdminService adminService = null;
    private String domainName = null;
    private ObjectName cMgrOName = null;
    private ObjectName cBalanceOName = null;
    private ObjectName mbeanServerOName = null;
    private ObjectName configRepositoryOName = null;
    private boolean initialized = false;
    private String dmgrName = "dmgr";

    public WLMServletListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private void initialize() {
        Serializable serializable;
        Iterator iterator;
        Object object;
        Object object2;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            if (this.adminService == null) {
                this.adminService = AdminServiceFactory.getAdminService();
            }
            if (this.domainName == null && this.adminService != null) {
                this.domainName = this.adminService.getDomainName();
            }
            try {
                this.mbeanServerOName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                this.addNotification(this.mbeanServerOName, null, this.handbackSD);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initialize", new Object[]{"ObjectName exception thrown from ObjectName creation for type=MBeanServerDelegate", exception});
                }
                this.initialized = false;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialize", new Boolean(this.initialized));
                }
                return;
            }
            try {
                object2 = this.adminService.getDeploymentManagerAdminClient();
                object = object2.getServerMBean();
                this.dmgrName = ((ObjectName)object).getKeyProperty("process");
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block23;
                Tr.debug(tc, "initialize", new Object[]{"AdminException exception thrown from getDeploymentManagerAdminClient", exception});
            }
        }
        if (this.configRepositoryOName == null) {
            try {
                object2 = this.domainName + ":*,type=" + "ConfigRepository" + ",process=" + this.dmgrName;
                object = this.adminService.queryNames(new ObjectName((String)object2), null);
                if (object != null && object.size() == 1) {
                    iterator = object.iterator();
                    this.configRepositoryOName = (ObjectName)iterator.next();
                    serializable = new NotificationFilterSupport();
                    ((NotificationFilterSupport)serializable).enableType("websphere.repository.change");
                    this.addNotification(this.configRepositoryOName, (NotificationFilterSupport)serializable, this.handback);
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.wlm.control.WLMServletListener.initialize", "247", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initialize", new Object[]{"exception getting ObjectName for CofigRepository: ", malformedObjectNameException});
                }
                this.initialized = false;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialize", new Boolean(this.initialized));
                }
                return;
            }
        }
        try {
            object2 = this.domainName + ":*,type=" + "AppManagement" + ",process=" + this.dmgrName;
            object = this.adminService.queryNames(new ObjectName((String)object2), null);
            if (object != null && object.size() == 1) {
                iterator = object.iterator();
                serializable = (ObjectName)iterator.next();
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.admin.appmgmt");
                this.addNotification((ObjectName)serializable, notificationFilterSupport, this.handback);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.wlm.control.WLMServletListener.initialize", "277", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize", new Object[]{"exception adding Notification for AppManagement: ", malformedObjectNameException});
            }
            this.initialized = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", new Boolean(this.initialized));
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize", new Object[]{this.adminService, this.domainName, this.mbeanServerOName, this.configRepositoryOName});
        }
        if (this.adminService != null && this.domainName != null) {
            this.initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", new Boolean(this.initialized));
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", object);
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (object.equals(this.handback) && this.initialized) {
            try {
                WLMServletListenerThread wLMServletListenerThread = new WLMServletListenerThread(notification, this.cBalanceOName, this.cMgrOName);
                wLMServletListenerThread.start();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wlm.control.WLMServletListener.handleNotification", "328", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleNotification", "Exception thrown from WLMSLT: " + exception);
                }
            }
        } else if (object.equals(this.handbackSD) && this.initialized && notification.getType().equals("JMX.mbean.registered")) {
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            ObjectName objectName = mBeanServerNotification.getMBeanName();
            String string = objectName.getKeyProperty("type");
            if (string.equals("ClusterBalance") && this.cBalanceOName == null) {
                this.cBalanceOName = objectName;
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("cluster.influence.cluster.added");
                notificationFilterSupport.enableType("cluster.influence.cluster.removed");
                this.addNotification(this.cBalanceOName, notificationFilterSupport, this.handback);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleNotification", "ClusterBalanceOName estabilished");
                }
            } else if (string.equals("ClusterMgr") && this.cMgrOName == null) {
                this.cMgrOName = objectName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleNotification", "ClusterMgrOName estabilished");
                }
            } else if (string.equals("Cluster")) {
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.cluster.running");
                this.addNotification(objectName, notificationFilterSupport, this.handback);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void addNotification(ObjectName objectName, NotificationFilterSupport notificationFilterSupport, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotification", new Object[]{objectName, notificationFilterSupport, object});
        }
        try {
            this.adminService.addNotificationListener(objectName, this, (NotificationFilter)notificationFilterSupport, object);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.wlm.control.WLMServletListener.addNotification", "403", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addNotification", new Object[]{"JMX exception registering notification.", jMException});
            }
            Tr.warning(tc, "NLSKEY_UNABLE_TO_REGISTER_WLMSERVLETLISTENER");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wlm.control.WLMServletListener.addNotification", "412", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addNotification", new Object[]{"exception registering notification.", exception});
            }
            Tr.warning(tc, "NLSKEY_UNABLE_TO_REGISTER_WLMSERVLETLISTENER");
        }
        if (tc.isEntryEnabled()) {
            String string = objectName.getKeyProperty("name");
            Tr.exit(tc, "addNotification", string);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.3 ");
        }
    }
}

