/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.control;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.wlm.ClusterData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.management.Notification;
import javax.management.ObjectName;

final class WLMServletListenerThread
extends Thread {
    private ContextManager contextMgr = null;
    private Notification notification = null;
    private static final TraceComponent tc = Tr.register(WLMServletListenerThread.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private String dWLMAppName = "dWLM Application for cluster ";
    private String installEarName = null;
    private AppManagement appProxy = null;
    private AdminService adminService = null;
    private String cellName = null;
    private ObjectName cBalanceOName = null;
    private ObjectName cMgrOName = null;

    public WLMServletListenerThread(Notification notification, ObjectName objectName, ObjectName objectName2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.adminService = AdminServiceFactory.getAdminService();
        this.cellName = this.adminService.getCellName();
        String string = this.cellName + ":WLMServletListenerThread:" + this.getName();
        this.setName(string);
        this.setDaemon(true);
        this.contextMgr = ContextManagerFactory.getInstance();
        this.notification = notification;
        this.cBalanceOName = objectName;
        this.cMgrOName = objectName2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", string);
        }
    }

    public void run() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run", this.getName());
            }
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    block22: {
                        try {
                            WLMServletListenerThread.this.appProxy = AppManagementProxy.getJMXProxyForServer();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wlm.control.WLMServletListenerThread.initialize", "534", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "initialize", new Object[]{"AppManagementProxy exception thrown from getJMXProxyForServer call, returning", exception});
                            }
                            return null;
                        }
                        String string = WLMServletListenerThread.this.notification.getType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "run", string);
                        }
                        if (string.equals("websphere.admin.appmgmt")) {
                            String string2 = ((AppNotification)((WLMServletListenerThread)WLMServletListenerThread.this).notification.getUserData()).taskName;
                            String string3 = ((AppNotification)((WLMServletListenerThread)WLMServletListenerThread.this).notification.getUserData()).taskStatus;
                            String string4 = ((AppNotification)((WLMServletListenerThread)WLMServletListenerThread.this).notification.getUserData()).props.getProperty("appname");
                            try {
                                String string5;
                                if (string3.equals("Completed") && string2.equals("InstallApplication") && string4.indexOf(WLMServletListenerThread.this.dWLMAppName) != -1 && WLMServletListenerThread.this.isClusterRunning(string5 = string4.substring(WLMServletListenerThread.this.dWLMAppName.length(), string4.length()))) {
                                    WLMServletListenerThread.this.startDWLMApp(string4, 30);
                                }
                                break block22;
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception thrown from AppManagement during app auto-start: " + exception);
                                }
                                break block22;
                            }
                        }
                        if (string.equals("cluster.influence.cluster.added")) {
                            Properties properties = (Properties)WLMServletListenerThread.this.notification.getUserData();
                            String string6 = properties.getProperty("clusterName");
                            WLMServletListenerThread.this.verifyDWLMAppInstalls(string6);
                        } else if (string.equals("cluster.influence.cluster.removed")) {
                            Properties properties = (Properties)WLMServletListenerThread.this.notification.getUserData();
                            String string7 = properties.getProperty("clusterName");
                            if (WLMServletListenerThread.this.isDWLMAppInstalled(string7)) {
                                WLMServletListenerThread.this.uninstallApp(string7);
                            }
                        } else if (string.equals("websphere.cluster.running")) {
                            String string8 = null;
                            ObjectName objectName = (ObjectName)WLMServletListenerThread.this.notification.getSource();
                            string8 = objectName.getKeyProperty("name");
                            if (!WLMServletListenerThread.this.verifyDWLMAppInstalls(string8)) {
                                if (WLMServletListenerThread.this.isDWLMAppInstalled(string8)) {
                                    WLMServletListenerThread.this.uninstallApp(string8);
                                }
                            } else {
                                WLMServletListenerThread.this.startDWLMApp(WLMServletListenerThread.this.dWLMAppName + string8, 0);
                            }
                        } else if (string.equals("websphere.repository.change")) {
                            WLMServletListenerThread.this.verifyDWLMAppInstalls(null);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "run", "Type matched nothing: " + string);
                        }
                    }
                    return null;
                }
            };
            try {
                this.contextMgr.runAsSystem(privilegedExceptionAction);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cluster.control.WLMServletListenerThread.run", "623", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "run exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run", this.getName());
        }
    }

    private void startDWLMApp(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDWLMApp", string);
        }
        try {
            if (n > 0) {
                Thread.sleep(n);
            }
            this.appProxy.startApplication(string, new Hashtable(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDWLMApp");
        }
    }

    private boolean verifyDWLMAppInstalls(String string) {
        boolean bl;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyDWLMAppInstalls", string);
        }
        boolean bl2 = false;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Object[] objectArray = null;
        Vector<Object> vector = new Vector<Object>();
        String[] stringArray = this.getAdvisedClusters();
        if (stringArray == null || stringArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "verifyDWLMAppInstalls", new Boolean(bl2));
            }
            return bl2;
        }
        if (string != null) {
            n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                stringArray = new String[]{string};
                n = 1;
            }
            if (n == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "verifyDWLMAppInstalls", new Boolean(n != 0));
                }
                return bl2;
            }
        }
        objectArray = this.listAppsInstalled();
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n].indexOf(this.dWLMAppName) == -1 && !((String)objectArray[n]).equalsIgnoreCase("adminconsole") && !((String)objectArray[n]).equalsIgnoreCase("filetransfer")) {
                vector.add(objectArray[n]);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "verifyDWLMAppInstalls", "Removed from list" + (String)objectArray[n]);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            String[] stringArray2 = this.getWebTargets((String)objectArray[n]);
            for (bl = false; bl < stringArray2.length; bl += 1) {
                hashtable.put(stringArray2[bl], "VALUE");
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            bl = hashtable.get(string2) != null;
            boolean bl3 = this.isDWLMAppInstalled(string2);
            if (bl && !bl3) {
                this.installApp(string2);
                continue;
            }
            if (!bl && bl3) {
                this.uninstallApp(string2);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "verifyDWLMAppInstalls", new Object[]{"advisedWebTarget: " + bl, "advCluster: " + string2, "dWLM: " + bl3});
        }
        bl2 = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyDWLMAppInstalls", new Boolean(bl2));
        }
        return bl2;
    }

    private String[] getWebTargets(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebTargets", string);
        }
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        String string3 = null;
        Vector vector2 = this.getAppInfo(string);
        boolean bl = false;
        for (int i = 0; i < vector2.size() && !bl; ++i) {
            AppDeploymentTask appDeploymentTask = (AppDeploymentTask)vector2.elementAt(i);
            if (!appDeploymentTask.getName().equals("MapModulesToServers")) continue;
            bl = true;
            String[][] stringArray = appDeploymentTask.getTaskData();
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                string3 = stringArray[j][1];
                string2 = stringArray[j][2];
                if (string3.toLowerCase().indexOf("web.xml") == -1 || string2.toLowerCase().indexOf("cluster") == -1) continue;
                vector.add(string2.substring(string2.toLowerCase().indexOf("cluster") + 8, string2.length()));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getWebModules", "Web URI: " + string3);
                Tr.debug(tc, "getWebModules", "Web Target added: " + string2);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebTargets", objectArray);
        }
        return objectArray;
    }

    private boolean isDWLMAppInstalled(String string) {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isDWLMAppInstalled", string);
            }
            bl = false;
            String string2 = this.dWLMAppName + string;
            try {
                bl = this.appProxy.checkIfAppExists(string2, null, null);
            }
            catch (AdminException adminException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isDWLMAppInstalled Exception: ", adminException);
                }
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.wlm.control.WLMServletListenerThread.isDWLMAppInstalled", "856", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "isDWLMAppInstalled exception", new Object[]{"Exception thrown while checking if dWLMApp is installed", adminException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDWLMAppInstalled", new Boolean(bl));
        }
        return bl;
    }

    private String[] listAppsInstalled() {
        Vector vector;
        Object[] objectArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listAppsInstalled");
            }
            objectArray = null;
            vector = null;
            try {
                vector = this.appProxy.listApplications(new Hashtable(), null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.wlm.control.WLMServletListenerThread.listAppsInstalled", "886", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "listAppsInstalled exception", new Object[]{"Exception thrown while getting list of application", adminException});
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAppsInstalled", objectArray);
        }
        return objectArray;
    }

    private Vector getAppInfo(String string) {
        Vector vector;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAppInfo", string);
            }
            vector = null;
            try {
                vector = this.appProxy.getApplicationInfo(string, new Hashtable(), null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.wlm.control.WLMServletListenerThread.getAppInfo", "918", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getAppInfo exception", new Object[]{"Exception thrown while getting appInfo for app: " + string, adminException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppInfo", vector);
        }
        return vector;
    }

    private String[] getAdvisedClusters() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdvisedClusters");
        }
        ObjectName[] objectNameArray = null;
        String[] stringArray = null;
        try {
            objectNameArray = (ObjectName[])this.adminService.invoke(this.cBalanceOName, "getClusters", null, null);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wlm.control.WLMServletListenerThread.getAdvisedClusters", "948", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAdvisedClusters exception", new Object[]{"Exception thrown while getting Cluster MBean, returning", exception});
            }
            return null;
        }
        stringArray = new String[objectNameArray.length];
        for (int i = 0; i < objectNameArray.length; ++i) {
            stringArray[i] = objectNameArray[i].getKeyProperty("name");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdvisedClusters", stringArray);
        }
        return stringArray;
    }

    private boolean isClusterRunning(String string) {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isClusterRunning", string);
            }
            bl = false;
            ClusterData clusterData = null;
            try {
                clusterData = (ClusterData)this.adminService.invoke(this.cMgrOName, "retrieveCluster", new Object[]{string}, new String[]{"java.lang.String"});
                String string2 = (String)this.adminService.getAttribute(clusterData.clusterObjectName, "state");
                if (string2.equals("websphere.cluster.running")) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wlm.control.WLMServletListener.isClusterRunning", "988", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "isClusterRunning exception", new Object[]{"Exception thrown while invoking a method on the ClusterMgr MBean", exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isClusterRunning", new Boolean(bl));
        }
        return bl;
    }

    private void installApp(String string) {
        String string2;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "installApp", string);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Properties properties = new Properties();
            if (this.installEarName == null) {
                string2 = System.getProperty("was.install.root");
                this.installEarName = string2 + File.separator + "installableApps" + File.separator + "wlmservlet.ear";
            }
            string2 = this.dWLMAppName + string;
            try {
                properties.put("appname", string2);
                String string3 = "wlmservlet.war+WEB-INF/web.xml";
                String string4 = "WebSphere:cell=" + this.cellName + ",cluster=" + string;
                hashtable.put(string3, string4);
                properties.put("moduleToServer", hashtable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "installApp", new Object[]{string3, string4});
                }
                if (this.installEarName != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "installApp", this.installEarName);
                    }
                    this.appProxy.installApplication(this.installEarName, string2, properties, null);
                }
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.wlm.control.WLMServletListenerThread.installApp", "1046", this);
                Tr.warning(tc, "NLSKEY_UNABLE_TO_INSTALL_DWLM_APP", new Object[]{"installApp"});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "installApp exception", new Object[]{this.installEarName, string2});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installApp", string2);
        }
    }

    private void uninstallApp(String string) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uninstallApp", string);
            }
            String string2 = this.dWLMAppName + string;
            Properties properties = new Properties();
            properties.put("appname", string2);
            try {
                this.appProxy.uninstallApplication(string2, properties, null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.wlm.control.WLMServletListenerThread.uninstallApp", "1080", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "uninstallApp exception", new Object[]{string, properties, adminException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallApp", string);
        }
    }
}

