/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.control.mbean;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.InvalidAttributeValueException;
import javax.management.Notification;
import javax.management.ObjectName;

public class ClusterInfluence {
    public static final String TYPE_ENABLED = "cluster.influence.enabled";
    public static final String TYPE_DISABLED = "cluster.influence.disabled";
    public static final String TYPE_CLUSTER_ADDED = "cluster.influence.cluster.added";
    public static final String TYPE_CLUSTER_REMOVED = "cluster.influence.cluster.removed";
    protected DefaultRuntimeCollaborator rtc = new DefaultRuntimeCollaborator(this);
    protected Boolean enabled = Boolean.FALSE;
    protected ObjectName objectName;
    protected Map clusters = new HashMap();
    private static final TraceComponent tc = Tr.register(ClusterInfluence.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean bl) {
        this.enabled = bl;
        String string = this.enabled != false ? TYPE_ENABLED : TYPE_DISABLED;
        Notification notification = new Notification(string, (Object)this.objectName, -1L, System.currentTimeMillis());
        try {
            this.rtc.sendNotification(notification);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, ClusterInfluence.class.getName() + ".setEnabled", "86", this);
        }
    }

    public synchronized ObjectName[] getClusters() {
        ObjectName[] objectNameArray = new ObjectName[this.clusters.size()];
        this.clusters.values().toArray(objectNameArray);
        return objectNameArray;
    }

    public synchronized void addCluster(ObjectName objectName) throws InvalidAttributeValueException {
        String string = objectName.getKeyProperty("type");
        if (!(string != null && string.equals("ExtendedCluster") || string != null && string.equals("Cluster"))) {
            throw new InvalidAttributeValueException("The ObjectName was not an ExtendedCluster: " + string);
        }
        String string2 = objectName.getKeyProperty("name");
        if (string2 == null) {
            throw new InvalidAttributeValueException("The ObjectName did not have the name attribute.");
        }
        this.clusters.put(string2, objectName);
        Notification notification = new Notification(TYPE_CLUSTER_ADDED, (Object)objectName, -1L, System.currentTimeMillis());
        Properties properties = new Properties();
        properties.setProperty("clusterName", string2);
        notification.setUserData(properties);
        try {
            this.rtc.sendNotification(notification);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, ClusterInfluence.class.getName() + ".addCluster", "119", this);
        }
    }

    public synchronized void removeCluster(ObjectName objectName) throws InvalidAttributeValueException {
        String string = objectName.getKeyProperty("type");
        if (!(string != null && string.equals("ExtendedCluster") || string != null && string.equals("Cluster"))) {
            throw new InvalidAttributeValueException("The ObjectName was not an ExtendedCluster: " + string);
        }
        String string2 = objectName.getKeyProperty("name");
        if (string2 == null) {
            throw new InvalidAttributeValueException("The ObjectName did not have the name attribute.");
        }
        this.clusters.remove(string2);
        Notification notification = new Notification(TYPE_CLUSTER_REMOVED, (Object)objectName, -1L, System.currentTimeMillis());
        Properties properties = new Properties();
        properties.setProperty("clusterName", string2);
        notification.setUserData(properties);
        try {
            this.rtc.sendNotification(notification);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, ClusterInfluence.class.getName() + ".removeCluster", "146", this);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2 ");
        }
    }
}

