/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.management.Registrar;
import com.ibm.websphere.cluster.propagation.DistributedListenerRep;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RegistrarImpl
implements Registrar {
    private static final TraceComponent tc = Tr.register(RegistrarImpl.class, "ClusterConfigurationManagement", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Map listeners = new HashMap();

    public void registerClusterListener(DescriptionKey descriptionKey, DistributedListenerRep distributedListenerRep) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "registerClusterListener", new Object[]{descriptionKey, distributedListenerRep});
        }
        Set set = this.getListenerSet(descriptionKey);
        set.add(distributedListenerRep);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "registerClusterListener", this.listeners);
        }
    }

    public void deregisterClusterListener(DescriptionKey descriptionKey, DistributedListenerRep distributedListenerRep) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "deregisterClusterListener", new Object[]{descriptionKey, distributedListenerRep});
        }
        Set set = this.getListenerSet(descriptionKey);
        set.remove(distributedListenerRep);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "deregisterClusterListener", this.listeners);
        }
    }

    public DistributedListenerRep[] getDistributedListeners(DescriptionKey descriptionKey) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getDistributedListeners", new Object[]{descriptionKey});
        }
        Set set = this.getListenerSet(descriptionKey);
        DistributedListenerRep[] distributedListenerRepArray = new DistributedListenerRep[set.size()];
        set.toArray(distributedListenerRepArray);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getDistributedListeners", distributedListenerRepArray);
        }
        return distributedListenerRepArray;
    }

    private Set getListenerSet(DescriptionKey descriptionKey) {
        HashSet hashSet;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getListenerSet", new Object[]{descriptionKey});
        }
        if ((hashSet = (HashSet)this.listeners.get(descriptionKey)) == null) {
            hashSet = new HashSet();
            this.listeners.put(descriptionKey, hashSet);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getListenerSet", new Object[]{hashSet});
        }
        return hashSet;
    }

    public String toString(DescriptionKey descriptionKey) {
        Set set = (Set)this.listeners.get(descriptionKey);
        if (set == null) {
            return "null";
        }
        return set.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2 ");
        }
    }
}

