/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.KeyConverter;
import com.ibm.ws.cluster.propagation.StreamContextHandler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.ws.wlm.PMIManager;
import com.ibm.ws.wlm.TypeConversion;
import com.ibm.ws.wlm.WLMServiceClientContextListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;

public final class ClientClusterContextListenerImpl
implements WLMServiceClientContextListener {
    private static final TraceComponent tc = Tr.register(ClientClusterContextListenerImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private List clusters = null;
    private StreamContextHandler ivStreamContextHandler = StreamContextHandler.getInstance();
    private DescriptionManager ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
    private KeyRepository ivKeyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();

    public ClientClusterContextListenerImpl(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", list);
        }
        this.clusters = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public byte[] sendClientContext() {
        byte[] byArray;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendClientContext");
            }
            byArray = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote context version 4");
                }
                this.sendClientContextPrefix(dataOutputStream);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
                this.sendClientContextClusters(objectOutputStream);
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                objectOutputStream.close();
                dataOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, ClientClusterContextListenerImpl.class.getName() + ".sendClientContext", "140", this);
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "unexpected exception", iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendClientContext", byArray);
        }
        return byArray;
    }

    private void sendClientContextPrefix(DataOutput dataOutput) throws IOException {
        ClusterDescription clusterDescription = (ClusterDescription)this.clusters.get(0);
        ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
        dataOutput.writeLong(memento.getStructuralEpoch());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote structural epoch " + memento.getStructuralEpoch());
        }
        dataOutput.writeInt(PMIManager.getClientId());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote client ID " + PMIManager.getClientId());
        }
        dataOutput.writeByte(PMIManager.getAffinityType());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote affinity type " + PMIManager.getAffinityType());
        }
    }

    private void sendClientContextClusters(ObjectOutput objectOutput) throws IOException {
        Iterator iterator = this.clusters.iterator();
        while (iterator.hasNext()) {
            ClusterDescription clusterDescription = (ClusterDescription)iterator.next();
            objectOutput.writeBoolean(true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote available to process true");
            }
            String[] stringArray = KeyConverter.translateKey(clusterDescription.getKey(), null, clusterDescription.getDefinitionKey(), false);
            objectOutput.writeObject(stringArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote cluster Key as String[]");
                for (int i = 0; i < stringArray.length; ++i) {
                    Tr.debug(tc, "clusterKey[" + i + "] = " + stringArray[i]);
                }
            }
            ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
            objectOutput.writeLong(memento.getStructuralEpoch());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote structural epoch " + memento.getStructuralEpoch());
            }
            objectOutput.writeLong(memento.getInfluentialEpoch());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "wrote influential epoch " + memento.getInfluentialEpoch());
        }
        objectOutput.writeBoolean(false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote available to process false");
        }
    }

    public void receiveClientContext(byte[] byArray) {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "receiveClientContext", new ByteArray(byArray).toString());
            }
            ByteArrayInputStream byteArrayInputStream = null;
            DataInputStream dataInputStream = null;
            try {
                int n = TypeConversion.bytesToInt(byArray, 0);
                if (n == -1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "receiveClientContext");
                    }
                    return;
                }
                if (n < 2) {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                } else {
                    byte[] byArray2 = Compressor.decompress(byArray, 4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "decompressed context data " + new ByteArray(byArray2).toString());
                    }
                    byteArrayInputStream = new ByteArrayInputStream(byArray2);
                }
                dataInputStream = new DataInputStream(byteArrayInputStream);
                int n2 = dataInputStream.readInt();
                switch (n2) {
                    case 1: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Version 1 context detected");
                        }
                        this.ivStreamContextHandler.parseVersion1(dataInputStream);
                        break;
                    }
                    case 2: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Version 2 context detected");
                        }
                        WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(dataInputStream);
                        this.ivStreamContextHandler.parseVersion2(wsObjectInputStream, false, null, false);
                        break;
                    }
                    default: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Version " + n2 + " context detected");
                        }
                        WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(dataInputStream);
                        this.receiveClientContext(wsObjectInputStream);
                        wsObjectInputStream.close();
                    }
                }
                dataInputStream.close();
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, ClientClusterContextListenerImpl.class.getName() + ".receiveClientContext", "300", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected in receiveClientContext", new ByteArray(byArray).toString());
                }
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "Unexpected exception", iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveClientContext");
        }
    }

    protected void receiveClientContext(ObjectInput objectInput) throws IOException {
        this.ivDescMgr.update(objectInput);
    }

    public int getListenerTag() {
        return 0;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.12 ");
        }
    }
}

